#ifndef SANCP_H
#include "sancp.h"
#endif
#define GVARS_H

#include "pcapFileHandle.h"
#include "outputFileHandle.h"
#include "MemoryPool.h"

#define HASH_KEYS 1211
#define MAX_IP_PROTO 256

typedef u_int bpf_u_int32;
typedef struct pcap pcap_t;

/* Modifications to this statement can cause alignment problems with fmtnames[] in sancp.cc */
/* Make certain all id's are represented in the same order (as strings) in fmtnames[] */
/* 'null' is a place holder - in the list for field 0 */ 

enum id {null,sancp_id,start_time_gmt,start_time_local,stop_time_gmt,stop_time_local,erased_time_gmt,erased_time_local,eth_proto_hex,eth_proto,ip_proto,src_ip_decimal,src_ip_dotted,src_port,dst_ip_decimal,dst_ip_dotted,dst_port,duration,timeout,src_pkts,dst_pkts,src_bytes,dst_bytes,sflags_hex,sflags,sflags_1,sflags_2,sflags_U,sflags_A,sflags_P,sflags_R,sflags_S,sflags_F,dflags_hex,dflags,dflags_1,dflags_2,dflags_U,dflags_A,dflags_P,dflags_R,dflags_S,dflags_F,cflags_hex,cflags,cflags_DA,cflags_SA,cflags_DR,cflags_SR,cflags_DF,cflags_SF,ip_len_s,ip_ttl_s,ip_df_s,tcp_wss_s,tcp_mss_s,tcp_wscale_s,tcp_sack_ok_s,tcp_nop_s,ip_len_d,ip_ttl_d,ip_df_d,tcp_wss_d,tcp_mss_d,tcp_wscale_d,tcp_sack_ok_d,tcp_nop_d,total_bytes,collect,collected,climit,tcplag,pcap,realtime,stats,reversed,hash,rid,rgid,node,zone,status,retro,src_mac,dst_mac };

struct cnx_queue {
	struct cnx *head;
	struct cnx *tail;
}; 

struct pcap_pkthdr {
        struct timeval ts;      /* time stamp */
        bpf_u_int32 caplen;     /* length of portion present */
        bpf_u_int32 len;        /* length this packet (off wire) */
};


struct gvars
{
        outputFileHandle *sdF;  // global stdout filehandle
	pcapFileHandle *pfH; // global pcap filehandle
	outputFileHandle *rfH;  // global realtimes filehandle
	outputFileHandle *sfH;  // global stats filehandle
	fileHandle *cfH;  // global .cid filehandle
	fileHandle *bfH;  // global bpf filehandle
	pcapFileHandle *rpfH; // global raw pcap filehandle
	int log_facility;
	u_int8_t node_id;
	char *username;
	char *groupname;
	char *pcap_fname;
	char *realtime_fname;
	char *stats_fname;
	char *bpf_fname;
	char *bpf_filter;
	char *config_file;
	char *input_filename;  // pcap -Input- filename  [see: -r]
	char *log_directory;
	char *default_device;
	struct timeval timeptr;///
	struct timeval timelast;///
	struct acl *acl_head; //*acl_tail;
	struct acl *tacl_head; //*acl_tail;
	struct vars *var_head; //*acl_tail;
	struct cnx *cnx_head[HASH_KEYS]; //*cnx_head;
	struct cnx *cnx_tail[HASH_KEYS]; //*cnx_tail;
	CMemoryPool *cnx_pool;//
	CMemoryPool *acl_pool;//
	struct t_ports *ports[MAX_IP_PROTO];
	struct t_ports *tports[MAX_IP_PROTO];
	struct cnx_queue expired_cnxs;
	time_t lastrun;//
	time_t start_time;//
	time_t restart_time;//
	u_int32_t pkts_in, pkts_out, bytes_in, bytes_out; //
	unsigned long uid;
	unsigned long gid;
	u_int16_t default_flush_interval;
	u_int16_t default_expire_interval;
	u_int16_t default_timeout;
	u_int64_t default_limit;
	u_int16_t default_tcplag;
	u_int32_t default_ctr;
	u_int16_t default_node;
	u_int16_t default_zone;
	u_int32_t default_rgid;
	u_int8_t default_status;
	u_int32_t default_rid;
	u_int16_t smode:4,rmode:4,pmode:4,enable_cid:1,burst_mode:1,print_schemas:1;
	u_int64_t cnx_id;
	u_int8_t daemon_mode:1, uselocaltime:1, strip_80211:1, pcap_raw:1, \
		log_icmp_type_code:1,  human_readable:1, pcap_shift:2; 
	u_int8_t console_mode:1, cmdl_stats_action:1, cmdl_pcap_action:1, \
		cmdl_realtimes_action:1, use_pcap_time:1, shift:1;
	char *realtime_fmt;
	char realtime_delimiter;
	char realtime_eor;
	int realtime_fmt_len;
	char *stats_fmt;
	char stats_delimiter;
	char stats_eor;
	int stats_fmt_len;
	char *stdout_fmt;
	char stdout_delimiter;
	char stdout_eor;
	int stdout_fmt_len;
	pcap_t *ph;      // pcap handle
	struct pcap_pkthdr *g_pkthdr;//
};

