<?php
/**
* ProjectControllerTest
*
* PHP version 5
*
* LICENSE: This source file is subject to LGPL license
* that is available through the world-wide-web at the following URI:
* http://www.gnu.org/copyleft/lesser.html
*
* @author       Antonio Alcorn
* @author       Giovanni Capalbo
* @author		Sylvia Hristakeva
* @author		Kumud Nepal
* @author		Ernel Wint
* @copyright    Lanka Software Foundation - http://www.opensource.lk
* @copyright    Trinity Humanitarian-FOSS Project - http://www.cs.trincoll.edu/hfoss
* @package      sahana
* @subpackage   vm
* @tutorial
* @license        http://www.gnu.org/copyleft/lesser.html GNU Lesser General
* Public License (LGPL)
*/


// Call ProjectControllerTest::main() if this source file is executed directly.
if (!defined("PHPUnit_MAIN_METHOD")) {
    define("PHPUnit_MAIN_METHOD", "ProjectControllerTest::main");
}

/**
 * Test class for ProjectController.
 * Generated by PHPUnit_Util_Skeleton on 2007-06-19 at 11:08:45.
 */
class ProjectControllerTest extends PHPUnit_Framework_TestCase {

    /**
     * Sets up the fixture, for example, open a network connection.
     * This method is called before a test is executed.
     *
     * @access protected
     */
    protected function setUp() {
    	$this->fixture = new ProjectController();

    	global $global,$dao;
    	$global=array('approot'=>realpath(dirname(__FILE__)).'/../../../');
		require_once($global['approot'].'3rd/adodb/adodb.inc.php');

		//Make the connection to $global['db']
		$global['db'] = NewADOConnection('mysql');
		$global['db']->Connect(TEST_DB_HOST, TEST_DB_USER,TEST_DB_PASSWD,TEST_DB_NAME);
		error_reporting(E_ALL ^ E_NOTICE);
		$dao = new DAO($global['db']);
    }

    /**
     * Tears down the fixture, for example, close a network connection.
     * This method is called after a test is executed.
     *
     * @access protected
     */
    protected function tearDown() {
    }

    public function testControlHandler() {
        // Remove the following line when you implement this test.
        $this->markTestIncomplete(
          "This test has not been implemented yet."
        );
    }

    public function testValidateAssignForm()
    {
    	global $global;
    	require_once($global['approot'].'inc/lib_errors.inc');

    	$this->assertTrue($this->fixture->validateAssignForm(array('id_task'=>'task', 'p_uuid'=>'id')));
    	$this->assertFalse($this->fixture->validateAssignForm(null));

    }

    public function testValidateAddForm()
    {
    	$test1 = array("name"=>"name", "SKILL_MGR_APPLY"=>"on", "manager"=>"manager");
    	$test10 = array("name"=>"name", "SKILL_MGR_APPLY"=>"on", "manager"=>"manager", "start_date"=>"2000-10-30", "end_date"=>"");

    	$test2=array("SKILL_mgr"=>"on");
    	$test3 = array("name"=>"name", "SKILL_MGR_APPLY"=>"not_on");
    	$test4 = array("name"=>"", "SKILL_MGR_APPLY"=>"on");
    	$test5 = array("name"=>"name", "SKILL_MGR_APPLY"=>"on", "manager"=>"manager", "start_date"=>"2000-10-30", "end_date"=>"2000-12-ff");
    	$test6 = array("name"=>"name", "SKILL_MGR_APPLY"=>"on", "start_date"=>"2000-10-30", "end_date"=>"1999-01-01");
    	$test7 = array("name"=>"name", "SKILL_MGR_APPLY"=>"on", "start_date"=>"2000-1-30", "end_date"=>"2009-12-10");
    	$test8 = array("name"=>"name", "SKILL_MGR_APPLY"=>"on", "manager"=>"", "start_date"=>"2000-10-30", "end_date"=>"2001-01-01");


    	$this->assertTrue($this->fixture->validateAddForm($test1));
    	$this->assertTrue($this->fixture->validateAddForm($test10));

    	$this->assertFalse($this->fixture->validateAddForm($test2));
    	$this->assertFalse($this->fixture->validateAddForm($test3));
    	$this->assertFalse($this->fixture->validateAddForm($test4));
    	$this->assertFalse($this->fixture->validateAddForm($test5));
    	$this->assertFalse($this->fixture->validateAddForm($test6));
    	$this->assertFalse($this->fixture->validateAddForm($test7));
    	$this->assertFalse($this->fixture->validateAddForm($test8));
    }

}


?>