/* rygel-media-export-harvester.c generated by valac 0.36.6, the Vala compiler
 * generated from rygel-media-export-harvester.vala, do not modify */

/*
 * Copyright (C) 2010 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-server.h>
#include <rygel-core.h>
#include <glib/gi18n-lib.h>
#include <rygel-db.h>


#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTER (rygel_media_export_harvester_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester))
#define RYGEL_MEDIA_EXPORT_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_HARVESTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))

typedef struct _RygelMediaExportHarvester RygelMediaExportHarvester;
typedef struct _RygelMediaExportHarvesterClass RygelMediaExportHarvesterClass;
typedef struct _RygelMediaExportHarvesterPrivate RygelMediaExportHarvesterPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK (rygel_media_export_harvesting_task_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTask))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))

typedef struct _RygelMediaExportHarvestingTask RygelMediaExportHarvestingTask;
typedef struct _RygelMediaExportHarvestingTaskClass RygelMediaExportHarvestingTaskClass;

#define RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR (rygel_media_export_recursive_file_monitor_get_type ())
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitor))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))

typedef struct _RygelMediaExportRecursiveFileMonitor RygelMediaExportRecursiveFileMonitor;
typedef struct _RygelMediaExportRecursiveFileMonitorClass RygelMediaExportRecursiveFileMonitorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelMediaExportHarvestingTaskPrivate RygelMediaExportHarvestingTaskPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER (rygel_media_export_trackable_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_TRACKABLE_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainer))
#define RYGEL_MEDIA_EXPORT_TRACKABLE_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_TRACKABLE_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_TRACKABLE_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_TRACKABLE_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER, RygelMediaExportTrackableDbContainerClass))

typedef struct _RygelMediaExportTrackableDbContainer RygelMediaExportTrackableDbContainer;
typedef struct _RygelMediaExportTrackableDbContainerClass RygelMediaExportTrackableDbContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER (rygel_media_export_writable_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_WRITABLE_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER, RygelMediaExportWritableDbContainer))
#define RYGEL_MEDIA_EXPORT_WRITABLE_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER, RygelMediaExportWritableDbContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_WRITABLE_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_WRITABLE_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_WRITABLE_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER, RygelMediaExportWritableDbContainerClass))

typedef struct _RygelMediaExportWritableDbContainer RygelMediaExportWritableDbContainer;
typedef struct _RygelMediaExportWritableDbContainerClass RygelMediaExportWritableDbContainerClass;
typedef struct _Block5Data Block5Data;
enum  {
	RYGEL_MEDIA_EXPORT_HARVESTER_DONE_SIGNAL,
	RYGEL_MEDIA_EXPORT_HARVESTER_LAST_SIGNAL
};
static guint rygel_media_export_harvester_signals[RYGEL_MEDIA_EXPORT_HARVESTER_LAST_SIGNAL] = {0};

struct _RygelMediaExportHarvester {
	GObject parent_instance;
	RygelMediaExportHarvesterPrivate * priv;
};

struct _RygelMediaExportHarvesterClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportHarvesterPrivate {
	GeeHashMap* tasks;
	GeeHashMap* extraction_grace_timers;
	RygelMediaExportRecursiveFileMonitor* monitor;
	GCancellable* cancellable;
	GeeArrayList* _locations;
};

struct _RygelMediaExportHarvestingTask {
	GObject parent_instance;
	RygelMediaExportHarvestingTaskPrivate * priv;
	GFile* origin;
};

struct _RygelMediaExportHarvestingTaskClass {
	GObjectClass parent_class;
};

struct _Block5Data {
	int _ref_count_;
	RygelMediaExportHarvester* self;
	GFile* file;
};


static gpointer rygel_media_export_harvester_parent_class = NULL;

GType rygel_media_export_harvester_get_type (void) G_GNUC_CONST;
GType rygel_media_export_harvesting_task_get_type (void) G_GNUC_CONST;
GType rygel_media_export_recursive_file_monitor_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_HARVESTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_HARVESTER_DUMMY_PROPERTY,
	RYGEL_MEDIA_EXPORT_HARVESTER_LOCATIONS_PROPERTY
};
#define RYGEL_MEDIA_EXPORT_HARVESTER_FILE_CHANGE_DEFAULT_GRACE_PERIOD ((guint) 5)
RygelMediaExportHarvester* rygel_media_export_harvester_new (GCancellable* cancellable, GeeArrayList* locations);
RygelMediaExportHarvester* rygel_media_export_harvester_construct (GType object_type, GCancellable* cancellable, GeeArrayList* locations);
static void rygel_media_export_harvester_set_locations (RygelMediaExportHarvester* self, GeeArrayList* value);
GeeArrayList* rygel_media_export_harvester_get_locations (RygelMediaExportHarvester* self);
RygelMediaExportRecursiveFileMonitor* rygel_media_export_recursive_file_monitor_new (GCancellable* cancellable);
RygelMediaExportRecursiveFileMonitor* rygel_media_export_recursive_file_monitor_construct (GType object_type, GCancellable* cancellable);
static void rygel_media_export_harvester_on_file_changed (RygelMediaExportHarvester* self, GFile* file, GFile* other, GFileMonitorEvent event);
static void _rygel_media_export_harvester_on_file_changed_rygel_media_export_recursive_file_monitor_changed (RygelMediaExportRecursiveFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
gboolean rygel_media_export_harvester_is_eligible (GFile* file, GFileInfo* info);
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (void);
gboolean rygel_media_export_media_cache_is_blacklisted (RygelMediaExportMediaCache* self, GFile* file);
void rygel_media_export_harvester_schedule_locations (RygelMediaExportHarvester* self, RygelMediaContainer* parent);
void rygel_media_export_harvester_schedule (RygelMediaExportHarvester* self, GFile* file, RygelMediaContainer* parent);
void rygel_media_export_harvester_cancel (RygelMediaExportHarvester* self, GFile* file);
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_new (RygelMediaExportRecursiveFileMonitor* monitor, GFile* file, RygelMediaContainer* parent);
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_construct (GType object_type, RygelMediaExportRecursiveFileMonitor* monitor, GFile* file, RygelMediaContainer* parent);
static void rygel_media_export_harvester_on_file_harvested (RygelMediaExportHarvester* self, RygelStateMachine* state_machine);
static void _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
void rygel_media_export_harvesting_task_cancel (RygelMediaExportHarvestingTask* self);
static void rygel_media_export_harvester_on_changes_done (RygelMediaExportHarvester* self, GFile* file, GError** error);
static void rygel_media_export_harvester_on_file_removed (RygelMediaExportHarvester* self, GFile* file);
static void rygel_media_export_harvester_on_file_added (RygelMediaExportHarvester* self, GFile* file);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const gchar* object_id, GError** error);
GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_trackable_db_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_writable_db_container_get_type (void) G_GNUC_CONST;
void rygel_media_export_writable_db_container_remove_tracked (RygelMediaExportWritableDbContainer* self, RygelMediaObject* object, GError** error);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean __lambda7_ (Block5Data* _data5_);
static gboolean ___lambda7__gsource_func (gpointer self);
static void rygel_media_export_harvester_finalize (GObject * obj);
static void _vala_rygel_media_export_harvester_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_export_harvester_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Create a new instance of the meta-data extraction manager.
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _rygel_media_export_harvester_on_file_changed_rygel_media_export_recursive_file_monitor_changed (RygelMediaExportRecursiveFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	rygel_media_export_harvester_on_file_changed ((RygelMediaExportHarvester*) self, file, other_file, event_type);
}


RygelMediaExportHarvester* rygel_media_export_harvester_construct (GType object_type, GCancellable* cancellable, GeeArrayList* locations) {
	RygelMediaExportHarvester * self = NULL;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GCancellable* _tmp19_;
	RygelMediaExportRecursiveFileMonitor* _tmp20_;
	RygelMediaExportRecursiveFileMonitor* _tmp21_;
	GeeHashMap* _tmp22_;
	GeeHashMap* _tmp23_;
	g_return_val_if_fail (cancellable != NULL, NULL);
	g_return_val_if_fail (locations != NULL, NULL);
	self = (RygelMediaExportHarvester*) g_object_new (object_type, NULL);
	_tmp0_ = cancellable;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp1_;
	_tmp2_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeEqualDataFunc) g_file_equal, NULL, NULL);
	_tmp3_ = _tmp2_;
	rygel_media_export_harvester_set_locations (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	{
		GeeArrayList* _file_list = NULL;
		GeeArrayList* _tmp4_;
		GeeArrayList* _tmp5_;
		gint _file_size = 0;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _file_index = 0;
		_tmp4_ = locations;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_file_list = _tmp5_;
		_tmp6_ = _file_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_file_size = _tmp8_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			GFile* file = NULL;
			GeeArrayList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			GFile* _tmp15_;
			gboolean _tmp16_;
			_tmp9_ = _file_index;
			_file_index = _tmp9_ + 1;
			_tmp10_ = _file_index;
			_tmp11_ = _file_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _file_list;
			_tmp13_ = _file_index;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
			file = (GFile*) _tmp14_;
			_tmp15_ = file;
			_tmp16_ = g_file_query_exists (_tmp15_, NULL);
			if (_tmp16_) {
				GeeArrayList* _tmp17_;
				GFile* _tmp18_;
				_tmp17_ = self->priv->_locations;
				_tmp18_ = file;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp18_);
			}
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_list);
	}
	_tmp19_ = cancellable;
	_tmp20_ = rygel_media_export_recursive_file_monitor_new (_tmp19_);
	_g_object_unref0 (self->priv->monitor);
	self->priv->monitor = _tmp20_;
	_tmp21_ = self->priv->monitor;
	g_signal_connect_object (_tmp21_, "changed", (GCallback) _rygel_media_export_harvester_on_file_changed_rygel_media_export_recursive_file_monitor_changed, self, 0);
	_tmp22_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeHashDataFunc) g_file_hash, NULL, NULL, (GeeEqualDataFunc) g_file_equal, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->tasks);
	self->priv->tasks = _tmp22_;
	_tmp23_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_UINT, NULL, NULL, (GeeHashDataFunc) g_file_hash, NULL, NULL, (GeeEqualDataFunc) g_file_equal, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->extraction_grace_timers);
	self->priv->extraction_grace_timers = _tmp23_;
	return self;
}


RygelMediaExportHarvester* rygel_media_export_harvester_new (GCancellable* cancellable, GeeArrayList* locations) {
	return rygel_media_export_harvester_construct (RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, cancellable, locations);
}


/**
     * Check if a FileInfo is considered for extraction
     *
     * @param info a FileInfo
     * @return true if file should be extracted, false otherwise
     */
gboolean rygel_media_export_harvester_is_eligible (GFile* file, GFileInfo* info) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	GFileInfo* _tmp7_;
	const gchar* _tmp8_;
	gboolean _tmp9_;
	gboolean is_supported_content_type = FALSE;
	RygelMediaExportMediaCache* cache = NULL;
	RygelMediaExportMediaCache* _tmp26_;
	gboolean is_blacklisted = FALSE;
	RygelMediaExportMediaCache* _tmp27_;
	GFile* _tmp28_;
	gboolean _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_;
	g_return_val_if_fail (file != NULL, FALSE);
	g_return_val_if_fail (info != NULL, FALSE);
	_tmp7_ = info;
	_tmp8_ = g_file_info_get_content_type (_tmp7_);
	_tmp9_ = g_str_has_prefix (_tmp8_, "image/");
	if (_tmp9_) {
		_tmp6_ = TRUE;
	} else {
		GFileInfo* _tmp10_;
		const gchar* _tmp11_;
		gboolean _tmp12_;
		_tmp10_ = info;
		_tmp11_ = g_file_info_get_content_type (_tmp10_);
		_tmp12_ = g_str_has_prefix (_tmp11_, "video/");
		_tmp6_ = _tmp12_;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		GFileInfo* _tmp13_;
		const gchar* _tmp14_;
		gboolean _tmp15_;
		_tmp13_ = info;
		_tmp14_ = g_file_info_get_content_type (_tmp13_);
		_tmp15_ = g_str_has_prefix (_tmp14_, "audio/");
		_tmp5_ = _tmp15_;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		GFileInfo* _tmp16_;
		const gchar* _tmp17_;
		_tmp16_ = info;
		_tmp17_ = g_file_info_get_content_type (_tmp16_);
		_tmp4_ = g_strcmp0 (_tmp17_, "application/ogg") == 0;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		GFileInfo* _tmp18_;
		const gchar* _tmp19_;
		_tmp18_ = info;
		_tmp19_ = g_file_info_get_content_type (_tmp18_);
		_tmp3_ = g_strcmp0 (_tmp19_, "application/xml") == 0;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		GFileInfo* _tmp20_;
		const gchar* _tmp21_;
		_tmp20_ = info;
		_tmp21_ = g_file_info_get_content_type (_tmp20_);
		_tmp2_ = g_strcmp0 (_tmp21_, "text/xml") == 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		GFileInfo* _tmp22_;
		const gchar* _tmp23_;
		_tmp22_ = info;
		_tmp23_ = g_file_info_get_content_type (_tmp22_);
		_tmp1_ = g_strcmp0 (_tmp23_, "text/plain") == 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		GFileInfo* _tmp24_;
		const gchar* _tmp25_;
		_tmp24_ = info;
		_tmp25_ = g_file_info_get_content_type (_tmp24_);
		_tmp0_ = g_strcmp0 (_tmp25_, "application/x-cd-image") == 0;
	}
	is_supported_content_type = _tmp0_;
	_tmp26_ = rygel_media_export_media_cache_get_default ();
	cache = _tmp26_;
	_tmp27_ = cache;
	_tmp28_ = file;
	_tmp29_ = rygel_media_export_media_cache_is_blacklisted (_tmp27_, _tmp28_);
	is_blacklisted = _tmp29_;
	_tmp30_ = is_blacklisted;
	if (_tmp30_) {
		GFile* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		_tmp31_ = file;
		_tmp32_ = g_file_get_uri (_tmp31_);
		_tmp33_ = _tmp32_;
		g_debug ("rygel-media-export-harvester.vala:83: URI %s is not eligible due to bl" \
"acklisting", _tmp33_);
		_g_free0 (_tmp33_);
	}
	_tmp35_ = is_supported_content_type;
	if (_tmp35_) {
		gboolean _tmp36_;
		_tmp36_ = is_blacklisted;
		_tmp34_ = !_tmp36_;
	} else {
		_tmp34_ = FALSE;
	}
	result = _tmp34_;
	_g_object_unref0 (cache);
	return result;
}


/**
     * Schedule rescan of all top-level locations known to the harvester.
     *
     * @param parent top-level container of the files
     */
void rygel_media_export_harvester_schedule_locations (RygelMediaExportHarvester* self, RygelMediaContainer* parent) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	{
		GeeArrayList* _file_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _file_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _file_index = 0;
		_tmp0_ = self->priv->_locations;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_file_list = _tmp1_;
		_tmp2_ = _file_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_file_size = _tmp4_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GFile* file = NULL;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			GFile* _tmp11_;
			RygelMediaContainer* _tmp12_;
			_tmp5_ = _file_index;
			_file_index = _tmp5_ + 1;
			_tmp6_ = _file_index;
			_tmp7_ = _file_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _file_list;
			_tmp9_ = _file_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			file = (GFile*) _tmp10_;
			_tmp11_ = file;
			_tmp12_ = parent;
			rygel_media_export_harvester_schedule (self, _tmp11_, _tmp12_);
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_list);
	}
}


/**
     * Put a file on queue for meta-data extraction
     *
     * @param file the file to investigate
     * @param parent container of the filer to be harvested
     */
static void _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
	rygel_media_export_harvester_on_file_harvested ((RygelMediaExportHarvester*) self, _sender);
}


void rygel_media_export_harvester_schedule (RygelMediaExportHarvester* self, GFile* file, RygelMediaContainer* parent) {
	GeeHashMap* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	RygelMediaExportHarvestingTask* task = NULL;
	RygelMediaExportRecursiveFileMonitor* _tmp3_;
	GFile* _tmp4_;
	RygelMediaContainer* _tmp5_;
	RygelMediaExportHarvestingTask* _tmp6_;
	GCancellable* _tmp7_;
	GeeHashMap* _tmp8_;
	GFile* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (parent != NULL);
	_tmp0_ = self->priv->extraction_grace_timers;
	_tmp1_ = file;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp0_, _tmp1_, NULL);
	_tmp2_ = file;
	rygel_media_export_harvester_cancel (self, _tmp2_);
	_tmp3_ = self->priv->monitor;
	_tmp4_ = file;
	_tmp5_ = parent;
	_tmp6_ = rygel_media_export_harvesting_task_new (_tmp3_, _tmp4_, _tmp5_);
	task = _tmp6_;
	_tmp7_ = self->priv->cancellable;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) task, _tmp7_);
	g_signal_connect_object ((RygelStateMachine*) task, "completed", (GCallback) _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed, self, 0);
	_tmp8_ = self->priv->tasks;
	_tmp9_ = file;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, _tmp9_, task);
	rygel_state_machine_run ((RygelStateMachine*) task, NULL, NULL);
	_g_object_unref0 (task);
}


/**
     * Cancel a running meta-data extraction run
     *
     * @param file file cancel the current run for
     */
void rygel_media_export_harvester_cancel (RygelMediaExportHarvester* self, GFile* file) {
	GeeHashMap* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = self->priv->tasks;
	_tmp1_ = file;
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp1_);
	if (_tmp2_) {
		RygelMediaExportHarvestingTask* task = NULL;
		GeeHashMap* _tmp3_;
		GFile* _tmp4_;
		gpointer _tmp5_;
		RygelMediaExportHarvestingTask* _tmp6_;
		guint _tmp7_;
		GeeHashMap* _tmp8_;
		GFile* _tmp9_;
		RygelMediaExportHarvestingTask* _tmp10_;
		_tmp3_ = self->priv->tasks;
		_tmp4_ = file;
		_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp4_);
		task = (RygelMediaExportHarvestingTask*) _tmp5_;
		_tmp6_ = task;
		g_signal_parse_name ("completed", RYGEL_TYPE_STATE_MACHINE, &_tmp7_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((RygelStateMachine*) _tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed, self);
		_tmp8_ = self->priv->tasks;
		_tmp9_ = file;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp8_, _tmp9_, NULL);
		_tmp10_ = task;
		rygel_media_export_harvesting_task_cancel (_tmp10_);
		_g_object_unref0 (task);
	}
}


/**
     * Callback for finished harvester.
     *
     * Updates book-keeping hash.
     * @param state_machine HarvestingTask sending the event
     */
static void rygel_media_export_harvester_on_file_harvested (RygelMediaExportHarvester* self, RygelStateMachine* state_machine) {
	RygelMediaExportHarvestingTask* task = NULL;
	RygelStateMachine* _tmp0_;
	RygelMediaExportHarvestingTask* _tmp1_;
	GFile* file = NULL;
	RygelMediaExportHarvestingTask* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GeeHashMap* _tmp8_;
	GFile* _tmp9_;
	GeeHashMap* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (state_machine != NULL);
	_tmp0_ = state_machine;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK) ? ((RygelMediaExportHarvestingTask*) _tmp0_) : NULL);
	task = _tmp1_;
	_tmp2_ = task;
	_tmp3_ = _tmp2_->origin;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	file = _tmp4_;
	_tmp5_ = file;
	_tmp6_ = g_file_get_uri (_tmp5_);
	_tmp7_ = _tmp6_;
	g_message (_ ("“%s” harvested"), _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = self->priv->tasks;
	_tmp9_ = file;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp8_, _tmp9_, NULL);
	_tmp10_ = self->priv->tasks;
	_tmp11_ = gee_map_get_is_empty ((GeeMap*) _tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_) {
		g_signal_emit (self, rygel_media_export_harvester_signals[RYGEL_MEDIA_EXPORT_HARVESTER_DONE_SIGNAL], 0);
	}
	_g_object_unref0 (file);
	_g_object_unref0 (task);
}


static void rygel_media_export_harvester_on_file_changed (RygelMediaExportHarvester* self, GFile* file, GFile* other, GFileMonitorEvent event) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	{
		GFileMonitorEvent _tmp0_;
		_tmp0_ = event;
		switch (_tmp0_) {
			case G_FILE_MONITOR_EVENT_CREATED:
			{
				{
					GFileInfo* info = NULL;
					GFile* _tmp1_;
					GCancellable* _tmp2_;
					GFileInfo* _tmp3_;
					GFileInfo* _tmp4_;
					GFileType _tmp5_;
					_tmp1_ = file;
					_tmp2_ = self->priv->cancellable;
					_tmp3_ = g_file_query_info (_tmp1_, G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_QUERY_INFO_NONE, _tmp2_, &_inner_error_);
					info = _tmp3_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch52_g_error;
					}
					_tmp4_ = info;
					_tmp5_ = g_file_info_get_file_type (_tmp4_);
					if (_tmp5_ == G_FILE_TYPE_DIRECTORY) {
						GFile* _tmp6_;
						_tmp6_ = file;
						rygel_media_export_harvester_on_changes_done (self, _tmp6_, &_inner_error_);
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							_g_object_unref0 (info);
							goto __catch52_g_error;
						}
					}
					_g_object_unref0 (info);
					break;
				}
			}
			case G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT:
			{
				GFile* _tmp7_;
				_tmp7_ = file;
				rygel_media_export_harvester_on_changes_done (self, _tmp7_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch52_g_error;
				}
				break;
			}
			case G_FILE_MONITOR_EVENT_DELETED:
			{
				GFile* _tmp8_;
				_tmp8_ = file;
				rygel_media_export_harvester_on_file_removed (self, _tmp8_);
				break;
			}
			default:
			{
				break;
			}
		}
	}
	goto __finally52;
	__catch52_g_error:
	{
		GError* _error_ = NULL;
		GFile* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GError* _tmp12_;
		const gchar* _tmp13_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = file;
		_tmp10_ = g_file_get_uri (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = _error_;
		_tmp13_ = _tmp12_->message;
		g_debug ("rygel-media-export-harvester.vala:179: Failed to query information for" \
" %s: %s", _tmp11_, _tmp13_);
		_g_free0 (_tmp11_);
		_g_error_free0 (_error_);
	}
	__finally52:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_harvester_on_file_added (RygelMediaExportHarvester* self, GFile* file) {
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = file;
	_tmp1_ = g_file_get_uri (_tmp0_);
	_tmp2_ = _tmp1_;
	g_debug ("rygel-media-export-harvester.vala:186: Filesystem events settled for %" \
"s, scheduling extraction…", _tmp2_);
	_g_free0 (_tmp2_);
	{
		RygelMediaExportMediaCache* cache = NULL;
		RygelMediaExportMediaCache* _tmp3_;
		GFileInfo* info = NULL;
		GFile* _tmp4_;
		GCancellable* _tmp5_;
		GFileInfo* _tmp6_;
		gboolean _tmp7_ = FALSE;
		GFileType _tmp8_;
		_tmp3_ = rygel_media_export_media_cache_get_default ();
		cache = _tmp3_;
		_tmp4_ = file;
		_tmp5_ = self->priv->cancellable;
		_tmp6_ = g_file_query_info (_tmp4_, G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, _tmp5_, &_inner_error_);
		info = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (cache);
			goto __catch53_g_error;
		}
		_tmp8_ = g_file_info_get_file_type (info);
		if (_tmp8_ == G_FILE_TYPE_DIRECTORY) {
			_tmp7_ = TRUE;
		} else {
			GFile* _tmp9_;
			gboolean _tmp10_;
			_tmp9_ = file;
			_tmp10_ = rygel_media_export_harvester_is_eligible (_tmp9_, info);
			_tmp7_ = _tmp10_;
		}
		if (_tmp7_) {
			gchar* id = NULL;
			GFile* _tmp11_;
			GFile* _tmp12_;
			GFile* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp11_ = file;
			_tmp12_ = g_file_get_parent (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = rygel_media_export_media_cache_get_id (_tmp13_);
			_tmp15_ = _tmp14_;
			_g_object_unref0 (_tmp13_);
			id = _tmp15_;
			{
				RygelMediaObject* _tmp16_ = NULL;
				const gchar* _tmp17_;
				RygelMediaObject* _tmp18_;
				RygelMediaContainer* parent_container = NULL;
				RygelMediaContainer* _tmp19_;
				GFile* _tmp20_;
				RygelMediaContainer* _tmp21_;
				_tmp17_ = id;
				_tmp18_ = rygel_media_export_media_cache_get_object (cache, _tmp17_, &_inner_error_);
				_tmp16_ = _tmp18_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
						goto __catch54_rygel_database_database_error;
					}
					_g_free0 (id);
					_g_object_unref0 (info);
					_g_object_unref0 (cache);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp16_) : NULL);
				parent_container = _tmp19_;
				_tmp20_ = file;
				_tmp21_ = parent_container;
				rygel_media_export_harvester_schedule (self, _tmp20_, _tmp21_);
				_g_object_unref0 (parent_container);
				_g_object_unref0 (_tmp16_);
			}
			goto __finally54;
			__catch54_rygel_database_database_error:
			{
				GError* _error_ = NULL;
				const gchar* _tmp22_;
				GError* _tmp23_;
				const gchar* _tmp24_;
				_error_ = _inner_error_;
				_inner_error_ = NULL;
				_tmp22_ = id;
				_tmp23_ = _error_;
				_tmp24_ = _tmp23_->message;
				g_warning (_ ("Error fetching object “%s” from database: %s"), _tmp22_, _tmp24_);
				_g_error_free0 (_error_);
			}
			__finally54:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (id);
				_g_object_unref0 (info);
				_g_object_unref0 (cache);
				goto __catch53_g_error;
			}
			_g_free0 (id);
		} else {
			GFile* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			_tmp25_ = file;
			_tmp26_ = g_file_get_uri (_tmp25_);
			_tmp27_ = _tmp26_;
			g_debug ("rygel-media-export-harvester.vala:207: %s is not eligible for extracti" \
"on", _tmp27_);
			_g_free0 (_tmp27_);
		}
		_g_object_unref0 (info);
		_g_object_unref0 (cache);
	}
	goto __finally53;
	__catch53_g_error:
	{
		GError* _error_ = NULL;
		GFile* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		GError* _tmp31_;
		const gchar* _tmp32_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp28_ = file;
		_tmp29_ = g_file_get_uri (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = _error_;
		_tmp32_ = _tmp31_->message;
		g_warning (_ ("Failed to query info of a file %s: %s"), _tmp30_, _tmp32_);
		_g_free0 (_tmp30_);
		_g_error_free0 (_error_);
	}
	__finally53:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_harvester_on_file_removed (RygelMediaExportHarvester* self, GFile* file) {
	RygelMediaExportMediaCache* cache = NULL;
	RygelMediaExportMediaCache* _tmp0_;
	GeeHashMap* _tmp1_;
	GFile* _tmp2_;
	gboolean _tmp3_;
	GFile* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = rygel_media_export_media_cache_get_default ();
	cache = _tmp0_;
	_tmp1_ = self->priv->extraction_grace_timers;
	_tmp2_ = file;
	_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, _tmp2_);
	if (_tmp3_) {
		GeeHashMap* _tmp4_;
		GFile* _tmp5_;
		gpointer _tmp6_;
		GeeHashMap* _tmp7_;
		GFile* _tmp8_;
		_tmp4_ = self->priv->extraction_grace_timers;
		_tmp5_ = file;
		_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
		g_source_remove ((guint) ((guintptr) _tmp6_));
		_tmp7_ = self->priv->extraction_grace_timers;
		_tmp8_ = file;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp7_, _tmp8_, NULL);
	}
	_tmp9_ = file;
	rygel_media_export_harvester_cancel (self, _tmp9_);
	{
		gchar* id = NULL;
		GFile* _tmp10_;
		gchar* _tmp11_;
		RygelMediaObject* object = NULL;
		RygelMediaExportMediaCache* _tmp12_;
		const gchar* _tmp13_;
		RygelMediaObject* _tmp14_;
		gboolean _tmp15_ = FALSE;
		RygelMediaObject* _tmp16_;
		_tmp10_ = file;
		_tmp11_ = rygel_media_export_media_cache_get_id (_tmp10_);
		id = _tmp11_;
		_tmp12_ = cache;
		_tmp13_ = id;
		_tmp14_ = rygel_media_export_media_cache_get_object (_tmp12_, _tmp13_, &_inner_error_);
		object = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (id);
			goto __catch55_g_error;
		}
		_tmp16_ = object;
		if (_tmp16_ != NULL) {
			RygelMediaObject* _tmp17_;
			RygelMediaContainer* _tmp18_;
			RygelMediaContainer* _tmp19_;
			_tmp17_ = object;
			_tmp18_ = rygel_media_object_get_parent (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp15_ = _tmp19_ != NULL;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			RygelMediaContainer* parent = NULL;
			RygelMediaObject* _tmp20_;
			RygelMediaContainer* _tmp21_;
			RygelMediaContainer* _tmp22_;
			RygelMediaContainer* _tmp23_;
			RygelMediaContainer* _tmp24_;
			_tmp20_ = object;
			_tmp21_ = rygel_media_object_get_parent (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = _g_object_ref0 (_tmp22_);
			parent = _tmp23_;
			_tmp24_ = parent;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER)) {
				RygelMediaExportWritableDbContainer* container = NULL;
				RygelMediaContainer* _tmp25_;
				RygelMediaExportWritableDbContainer* _tmp26_;
				RygelMediaExportWritableDbContainer* _tmp27_;
				RygelMediaObject* _tmp28_;
				_tmp25_ = parent;
				_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER) ? ((RygelMediaExportWritableDbContainer*) _tmp25_) : NULL);
				container = _tmp26_;
				_tmp27_ = container;
				_tmp28_ = object;
				rygel_media_export_writable_db_container_remove_tracked (_tmp27_, _tmp28_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_object_unref0 (container);
					_g_object_unref0 (parent);
					_g_object_unref0 (object);
					_g_free0 (id);
					goto __catch55_g_error;
				}
				_g_object_unref0 (container);
			} else {
				RygelMediaContainer* _tmp29_;
				_tmp29_ = parent;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, RYGEL_MEDIA_EXPORT_TYPE_TRACKABLE_DB_CONTAINER)) {
					RygelTrackableContainer* container = NULL;
					RygelMediaContainer* _tmp30_;
					RygelTrackableContainer* _tmp31_;
					RygelTrackableContainer* _tmp32_;
					RygelMediaObject* _tmp33_;
					_tmp30_ = parent;
					_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, RYGEL_TYPE_TRACKABLE_CONTAINER) ? ((RygelTrackableContainer*) _tmp30_) : NULL);
					container = _tmp31_;
					_tmp32_ = container;
					_tmp33_ = object;
					rygel_trackable_container_remove_child_tracked (_tmp32_, _tmp33_, NULL, NULL);
					_g_object_unref0 (container);
				}
			}
			_g_object_unref0 (parent);
		} else {
			const gchar* _tmp34_;
			_tmp34_ = id;
			g_warning (_ ("Could not find object %s or its parent. Database is inconsistent"), _tmp34_);
		}
		_g_object_unref0 (object);
		_g_free0 (id);
	}
	goto __finally55;
	__catch55_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp35_;
		const gchar* _tmp36_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp35_ = _error_;
		_tmp36_ = _tmp35_->message;
		g_warning (_ ("Error removing object from database: %s"), _tmp36_);
		_g_error_free0 (_error_);
	}
	__finally55:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (cache);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (cache);
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		RygelMediaExportHarvester* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->file);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static gboolean __lambda7_ (Block5Data* _data5_) {
	RygelMediaExportHarvester* self;
	gboolean result = FALSE;
	GFile* _tmp0_;
	self = _data5_->self;
	_tmp0_ = _data5_->file;
	rygel_media_export_harvester_on_file_added (self, _tmp0_);
	result = FALSE;
	return result;
}


static gboolean ___lambda7__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda7_ (self);
	return result;
}


static void rygel_media_export_harvester_on_changes_done (RygelMediaExportHarvester* self, GFile* file, GError** error) {
	Block5Data* _data5_;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	guint period = 0U;
	GeeHashMap* _tmp11_;
	GFile* _tmp12_;
	gboolean _tmp13_;
	GSourceFunc callback = NULL;
	void* callback_target;
	GDestroyNotify callback_target_destroy_notify;
	guint _tmp21_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data5_->file);
	_data5_->file = _tmp1_;
	_tmp2_ = _data5_->file;
	_tmp3_ = g_file_get_basename (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_str_has_prefix (_tmp4_, ".");
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	if (_tmp6_) {
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return;
	}
	period = RYGEL_MEDIA_EXPORT_HARVESTER_FILE_CHANGE_DEFAULT_GRACE_PERIOD;
	{
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp7_;
		gint _tmp8_ = 0;
		RygelMetaConfig* _tmp9_;
		gint _tmp10_;
		_tmp7_ = rygel_meta_config_get_default ();
		config = _tmp7_;
		_tmp9_ = config;
		_tmp10_ = rygel_configuration_get_int ((RygelConfiguration*) _tmp9_, "MediaExport", "monitor-grace-timeout", 0, 500, &_inner_error_);
		_tmp8_ = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (config);
			goto __catch56_g_error;
		}
		period = (guint) _tmp8_;
		_g_object_unref0 (config);
	}
	goto __finally56;
	__catch56_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally56:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return;
	}
	_tmp11_ = self->priv->extraction_grace_timers;
	_tmp12_ = _data5_->file;
	_tmp13_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp11_, _tmp12_);
	if (_tmp13_) {
		GeeHashMap* _tmp14_;
		GFile* _tmp15_;
		gpointer _tmp16_;
		_tmp14_ = self->priv->extraction_grace_timers;
		_tmp15_ = _data5_->file;
		_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp14_, _tmp15_);
		g_source_remove ((guint) ((guintptr) _tmp16_));
	} else {
		guint _tmp17_;
		_tmp17_ = period;
		if (_tmp17_ > ((guint) 0)) {
			GFile* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp18_ = _data5_->file;
			_tmp19_ = g_file_get_uri (_tmp18_);
			_tmp20_ = _tmp19_;
			g_debug ("rygel-media-export-harvester.vala:272: Starting grace timer for harves" \
"ting %s…", _tmp20_);
			_g_free0 (_tmp20_);
		}
	}
	callback = ___lambda7__gsource_func;
	callback_target = block5_data_ref (_data5_);
	callback_target_destroy_notify = block5_data_unref;
	_tmp21_ = period;
	if (_tmp21_ > ((guint) 0)) {
		guint timeout = 0U;
		GSourceFunc _tmp22_;
		void* _tmp22__target;
		GDestroyNotify _tmp22__target_destroy_notify;
		guint _tmp23_;
		GeeHashMap* _tmp24_;
		GFile* _tmp25_;
		guint _tmp26_;
		_tmp22_ = callback;
		_tmp22__target = callback_target;
		_tmp22__target_destroy_notify = callback_target_destroy_notify;
		callback = NULL;
		callback_target = NULL;
		callback_target_destroy_notify = NULL;
		_tmp23_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, RYGEL_MEDIA_EXPORT_HARVESTER_FILE_CHANGE_DEFAULT_GRACE_PERIOD, _tmp22_, _tmp22__target, _tmp22__target_destroy_notify);
		timeout = _tmp23_;
		_tmp24_ = self->priv->extraction_grace_timers;
		_tmp25_ = _data5_->file;
		_tmp26_ = timeout;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp24_, _tmp25_, (gpointer) ((guintptr) _tmp26_));
	} else {
		GSourceFunc _tmp27_;
		void* _tmp27__target;
		GDestroyNotify _tmp27__target_destroy_notify;
		_tmp27_ = callback;
		_tmp27__target = callback_target;
		_tmp27__target_destroy_notify = callback_target_destroy_notify;
		callback = NULL;
		callback_target = NULL;
		callback_target_destroy_notify = NULL;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp27_, _tmp27__target, _tmp27__target_destroy_notify);
	}
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	block5_data_unref (_data5_);
	_data5_ = NULL;
}


GeeArrayList* rygel_media_export_harvester_get_locations (RygelMediaExportHarvester* self) {
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_locations;
	result = _tmp0_;
	return result;
}


static void rygel_media_export_harvester_set_locations (RygelMediaExportHarvester* self, GeeArrayList* value) {
	g_return_if_fail (self != NULL);
	if (rygel_media_export_harvester_get_locations (self) != value) {
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_locations);
		self->priv->_locations = _tmp1_;
		g_object_notify ((GObject *) self, "locations");
	}
}


static void rygel_media_export_harvester_class_init (RygelMediaExportHarvesterClass * klass) {
	rygel_media_export_harvester_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportHarvesterPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_export_harvester_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_export_harvester_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_harvester_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_EXPORT_HARVESTER_LOCATIONS_PROPERTY, g_param_spec_object ("locations", "locations", "locations", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	rygel_media_export_harvester_signals[RYGEL_MEDIA_EXPORT_HARVESTER_DONE_SIGNAL] = g_signal_new ("done", RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void rygel_media_export_harvester_instance_init (RygelMediaExportHarvester * self) {
	self->priv = RYGEL_MEDIA_EXPORT_HARVESTER_GET_PRIVATE (self);
}


static void rygel_media_export_harvester_finalize (GObject * obj) {
	RygelMediaExportHarvester * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester);
	_g_object_unref0 (self->priv->tasks);
	_g_object_unref0 (self->priv->extraction_grace_timers);
	_g_object_unref0 (self->priv->monitor);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->_locations);
	G_OBJECT_CLASS (rygel_media_export_harvester_parent_class)->finalize (obj);
}


/**
 * This class takes care of the book-keeping of running and finished
 * extraction tasks running within the media-export plugin
 */
GType rygel_media_export_harvester_get_type (void) {
	static volatile gsize rygel_media_export_harvester_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_harvester_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportHarvesterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_harvester_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportHarvester), 0, (GInstanceInitFunc) rygel_media_export_harvester_instance_init, NULL };
		GType rygel_media_export_harvester_type_id;
		rygel_media_export_harvester_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportHarvester", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_harvester_type_id__volatile, rygel_media_export_harvester_type_id);
	}
	return rygel_media_export_harvester_type_id__volatile;
}


static void _vala_rygel_media_export_harvester_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaExportHarvester * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester);
	switch (property_id) {
		case RYGEL_MEDIA_EXPORT_HARVESTER_LOCATIONS_PROPERTY:
		g_value_set_object (value, rygel_media_export_harvester_get_locations (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_media_export_harvester_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaExportHarvester * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester);
	switch (property_id) {
		case RYGEL_MEDIA_EXPORT_HARVESTER_LOCATIONS_PROPERTY:
		rygel_media_export_harvester_set_locations (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



