/* rygel-tracker-music-item-factory.c generated by valac 0.27.2.2-e6bbc, the Vala compiler
 * generated from rygel-tracker-music-item-factory.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008-2012 Nokia Corporation.
 * Copyright (C) 2010 MediaNet Inh.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Sunil Mohan Adapa <sunil@medhas.org>
 *          Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-server.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <gee.h>
#include <rygel-core.h>


#define RYGEL_TRACKER_TYPE_ITEM_FACTORY (rygel_tracker_item_factory_get_type ())
#define RYGEL_TRACKER_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactory))
#define RYGEL_TRACKER_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))
#define RYGEL_TRACKER_IS_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_IS_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))

typedef struct _RygelTrackerItemFactory RygelTrackerItemFactory;
typedef struct _RygelTrackerItemFactoryClass RygelTrackerItemFactoryClass;
typedef struct _RygelTrackerItemFactoryPrivate RygelTrackerItemFactoryPrivate;

#define RYGEL_TRACKER_TYPE_SEARCH_CONTAINER (rygel_tracker_search_container_get_type ())
#define RYGEL_TRACKER_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainer))
#define RYGEL_TRACKER_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_SEARCH_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))

typedef struct _RygelTrackerSearchContainer RygelTrackerSearchContainer;
typedef struct _RygelTrackerSearchContainerClass RygelTrackerSearchContainerClass;

#define RYGEL_TRACKER_TYPE_MUSIC_ITEM_FACTORY (rygel_tracker_music_item_factory_get_type ())
#define RYGEL_TRACKER_MUSIC_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_MUSIC_ITEM_FACTORY, RygelTrackerMusicItemFactory))
#define RYGEL_TRACKER_MUSIC_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_MUSIC_ITEM_FACTORY, RygelTrackerMusicItemFactoryClass))
#define RYGEL_TRACKER_IS_MUSIC_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_MUSIC_ITEM_FACTORY))
#define RYGEL_TRACKER_IS_MUSIC_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_MUSIC_ITEM_FACTORY))
#define RYGEL_TRACKER_MUSIC_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_MUSIC_ITEM_FACTORY, RygelTrackerMusicItemFactoryClass))

typedef struct _RygelTrackerMusicItemFactory RygelTrackerMusicItemFactory;
typedef struct _RygelTrackerMusicItemFactoryClass RygelTrackerMusicItemFactoryClass;
typedef struct _RygelTrackerMusicItemFactoryPrivate RygelTrackerMusicItemFactoryPrivate;

#define RYGEL_TRACKER_ITEM_FACTORY_TYPE_METADATA (rygel_tracker_item_factory_metadata_get_type ())

#define RYGEL_TRACKER_MUSIC_ITEM_FACTORY_TYPE_MUSIC_METADATA (rygel_tracker_music_item_factory_music_metadata_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelTrackerItemFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerItemFactoryPrivate * priv;
	gchar* category;
	gchar* category_iri;
	gchar* upnp_class;
	gchar* upload_dir;
	GeeArrayList* properties;
};

struct _RygelTrackerItemFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerItemFactory *self);
	RygelMediaFileItem* (*create) (RygelTrackerItemFactory* self, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, TrackerSparqlCursor* metadata, GError** error);
	void (*set_metadata) (RygelTrackerItemFactory* self, RygelMediaFileItem* item, const gchar* uri, TrackerSparqlCursor* metadata, GError** error);
	void (*add_resources) (RygelTrackerItemFactory* self, RygelMediaItem* item, GError** error);
};

struct _RygelTrackerMusicItemFactory {
	RygelTrackerItemFactory parent_instance;
	RygelTrackerMusicItemFactoryPrivate * priv;
};

struct _RygelTrackerMusicItemFactoryClass {
	RygelTrackerItemFactoryClass parent_class;
};

typedef enum  {
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_TRACKER_ID,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_URL,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_PLACE_HOLDER,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_FILE_NAME,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_TITLE,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_DLNA_PROFILE,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_MIME,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_SIZE,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_DATE,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_LAST_KEY
} RygelTrackerItemFactoryMetadata;

typedef enum  {
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_DURATION = RYGEL_TRACKER_ITEM_FACTORY_METADATA_LAST_KEY,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ALBUM,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ARTIST,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_TRACK_NUM,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_GENRE,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_SAMPLE_RATE,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_CHANNELS,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITS_PER_SAMPLE,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITRATE,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_LAST_KEY
} RygelTrackerMusicItemFactoryMusicMetadata;


static gpointer rygel_tracker_music_item_factory_parent_class = NULL;

gpointer rygel_tracker_item_factory_ref (gpointer instance);
void rygel_tracker_item_factory_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_item_factory (GValue* value, gpointer v_object);
void rygel_tracker_value_take_item_factory (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_item_factory (const GValue* value);
GType rygel_tracker_item_factory_get_type (void) G_GNUC_CONST;
GType rygel_tracker_search_container_get_type (void) G_GNUC_CONST;
GType rygel_tracker_music_item_factory_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_DUMMY_PROPERTY
};
GType rygel_tracker_item_factory_metadata_get_type (void) G_GNUC_CONST;
static GType rygel_tracker_music_item_factory_music_metadata_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define RYGEL_TRACKER_MUSIC_ITEM_FACTORY_CATEGORY "nmm:MusicPiece"
#define RYGEL_TRACKER_MUSIC_ITEM_FACTORY_CATEGORY_IRI "http://www.tracker-project.org/" "temp/nmm#MusicPiece"
RygelTrackerMusicItemFactory* rygel_tracker_music_item_factory_new (void);
RygelTrackerMusicItemFactory* rygel_tracker_music_item_factory_construct (GType object_type);
RygelTrackerItemFactory* rygel_tracker_item_factory_construct (GType object_type, const gchar* category, const gchar* category_iri, const gchar* upnp_class, const gchar* upload_dir);
static RygelMediaFileItem* rygel_tracker_music_item_factory_real_create (RygelTrackerItemFactory* base, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, TrackerSparqlCursor* metadata, GError** error);
void rygel_tracker_item_factory_set_metadata (RygelTrackerItemFactory* self, RygelMediaFileItem* item, const gchar* uri, TrackerSparqlCursor* metadata, GError** error);
static void rygel_tracker_music_item_factory_real_set_metadata (RygelTrackerItemFactory* base, RygelMediaFileItem* item, const gchar* uri, TrackerSparqlCursor* metadata, GError** error);
void rygel_tracker_item_factory_set_ref_id (RygelTrackerItemFactory* self, RygelMediaFileItem* item, const gchar* prefix);
void rygel_tracker_item_factory_add_resources (RygelTrackerItemFactory* self, RygelMediaItem* item, GError** error);


static GType rygel_tracker_music_item_factory_music_metadata_get_type (void) {
	static volatile gsize rygel_tracker_music_item_factory_music_metadata_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_music_item_factory_music_metadata_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_DURATION, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_DURATION", "duration"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ALBUM, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ALBUM", "audio-album"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ARTIST, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ARTIST", "audio-artist"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_TRACK_NUM, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_TRACK_NUM", "audio-track-num"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_GENRE, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_GENRE", "audio-genre"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_SAMPLE_RATE, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_SAMPLE_RATE", "sample-rate"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_CHANNELS, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_CHANNELS", "channels"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITS_PER_SAMPLE, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITS_PER_SAMPLE", "bits-per-sample"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITRATE, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITRATE", "bitrate"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_LAST_KEY, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_LAST_KEY", "last-key"}, {0, NULL, NULL}};
		GType rygel_tracker_music_item_factory_music_metadata_type_id;
		rygel_tracker_music_item_factory_music_metadata_type_id = g_enum_register_static ("RygelTrackerMusicItemFactoryMusicMetadata", values);
		g_once_init_leave (&rygel_tracker_music_item_factory_music_metadata_type_id__volatile, rygel_tracker_music_item_factory_music_metadata_type_id);
	}
	return rygel_tracker_music_item_factory_music_metadata_type_id__volatile;
}


RygelTrackerMusicItemFactory* rygel_tracker_music_item_factory_construct (GType object_type) {
	RygelTrackerMusicItemFactory* self = NULL;
	gchar* upload_folder = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp6_ = NULL;
	GeeArrayList* _tmp7_ = NULL;
	GeeArrayList* _tmp8_ = NULL;
	GeeArrayList* _tmp9_ = NULL;
	GeeArrayList* _tmp10_ = NULL;
	GeeArrayList* _tmp11_ = NULL;
	GeeArrayList* _tmp12_ = NULL;
	GeeArrayList* _tmp13_ = NULL;
	GeeArrayList* _tmp14_ = NULL;
	GeeArrayList* _tmp15_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_get_user_special_dir (G_USER_DIRECTORY_MUSIC);
	_tmp1_ = g_strdup (_tmp0_);
	upload_folder = _tmp1_;
	{
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp2_ = rygel_meta_config_get_default ();
		config = _tmp2_;
		_tmp4_ = rygel_configuration_get_music_upload_folder ((RygelConfiguration*) config, &_inner_error_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (config);
			goto __catch12_g_error;
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_g_free0 (upload_folder);
		upload_folder = _tmp5_;
		_g_free0 (_tmp3_);
		_g_object_unref0 (config);
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally12:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (upload_folder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp6_ = upload_folder;
	self = (RygelTrackerMusicItemFactory*) rygel_tracker_item_factory_construct (object_type, RYGEL_TRACKER_MUSIC_ITEM_FACTORY_CATEGORY, RYGEL_TRACKER_MUSIC_ITEM_FACTORY_CATEGORY_IRI, RYGEL_MUSIC_ITEM_UPNP_CLASS, _tmp6_);
	_tmp7_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, "res@duration");
	_tmp8_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, "upnp:album");
	_tmp9_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, "upnp:artist");
	_tmp10_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, "upnp:originalTrackNumber");
	_tmp11_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, "upnp:genre");
	_tmp12_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, "sampleRate");
	_tmp13_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, "upnp:nrAudioChannels");
	_tmp14_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, "upnp:bitsPerSample");
	_tmp15_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, "upnp:bitrate");
	_g_free0 (upload_folder);
	return self;
}


RygelTrackerMusicItemFactory* rygel_tracker_music_item_factory_new (void) {
	return rygel_tracker_music_item_factory_construct (RYGEL_TRACKER_TYPE_MUSIC_ITEM_FACTORY);
}


static RygelMediaFileItem* rygel_tracker_music_item_factory_real_create (RygelTrackerItemFactory* base, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, TrackerSparqlCursor* metadata, GError** error) {
	RygelTrackerMusicItemFactory * self;
	RygelMediaFileItem* result = NULL;
	RygelMusicItem* item = NULL;
	const gchar* _tmp0_ = NULL;
	RygelTrackerSearchContainer* _tmp1_ = NULL;
	RygelMusicItem* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	TrackerSparqlCursor* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelTrackerMusicItemFactory*) base;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (metadata != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = parent;
	_tmp2_ = rygel_music_item_new (_tmp0_, (RygelMediaContainer*) _tmp1_, "", RYGEL_MUSIC_ITEM_UPNP_CLASS);
	item = _tmp2_;
	_tmp3_ = uri;
	_tmp4_ = metadata;
	rygel_tracker_item_factory_set_metadata ((RygelTrackerItemFactory*) self, (RygelMediaFileItem*) item, _tmp3_, _tmp4_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (item);
		return NULL;
	}
	result = (RygelMediaFileItem*) item;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_tracker_music_item_factory_real_set_metadata (RygelTrackerItemFactory* base, RygelMediaFileItem* item, const gchar* uri, TrackerSparqlCursor* metadata, GError** error) {
	RygelTrackerMusicItemFactory * self;
	RygelMediaFileItem* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	TrackerSparqlCursor* _tmp2_ = NULL;
	RygelMediaFileItem* _tmp3_ = NULL;
	RygelMusicItem* music = NULL;
	RygelMediaFileItem* _tmp4_ = NULL;
	RygelMusicItem* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	TrackerSparqlCursor* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	TrackerSparqlCursor* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	TrackerSparqlCursor* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	TrackerSparqlCursor* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	TrackerSparqlCursor* _tmp29_ = NULL;
	gboolean _tmp30_ = FALSE;
	TrackerSparqlCursor* _tmp34_ = NULL;
	gboolean _tmp35_ = FALSE;
	TrackerSparqlCursor* _tmp39_ = NULL;
	gboolean _tmp40_ = FALSE;
	TrackerSparqlCursor* _tmp44_ = NULL;
	gboolean _tmp45_ = FALSE;
	TrackerSparqlCursor* _tmp49_ = NULL;
	gboolean _tmp50_ = FALSE;
	RygelMusicItem* _tmp54_ = NULL;
	RygelMusicItem* _tmp55_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelTrackerMusicItemFactory*) base;
	g_return_if_fail (item != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (metadata != NULL);
	_tmp0_ = item;
	_tmp1_ = uri;
	_tmp2_ = metadata;
	RYGEL_TRACKER_ITEM_FACTORY_CLASS (rygel_tracker_music_item_factory_parent_class)->set_metadata (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactory), _tmp0_, _tmp1_, _tmp2_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp3_ = item;
	rygel_tracker_item_factory_set_ref_id ((RygelTrackerItemFactory*) self, _tmp3_, "AllMusic");
	_tmp4_ = item;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_MUSIC_ITEM) ? ((RygelMusicItem*) _tmp4_) : NULL);
	music = _tmp5_;
	_tmp7_ = metadata;
	_tmp8_ = tracker_sparql_cursor_is_bound (_tmp7_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_DURATION);
	if (_tmp8_) {
		TrackerSparqlCursor* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		_tmp9_ = metadata;
		_tmp10_ = tracker_sparql_cursor_get_string (_tmp9_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_DURATION, NULL);
		_tmp6_ = g_strcmp0 (_tmp10_, "0") != 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		RygelMusicItem* _tmp11_ = NULL;
		TrackerSparqlCursor* _tmp12_ = NULL;
		gint64 _tmp13_ = 0LL;
		_tmp11_ = music;
		_tmp12_ = metadata;
		_tmp13_ = tracker_sparql_cursor_get_integer (_tmp12_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_DURATION);
		rygel_audio_item_set_duration ((RygelAudioItem*) _tmp11_, (glong) _tmp13_);
	}
	_tmp14_ = metadata;
	_tmp15_ = tracker_sparql_cursor_is_bound (_tmp14_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_SAMPLE_RATE);
	if (_tmp15_) {
		RygelMusicItem* _tmp16_ = NULL;
		TrackerSparqlCursor* _tmp17_ = NULL;
		gint64 _tmp18_ = 0LL;
		_tmp16_ = music;
		_tmp17_ = metadata;
		_tmp18_ = tracker_sparql_cursor_get_integer (_tmp17_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_SAMPLE_RATE);
		rygel_audio_item_set_sample_freq ((RygelAudioItem*) _tmp16_, (gint) _tmp18_);
	}
	_tmp19_ = metadata;
	_tmp20_ = tracker_sparql_cursor_is_bound (_tmp19_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_CHANNELS);
	if (_tmp20_) {
		RygelMusicItem* _tmp21_ = NULL;
		TrackerSparqlCursor* _tmp22_ = NULL;
		gint64 _tmp23_ = 0LL;
		_tmp21_ = music;
		_tmp22_ = metadata;
		_tmp23_ = tracker_sparql_cursor_get_integer (_tmp22_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_CHANNELS);
		rygel_audio_item_set_channels ((RygelAudioItem*) _tmp21_, (gint) _tmp23_);
	}
	_tmp24_ = metadata;
	_tmp25_ = tracker_sparql_cursor_is_bound (_tmp24_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITS_PER_SAMPLE);
	if (_tmp25_) {
		RygelMusicItem* _tmp26_ = NULL;
		TrackerSparqlCursor* _tmp27_ = NULL;
		gint64 _tmp28_ = 0LL;
		_tmp26_ = music;
		_tmp27_ = metadata;
		_tmp28_ = tracker_sparql_cursor_get_integer (_tmp27_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITS_PER_SAMPLE);
		rygel_audio_item_set_bits_per_sample ((RygelAudioItem*) _tmp26_, (gint) _tmp28_);
	}
	_tmp29_ = metadata;
	_tmp30_ = tracker_sparql_cursor_is_bound (_tmp29_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITRATE);
	if (_tmp30_) {
		RygelMusicItem* _tmp31_ = NULL;
		TrackerSparqlCursor* _tmp32_ = NULL;
		gint64 _tmp33_ = 0LL;
		_tmp31_ = music;
		_tmp32_ = metadata;
		_tmp33_ = tracker_sparql_cursor_get_integer (_tmp32_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITRATE);
		rygel_audio_item_set_bitrate ((RygelAudioItem*) _tmp31_, ((gint) _tmp33_) / 8);
	}
	_tmp34_ = metadata;
	_tmp35_ = tracker_sparql_cursor_is_bound (_tmp34_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_TRACK_NUM);
	if (_tmp35_) {
		RygelMusicItem* _tmp36_ = NULL;
		TrackerSparqlCursor* _tmp37_ = NULL;
		gint64 _tmp38_ = 0LL;
		_tmp36_ = music;
		_tmp37_ = metadata;
		_tmp38_ = tracker_sparql_cursor_get_integer (_tmp37_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_TRACK_NUM);
		rygel_music_item_set_track_number (_tmp36_, (gint) _tmp38_);
	}
	_tmp39_ = metadata;
	_tmp40_ = tracker_sparql_cursor_is_bound (_tmp39_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ARTIST);
	if (_tmp40_) {
		RygelMusicItem* _tmp41_ = NULL;
		TrackerSparqlCursor* _tmp42_ = NULL;
		const gchar* _tmp43_ = NULL;
		_tmp41_ = music;
		_tmp42_ = metadata;
		_tmp43_ = tracker_sparql_cursor_get_string (_tmp42_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ARTIST, NULL);
		rygel_media_object_set_artist ((RygelMediaObject*) _tmp41_, _tmp43_);
	}
	_tmp44_ = metadata;
	_tmp45_ = tracker_sparql_cursor_is_bound (_tmp44_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ALBUM);
	if (_tmp45_) {
		RygelMusicItem* _tmp46_ = NULL;
		TrackerSparqlCursor* _tmp47_ = NULL;
		const gchar* _tmp48_ = NULL;
		_tmp46_ = music;
		_tmp47_ = metadata;
		_tmp48_ = tracker_sparql_cursor_get_string (_tmp47_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ALBUM, NULL);
		rygel_audio_item_set_album ((RygelAudioItem*) _tmp46_, _tmp48_);
	}
	_tmp49_ = metadata;
	_tmp50_ = tracker_sparql_cursor_is_bound (_tmp49_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_GENRE);
	if (_tmp50_) {
		RygelMusicItem* _tmp51_ = NULL;
		TrackerSparqlCursor* _tmp52_ = NULL;
		const gchar* _tmp53_ = NULL;
		_tmp51_ = music;
		_tmp52_ = metadata;
		_tmp53_ = tracker_sparql_cursor_get_string (_tmp52_, (gint) RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_GENRE, NULL);
		rygel_media_object_set_genre ((RygelMediaObject*) _tmp51_, _tmp53_);
	}
	_tmp54_ = music;
	rygel_music_item_lookup_album_art (_tmp54_);
	_tmp55_ = music;
	RYGEL_TRACKER_ITEM_FACTORY_CLASS (rygel_tracker_music_item_factory_parent_class)->add_resources (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactory), (RygelMediaItem*) _tmp55_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (music);
		return;
	}
	_g_object_unref0 (music);
}


static void rygel_tracker_music_item_factory_class_init (RygelTrackerMusicItemFactoryClass * klass) {
	rygel_tracker_music_item_factory_parent_class = g_type_class_peek_parent (klass);
	((RygelTrackerItemFactoryClass *) klass)->create = rygel_tracker_music_item_factory_real_create;
	((RygelTrackerItemFactoryClass *) klass)->set_metadata = rygel_tracker_music_item_factory_real_set_metadata;
}


static void rygel_tracker_music_item_factory_instance_init (RygelTrackerMusicItemFactory * self) {
}


/**
 * Tracker music item factory.
 */
GType rygel_tracker_music_item_factory_get_type (void) {
	static volatile gsize rygel_tracker_music_item_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_music_item_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerMusicItemFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_music_item_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerMusicItemFactory), 0, (GInstanceInitFunc) rygel_tracker_music_item_factory_instance_init, NULL };
		GType rygel_tracker_music_item_factory_type_id;
		rygel_tracker_music_item_factory_type_id = g_type_register_static (RYGEL_TRACKER_TYPE_ITEM_FACTORY, "RygelTrackerMusicItemFactory", &g_define_type_info, 0);
		g_once_init_leave (&rygel_tracker_music_item_factory_type_id__volatile, rygel_tracker_music_item_factory_type_id);
	}
	return rygel_tracker_music_item_factory_type_id__volatile;
}



