/* rygel-http-get-test.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-http-get-test.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
typedef struct _RygelClientHacksPrivate RygelClientHacksPrivate;
#define __vala_SoupMessageHeaders_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupMessageHeaders_free (var), NULL)))

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelParamSpecClientHacks RygelParamSpecClientHacks;

#define RYGEL_TYPE_TEST_REQUEST_FACTORY (rygel_test_request_factory_get_type ())
#define RYGEL_TEST_REQUEST_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TEST_REQUEST_FACTORY, RygelTestRequestFactory))
#define RYGEL_TEST_REQUEST_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TEST_REQUEST_FACTORY, RygelTestRequestFactoryClass))
#define RYGEL_IS_TEST_REQUEST_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TEST_REQUEST_FACTORY))
#define RYGEL_IS_TEST_REQUEST_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TEST_REQUEST_FACTORY))
#define RYGEL_TEST_REQUEST_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TEST_REQUEST_FACTORY, RygelTestRequestFactoryClass))

typedef struct _RygelTestRequestFactory RygelTestRequestFactory;
typedef struct _RygelTestRequestFactoryClass RygelTestRequestFactoryClass;
typedef struct _RygelTestRequestFactoryPrivate RygelTestRequestFactoryPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
#define _rygel_http_get_handler_unref0(var) ((var == NULL) ? NULL : (var = (rygel_http_get_handler_unref (var), NULL)))
typedef struct _RygelParamSpecTestRequestFactory RygelParamSpecTestRequestFactory;

#define RYGEL_TYPE_HTTP_GET_TEST (rygel_http_get_test_get_type ())
#define RYGEL_HTTP_GET_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTest))
#define RYGEL_HTTP_GET_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTestClass))
#define RYGEL_IS_HTTP_GET_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_TEST))
#define RYGEL_IS_HTTP_GET_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_TEST))
#define RYGEL_HTTP_GET_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTestClass))

typedef struct _RygelHTTPGetTest RygelHTTPGetTest;
typedef struct _RygelHTTPGetTestClass RygelHTTPGetTestClass;
typedef struct _RygelHTTPGetTestPrivate RygelHTTPGetTestPrivate;

#define RYGEL_TYPE_HTTP_CLIENT (rygel_http_client_get_type ())
#define RYGEL_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClient))
#define RYGEL_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))
#define RYGEL_IS_HTTP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_IS_HTTP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_CLIENT))
#define RYGEL_HTTP_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientClass))

typedef struct _RygelHTTPClient RygelHTTPClient;
typedef struct _RygelHTTPClientClass RygelHTTPClientClass;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _rygel_test_request_factory_unref0(var) ((var == NULL) ? NULL : (var = (rygel_test_request_factory_unref (var), NULL)))

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;
#define _rygel_media_object_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_object_unref (var), NULL)))
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelHTTPClientPrivate RygelHTTPClientPrivate;
typedef struct _RygelHttpGetTestHandleClientMessageData RygelHttpGetTestHandleClientMessageData;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
typedef struct _Block1Data Block1Data;
typedef struct _RygelHttpClientRunData RygelHttpClientRunData;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;
typedef struct _Block2Data Block2Data;
typedef struct _RygelMediaContainerFindObjectData RygelMediaContainerFindObjectData;
typedef struct _RygelHTTPGetHandlerPrivate RygelHTTPGetHandlerPrivate;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
typedef struct _RygelParamSpecHTTPGetHandler RygelParamSpecHTTPGetHandler;

#define RYGEL_TYPE_HTTP_TRANSCODE_HANDLER (rygel_http_transcode_handler_get_type ())
#define RYGEL_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandler))
#define RYGEL_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_IS_HTTP_TRANSCODE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER))
#define RYGEL_HTTP_TRANSCODE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, RygelHTTPTranscodeHandlerClass))

typedef struct _RygelHTTPTranscodeHandler RygelHTTPTranscodeHandler;
typedef struct _RygelHTTPTranscodeHandlerClass RygelHTTPTranscodeHandlerClass;
typedef struct _RygelHTTPTranscodeHandlerPrivate RygelHTTPTranscodeHandlerPrivate;

#define RYGEL_TYPE_HTTP_IDENTITY_HANDLER (rygel_http_identity_handler_get_type ())
#define RYGEL_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandler))
#define RYGEL_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_HTTP_IDENTITY_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))

typedef struct _RygelHTTPIdentityHandler RygelHTTPIdentityHandler;
typedef struct _RygelHTTPIdentityHandlerClass RygelHTTPIdentityHandlerClass;
typedef struct _RygelHTTPIdentityHandlerPrivate RygelHTTPIdentityHandlerPrivate;

#define RYGEL_TYPE_HTTP_PLAYLIST_HANDLER (rygel_http_playlist_handler_get_type ())
#define RYGEL_HTTP_PLAYLIST_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER, RygelHTTPPlaylistHandler))
#define RYGEL_HTTP_PLAYLIST_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER, RygelHTTPPlaylistHandlerClass))
#define RYGEL_IS_HTTP_PLAYLIST_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER))
#define RYGEL_IS_HTTP_PLAYLIST_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER))
#define RYGEL_HTTP_PLAYLIST_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER, RygelHTTPPlaylistHandlerClass))

typedef struct _RygelHTTPPlaylistHandler RygelHTTPPlaylistHandler;
typedef struct _RygelHTTPPlaylistHandlerClass RygelHTTPPlaylistHandlerClass;
typedef struct _RygelHTTPPlaylistHandlerPrivate RygelHTTPPlaylistHandlerPrivate;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;
typedef struct _RygelVideoItemPrivate RygelVideoItemPrivate;
#define _rygel_thumbnail_unref0(var) ((var == NULL) ? NULL : (var = (rygel_thumbnail_unref (var), NULL)))

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
typedef struct _RygelMusicItemPrivate RygelMusicItemPrivate;
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;
typedef struct _RygelParamSpecThumbnail RygelParamSpecThumbnail;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;
typedef struct _RygelParamSpecSubtitle RygelParamSpecSubtitle;
typedef struct _RygelHTTPResponsePrivate RygelHTTPResponsePrivate;
typedef struct _Block3Data Block3Data;
typedef struct _RygelHttpResponseRunData RygelHttpResponseRunData;
typedef struct _RygelParamSpecMediaObject RygelParamSpecMediaObject;
typedef struct _RygelTranscoderPrivate RygelTranscoderPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	RYGEL_TEST_ERROR_SKIP = 77,
	RYGEL_TEST_ERROR_TIMEOUT
} RygelTestError;
#define RYGEL_TEST_ERROR rygel_test_error_quark ()
typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()
struct _RygelClientHacks {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelClientHacksPrivate * priv;
};

struct _RygelClientHacksClass {
	GTypeClass parent_class;
	void (*finalize) (RygelClientHacks *self);
};

struct _RygelParamSpecClientHacks {
	GParamSpec parent_instance;
};

struct _RygelTestRequestFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTestRequestFactoryPrivate * priv;
	SoupMessage* msg;
	SoupStatus expected_code;
};

struct _RygelTestRequestFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTestRequestFactory *self);
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPGet {
	RygelHTTPRequest parent_instance;
	RygelHTTPGetPrivate * priv;
	RygelThumbnail* thumbnail;
	RygelSubtitle* subtitle;
	RygelHTTPSeek* seek;
	RygelHTTPGetHandler* handler;
};

struct _RygelHTTPGetClass {
	RygelHTTPRequestClass parent_class;
};

struct _RygelParamSpecTestRequestFactory {
	GParamSpec parent_instance;
};

struct _RygelHTTPGetTest {
	GObject parent_instance;
	RygelHTTPGetTestPrivate * priv;
	RygelHTTPServer* server;
	RygelHTTPClient* client;
};

struct _RygelHTTPGetTestClass {
	GObjectClass parent_class;
	void (*run) (RygelHTTPGetTest* self, GError** error);
};

struct _RygelHTTPGetTestPrivate {
	gboolean server_done;
	gboolean client_done;
	GMainLoop* main_loop;
	GError* error;
	GeeArrayList* requests;
	RygelTestRequestFactory* current_request;
};

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};

struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};

struct _RygelHTTPClient {
	GObject parent_instance;
	RygelHTTPClientPrivate * priv;
	GUPnPContext* context;
	SoupMessage* msg;
};

struct _RygelHTTPClientClass {
	GObjectClass parent_class;
};

struct _RygelHttpGetTestHandleClientMessageData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPGetTest* self;
	SoupMessage* msg;
	RygelHTTPGet* request;
	SoupMessage* _tmp0_;
	RygelHTTPGet* _tmp1_;
	RygelHTTPGet* _tmp2_;
	RygelHTTPGet* _tmp3_;
	RygelMediaObject* _tmp4_;
	SoupMessage* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	SoupMessage* _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	RygelTestRequestFactory* _tmp11_;
	SoupStatus _tmp12_;
	gboolean _tmp13_;
	GMainLoop* _tmp14_;
	GError* _error_;
	GError* _tmp15_;
	GError* _tmp16_;
	GMainLoop* _tmp17_;
	GError * _inner_error_;
};

struct _RygelMediaObject {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* mime_type;
};

struct _RygelMediaObjectClass {
	GTypeClass parent_class;
	void (*finalize) (RygelMediaObject *self);
};

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPClientPrivate {
	GCancellable* _cancellable;
};

struct _Block1Data {
	int _ref_count_;
	RygelHTTPClient* self;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelHttpClientRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPClient* self;
	Block1Data* _data1_;
	GUPnPContext* _tmp0_;
	SoupSession* _tmp1_;
	SoupSession* _tmp2_;
	SoupMessage* _tmp3_;
	SoupMessage* _tmp4_;
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	RygelMediaContainer* self;
	GSourceFunc find_object_continue;
	gpointer find_object_continue_target;
	GDestroyNotify find_object_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelMediaContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaContainer* self;
	gchar* item_id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	Block2Data* _data2_;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	RygelVideoItem* _tmp2_;
	const gchar* _tmp3_;
	RygelAudioItem* _tmp4_;
};

struct _RygelHTTPGetHandler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelHTTPGetHandlerPrivate * priv;
};

struct _RygelHTTPGetHandlerClass {
	GTypeClass parent_class;
	void (*finalize) (RygelHTTPGetHandler *self);
};

struct _RygelParamSpecHTTPGetHandler {
	GParamSpec parent_instance;
};

struct _RygelHTTPTranscodeHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPTranscodeHandlerPrivate * priv;
};

struct _RygelHTTPTranscodeHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

struct _RygelHTTPIdentityHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPIdentityHandlerPrivate * priv;
};

struct _RygelHTTPIdentityHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

struct _RygelHTTPPlaylistHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPPlaylistHandlerPrivate * priv;
};

struct _RygelHTTPPlaylistHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	glong size;
	GeeArrayList* uris;
	gboolean place_holder;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	gint64 duration;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelVideoItem {
	RygelAudioItem parent_instance;
	RygelVideoItemPrivate * priv;
	GeeArrayList* subtitles;
};

struct _RygelVideoItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelVideoItemPrivate {
	gint _width;
	gint _height;
	gint _color_depth;
	GeeArrayList* ts;
};

struct _RygelMusicItem {
	RygelAudioItem parent_instance;
	RygelMusicItemPrivate * priv;
	RygelThumbnail* album_art;
};

struct _RygelMusicItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelThumbnail {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelThumbnailPrivate * priv;
	glong size;
	gchar* file_extension;
};

struct _RygelThumbnailClass {
	GTypeClass parent_class;
	void (*finalize) (RygelThumbnail *self);
};

struct _RygelParamSpecThumbnail {
	GParamSpec parent_instance;
};

struct _RygelSubtitle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSubtitlePrivate * priv;
	glong size;
	gchar* caption_type;
};

struct _RygelSubtitleClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSubtitle *self);
};

struct _RygelParamSpecSubtitle {
	GParamSpec parent_instance;
};

struct _RygelHTTPResponse {
	GObject parent_instance;
	RygelHTTPResponsePrivate * priv;
};

struct _RygelHTTPResponseClass {
	GObjectClass parent_class;
};

struct _RygelHTTPResponsePrivate {
	GCancellable* _cancellable;
	SoupMessage* msg;
	SoupServer* server;
};

struct _Block3Data {
	int _ref_count_;
	RygelHTTPResponse* self;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
	gpointer _async_data_;
};

struct _RygelHttpResponseRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPResponse* self;
	Block3Data* _data3_;
	SoupMessage* _tmp0_;
	SoupServer* _tmp1_;
	SoupMessage* _tmp2_;
};

struct _RygelParamSpecMediaObject {
	GParamSpec parent_instance;
};

struct _RygelTranscoder {
	GObject parent_instance;
	RygelTranscoderPrivate * priv;
};

struct _RygelTranscoderClass {
	GObjectClass parent_class;
};

struct _RygelTranscoderPrivate {
	gchar* _extension;
};


static gpointer rygel_client_hacks_parent_class = NULL;
static gpointer rygel_test_request_factory_parent_class = NULL;
static gpointer rygel_http_get_test_parent_class = NULL;
static gpointer rygel_http_server_parent_class = NULL;
static gpointer rygel_http_client_parent_class = NULL;
static RygelStateMachineIface* rygel_http_client_rygel_state_machine_parent_iface = NULL;
static gpointer rygel_media_container_parent_class = NULL;
static gpointer rygel_http_get_handler_parent_class = NULL;
static gpointer rygel_http_transcode_handler_parent_class = NULL;
static gpointer rygel_http_identity_handler_parent_class = NULL;
static gpointer rygel_http_playlist_handler_parent_class = NULL;
static gpointer rygel_media_item_parent_class = NULL;
static gpointer rygel_audio_item_parent_class = NULL;
static gpointer rygel_video_item_parent_class = NULL;
static RygelVisualItemIface* rygel_video_item_rygel_visual_item_parent_iface = NULL;
static gpointer rygel_music_item_parent_class = NULL;
static gpointer rygel_thumbnail_parent_class = NULL;
static gpointer rygel_subtitle_parent_class = NULL;
static gpointer rygel_http_response_parent_class = NULL;
static RygelStateMachineIface* rygel_http_response_rygel_state_machine_parent_iface = NULL;
static gpointer rygel_media_object_parent_class = NULL;
static gpointer rygel_transcoder_parent_class = NULL;

GQuark rygel_test_error_quark (void);
GQuark rygel_client_hacks_error_quark (void);
gpointer rygel_client_hacks_ref (gpointer instance);
void rygel_client_hacks_unref (gpointer instance);
GParamSpec* rygel_param_spec_client_hacks (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_client_hacks (GValue* value, gpointer v_object);
void rygel_value_take_client_hacks (GValue* value, gpointer v_object);
gpointer rygel_value_get_client_hacks (const GValue* value);
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_CLIENT_HACKS_DUMMY_PROPERTY
};
RygelClientHacks* rygel_client_hacks_create (SoupMessage* message, GError** error);
static SoupMessageHeaders* _vala_SoupMessageHeaders_copy (SoupMessageHeaders* self);
RygelClientHacks* rygel_client_hacks_new (void);
RygelClientHacks* rygel_client_hacks_construct (GType object_type);
static void _vala_SoupMessageHeaders_free (SoupMessageHeaders* self);
gpointer rygel_media_object_ref (gpointer instance);
void rygel_media_object_unref (gpointer instance);
GParamSpec* rygel_param_spec_media_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_media_object (GValue* value, gpointer v_object);
void rygel_value_take_media_object (GValue* value, gpointer v_object);
gpointer rygel_value_get_media_object (const GValue* value);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
void rygel_client_hacks_apply (RygelClientHacks* self, RygelMediaObject* item);
gboolean rygel_client_hacks_force_seek (RygelClientHacks* self);
static void rygel_client_hacks_finalize (RygelClientHacks* obj);
gpointer rygel_test_request_factory_ref (gpointer instance);
void rygel_test_request_factory_unref (gpointer instance);
GParamSpec* rygel_param_spec_test_request_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_test_request_factory (GValue* value, gpointer v_object);
void rygel_value_take_test_request_factory (GValue* value, gpointer v_object);
gpointer rygel_value_get_test_request_factory (const GValue* value);
GType rygel_test_request_factory_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_TEST_REQUEST_FACTORY_DUMMY_PROPERTY
};
RygelTestRequestFactory* rygel_test_request_factory_new (SoupMessage* msg, SoupStatus expected_code);
RygelTestRequestFactory* rygel_test_request_factory_construct (GType object_type, SoupMessage* msg, SoupStatus expected_code);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
RygelHTTPGet* rygel_test_request_factory_create_get (RygelTestRequestFactory* self, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPGet* rygel_http_get_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
gpointer rygel_thumbnail_ref (gpointer instance);
void rygel_thumbnail_unref (gpointer instance);
GParamSpec* rygel_param_spec_thumbnail (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_thumbnail (GValue* value, gpointer v_object);
void rygel_value_take_thumbnail (GValue* value, gpointer v_object);
gpointer rygel_value_get_thumbnail (const GValue* value);
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_get_type (void) G_GNUC_CONST;
gpointer rygel_http_get_handler_ref (gpointer instance);
void rygel_http_get_handler_unref (gpointer instance);
GParamSpec* rygel_param_spec_http_get_handler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_http_get_handler (GValue* value, gpointer v_object);
void rygel_value_take_http_get_handler (GValue* value, gpointer v_object);
gpointer rygel_value_get_http_get_handler (const GValue* value);
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
static void rygel_test_request_factory_finalize (RygelTestRequestFactory* obj);
GType rygel_http_get_test_get_type (void) G_GNUC_CONST;
GType rygel_http_client_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_GET_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTestPrivate))
enum  {
	RYGEL_HTTP_GET_TEST_DUMMY_PROPERTY
};
gint rygel_http_get_test_main (gchar** args, int args_length1);
RygelHTTPGetTest* rygel_http_get_test_new (GError** error);
RygelHTTPGetTest* rygel_http_get_test_construct (GType object_type, GError** error);
void rygel_http_get_test_run (RygelHTTPGetTest* self, GError** error);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
RygelVideoItem* rygel_video_item_new (void);
RygelVideoItem* rygel_video_item_construct (GType object_type);
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
gboolean rygel_visual_item_is_live_stream (RygelVisualItem* self);
gboolean rygel_visual_item_streamable (RygelVisualItem* self);
RygelHTTPServer* rygel_http_server_new (GError** error);
RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error);
GType rygel_media_container_get_type (void) G_GNUC_CONST;
RygelHTTPClient* rygel_http_client_new (GUPnPContext* context);
RygelHTTPClient* rygel_http_client_construct (GType object_type, GUPnPContext* context);
static void rygel_http_get_test_create_test_messages (RygelHTTPGetTest* self);
static void rygel_http_get_test_real_run (RygelHTTPGetTest* self, GError** error);
static gboolean rygel_http_get_test_on_timeout (RygelHTTPGetTest* self);
static gboolean _rygel_http_get_test_on_timeout_gsource_func (gpointer self);
static void rygel_http_get_test_on_message_received (RygelHTTPGetTest* self, RygelHTTPServer* server, SoupMessage* msg);
static void _rygel_http_get_test_on_message_received_rygel_http_server_message_received (RygelHTTPServer* _sender, SoupMessage* message, gpointer self);
static void rygel_http_get_test_on_client_completed (RygelHTTPGetTest* self, RygelStateMachine* client);
static void _rygel_http_get_test_on_client_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
static void rygel_http_get_test_start_next_test_request (RygelHTTPGetTest* self);
gchar* rygel_http_server_get_uri (RygelHTTPServer* self);
gchar* rygel_http_server_create_uri (RygelHTTPServer* self, const gchar* item_id);
static RygelHTTPGet* rygel_http_get_test_create_request (RygelHTTPGetTest* self, SoupMessage* msg, GError** error);
void rygel_state_machine_run (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_state_machine_run_finish (RygelStateMachine* self, GAsyncResult* _res_);
static void rygel_http_get_test_handle_client_message (RygelHTTPGetTest* self, SoupMessage* msg, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_get_test_handle_client_message_finish (RygelHTTPGetTest* self, GAsyncResult* _res_);
static void rygel_http_get_test_handle_client_message_data_free (gpointer _data);
static gboolean rygel_http_get_test_handle_client_message_co (RygelHttpGetTestHandleClientMessageData* _data_);
static void rygel_http_get_test_handle_client_message_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_http_get_test_finalize (GObject* obj);
enum  {
	RYGEL_HTTP_SERVER_DUMMY_PROPERTY,
	RYGEL_HTTP_SERVER_PATH_ROOT,
	RYGEL_HTTP_SERVER_URI
};
#define RYGEL_HTTP_SERVER_SERVER_PATH "/RygelHTTPServer/Rygel/Test"
RygelHTTPItemURI* rygel_http_item_uri_new (RygelMediaObject* object, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_format);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, RygelMediaObject* object, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target, const gchar* playlist_format);
gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
static void rygel_http_server_server_cb (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client);
static void _rygel_http_server_server_cb_soup_server_callback (SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client, gpointer self);
RygelMediaContainer* rygel_media_container_new (void);
RygelMediaContainer* rygel_media_container_construct (GType object_type);
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
RygelTranscoder* rygel_http_server_get_transcoder (RygelHTTPServer* self, const gchar* target, GError** error);
RygelTranscoder* rygel_transcoder_new (const gchar* extension);
RygelTranscoder* rygel_transcoder_construct (GType object_type, const gchar* extension);
GQuark rygel_http_request_error_quark (void);
const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self);
static void rygel_http_server_finalize (GObject* obj);
static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
#define RYGEL_HTTP_CLIENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClientPrivate))
enum  {
	RYGEL_HTTP_CLIENT_DUMMY_PROPERTY,
	RYGEL_HTTP_CLIENT_CANCELLABLE
};
static void rygel_http_client_real_run_data_free (gpointer _data);
static void rygel_http_client_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_client_real_run_co (RygelHttpClientRunData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean _rygel_http_client_real_run_co_gsource_func (gpointer self);
static void __lambda7_ (Block1Data* _data1_, SoupSession* session, SoupMessage* msg);
static void ___lambda7__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
static void rygel_http_client_finalize (GObject* obj);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void _vala_rygel_http_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
static void _vala_rygel_http_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	RYGEL_MEDIA_CONTAINER_DUMMY_PROPERTY
};
static void rygel_media_container_find_object_data_free (gpointer _data);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* item_id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_media_container_find_object_co (RygelMediaContainerFindObjectData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean _rygel_media_container_find_object_co_gsource_func (gpointer self);
static gboolean __lambda4_ (Block2Data* _data2_);
static gboolean ___lambda4__gsource_func (gpointer self);
RygelAudioItem* rygel_audio_item_new (void);
RygelAudioItem* rygel_audio_item_construct (GType object_type);
RygelMediaObject* rygel_media_object_new (void);
RygelMediaObject* rygel_media_object_construct (GType object_type);
enum  {
	RYGEL_HTTP_GET_HANDLER_DUMMY_PROPERTY
};
GType rygel_http_response_get_type (void) G_GNUC_CONST;
RygelHTTPResponse* rygel_http_get_handler_render_body (RygelHTTPGetHandler* self, RygelHTTPGet* get_request);
RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* get_request);
RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPGet* get_request);
void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* get_request);
gboolean rygel_http_get_handler_knows_size (RygelHTTPGetHandler* self, RygelHTTPGet* request);
RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type);
static void rygel_http_get_handler_finalize (RygelHTTPGetHandler* obj);
GType rygel_http_transcode_handler_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_TRANSCODE_HANDLER_DUMMY_PROPERTY
};
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_new (RygelTranscoder* transcoder, GCancellable* cancellable);
RygelHTTPTranscodeHandler* rygel_http_transcode_handler_construct (GType object_type, RygelTranscoder* transcoder, GCancellable* cancellable);
GType rygel_http_identity_handler_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_IDENTITY_HANDLER_DUMMY_PROPERTY
};
RygelHTTPIdentityHandler* rygel_http_identity_handler_new (GCancellable* cancellable);
RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type, GCancellable* cancellable);
GType rygel_http_playlist_handler_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_PLAYLIST_HANDLER_DUMMY_PROPERTY
};
RygelHTTPPlaylistHandler* rygel_http_playlist_handler_new (const gchar* arg, GCancellable* cancellable);
RygelHTTPPlaylistHandler* rygel_http_playlist_handler_construct (GType object_type, const gchar* arg, GCancellable* cancellable);
gboolean rygel_http_playlist_handler_is_supported (const gchar* arg);
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY
};
GeeArrayList* rygel_media_item_get_uris (RygelMediaItem* self);
gboolean rygel_media_item_is_live_stream (RygelMediaItem* self);
gboolean rygel_media_item_streamable (RygelMediaItem* self);
RygelMediaItem* rygel_media_item_construct (GType object_type);
static void rygel_media_item_finalize (RygelMediaObject* obj);
enum  {
	RYGEL_AUDIO_ITEM_DUMMY_PROPERTY
};
static void rygel_audio_item_finalize (RygelMediaObject* obj);
gint rygel_visual_item_get_width (RygelVisualItem* self);
void rygel_visual_item_set_width (RygelVisualItem* self, gint value);
gint rygel_visual_item_get_height (RygelVisualItem* self);
void rygel_visual_item_set_height (RygelVisualItem* self, gint value);
gint rygel_visual_item_get_color_depth (RygelVisualItem* self);
void rygel_visual_item_set_color_depth (RygelVisualItem* self, gint value);
GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self);
void rygel_visual_item_set_thumbnails (RygelVisualItem* self, GeeArrayList* value);
#define RYGEL_VIDEO_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemPrivate))
enum  {
	RYGEL_VIDEO_ITEM_DUMMY_PROPERTY
};
RygelThumbnail* rygel_thumbnail_new (void);
RygelThumbnail* rygel_thumbnail_construct (GType object_type);
static void rygel_video_item_finalize (RygelMediaObject* obj);
GType rygel_music_item_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_MUSIC_ITEM_DUMMY_PROPERTY
};
RygelMusicItem* rygel_music_item_new (void);
RygelMusicItem* rygel_music_item_construct (GType object_type);
static void rygel_music_item_finalize (RygelMediaObject* obj);
enum  {
	RYGEL_THUMBNAIL_DUMMY_PROPERTY
};
static void rygel_thumbnail_finalize (RygelThumbnail* obj);
enum  {
	RYGEL_SUBTITLE_DUMMY_PROPERTY
};
RygelSubtitle* rygel_subtitle_new (void);
RygelSubtitle* rygel_subtitle_construct (GType object_type);
static void rygel_subtitle_finalize (RygelSubtitle* obj);
#define RYGEL_HTTP_RESPONSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponsePrivate))
enum  {
	RYGEL_HTTP_RESPONSE_DUMMY_PROPERTY,
	RYGEL_HTTP_RESPONSE_CANCELLABLE
};
static void rygel_http_response_real_run_data_free (gpointer _data);
static void rygel_http_response_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_response_real_run_co (RygelHttpResponseRunData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean _rygel_http_response_real_run_co_gsource_func (gpointer self);
static gboolean __lambda5_ (Block3Data* _data3_);
static gboolean ___lambda5__gsource_func (gpointer self);
static void rygel_http_response_finalize (GObject* obj);
static void _vala_rygel_http_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	RYGEL_MEDIA_OBJECT_DUMMY_PROPERTY
};
static void rygel_media_object_finalize (RygelMediaObject* obj);
#define RYGEL_TRANSCODER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_TRANSCODER, RygelTranscoderPrivate))
enum  {
	RYGEL_TRANSCODER_DUMMY_PROPERTY,
	RYGEL_TRANSCODER_EXTENSION
};
void rygel_transcoder_set_extension (RygelTranscoder* self, const gchar* value);
const gchar* rygel_transcoder_get_extension (RygelTranscoder* self);
static void rygel_transcoder_finalize (GObject* obj);
static void _vala_rygel_transcoder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_transcoder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark rygel_test_error_quark (void) {
	return g_quark_from_static_string ("rygel_test_error-quark");
}


GQuark rygel_client_hacks_error_quark (void) {
	return g_quark_from_static_string ("rygel_client_hacks_error-quark");
}


static SoupMessageHeaders* _vala_SoupMessageHeaders_copy (SoupMessageHeaders* self) {
	return g_boxed_copy (soup_message_headers_get_type (), self);
}


static gpointer __vala_SoupMessageHeaders_copy0 (gpointer self) {
	return self ? _vala_SoupMessageHeaders_copy (self) : NULL;
}


static void _vala_SoupMessageHeaders_free (SoupMessageHeaders* self) {
	g_boxed_free (soup_message_headers_get_type (), self);
}


RygelClientHacks* rygel_client_hacks_create (SoupMessage* message, GError** error) {
	RygelClientHacks* result = NULL;
	SoupMessageHeaders* headers = NULL;
	SoupMessage* _tmp0_ = NULL;
	SoupMessageHeaders* _tmp1_ = NULL;
	SoupMessageHeaders* _tmp2_ = NULL;
	SoupMessageHeaders* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = message;
	_tmp1_ = _tmp0_->request_headers;
	_tmp2_ = __vala_SoupMessageHeaders_copy0 (_tmp1_);
	headers = _tmp2_;
	_tmp3_ = headers;
	_tmp4_ = soup_message_headers_get_one (_tmp3_, "clienthacks.test.rygel");
	if (_tmp4_ != NULL) {
		RygelClientHacks* _tmp5_ = NULL;
		_tmp5_ = rygel_client_hacks_new ();
		result = _tmp5_;
		__vala_SoupMessageHeaders_free0 (headers);
		return result;
	} else {
		GError* _tmp6_ = NULL;
		_tmp6_ = g_error_new_literal (RYGEL_CLIENT_HACKS_ERROR, RYGEL_CLIENT_HACKS_ERROR_NA, "");
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		__vala_SoupMessageHeaders_free0 (headers);
		return NULL;
	}
	__vala_SoupMessageHeaders_free0 (headers);
}


void rygel_client_hacks_apply (RygelClientHacks* self, RygelMediaObject* item) {
	g_return_if_fail (self != NULL);
}


gboolean rygel_client_hacks_force_seek (RygelClientHacks* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = FALSE;
	return result;
}


RygelClientHacks* rygel_client_hacks_construct (GType object_type) {
	RygelClientHacks* self = NULL;
	self = (RygelClientHacks*) g_type_create_instance (object_type);
	return self;
}


RygelClientHacks* rygel_client_hacks_new (void) {
	return rygel_client_hacks_construct (RYGEL_TYPE_CLIENT_HACKS);
}


static void rygel_value_client_hacks_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_client_hacks_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_client_hacks_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_client_hacks_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_client_hacks_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_client_hacks_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_client_hacks_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelClientHacks* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_client_hacks_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_client_hacks_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelClientHacks** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_client_hacks_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_client_hacks (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecClientHacks* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_CLIENT_HACKS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_client_hacks (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_CLIENT_HACKS), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_client_hacks (GValue* value, gpointer v_object) {
	RygelClientHacks* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_CLIENT_HACKS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_CLIENT_HACKS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_client_hacks_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_client_hacks_unref (old);
	}
}


void rygel_value_take_client_hacks (GValue* value, gpointer v_object) {
	RygelClientHacks* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_CLIENT_HACKS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_CLIENT_HACKS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_client_hacks_unref (old);
	}
}


static void rygel_client_hacks_class_init (RygelClientHacksClass * klass) {
	rygel_client_hacks_parent_class = g_type_class_peek_parent (klass);
	((RygelClientHacksClass *) klass)->finalize = rygel_client_hacks_finalize;
}


static void rygel_client_hacks_instance_init (RygelClientHacks * self) {
	self->ref_count = 1;
}


static void rygel_client_hacks_finalize (RygelClientHacks* obj) {
	RygelClientHacks * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks);
	g_signal_handlers_destroy (self);
}


GType rygel_client_hacks_get_type (void) {
	static volatile gsize rygel_client_hacks_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_client_hacks_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_client_hacks_init, rygel_value_client_hacks_free_value, rygel_value_client_hacks_copy_value, rygel_value_client_hacks_peek_pointer, "p", rygel_value_client_hacks_collect_value, "p", rygel_value_client_hacks_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelClientHacksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_client_hacks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelClientHacks), 0, (GInstanceInitFunc) rygel_client_hacks_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_client_hacks_type_id;
		rygel_client_hacks_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelClientHacks", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_client_hacks_type_id__volatile, rygel_client_hacks_type_id);
	}
	return rygel_client_hacks_type_id__volatile;
}


gpointer rygel_client_hacks_ref (gpointer instance) {
	RygelClientHacks* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_client_hacks_unref (gpointer instance) {
	RygelClientHacks* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_CLIENT_HACKS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelTestRequestFactory* rygel_test_request_factory_construct (GType object_type, SoupMessage* msg, SoupStatus expected_code) {
	RygelTestRequestFactory* self = NULL;
	SoupMessage* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupStatus _tmp2_ = 0;
	g_return_val_if_fail (msg != NULL, NULL);
	self = (RygelTestRequestFactory*) g_type_create_instance (object_type);
	_tmp0_ = msg;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->msg);
	self->msg = _tmp1_;
	_tmp2_ = expected_code;
	self->expected_code = _tmp2_;
	return self;
}


RygelTestRequestFactory* rygel_test_request_factory_new (SoupMessage* msg, SoupStatus expected_code) {
	return rygel_test_request_factory_construct (RYGEL_TYPE_TEST_REQUEST_FACTORY, msg, expected_code);
}


RygelHTTPGet* rygel_test_request_factory_create_get (RygelTestRequestFactory* self, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg) {
	RygelHTTPGet* result = NULL;
	RygelHTTPGet* request = NULL;
	RygelHTTPServer* _tmp0_ = NULL;
	SoupServer* _tmp1_ = NULL;
	SoupMessage* _tmp2_ = NULL;
	RygelHTTPGet* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	g_return_val_if_fail (server != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	_tmp0_ = http_server;
	_tmp1_ = server;
	_tmp2_ = msg;
	_tmp3_ = rygel_http_get_new (_tmp0_, _tmp1_, _tmp2_);
	request = _tmp3_;
	_rygel_http_get_handler_unref0 (request->handler);
	request->handler = NULL;
	result = request;
	return result;
}


static void rygel_value_test_request_factory_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_test_request_factory_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_test_request_factory_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_test_request_factory_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_test_request_factory_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_test_request_factory_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_test_request_factory_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelTestRequestFactory* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_test_request_factory_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_test_request_factory_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelTestRequestFactory** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_test_request_factory_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_test_request_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecTestRequestFactory* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_TEST_REQUEST_FACTORY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_test_request_factory (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_TEST_REQUEST_FACTORY), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_test_request_factory (GValue* value, gpointer v_object) {
	RygelTestRequestFactory* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_TEST_REQUEST_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_TEST_REQUEST_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_test_request_factory_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_test_request_factory_unref (old);
	}
}


void rygel_value_take_test_request_factory (GValue* value, gpointer v_object) {
	RygelTestRequestFactory* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_TEST_REQUEST_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_TEST_REQUEST_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_test_request_factory_unref (old);
	}
}


static void rygel_test_request_factory_class_init (RygelTestRequestFactoryClass * klass) {
	rygel_test_request_factory_parent_class = g_type_class_peek_parent (klass);
	((RygelTestRequestFactoryClass *) klass)->finalize = rygel_test_request_factory_finalize;
}


static void rygel_test_request_factory_instance_init (RygelTestRequestFactory * self) {
	self->ref_count = 1;
}


static void rygel_test_request_factory_finalize (RygelTestRequestFactory* obj) {
	RygelTestRequestFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_TEST_REQUEST_FACTORY, RygelTestRequestFactory);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->msg);
}


GType rygel_test_request_factory_get_type (void) {
	static volatile gsize rygel_test_request_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_test_request_factory_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_test_request_factory_init, rygel_value_test_request_factory_free_value, rygel_value_test_request_factory_copy_value, rygel_value_test_request_factory_peek_pointer, "p", rygel_value_test_request_factory_collect_value, "p", rygel_value_test_request_factory_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelTestRequestFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_test_request_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTestRequestFactory), 0, (GInstanceInitFunc) rygel_test_request_factory_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_test_request_factory_type_id;
		rygel_test_request_factory_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelTestRequestFactory", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_test_request_factory_type_id__volatile, rygel_test_request_factory_type_id);
	}
	return rygel_test_request_factory_type_id__volatile;
}


gpointer rygel_test_request_factory_ref (gpointer instance) {
	RygelTestRequestFactory* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_test_request_factory_unref (gpointer instance) {
	RygelTestRequestFactory* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_TEST_REQUEST_FACTORY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


gint rygel_http_get_test_main (gchar** args, int args_length1) {
	gint result = 0;
	RygelVideoItem* item = NULL;
	RygelVideoItem* _tmp6_ = NULL;
	RygelVideoItem* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	RygelVideoItem* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GError * _inner_error_ = NULL;
	{
		RygelHTTPGetTest* test = NULL;
		RygelHTTPGetTest* _tmp0_ = NULL;
		RygelHTTPGetTest* _tmp1_ = NULL;
		_tmp0_ = rygel_http_get_test_new (&_inner_error_);
		test = _tmp0_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
		_tmp1_ = test;
		rygel_http_get_test_run (_tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (test);
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
		_g_object_unref0 (test);
	}
	goto __finally0;
	__catch0_rygel_test_error_skip:
	{
		GError* _error_ = NULL;
		GError* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _error_;
		_tmp3_ = _tmp2_->code;
		result = _tmp3_;
		_g_error_free0 (_error_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		g_critical ("rygel-http-get-test.vala:96: %s", _tmp5_);
		result = -1;
		_g_error_free0 (_error_);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp6_ = rygel_video_item_new ();
	item = _tmp6_;
	_tmp7_ = item;
	_tmp8_ = rygel_visual_item_is_live_stream ((RygelVisualItem*) _tmp7_);
	_vala_assert (!_tmp8_, "!item.is_live_stream()");
	_tmp9_ = item;
	_tmp10_ = rygel_visual_item_streamable ((RygelVisualItem*) _tmp9_);
	_vala_assert (!_tmp10_, "!item.streamable()");
	result = 0;
	_rygel_media_object_unref0 (item);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return rygel_http_get_test_main (argv, argc);
}


RygelHTTPGetTest* rygel_http_get_test_construct (GType object_type, GError** error) {
	RygelHTTPGetTest * self = NULL;
	RygelHTTPServer* _tmp0_ = NULL;
	RygelHTTPServer* _tmp1_ = NULL;
	RygelHTTPServer* _tmp2_ = NULL;
	RygelHTTPServer* _tmp3_ = NULL;
	GUPnPContext* _tmp4_ = NULL;
	RygelHTTPClient* _tmp5_ = NULL;
	GMainLoop* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelHTTPGetTest*) g_object_new (object_type, NULL);
	_tmp1_ = rygel_http_server_new (&_inner_error_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (self->server);
	self->server = _tmp2_;
	_tmp3_ = self->server;
	_tmp4_ = _tmp3_->context;
	_tmp5_ = rygel_http_client_new (_tmp4_);
	_g_object_unref0 (self->client);
	self->client = _tmp5_;
	_tmp6_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->main_loop);
	self->priv->main_loop = _tmp6_;
	rygel_http_get_test_create_test_messages (self);
	_g_object_unref0 (_tmp0_);
	return self;
}


RygelHTTPGetTest* rygel_http_get_test_new (GError** error) {
	return rygel_http_get_test_construct (RYGEL_TYPE_HTTP_GET_TEST, error);
}


static gboolean _rygel_http_get_test_on_timeout_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_get_test_on_timeout ((RygelHTTPGetTest*) self);
	return result;
}


static void _rygel_http_get_test_on_message_received_rygel_http_server_message_received (RygelHTTPServer* _sender, SoupMessage* message, gpointer self) {
	rygel_http_get_test_on_message_received ((RygelHTTPGetTest*) self, _sender, message);
}


static void _rygel_http_get_test_on_client_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
	rygel_http_get_test_on_client_completed ((RygelHTTPGetTest*) self, _sender);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void rygel_http_get_test_real_run (RygelHTTPGetTest* self, GError** error) {
	RygelHTTPServer* _tmp0_ = NULL;
	RygelHTTPClient* _tmp1_ = NULL;
	GMainLoop* _tmp2_ = NULL;
	GError* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 3, _rygel_http_get_test_on_timeout_gsource_func, g_object_ref (self), g_object_unref);
	_tmp0_ = self->server;
	g_signal_connect_object (_tmp0_, "message-received", (GCallback) _rygel_http_get_test_on_message_received_rygel_http_server_message_received, self, 0);
	_tmp1_ = self->client;
	g_signal_connect_object ((RygelStateMachine*) _tmp1_, "completed", (GCallback) _rygel_http_get_test_on_client_completed_rygel_state_machine_completed, self, 0);
	rygel_http_get_test_start_next_test_request (self);
	_tmp2_ = self->priv->main_loop;
	g_main_loop_run (_tmp2_);
	_tmp3_ = self->priv->error;
	if (_tmp3_ != NULL) {
		GError* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		_tmp4_ = self->priv->error;
		_tmp5_ = _g_error_copy0 (_tmp4_);
		_inner_error_ = _tmp5_;
		g_propagate_error (error, _inner_error_);
		return;
	}
}


void rygel_http_get_test_run (RygelHTTPGetTest* self, GError** error) {
	g_return_if_fail (self != NULL);
	RYGEL_HTTP_GET_TEST_GET_CLASS (self)->run (self, error);
}


static void rygel_http_get_test_create_test_messages (RygelHTTPGetTest* self) {
	GeeArrayList* _tmp0_ = NULL;
	SoupMessage* request = NULL;
	RygelHTTPServer* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	SoupMessage* _tmp5_ = NULL;
	SoupMessage* _tmp6_ = NULL;
	GeeArrayList* _tmp7_ = NULL;
	SoupMessage* _tmp8_ = NULL;
	RygelTestRequestFactory* _tmp9_ = NULL;
	RygelTestRequestFactory* _tmp10_ = NULL;
	RygelHTTPServer* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	SoupMessage* _tmp15_ = NULL;
	GeeArrayList* _tmp16_ = NULL;
	SoupMessage* _tmp17_ = NULL;
	RygelTestRequestFactory* _tmp18_ = NULL;
	RygelTestRequestFactory* _tmp19_ = NULL;
	RygelHTTPServer* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	SoupMessage* _tmp24_ = NULL;
	GeeArrayList* _tmp25_ = NULL;
	SoupMessage* _tmp26_ = NULL;
	RygelTestRequestFactory* _tmp27_ = NULL;
	RygelTestRequestFactory* _tmp28_ = NULL;
	gchar* uri = NULL;
	RygelHTTPServer* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	SoupMessage* _tmp34_ = NULL;
	GeeArrayList* _tmp35_ = NULL;
	SoupMessage* _tmp36_ = NULL;
	RygelTestRequestFactory* _tmp37_ = NULL;
	RygelTestRequestFactory* _tmp38_ = NULL;
	RygelHTTPServer* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	SoupMessage* _tmp43_ = NULL;
	SoupMessage* _tmp44_ = NULL;
	SoupMessageHeaders* _tmp45_ = NULL;
	GeeArrayList* _tmp46_ = NULL;
	SoupMessage* _tmp47_ = NULL;
	RygelTestRequestFactory* _tmp48_ = NULL;
	RygelTestRequestFactory* _tmp49_ = NULL;
	RygelHTTPServer* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
	gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	SoupMessage* _tmp54_ = NULL;
	SoupMessage* _tmp55_ = NULL;
	SoupMessageHeaders* _tmp56_ = NULL;
	GeeArrayList* _tmp57_ = NULL;
	SoupMessage* _tmp58_ = NULL;
	RygelTestRequestFactory* _tmp59_ = NULL;
	RygelTestRequestFactory* _tmp60_ = NULL;
	RygelHTTPServer* _tmp61_ = NULL;
	gchar* _tmp62_ = NULL;
	gchar* _tmp63_ = NULL;
	gchar* _tmp64_ = NULL;
	SoupMessage* _tmp65_ = NULL;
	SoupMessage* _tmp66_ = NULL;
	SoupMessageHeaders* _tmp67_ = NULL;
	GeeArrayList* _tmp68_ = NULL;
	SoupMessage* _tmp69_ = NULL;
	RygelTestRequestFactory* _tmp70_ = NULL;
	RygelTestRequestFactory* _tmp71_ = NULL;
	RygelHTTPServer* _tmp72_ = NULL;
	gchar* _tmp73_ = NULL;
	const gchar* _tmp74_ = NULL;
	gchar* _tmp75_ = NULL;
	const gchar* _tmp76_ = NULL;
	SoupMessage* _tmp77_ = NULL;
	GeeArrayList* _tmp78_ = NULL;
	SoupMessage* _tmp79_ = NULL;
	RygelTestRequestFactory* _tmp80_ = NULL;
	RygelTestRequestFactory* _tmp81_ = NULL;
	RygelHTTPServer* _tmp82_ = NULL;
	gchar* _tmp83_ = NULL;
	gchar* _tmp84_ = NULL;
	gchar* _tmp85_ = NULL;
	SoupMessage* _tmp86_ = NULL;
	SoupMessage* _tmp87_ = NULL;
	SoupMessageHeaders* _tmp88_ = NULL;
	GeeArrayList* _tmp89_ = NULL;
	SoupMessage* _tmp90_ = NULL;
	RygelTestRequestFactory* _tmp91_ = NULL;
	RygelTestRequestFactory* _tmp92_ = NULL;
	RygelHTTPServer* _tmp93_ = NULL;
	gchar* _tmp94_ = NULL;
	const gchar* _tmp95_ = NULL;
	SoupMessage* _tmp96_ = NULL;
	SoupMessage* _tmp97_ = NULL;
	SoupMessageHeaders* _tmp98_ = NULL;
	GeeArrayList* _tmp99_ = NULL;
	SoupMessage* _tmp100_ = NULL;
	RygelTestRequestFactory* _tmp101_ = NULL;
	RygelTestRequestFactory* _tmp102_ = NULL;
	RygelHTTPServer* _tmp103_ = NULL;
	gchar* _tmp104_ = NULL;
	const gchar* _tmp105_ = NULL;
	SoupMessage* _tmp106_ = NULL;
	SoupMessage* _tmp107_ = NULL;
	SoupMessageHeaders* _tmp108_ = NULL;
	GeeArrayList* _tmp109_ = NULL;
	SoupMessage* _tmp110_ = NULL;
	RygelTestRequestFactory* _tmp111_ = NULL;
	RygelTestRequestFactory* _tmp112_ = NULL;
	RygelHTTPServer* _tmp113_ = NULL;
	gchar* _tmp114_ = NULL;
	gchar* _tmp115_ = NULL;
	gchar* _tmp116_ = NULL;
	SoupMessage* _tmp117_ = NULL;
	SoupMessage* _tmp118_ = NULL;
	SoupMessageHeaders* _tmp119_ = NULL;
	GeeArrayList* _tmp120_ = NULL;
	SoupMessage* _tmp121_ = NULL;
	RygelTestRequestFactory* _tmp122_ = NULL;
	RygelTestRequestFactory* _tmp123_ = NULL;
	RygelHTTPServer* _tmp124_ = NULL;
	gchar* _tmp125_ = NULL;
	gchar* _tmp126_ = NULL;
	gchar* _tmp127_ = NULL;
	SoupMessage* _tmp128_ = NULL;
	SoupMessage* _tmp129_ = NULL;
	SoupMessageHeaders* _tmp130_ = NULL;
	GeeArrayList* _tmp131_ = NULL;
	SoupMessage* _tmp132_ = NULL;
	RygelTestRequestFactory* _tmp133_ = NULL;
	RygelTestRequestFactory* _tmp134_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_TEST_REQUEST_FACTORY, (GBoxedCopyFunc) rygel_test_request_factory_ref, rygel_test_request_factory_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->requests);
	self->priv->requests = _tmp0_;
	_tmp1_ = self->server;
	_tmp2_ = rygel_http_server_get_uri (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = soup_message_new ("POST", _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	request = _tmp6_;
	_tmp7_ = self->priv->requests;
	_tmp8_ = request;
	_tmp9_ = rygel_test_request_factory_new (_tmp8_, SOUP_STATUS_BAD_REQUEST);
	_tmp10_ = _tmp9_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp10_);
	_rygel_test_request_factory_unref0 (_tmp10_);
	_tmp11_ = self->server;
	_tmp12_ = rygel_http_server_get_uri (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_;
	_tmp15_ = soup_message_new ("HEAD", _tmp14_);
	_g_object_unref0 (request);
	request = _tmp15_;
	_g_free0 (_tmp14_);
	_tmp16_ = self->priv->requests;
	_tmp17_ = request;
	_tmp18_ = rygel_test_request_factory_new (_tmp17_, SOUP_STATUS_OK);
	_tmp19_ = _tmp18_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp19_);
	_rygel_test_request_factory_unref0 (_tmp19_);
	_tmp20_ = self->server;
	_tmp21_ = rygel_http_server_get_uri (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = _tmp22_;
	_tmp24_ = soup_message_new ("GET", _tmp23_);
	_g_object_unref0 (request);
	request = _tmp24_;
	_g_free0 (_tmp23_);
	_tmp25_ = self->priv->requests;
	_tmp26_ = request;
	_tmp27_ = rygel_test_request_factory_new (_tmp26_, SOUP_STATUS_OK);
	_tmp28_ = _tmp27_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, _tmp28_);
	_rygel_test_request_factory_unref0 (_tmp28_);
	_tmp29_ = self->server;
	_tmp30_ = rygel_http_server_create_uri (_tmp29_, "VideoItem");
	uri = _tmp30_;
	_tmp31_ = uri;
	_tmp32_ = g_strconcat (_tmp31_, "/tr/MP3", NULL);
	_g_free0 (uri);
	uri = _tmp32_;
	_tmp33_ = uri;
	_tmp34_ = soup_message_new ("HEAD", _tmp33_);
	_g_object_unref0 (request);
	request = _tmp34_;
	_tmp35_ = self->priv->requests;
	_tmp36_ = request;
	_tmp37_ = rygel_test_request_factory_new (_tmp36_, SOUP_STATUS_OK);
	_tmp38_ = _tmp37_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp35_, _tmp38_);
	_rygel_test_request_factory_unref0 (_tmp38_);
	_tmp39_ = self->server;
	_tmp40_ = rygel_http_server_get_uri (_tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = _tmp41_;
	_tmp43_ = soup_message_new ("GET", _tmp42_);
	_g_object_unref0 (request);
	request = _tmp43_;
	_g_free0 (_tmp42_);
	_tmp44_ = request;
	_tmp45_ = _tmp44_->request_headers;
	soup_message_headers_append (_tmp45_, "transferMode.dlna.org", "Streaming");
	_tmp46_ = self->priv->requests;
	_tmp47_ = request;
	_tmp48_ = rygel_test_request_factory_new (_tmp47_, SOUP_STATUS_OK);
	_tmp49_ = _tmp48_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp46_, _tmp49_);
	_rygel_test_request_factory_unref0 (_tmp49_);
	_tmp50_ = self->server;
	_tmp51_ = rygel_http_server_get_uri (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = _tmp52_;
	_tmp54_ = soup_message_new ("GET", _tmp53_);
	_g_object_unref0 (request);
	request = _tmp54_;
	_g_free0 (_tmp53_);
	_tmp55_ = request;
	_tmp56_ = _tmp55_->request_headers;
	soup_message_headers_append (_tmp56_, "transferMode.dlna.org", "Interactive");
	_tmp57_ = self->priv->requests;
	_tmp58_ = request;
	_tmp59_ = rygel_test_request_factory_new (_tmp58_, SOUP_STATUS_NOT_ACCEPTABLE);
	_tmp60_ = _tmp59_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp57_, _tmp60_);
	_rygel_test_request_factory_unref0 (_tmp60_);
	_tmp61_ = self->server;
	_tmp62_ = rygel_http_server_get_uri (_tmp61_);
	_tmp63_ = _tmp62_;
	_tmp64_ = _tmp63_;
	_tmp65_ = soup_message_new ("GET", _tmp64_);
	_g_object_unref0 (request);
	request = _tmp65_;
	_g_free0 (_tmp64_);
	_tmp66_ = request;
	_tmp67_ = _tmp66_->request_headers;
	soup_message_headers_append (_tmp67_, "Range", "bytes=1-2");
	_tmp68_ = self->priv->requests;
	_tmp69_ = request;
	_tmp70_ = rygel_test_request_factory_new (_tmp69_, SOUP_STATUS_OK);
	_tmp71_ = _tmp70_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp68_, _tmp71_);
	_rygel_test_request_factory_unref0 (_tmp71_);
	_tmp72_ = self->server;
	_tmp73_ = rygel_http_server_create_uri (_tmp72_, "AudioItem");
	_g_free0 (uri);
	uri = _tmp73_;
	_tmp74_ = uri;
	_tmp75_ = g_strconcat (_tmp74_, "/th/0", NULL);
	_g_free0 (uri);
	uri = _tmp75_;
	_tmp76_ = uri;
	_tmp77_ = soup_message_new ("GET", _tmp76_);
	_g_object_unref0 (request);
	request = _tmp77_;
	_tmp78_ = self->priv->requests;
	_tmp79_ = request;
	_tmp80_ = rygel_test_request_factory_new (_tmp79_, SOUP_STATUS_NOT_FOUND);
	_tmp81_ = _tmp80_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp78_, _tmp81_);
	_rygel_test_request_factory_unref0 (_tmp81_);
	_tmp82_ = self->server;
	_tmp83_ = rygel_http_server_get_uri (_tmp82_);
	_tmp84_ = _tmp83_;
	_tmp85_ = _tmp84_;
	_tmp86_ = soup_message_new ("GET", _tmp85_);
	_g_object_unref0 (request);
	request = _tmp86_;
	_g_free0 (_tmp85_);
	_tmp87_ = request;
	_tmp88_ = _tmp87_->request_headers;
	soup_message_headers_append (_tmp88_, "TimeSeekRange.dlna.org", "0");
	_tmp89_ = self->priv->requests;
	_tmp90_ = request;
	_tmp91_ = rygel_test_request_factory_new (_tmp90_, SOUP_STATUS_NOT_ACCEPTABLE);
	_tmp92_ = _tmp91_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp89_, _tmp92_);
	_rygel_test_request_factory_unref0 (_tmp92_);
	_tmp93_ = self->server;
	_tmp94_ = rygel_http_server_create_uri (_tmp93_, "AudioItem");
	_g_free0 (uri);
	uri = _tmp94_;
	_tmp95_ = uri;
	_tmp96_ = soup_message_new ("GET", _tmp95_);
	_g_object_unref0 (request);
	request = _tmp96_;
	_tmp97_ = request;
	_tmp98_ = _tmp97_->request_headers;
	soup_message_headers_append (_tmp98_, "TimeSeekRange.dlna.org", "0");
	_tmp99_ = self->priv->requests;
	_tmp100_ = request;
	_tmp101_ = rygel_test_request_factory_new (_tmp100_, SOUP_STATUS_BAD_REQUEST);
	_tmp102_ = _tmp101_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp99_, _tmp102_);
	_rygel_test_request_factory_unref0 (_tmp102_);
	_tmp103_ = self->server;
	_tmp104_ = rygel_http_server_create_uri (_tmp103_, "AudioItem");
	_g_free0 (uri);
	uri = _tmp104_;
	_tmp105_ = uri;
	_tmp106_ = soup_message_new ("GET", _tmp105_);
	_g_object_unref0 (request);
	request = _tmp106_;
	_tmp107_ = request;
	_tmp108_ = _tmp107_->request_headers;
	soup_message_headers_append (_tmp108_, "TimeSeekRange.dlna.org", "npt=1-2049");
	_tmp109_ = self->priv->requests;
	_tmp110_ = request;
	_tmp111_ = rygel_test_request_factory_new (_tmp110_, SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE);
	_tmp112_ = _tmp111_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp109_, _tmp112_);
	_rygel_test_request_factory_unref0 (_tmp112_);
	_tmp113_ = self->server;
	_tmp114_ = rygel_http_server_get_uri (_tmp113_);
	_tmp115_ = _tmp114_;
	_tmp116_ = _tmp115_;
	_tmp117_ = soup_message_new ("GET", _tmp116_);
	_g_object_unref0 (request);
	request = _tmp117_;
	_g_free0 (_tmp116_);
	_tmp118_ = request;
	_tmp119_ = _tmp118_->request_headers;
	soup_message_headers_append (_tmp119_, "clienthacks.test.rygel", "f");
	_tmp120_ = self->priv->requests;
	_tmp121_ = request;
	_tmp122_ = rygel_test_request_factory_new (_tmp121_, SOUP_STATUS_OK);
	_tmp123_ = _tmp122_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp120_, _tmp123_);
	_rygel_test_request_factory_unref0 (_tmp123_);
	_tmp124_ = self->server;
	_tmp125_ = rygel_http_server_get_uri (_tmp124_);
	_tmp126_ = _tmp125_;
	_tmp127_ = _tmp126_;
	_tmp128_ = soup_message_new ("GET", _tmp127_);
	_g_object_unref0 (request);
	request = _tmp128_;
	_g_free0 (_tmp127_);
	_tmp129_ = request;
	_tmp130_ = _tmp129_->request_headers;
	soup_message_headers_append (_tmp130_, "clienthacks.test.rygel", "t");
	_tmp131_ = self->priv->requests;
	_tmp132_ = request;
	_tmp133_ = rygel_test_request_factory_new (_tmp132_, SOUP_STATUS_OK);
	_tmp134_ = _tmp133_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp131_, _tmp134_);
	_rygel_test_request_factory_unref0 (_tmp134_);
	_g_free0 (uri);
	_g_object_unref0 (request);
}


static RygelHTTPGet* rygel_http_get_test_create_request (RygelHTTPGetTest* self, SoupMessage* msg, GError** error) {
	RygelHTTPGet* result = NULL;
	RygelHTTPGet* request = NULL;
	RygelTestRequestFactory* _tmp0_ = NULL;
	RygelHTTPServer* _tmp1_ = NULL;
	RygelHTTPServer* _tmp2_ = NULL;
	GUPnPContext* _tmp3_ = NULL;
	SoupServer* _tmp4_ = NULL;
	SoupServer* _tmp5_ = NULL;
	SoupMessage* _tmp6_ = NULL;
	RygelHTTPGet* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	_tmp0_ = self->priv->current_request;
	_tmp1_ = self->server;
	_tmp2_ = self->server;
	_tmp3_ = _tmp2_->context;
	_tmp4_ = gupnp_context_get_server (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = msg;
	_tmp7_ = rygel_test_request_factory_create_get (_tmp0_, _tmp1_, _tmp5_, _tmp6_);
	request = _tmp7_;
	result = request;
	return result;
}


static void rygel_http_get_test_on_client_completed (RygelHTTPGetTest* self, RygelStateMachine* client) {
	GeeArrayList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (client != NULL);
	_tmp0_ = self->priv->requests;
	_tmp1_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		rygel_http_get_test_start_next_test_request (self);
	} else {
		GMainLoop* _tmp3_ = NULL;
		_tmp3_ = self->priv->main_loop;
		g_main_loop_quit (_tmp3_);
		self->priv->client_done = TRUE;
	}
}


static void rygel_http_get_test_start_next_test_request (RygelHTTPGetTest* self) {
	GeeArrayList* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
	RygelHTTPClient* _tmp2_ = NULL;
	RygelTestRequestFactory* _tmp3_ = NULL;
	SoupMessage* _tmp4_ = NULL;
	SoupMessage* _tmp5_ = NULL;
	RygelHTTPClient* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->requests;
	_tmp1_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp0_, 0);
	_rygel_test_request_factory_unref0 (self->priv->current_request);
	self->priv->current_request = (RygelTestRequestFactory*) _tmp1_;
	_tmp2_ = self->client;
	_tmp3_ = self->priv->current_request;
	_tmp4_ = _tmp3_->msg;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (_tmp2_->msg);
	_tmp2_->msg = _tmp5_;
	_tmp6_ = self->client;
	rygel_state_machine_run ((RygelStateMachine*) _tmp6_, NULL, NULL);
}


static void rygel_http_get_test_on_message_received (RygelHTTPGetTest* self, RygelHTTPServer* server, SoupMessage* msg) {
	SoupMessage* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (server != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	rygel_http_get_test_handle_client_message (self, _tmp0_, NULL, NULL);
}


static void rygel_http_get_test_handle_client_message_data_free (gpointer _data) {
	RygelHttpGetTestHandleClientMessageData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->msg);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelHttpGetTestHandleClientMessageData, _data_);
}


static void rygel_http_get_test_handle_client_message (RygelHTTPGetTest* self, SoupMessage* msg, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpGetTestHandleClientMessageData* _data_;
	RygelHTTPGetTest* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupMessage* _tmp2_ = NULL;
	_data_ = g_slice_new0 (RygelHttpGetTestHandleClientMessageData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_get_test_handle_client_message);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_get_test_handle_client_message_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = msg;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->msg);
	_data_->msg = _tmp2_;
	rygel_http_get_test_handle_client_message_co (_data_);
}


static void rygel_http_get_test_handle_client_message_finish (RygelHTTPGetTest* self, GAsyncResult* _res_) {
	RygelHttpGetTestHandleClientMessageData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_get_test_handle_client_message_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpGetTestHandleClientMessageData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_http_get_test_handle_client_message_co (_data_);
}


static gboolean rygel_http_get_test_handle_client_message_co (RygelHttpGetTestHandleClientMessageData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = NULL;
		_data_->_tmp0_ = _data_->msg;
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = rygel_http_get_test_create_request (_data_->self, _data_->_tmp0_, &_data_->_inner_error_);
		_data_->request = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _data_->request;
		_data_->_state_ = 1;
		rygel_state_machine_run ((RygelStateMachine*) _data_->_tmp2_, rygel_http_get_test_handle_client_message_ready, _data_);
		return FALSE;
		_state_1:
		rygel_state_machine_run_finish ((RygelStateMachine*) _data_->_tmp2_, _data_->_res_);
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->request;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = ((RygelHTTPRequest*) (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp3_, RYGEL_TYPE_HTTP_GET) ? ((RygelHTTPGet*) _data_->_tmp3_) : NULL))->object;
		_vala_assert (_data_->_tmp4_ != NULL, "(request as HTTPGet).object != null");
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->msg;
		_data_->_tmp6_ = 0U;
		g_object_get (_data_->_tmp5_, "status-code", &_data_->_tmp6_, NULL);
		_data_->_tmp7_ = 0U;
		_data_->_tmp7_ = _data_->_tmp6_;
		g_debug ("rygel-http-get-test.vala:231: status.code: %d", (gint) _data_->_tmp7_);
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->msg;
		_data_->_tmp9_ = 0U;
		g_object_get (_data_->_tmp8_, "status-code", &_data_->_tmp9_, NULL);
		_data_->_tmp10_ = 0U;
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->self->priv->current_request;
		_data_->_tmp12_ = 0;
		_data_->_tmp12_ = _data_->_tmp11_->expected_code;
		_vala_assert (_data_->_tmp10_ == ((guint) _data_->_tmp12_), "msg.status_code == this.current_request.expected_code");
		_data_->_tmp13_ = FALSE;
		_data_->_tmp13_ = _data_->self->priv->client_done;
		if (_data_->_tmp13_) {
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = _data_->self->priv->main_loop;
			g_main_loop_quit (_data_->_tmp14_);
		}
		_data_->self->priv->server_done = TRUE;
		_g_object_unref0 (_data_->request);
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->_error_;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _g_error_copy0 (_data_->_tmp15_);
		_g_error_free0 (_data_->self->priv->error);
		_data_->self->priv->error = _data_->_tmp16_;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _data_->self->priv->main_loop;
		g_main_loop_quit (_data_->_tmp17_);
		_g_error_free0 (_data_->_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean rygel_http_get_test_on_timeout (RygelHTTPGetTest* self) {
	gboolean result = FALSE;
	GError* _tmp0_ = NULL;
	GMainLoop* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_TIMEOUT, "Timeout");
	_g_error_free0 (self->priv->error);
	self->priv->error = _tmp0_;
	_tmp1_ = self->priv->main_loop;
	g_main_loop_quit (_tmp1_);
	result = FALSE;
	return result;
}


static void rygel_http_get_test_class_init (RygelHTTPGetTestClass * klass) {
	rygel_http_get_test_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPGetTestPrivate));
	((RygelHTTPGetTestClass *) klass)->run = rygel_http_get_test_real_run;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_test_finalize;
}


static void rygel_http_get_test_instance_init (RygelHTTPGetTest * self) {
	self->priv = RYGEL_HTTP_GET_TEST_GET_PRIVATE (self);
}


static void rygel_http_get_test_finalize (GObject* obj) {
	RygelHTTPGetTest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_GET_TEST, RygelHTTPGetTest);
	_g_object_unref0 (self->server);
	_g_object_unref0 (self->client);
	_g_main_loop_unref0 (self->priv->main_loop);
	_g_error_free0 (self->priv->error);
	_g_object_unref0 (self->priv->requests);
	_rygel_test_request_factory_unref0 (self->priv->current_request);
	G_OBJECT_CLASS (rygel_http_get_test_parent_class)->finalize (obj);
}


GType rygel_http_get_test_get_type (void) {
	static volatile gsize rygel_http_get_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetTestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGetTest), 0, (GInstanceInitFunc) rygel_http_get_test_instance_init, NULL };
		GType rygel_http_get_test_type_id;
		rygel_http_get_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPGetTest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_get_test_type_id__volatile, rygel_http_get_test_type_id);
	}
	return rygel_http_get_test_type_id__volatile;
}


gchar* rygel_http_server_create_uri (RygelHTTPServer* self, const gchar* item_id) {
	gchar* result = NULL;
	RygelVideoItem* item = NULL;
	RygelVideoItem* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	RygelHTTPItemURI* item_uri = NULL;
	RygelHTTPItemURI* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item_id != NULL, NULL);
	_tmp0_ = rygel_video_item_new ();
	item = _tmp0_;
	_tmp1_ = item_id;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (((RygelMediaObject*) item)->id);
	((RygelMediaObject*) item)->id = _tmp2_;
	_tmp3_ = rygel_http_item_uri_new ((RygelMediaObject*) item, self, -1, -1, NULL, NULL);
	item_uri = _tmp3_;
	_tmp4_ = rygel_http_item_uri_to_string (item_uri);
	result = _tmp4_;
	_g_object_unref0 (item_uri);
	_rygel_media_object_unref0 (item);
	return result;
}


static void _rygel_http_server_server_cb_soup_server_callback (SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client, gpointer self) {
	rygel_http_server_server_cb ((RygelHTTPServer*) self, server, msg, path, query, client);
}


RygelHTTPServer* rygel_http_server_construct (GType object_type, GError** error) {
	RygelHTTPServer * self = NULL;
	GUPnPContext* _tmp4_ = NULL;
	GUPnPContext* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GUPnPContext* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	GUPnPContext* _tmp11_ = NULL;
	SoupServer* _tmp12_ = NULL;
	SoupServer* _tmp13_ = NULL;
	RygelMediaContainer* _tmp14_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelHTTPServer*) g_object_new (object_type, NULL);
	{
		GUPnPContext* _tmp0_ = NULL;
		GUPnPContext* _tmp1_ = NULL;
		GUPnPContext* _tmp2_ = NULL;
		_tmp1_ = gupnp_context_new (NULL, "lo", (guint) 0, &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->context);
		self->context = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp3_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = g_error_new_literal (RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP, "Network context not available");
		_inner_error_ = _tmp3_;
		_g_error_free0 (_error_);
		goto __finally2;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_TEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp4_ = self->context;
	_vala_assert (_tmp4_ != NULL, "this.context != null");
	_tmp5_ = self->context;
	_tmp6_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp5_);
	_tmp7_ = _tmp6_;
	_vala_assert (_tmp7_ != NULL, "this.context.host_ip != null");
	_tmp8_ = self->context;
	_tmp9_ = gupnp_context_get_port (_tmp8_);
	_tmp10_ = _tmp9_;
	_vala_assert (_tmp10_ > ((guint) 0), "this.context.port > 0");
	_tmp11_ = self->context;
	_tmp12_ = gupnp_context_get_server (_tmp11_);
	_tmp13_ = _tmp12_;
	soup_server_add_handler (_tmp13_, RYGEL_HTTP_SERVER_SERVER_PATH, _rygel_http_server_server_cb_soup_server_callback, g_object_ref (self), g_object_unref);
	_tmp14_ = rygel_media_container_new ();
	_rygel_media_object_unref0 (self->root_container);
	self->root_container = _tmp14_;
	return self;
}


RygelHTTPServer* rygel_http_server_new (GError** error) {
	return rygel_http_server_construct (RYGEL_TYPE_HTTP_SERVER, error);
}


static void rygel_http_server_server_cb (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const gchar* path, GHashTable* query, SoupClientContext* client) {
	GUPnPContext* _tmp0_ = NULL;
	SoupServer* _tmp1_ = NULL;
	SoupServer* _tmp2_ = NULL;
	SoupMessage* _tmp3_ = NULL;
	SoupMessage* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (server != NULL);
	g_return_if_fail (msg != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (client != NULL);
	_tmp0_ = self->context;
	_tmp1_ = gupnp_context_get_server (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = msg;
	soup_server_pause_message (_tmp2_, _tmp3_);
	_tmp4_ = msg;
	g_signal_emit_by_name (self, "message-received", _tmp4_);
}


RygelTranscoder* rygel_http_server_get_transcoder (RygelHTTPServer* self, const gchar* target, GError** error) {
	RygelTranscoder* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp2_ = NULL;
	GError* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (target != NULL, NULL);
	_tmp0_ = target;
	if (g_strcmp0 (_tmp0_, "MP3") == 0) {
		RygelTranscoder* _tmp1_ = NULL;
		_tmp1_ = rygel_transcoder_new ("mp3");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = target;
	_tmp3_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, "No transcoder available for target format '%s'", _tmp2_);
	_inner_error_ = _tmp3_;
	g_propagate_error (error, _inner_error_);
	return NULL;
}


const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = RYGEL_HTTP_SERVER_SERVER_PATH;
	return result;
}


gchar* rygel_http_server_get_uri (RygelHTTPServer* self) {
	gchar* result;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_http_server_create_uri (self, "VideoItem");
	result = _tmp0_;
	return result;
}


static void rygel_http_server_class_init (RygelHTTPServerClass * klass) {
	rygel_http_server_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_server_get_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_server_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_PATH_ROOT, g_param_spec_string ("path-root", "path-root", "path-root", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("message_received", RYGEL_TYPE_HTTP_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, soup_message_get_type ());
}


static void rygel_http_server_instance_init (RygelHTTPServer * self) {
}


static void rygel_http_server_finalize (GObject* obj) {
	RygelHTTPServer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer);
	_rygel_media_object_unref0 (self->root_container);
	_g_object_unref0 (self->context);
	G_OBJECT_CLASS (rygel_http_server_parent_class)->finalize (obj);
}


GType rygel_http_server_get_type (void) {
	static volatile gsize rygel_http_server_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_server_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPServer), 0, (GInstanceInitFunc) rygel_http_server_instance_init, NULL };
		GType rygel_http_server_type_id;
		rygel_http_server_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPServer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_server_type_id__volatile, rygel_http_server_type_id);
	}
	return rygel_http_server_type_id__volatile;
}


static void _vala_rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer);
	switch (property_id) {
		case RYGEL_HTTP_SERVER_PATH_ROOT:
		g_value_set_string (value, rygel_http_server_get_path_root (self));
		break;
		case RYGEL_HTTP_SERVER_URI:
		g_value_take_string (value, rygel_http_server_get_uri (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


RygelHTTPClient* rygel_http_client_construct (GType object_type, GUPnPContext* context) {
	RygelHTTPClient * self = NULL;
	GUPnPContext* _tmp0_ = NULL;
	GUPnPContext* _tmp1_ = NULL;
	g_return_val_if_fail (context != NULL, NULL);
	self = (RygelHTTPClient*) g_object_new (object_type, NULL);
	_tmp0_ = context;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->context);
	self->context = _tmp1_;
	return self;
}


RygelHTTPClient* rygel_http_client_new (GUPnPContext* context) {
	return rygel_http_client_construct (RYGEL_TYPE_HTTP_CLIENT, context);
}


static void rygel_http_client_real_run_data_free (gpointer _data) {
	RygelHttpClientRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelHttpClientRunData, _data_);
}


static void rygel_http_client_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPClient * self;
	RygelHttpClientRunData* _data_;
	RygelHTTPClient* _tmp0_ = NULL;
	self = (RygelHTTPClient*) base;
	_data_ = g_slice_new0 (RygelHttpClientRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_client_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_client_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_http_client_real_run_co (_data_);
}


static void rygel_http_client_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpClientRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		RygelHTTPClient* self;
		self = _data1_->self;
		(_data1_->run_continue_target_destroy_notify == NULL) ? NULL : (_data1_->run_continue_target_destroy_notify (_data1_->run_continue_target), NULL);
		_data1_->run_continue = NULL;
		_data1_->run_continue_target = NULL;
		_data1_->run_continue_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean _rygel_http_client_real_run_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_client_real_run_co (self);
	return result;
}


static void __lambda7_ (Block1Data* _data1_, SoupSession* session, SoupMessage* msg) {
	RygelHTTPClient* self;
	self = _data1_->self;
	g_return_if_fail (session != NULL);
	g_return_if_fail (msg != NULL);
	_data1_->run_continue (_data1_->run_continue_target);
}


static void ___lambda7__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
	__lambda7_ (self, session, msg);
	block1_data_unref (self);
}


static gboolean rygel_http_client_real_run_co (RygelHttpClientRunData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	_data_->_data1_->run_continue = _rygel_http_client_real_run_co_gsource_func;
	_data_->_data1_->run_continue_target = _data_;
	_data_->_data1_->run_continue_target_destroy_notify = NULL;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->context;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = gupnp_context_get_session (_data_->_tmp0_);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->self->msg;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _g_object_ref0 (_data_->_tmp3_);
	soup_session_queue_message (_data_->_tmp2_, _data_->_tmp4_, ___lambda7__soup_session_callback, block1_data_ref (_data_->_data1_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static GCancellable* rygel_http_client_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPClient* self;
	GCancellable* _tmp0_ = NULL;
	self = (RygelHTTPClient*) base;
	_tmp0_ = self->priv->_cancellable;
	result = _tmp0_;
	return result;
}


static void rygel_http_client_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPClient* self;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	self = (RygelHTTPClient*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = _tmp1_;
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_http_client_class_init (RygelHTTPClientClass * klass) {
	rygel_http_client_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPClientPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_client_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_client_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_client_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_CLIENT_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_http_client_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_http_client_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*)(RygelStateMachine*)) rygel_http_client_real_run;
	iface->run_finish = rygel_http_client_real_run_finish;
	iface->get_cancellable = rygel_http_client_real_get_cancellable;
	iface->set_cancellable = rygel_http_client_real_set_cancellable;
}


static void rygel_http_client_instance_init (RygelHTTPClient * self) {
	self->priv = RYGEL_HTTP_CLIENT_GET_PRIVATE (self);
}


static void rygel_http_client_finalize (GObject* obj) {
	RygelHTTPClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClient);
	_g_object_unref0 (self->context);
	_g_object_unref0 (self->msg);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_http_client_parent_class)->finalize (obj);
}


GType rygel_http_client_get_type (void) {
	static volatile gsize rygel_http_client_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_client_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPClient), 0, (GInstanceInitFunc) rygel_http_client_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_client_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_client_type_id;
		rygel_http_client_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPClient", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_client_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_client_type_id__volatile, rygel_http_client_type_id);
	}
	return rygel_http_client_type_id__volatile;
}


static void _vala_rygel_http_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClient);
	switch (property_id) {
		case RYGEL_HTTP_CLIENT_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_http_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_CLIENT, RygelHTTPClient);
	switch (property_id) {
		case RYGEL_HTTP_CLIENT_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_media_container_find_object_data_free (gpointer _data) {
	RygelMediaContainerFindObjectData* _data_;
	_data_ = _data;
	_g_free0 (_data_->item_id);
	_g_object_unref0 (_data_->cancellable);
	_rygel_media_object_unref0 (_data_->result);
	_rygel_media_object_unref0 (_data_->self);
	g_slice_free (RygelMediaContainerFindObjectData, _data_);
}


static gpointer _rygel_media_object_ref0 (gpointer self) {
	return self ? rygel_media_object_ref (self) : NULL;
}


void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* item_id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaContainerFindObjectData* _data_;
	RygelMediaContainer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	_data_ = g_slice_new0 (RygelMediaContainerFindObjectData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, rygel_media_container_find_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_container_find_object_data_free);
	_tmp0_ = _rygel_media_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = item_id;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->item_id);
	_data_->item_id = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	rygel_media_container_find_object_co (_data_);
}


RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelMediaContainerFindObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		RygelMediaContainer* self;
		self = _data2_->self;
		(_data2_->find_object_continue_target_destroy_notify == NULL) ? NULL : (_data2_->find_object_continue_target_destroy_notify (_data2_->find_object_continue_target), NULL);
		_data2_->find_object_continue = NULL;
		_data2_->find_object_continue_target = NULL;
		_data2_->find_object_continue_target_destroy_notify = NULL;
		_rygel_media_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean _rygel_media_container_find_object_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_media_container_find_object_co (self);
	return result;
}


static gboolean __lambda4_ (Block2Data* _data2_) {
	RygelMediaContainer* self;
	gboolean result = FALSE;
	GSourceFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	self = _data2_->self;
	_tmp0_ = _data2_->find_object_continue;
	_tmp0__target = _data2_->find_object_continue_target;
	_tmp0_ (_tmp0__target);
	result = FALSE;
	return result;
}


static gboolean ___lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda4_ (self);
	return result;
}


static gboolean rygel_media_container_find_object_co (RygelMediaContainerFindObjectData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data2_ = g_slice_new0 (Block2Data);
	_data_->_data2_->_ref_count_ = 1;
	_data_->_data2_->self = rygel_media_object_ref (_data_->self);
	_data_->_data2_->_async_data_ = _data_;
	_data_->_data2_->find_object_continue = _rygel_media_container_find_object_co_gsource_func;
	_data_->_data2_->find_object_continue_target = _data_;
	_data_->_data2_->find_object_continue_target_destroy_notify = NULL;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda4__gsource_func, block2_data_ref (_data_->_data2_), block2_data_unref);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->item_id;
	g_debug ("rygel-http-get-test.vala:355: item id: %s", _data_->_tmp0_);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->item_id;
	if (g_strcmp0 (_data_->_tmp1_, "VideoItem") == 0) {
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = rygel_video_item_new ();
		_data_->result = (RygelMediaObject*) _data_->_tmp2_;
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->item_id;
		if (g_strcmp0 (_data_->_tmp3_, "AudioItem") == 0) {
			_data_->_tmp4_ = NULL;
			_data_->_tmp4_ = rygel_audio_item_new ();
			_data_->result = (RygelMediaObject*) _data_->_tmp4_;
			block2_data_unref (_data_->_data2_);
			_data_->_data2_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_data_->result = NULL;
			block2_data_unref (_data_->_data2_);
			_data_->_data2_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


RygelMediaContainer* rygel_media_container_construct (GType object_type) {
	RygelMediaContainer* self = NULL;
	self = (RygelMediaContainer*) rygel_media_object_construct (object_type);
	return self;
}


RygelMediaContainer* rygel_media_container_new (void) {
	return rygel_media_container_construct (RYGEL_TYPE_MEDIA_CONTAINER);
}


static void rygel_media_container_class_init (RygelMediaContainerClass * klass) {
	rygel_media_container_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_media_container_instance_init (RygelMediaContainer * self) {
}


GType rygel_media_container_get_type (void) {
	static volatile gsize rygel_media_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaContainer), 0, (GInstanceInitFunc) rygel_media_container_instance_init, NULL };
		GType rygel_media_container_type_id;
		rygel_media_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_container_type_id__volatile, rygel_media_container_type_id);
	}
	return rygel_media_container_type_id__volatile;
}


RygelHTTPResponse* rygel_http_get_handler_render_body (RygelHTTPGetHandler* self, RygelHTTPGet* get_request) {
	RygelHTTPResponse* result = NULL;
	RygelHTTPGet* _tmp0_ = NULL;
	RygelHTTPResponse* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (get_request != NULL, NULL);
	_tmp0_ = get_request;
	_tmp1_ = rygel_http_response_new (_tmp0_);
	result = _tmp1_;
	return result;
}


void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* get_request) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (get_request != NULL);
}


gboolean rygel_http_get_handler_knows_size (RygelHTTPGetHandler* self, RygelHTTPGet* request) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (request != NULL, FALSE);
	result = FALSE;
	return result;
}


RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type) {
	RygelHTTPGetHandler* self = NULL;
	self = (RygelHTTPGetHandler*) g_type_create_instance (object_type);
	return self;
}


static void rygel_value_http_get_handler_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_http_get_handler_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_http_get_handler_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_http_get_handler_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_http_get_handler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_http_get_handler_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_http_get_handler_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelHTTPGetHandler* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_http_get_handler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_http_get_handler_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelHTTPGetHandler** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_http_get_handler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_http_get_handler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecHTTPGetHandler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_HTTP_GET_HANDLER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_http_get_handler (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_HTTP_GET_HANDLER), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_http_get_handler (GValue* value, gpointer v_object) {
	RygelHTTPGetHandler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_HTTP_GET_HANDLER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_HTTP_GET_HANDLER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_http_get_handler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_http_get_handler_unref (old);
	}
}


void rygel_value_take_http_get_handler (GValue* value, gpointer v_object) {
	RygelHTTPGetHandler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_HTTP_GET_HANDLER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_HTTP_GET_HANDLER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_http_get_handler_unref (old);
	}
}


static void rygel_http_get_handler_class_init (RygelHTTPGetHandlerClass * klass) {
	rygel_http_get_handler_parent_class = g_type_class_peek_parent (klass);
	((RygelHTTPGetHandlerClass *) klass)->finalize = rygel_http_get_handler_finalize;
}


static void rygel_http_get_handler_instance_init (RygelHTTPGetHandler * self) {
	self->ref_count = 1;
}


static void rygel_http_get_handler_finalize (RygelHTTPGetHandler* obj) {
	RygelHTTPGetHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler);
	g_signal_handlers_destroy (self);
}


GType rygel_http_get_handler_get_type (void) {
	static volatile gsize rygel_http_get_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_handler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_http_get_handler_init, rygel_value_http_get_handler_free_value, rygel_value_http_get_handler_copy_value, rygel_value_http_get_handler_peek_pointer, "p", rygel_value_http_get_handler_collect_value, "p", rygel_value_http_get_handler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGetHandler), 0, (GInstanceInitFunc) rygel_http_get_handler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_http_get_handler_type_id;
		rygel_http_get_handler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelHTTPGetHandler", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_http_get_handler_type_id__volatile, rygel_http_get_handler_type_id);
	}
	return rygel_http_get_handler_type_id__volatile;
}


gpointer rygel_http_get_handler_ref (gpointer instance) {
	RygelHTTPGetHandler* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_http_get_handler_unref (gpointer instance) {
	RygelHTTPGetHandler* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_HTTP_GET_HANDLER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


RygelHTTPTranscodeHandler* rygel_http_transcode_handler_construct (GType object_type, RygelTranscoder* transcoder, GCancellable* cancellable) {
	RygelHTTPTranscodeHandler* self = NULL;
	g_return_val_if_fail (transcoder != NULL, NULL);
	g_return_val_if_fail (cancellable != NULL, NULL);
	self = (RygelHTTPTranscodeHandler*) rygel_http_get_handler_construct (object_type);
	return self;
}


RygelHTTPTranscodeHandler* rygel_http_transcode_handler_new (RygelTranscoder* transcoder, GCancellable* cancellable) {
	return rygel_http_transcode_handler_construct (RYGEL_TYPE_HTTP_TRANSCODE_HANDLER, transcoder, cancellable);
}


static void rygel_http_transcode_handler_class_init (RygelHTTPTranscodeHandlerClass * klass) {
	rygel_http_transcode_handler_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_http_transcode_handler_instance_init (RygelHTTPTranscodeHandler * self) {
}


GType rygel_http_transcode_handler_get_type (void) {
	static volatile gsize rygel_http_transcode_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_transcode_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTranscodeHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_transcode_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTranscodeHandler), 0, (GInstanceInitFunc) rygel_http_transcode_handler_instance_init, NULL };
		GType rygel_http_transcode_handler_type_id;
		rygel_http_transcode_handler_type_id = g_type_register_static (RYGEL_TYPE_HTTP_GET_HANDLER, "RygelHTTPTranscodeHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_transcode_handler_type_id__volatile, rygel_http_transcode_handler_type_id);
	}
	return rygel_http_transcode_handler_type_id__volatile;
}


RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type, GCancellable* cancellable) {
	RygelHTTPIdentityHandler* self = NULL;
	g_return_val_if_fail (cancellable != NULL, NULL);
	self = (RygelHTTPIdentityHandler*) rygel_http_get_handler_construct (object_type);
	return self;
}


RygelHTTPIdentityHandler* rygel_http_identity_handler_new (GCancellable* cancellable) {
	return rygel_http_identity_handler_construct (RYGEL_TYPE_HTTP_IDENTITY_HANDLER, cancellable);
}


static void rygel_http_identity_handler_class_init (RygelHTTPIdentityHandlerClass * klass) {
	rygel_http_identity_handler_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_http_identity_handler_instance_init (RygelHTTPIdentityHandler * self) {
}


GType rygel_http_identity_handler_get_type (void) {
	static volatile gsize rygel_http_identity_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_identity_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPIdentityHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_identity_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPIdentityHandler), 0, (GInstanceInitFunc) rygel_http_identity_handler_instance_init, NULL };
		GType rygel_http_identity_handler_type_id;
		rygel_http_identity_handler_type_id = g_type_register_static (RYGEL_TYPE_HTTP_GET_HANDLER, "RygelHTTPIdentityHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_identity_handler_type_id__volatile, rygel_http_identity_handler_type_id);
	}
	return rygel_http_identity_handler_type_id__volatile;
}


RygelHTTPPlaylistHandler* rygel_http_playlist_handler_construct (GType object_type, const gchar* arg, GCancellable* cancellable) {
	RygelHTTPPlaylistHandler* self = NULL;
	g_return_val_if_fail (cancellable != NULL, NULL);
	self = (RygelHTTPPlaylistHandler*) rygel_http_get_handler_construct (object_type);
	return self;
}


RygelHTTPPlaylistHandler* rygel_http_playlist_handler_new (const gchar* arg, GCancellable* cancellable) {
	return rygel_http_playlist_handler_construct (RYGEL_TYPE_HTTP_PLAYLIST_HANDLER, arg, cancellable);
}


gboolean rygel_http_playlist_handler_is_supported (const gchar* arg) {
	gboolean result = FALSE;
	result = TRUE;
	return result;
}


static void rygel_http_playlist_handler_class_init (RygelHTTPPlaylistHandlerClass * klass) {
	rygel_http_playlist_handler_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_http_playlist_handler_instance_init (RygelHTTPPlaylistHandler * self) {
}


GType rygel_http_playlist_handler_get_type (void) {
	static volatile gsize rygel_http_playlist_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_playlist_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPPlaylistHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_playlist_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPPlaylistHandler), 0, (GInstanceInitFunc) rygel_http_playlist_handler_instance_init, NULL };
		GType rygel_http_playlist_handler_type_id;
		rygel_http_playlist_handler_type_id = g_type_register_static (RYGEL_TYPE_HTTP_GET_HANDLER, "RygelHTTPPlaylistHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_playlist_handler_type_id__volatile, rygel_http_playlist_handler_type_id);
	}
	return rygel_http_playlist_handler_type_id__volatile;
}


GeeArrayList* rygel_media_item_get_uris (RygelMediaItem* self) {
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->uris;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


gboolean rygel_media_item_is_live_stream (RygelMediaItem* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = ((RygelMediaObject*) self)->id;
	if (g_strcmp0 (_tmp0_, "VideoItem") == 0) {
		result = FALSE;
		return result;
	} else {
		result = TRUE;
		return result;
	}
}


gboolean rygel_media_item_streamable (RygelMediaItem* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = TRUE;
	return result;
}


RygelMediaItem* rygel_media_item_construct (GType object_type) {
	RygelMediaItem* self = NULL;
	self = (RygelMediaItem*) rygel_media_object_construct (object_type);
	return self;
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
	((RygelMediaObjectClass *) klass)->finalize = rygel_media_item_finalize;
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
	GeeArrayList* _tmp0_ = NULL;
	self->size = (glong) 1024;
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	self->uris = _tmp0_;
	self->place_holder = FALSE;
}


static void rygel_media_item_finalize (RygelMediaObject* obj) {
	RygelMediaItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem);
	_g_object_unref0 (self->uris);
	RYGEL_MEDIA_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
}


GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_OBJECT, "RygelMediaItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


RygelAudioItem* rygel_audio_item_construct (GType object_type) {
	RygelAudioItem* self = NULL;
	gchar* _tmp0_ = NULL;
	self = (RygelAudioItem*) rygel_media_item_construct (object_type);
	_tmp0_ = g_strdup ("AudioItem");
	_g_free0 (((RygelMediaObject*) self)->id);
	((RygelMediaObject*) self)->id = _tmp0_;
	return self;
}


RygelAudioItem* rygel_audio_item_new (void) {
	return rygel_audio_item_construct (RYGEL_TYPE_AUDIO_ITEM);
}


static void rygel_audio_item_class_init (RygelAudioItemClass * klass) {
	rygel_audio_item_parent_class = g_type_class_peek_parent (klass);
	((RygelMediaObjectClass *) klass)->finalize = rygel_audio_item_finalize;
}


static void rygel_audio_item_instance_init (RygelAudioItem * self) {
	self->duration = (gint64) 2048;
}


static void rygel_audio_item_finalize (RygelMediaObject* obj) {
	RygelAudioItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem);
	RYGEL_MEDIA_OBJECT_CLASS (rygel_audio_item_parent_class)->finalize (obj);
}


GType rygel_audio_item_get_type (void) {
	static volatile gsize rygel_audio_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_audio_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelAudioItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_audio_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelAudioItem), 0, (GInstanceInitFunc) rygel_audio_item_instance_init, NULL };
		GType rygel_audio_item_type_id;
		rygel_audio_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ITEM, "RygelAudioItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_audio_item_type_id__volatile, rygel_audio_item_type_id);
	}
	return rygel_audio_item_type_id__volatile;
}


gboolean rygel_visual_item_is_live_stream (RygelVisualItem* self) {
	gboolean result = FALSE;
	result = FALSE;
	return result;
}


gboolean rygel_visual_item_streamable (RygelVisualItem* self) {
	gboolean result = FALSE;
	result = FALSE;
	return result;
}


gint rygel_visual_item_get_width (RygelVisualItem* self) {
	g_return_val_if_fail (self != NULL, 0);
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_width (self);
}


void rygel_visual_item_set_width (RygelVisualItem* self, gint value) {
	g_return_if_fail (self != NULL);
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_width (self, value);
}


gint rygel_visual_item_get_height (RygelVisualItem* self) {
	g_return_val_if_fail (self != NULL, 0);
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_height (self);
}


void rygel_visual_item_set_height (RygelVisualItem* self, gint value) {
	g_return_if_fail (self != NULL);
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_height (self, value);
}


gint rygel_visual_item_get_color_depth (RygelVisualItem* self) {
	g_return_val_if_fail (self != NULL, 0);
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_color_depth (self);
}


void rygel_visual_item_set_color_depth (RygelVisualItem* self, gint value) {
	g_return_if_fail (self != NULL);
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_color_depth (self, value);
}


GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->get_thumbnails (self);
}


void rygel_visual_item_set_thumbnails (RygelVisualItem* self, GeeArrayList* value) {
	g_return_if_fail (self != NULL);
	RYGEL_VISUAL_ITEM_GET_INTERFACE (self)->set_thumbnails (self, value);
}


static void rygel_visual_item_base_init (RygelVisualItemIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType rygel_visual_item_get_type (void) {
	static volatile gsize rygel_visual_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_visual_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelVisualItemIface), (GBaseInitFunc) rygel_visual_item_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_visual_item_type_id;
		rygel_visual_item_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelVisualItem", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_visual_item_type_id, RYGEL_TYPE_MEDIA_ITEM);
		g_once_init_leave (&rygel_visual_item_type_id__volatile, rygel_visual_item_type_id);
	}
	return rygel_visual_item_type_id__volatile;
}


RygelVideoItem* rygel_video_item_construct (GType object_type) {
	RygelVideoItem* self = NULL;
	gchar* _tmp0_ = NULL;
	self = (RygelVideoItem*) rygel_audio_item_construct (object_type);
	_tmp0_ = g_strdup ("VideoItem");
	_g_free0 (((RygelMediaObject*) self)->id);
	((RygelMediaObject*) self)->id = _tmp0_;
	return self;
}


RygelVideoItem* rygel_video_item_new (void) {
	return rygel_video_item_construct (RYGEL_TYPE_VIDEO_ITEM);
}


static gint rygel_video_item_real_get_width (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_ = 0;
	self = (RygelVideoItem*) base;
	_tmp0_ = self->priv->_width;
	result = _tmp0_;
	return result;
}


static void rygel_video_item_real_set_width (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_ = 0;
	self = (RygelVideoItem*) base;
	_tmp0_ = value;
	self->priv->_width = _tmp0_;
}


static gint rygel_video_item_real_get_height (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_ = 0;
	self = (RygelVideoItem*) base;
	_tmp0_ = self->priv->_height;
	result = _tmp0_;
	return result;
}


static void rygel_video_item_real_set_height (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_ = 0;
	self = (RygelVideoItem*) base;
	_tmp0_ = value;
	self->priv->_height = _tmp0_;
}


static gint rygel_video_item_real_get_color_depth (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_ = 0;
	self = (RygelVideoItem*) base;
	_tmp0_ = self->priv->_color_depth;
	result = _tmp0_;
	return result;
}


static void rygel_video_item_real_set_color_depth (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_ = 0;
	self = (RygelVideoItem*) base;
	_tmp0_ = value;
	self->priv->_color_depth = _tmp0_;
}


static GeeArrayList* rygel_video_item_real_get_thumbnails (RygelVisualItem* base) {
	GeeArrayList* result;
	RygelVideoItem* self;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	RygelThumbnail* _tmp2_ = NULL;
	RygelThumbnail* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
	self = (RygelVideoItem*) base;
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_THUMBNAIL, (GBoxedCopyFunc) rygel_thumbnail_ref, rygel_thumbnail_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->ts);
	self->priv->ts = _tmp0_;
	_tmp1_ = self->priv->ts;
	_tmp2_ = rygel_thumbnail_new ();
	_tmp3_ = _tmp2_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp3_);
	_rygel_thumbnail_unref0 (_tmp3_);
	_tmp4_ = self->priv->ts;
	result = _tmp4_;
	return result;
}


static void rygel_video_item_real_set_thumbnails (RygelVisualItem* base, GeeArrayList* value) {
	RygelVideoItem* self;
	self = (RygelVideoItem*) base;
}


static void rygel_video_item_class_init (RygelVideoItemClass * klass) {
	rygel_video_item_parent_class = g_type_class_peek_parent (klass);
	((RygelMediaObjectClass *) klass)->finalize = rygel_video_item_finalize;
	g_type_class_add_private (klass, sizeof (RygelVideoItemPrivate));
}


static void rygel_video_item_rygel_visual_item_interface_init (RygelVisualItemIface * iface) {
	rygel_video_item_rygel_visual_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_width = rygel_video_item_real_get_width;
	iface->set_width = rygel_video_item_real_set_width;
	iface->get_height = rygel_video_item_real_get_height;
	iface->set_height = rygel_video_item_real_set_height;
	iface->get_color_depth = rygel_video_item_real_get_color_depth;
	iface->set_color_depth = rygel_video_item_real_set_color_depth;
	iface->get_thumbnails = rygel_video_item_real_get_thumbnails;
	iface->set_thumbnails = rygel_video_item_real_set_thumbnails;
}


static void rygel_video_item_instance_init (RygelVideoItem * self) {
	GeeArrayList* _tmp0_ = NULL;
	self->priv = RYGEL_VIDEO_ITEM_GET_PRIVATE (self);
	self->priv->_width = -1;
	self->priv->_height = -1;
	self->priv->_color_depth = -1;
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_SUBTITLE, (GBoxedCopyFunc) rygel_subtitle_ref, rygel_subtitle_unref, NULL, NULL, NULL);
	self->subtitles = _tmp0_;
}


static void rygel_video_item_finalize (RygelMediaObject* obj) {
	RygelVideoItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem);
	_g_object_unref0 (self->priv->ts);
	_g_object_unref0 (self->subtitles);
	RYGEL_MEDIA_OBJECT_CLASS (rygel_video_item_parent_class)->finalize (obj);
}


GType rygel_video_item_get_type (void) {
	static volatile gsize rygel_video_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_video_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelVideoItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_video_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelVideoItem), 0, (GInstanceInitFunc) rygel_video_item_instance_init, NULL };
		static const GInterfaceInfo rygel_visual_item_info = { (GInterfaceInitFunc) rygel_video_item_rygel_visual_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_video_item_type_id;
		rygel_video_item_type_id = g_type_register_static (RYGEL_TYPE_AUDIO_ITEM, "RygelVideoItem", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_video_item_type_id, RYGEL_TYPE_VISUAL_ITEM, &rygel_visual_item_info);
		g_once_init_leave (&rygel_video_item_type_id__volatile, rygel_video_item_type_id);
	}
	return rygel_video_item_type_id__volatile;
}


RygelMusicItem* rygel_music_item_construct (GType object_type) {
	RygelMusicItem* self = NULL;
	self = (RygelMusicItem*) rygel_audio_item_construct (object_type);
	return self;
}


RygelMusicItem* rygel_music_item_new (void) {
	return rygel_music_item_construct (RYGEL_TYPE_MUSIC_ITEM);
}


static void rygel_music_item_class_init (RygelMusicItemClass * klass) {
	rygel_music_item_parent_class = g_type_class_peek_parent (klass);
	((RygelMediaObjectClass *) klass)->finalize = rygel_music_item_finalize;
}


static void rygel_music_item_instance_init (RygelMusicItem * self) {
}


static void rygel_music_item_finalize (RygelMediaObject* obj) {
	RygelMusicItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem);
	_rygel_thumbnail_unref0 (self->album_art);
	RYGEL_MEDIA_OBJECT_CLASS (rygel_music_item_parent_class)->finalize (obj);
}


GType rygel_music_item_get_type (void) {
	static volatile gsize rygel_music_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_music_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMusicItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_music_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMusicItem), 0, (GInstanceInitFunc) rygel_music_item_instance_init, NULL };
		GType rygel_music_item_type_id;
		rygel_music_item_type_id = g_type_register_static (RYGEL_TYPE_AUDIO_ITEM, "RygelMusicItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_music_item_type_id__volatile, rygel_music_item_type_id);
	}
	return rygel_music_item_type_id__volatile;
}


RygelThumbnail* rygel_thumbnail_construct (GType object_type) {
	RygelThumbnail* self = NULL;
	self = (RygelThumbnail*) g_type_create_instance (object_type);
	return self;
}


RygelThumbnail* rygel_thumbnail_new (void) {
	return rygel_thumbnail_construct (RYGEL_TYPE_THUMBNAIL);
}


static void rygel_value_thumbnail_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_thumbnail_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_thumbnail_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_thumbnail_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_thumbnail_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_thumbnail_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_thumbnail_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelThumbnail* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_thumbnail_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_thumbnail_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelThumbnail** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_thumbnail_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_thumbnail (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecThumbnail* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_THUMBNAIL), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_thumbnail (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_THUMBNAIL), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_thumbnail (GValue* value, gpointer v_object) {
	RygelThumbnail* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_THUMBNAIL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_THUMBNAIL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_thumbnail_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_thumbnail_unref (old);
	}
}


void rygel_value_take_thumbnail (GValue* value, gpointer v_object) {
	RygelThumbnail* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_THUMBNAIL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_THUMBNAIL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_thumbnail_unref (old);
	}
}


static void rygel_thumbnail_class_init (RygelThumbnailClass * klass) {
	rygel_thumbnail_parent_class = g_type_class_peek_parent (klass);
	((RygelThumbnailClass *) klass)->finalize = rygel_thumbnail_finalize;
}


static void rygel_thumbnail_instance_init (RygelThumbnail * self) {
	self->size = (glong) 1024;
	self->ref_count = 1;
}


static void rygel_thumbnail_finalize (RygelThumbnail* obj) {
	RygelThumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_THUMBNAIL, RygelThumbnail);
	g_signal_handlers_destroy (self);
	_g_free0 (self->file_extension);
}


GType rygel_thumbnail_get_type (void) {
	static volatile gsize rygel_thumbnail_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_thumbnail_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_thumbnail_init, rygel_value_thumbnail_free_value, rygel_value_thumbnail_copy_value, rygel_value_thumbnail_peek_pointer, "p", rygel_value_thumbnail_collect_value, "p", rygel_value_thumbnail_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelThumbnail), 0, (GInstanceInitFunc) rygel_thumbnail_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_thumbnail_type_id;
		rygel_thumbnail_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelThumbnail", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_thumbnail_type_id__volatile, rygel_thumbnail_type_id);
	}
	return rygel_thumbnail_type_id__volatile;
}


gpointer rygel_thumbnail_ref (gpointer instance) {
	RygelThumbnail* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_thumbnail_unref (gpointer instance) {
	RygelThumbnail* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_THUMBNAIL_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


RygelSubtitle* rygel_subtitle_construct (GType object_type) {
	RygelSubtitle* self = NULL;
	self = (RygelSubtitle*) g_type_create_instance (object_type);
	return self;
}


RygelSubtitle* rygel_subtitle_new (void) {
	return rygel_subtitle_construct (RYGEL_TYPE_SUBTITLE);
}


static void rygel_value_subtitle_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_subtitle_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_subtitle_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_subtitle_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_subtitle_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_subtitle_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_subtitle_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelSubtitle* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_subtitle_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_subtitle_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelSubtitle** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_subtitle_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecSubtitle* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_SUBTITLE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_subtitle (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_SUBTITLE), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_subtitle (GValue* value, gpointer v_object) {
	RygelSubtitle* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_SUBTITLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_SUBTITLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_subtitle_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_subtitle_unref (old);
	}
}


void rygel_value_take_subtitle (GValue* value, gpointer v_object) {
	RygelSubtitle* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_SUBTITLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_SUBTITLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_subtitle_unref (old);
	}
}


static void rygel_subtitle_class_init (RygelSubtitleClass * klass) {
	rygel_subtitle_parent_class = g_type_class_peek_parent (klass);
	((RygelSubtitleClass *) klass)->finalize = rygel_subtitle_finalize;
}


static void rygel_subtitle_instance_init (RygelSubtitle * self) {
	self->size = (glong) 1024;
	self->ref_count = 1;
}


static void rygel_subtitle_finalize (RygelSubtitle* obj) {
	RygelSubtitle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_SUBTITLE, RygelSubtitle);
	g_signal_handlers_destroy (self);
	_g_free0 (self->caption_type);
}


GType rygel_subtitle_get_type (void) {
	static volatile gsize rygel_subtitle_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_subtitle_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_subtitle_init, rygel_value_subtitle_free_value, rygel_value_subtitle_copy_value, rygel_value_subtitle_peek_pointer, "p", rygel_value_subtitle_collect_value, "p", rygel_value_subtitle_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelSubtitleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_subtitle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSubtitle), 0, (GInstanceInitFunc) rygel_subtitle_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_subtitle_type_id;
		rygel_subtitle_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelSubtitle", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_subtitle_type_id__volatile, rygel_subtitle_type_id);
	}
	return rygel_subtitle_type_id__volatile;
}


gpointer rygel_subtitle_ref (gpointer instance) {
	RygelSubtitle* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_subtitle_unref (gpointer instance) {
	RygelSubtitle* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_SUBTITLE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPGet* get_request) {
	RygelHTTPResponse * self = NULL;
	RygelHTTPGet* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupMessage* _tmp2_ = NULL;
	SoupMessage* _tmp3_ = NULL;
	SoupMessageHeaders* _tmp4_ = NULL;
	RygelHTTPGet* _tmp5_ = NULL;
	SoupServer* _tmp6_ = NULL;
	SoupServer* _tmp7_ = NULL;
	g_return_val_if_fail (get_request != NULL, NULL);
	self = (RygelHTTPResponse*) g_object_new (object_type, NULL);
	_tmp0_ = get_request;
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->msg);
	self->priv->msg = _tmp2_;
	_tmp3_ = self->priv->msg;
	_tmp4_ = _tmp3_->response_headers;
	soup_message_headers_set_encoding (_tmp4_, SOUP_ENCODING_CONTENT_LENGTH);
	_tmp5_ = get_request;
	_tmp6_ = ((RygelHTTPRequest*) _tmp5_)->server;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (self->priv->server);
	self->priv->server = _tmp7_;
	return self;
}


RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* get_request) {
	return rygel_http_response_construct (RYGEL_TYPE_HTTP_RESPONSE, get_request);
}


static void rygel_http_response_real_run_data_free (gpointer _data) {
	RygelHttpResponseRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelHttpResponseRunData, _data_);
}


static void rygel_http_response_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPResponse * self;
	RygelHttpResponseRunData* _data_;
	RygelHTTPResponse* _tmp0_ = NULL;
	self = (RygelHTTPResponse*) base;
	_data_ = g_slice_new0 (RygelHttpResponseRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_response_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_response_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_http_response_real_run_co (_data_);
}


static void rygel_http_response_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpResponseRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		RygelHTTPResponse* self;
		self = _data3_->self;
		(_data3_->run_continue_target_destroy_notify == NULL) ? NULL : (_data3_->run_continue_target_destroy_notify (_data3_->run_continue_target), NULL);
		_data3_->run_continue = NULL;
		_data3_->run_continue_target = NULL;
		_data3_->run_continue_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static gboolean _rygel_http_response_real_run_co_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_http_response_real_run_co (self);
	return result;
}


static gboolean __lambda5_ (Block3Data* _data3_) {
	RygelHTTPResponse* self;
	gboolean result = FALSE;
	self = _data3_->self;
	_data3_->run_continue (_data3_->run_continue_target);
	result = FALSE;
	return result;
}


static gboolean ___lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda5_ (self);
	return result;
}


static gboolean rygel_http_response_real_run_co (RygelHttpResponseRunData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data3_ = g_slice_new0 (Block3Data);
	_data_->_data3_->_ref_count_ = 1;
	_data_->_data3_->self = g_object_ref (_data_->self);
	_data_->_data3_->_async_data_ = _data_;
	_data_->_data3_->run_continue = _rygel_http_response_real_run_co_gsource_func;
	_data_->_data3_->run_continue_target = _data_;
	_data_->_data3_->run_continue_target_destroy_notify = NULL;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda5__gsource_func, block3_data_ref (_data_->_data3_), block3_data_unref);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->msg;
	soup_message_set_status (_data_->_tmp0_, (guint) SOUP_STATUS_OK);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->priv->server;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->self->priv->msg;
	soup_server_unpause_message (_data_->_tmp1_, _data_->_tmp2_);
	g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
	block3_data_unref (_data_->_data3_);
	_data_->_data3_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static GCancellable* rygel_http_response_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPResponse* self;
	GCancellable* _tmp0_ = NULL;
	self = (RygelHTTPResponse*) base;
	_tmp0_ = self->priv->_cancellable;
	result = _tmp0_;
	return result;
}


static void rygel_http_response_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPResponse* self;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	self = (RygelHTTPResponse*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = _tmp1_;
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_http_response_class_init (RygelHTTPResponseClass * klass) {
	rygel_http_response_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPResponsePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_response_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_response_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_response_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_RESPONSE_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_http_response_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_http_response_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*)(RygelStateMachine*)) rygel_http_response_real_run;
	iface->run_finish = rygel_http_response_real_run_finish;
	iface->get_cancellable = rygel_http_response_real_get_cancellable;
	iface->set_cancellable = rygel_http_response_real_set_cancellable;
}


static void rygel_http_response_instance_init (RygelHTTPResponse * self) {
	self->priv = RYGEL_HTTP_RESPONSE_GET_PRIVATE (self);
}


static void rygel_http_response_finalize (GObject* obj) {
	RygelHTTPResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse);
	_g_object_unref0 (self->priv->_cancellable);
	_g_object_unref0 (self->priv->msg);
	_g_object_unref0 (self->priv->server);
	G_OBJECT_CLASS (rygel_http_response_parent_class)->finalize (obj);
}


GType rygel_http_response_get_type (void) {
	static volatile gsize rygel_http_response_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_response_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPResponse), 0, (GInstanceInitFunc) rygel_http_response_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_response_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_response_type_id;
		rygel_http_response_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPResponse", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_response_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_response_type_id__volatile, rygel_http_response_type_id);
	}
	return rygel_http_response_type_id__volatile;
}


static void _vala_rygel_http_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse);
	switch (property_id) {
		case RYGEL_HTTP_RESPONSE_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_http_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse);
	switch (property_id) {
		case RYGEL_HTTP_RESPONSE_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


RygelMediaObject* rygel_media_object_construct (GType object_type) {
	RygelMediaObject* self = NULL;
	self = (RygelMediaObject*) g_type_create_instance (object_type);
	return self;
}


RygelMediaObject* rygel_media_object_new (void) {
	return rygel_media_object_construct (RYGEL_TYPE_MEDIA_OBJECT);
}


static void rygel_value_media_object_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_value_media_object_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_media_object_unref (value->data[0].v_pointer);
	}
}


static void rygel_value_media_object_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_media_object_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_value_media_object_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_value_media_object_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelMediaObject* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_media_object_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_value_media_object_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelMediaObject** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_media_object_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_param_spec_media_object (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelParamSpecMediaObject* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_TYPE_MEDIA_OBJECT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_value_get_media_object (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_OBJECT), NULL);
	return value->data[0].v_pointer;
}


void rygel_value_set_media_object (GValue* value, gpointer v_object) {
	RygelMediaObject* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_OBJECT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_MEDIA_OBJECT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_media_object_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_media_object_unref (old);
	}
}


void rygel_value_take_media_object (GValue* value, gpointer v_object) {
	RygelMediaObject* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_TYPE_MEDIA_OBJECT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_TYPE_MEDIA_OBJECT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_media_object_unref (old);
	}
}


static void rygel_media_object_class_init (RygelMediaObjectClass * klass) {
	rygel_media_object_parent_class = g_type_class_peek_parent (klass);
	((RygelMediaObjectClass *) klass)->finalize = rygel_media_object_finalize;
}


static void rygel_media_object_instance_init (RygelMediaObject * self) {
	gchar* _tmp0_ = NULL;
	_tmp0_ = g_strdup ("");
	self->mime_type = _tmp0_;
	self->ref_count = 1;
}


static void rygel_media_object_finalize (RygelMediaObject* obj) {
	RygelMediaObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject);
	g_signal_handlers_destroy (self);
	_g_free0 (self->id);
	_g_free0 (self->mime_type);
}


GType rygel_media_object_get_type (void) {
	static volatile gsize rygel_media_object_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_object_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_value_media_object_init, rygel_value_media_object_free_value, rygel_value_media_object_copy_value, rygel_value_media_object_peek_pointer, "p", rygel_value_media_object_collect_value, "p", rygel_value_media_object_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaObject), 0, (GInstanceInitFunc) rygel_media_object_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_media_object_type_id;
		rygel_media_object_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelMediaObject", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_media_object_type_id__volatile, rygel_media_object_type_id);
	}
	return rygel_media_object_type_id__volatile;
}


gpointer rygel_media_object_ref (gpointer instance) {
	RygelMediaObject* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_media_object_unref (gpointer instance) {
	RygelMediaObject* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_MEDIA_OBJECT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


RygelTranscoder* rygel_transcoder_construct (GType object_type, const gchar* extension) {
	RygelTranscoder * self = NULL;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (extension != NULL, NULL);
	self = (RygelTranscoder*) g_object_new (object_type, NULL);
	_tmp0_ = extension;
	rygel_transcoder_set_extension (self, _tmp0_);
	return self;
}


RygelTranscoder* rygel_transcoder_new (const gchar* extension) {
	return rygel_transcoder_construct (RYGEL_TYPE_TRANSCODER, extension);
}


const gchar* rygel_transcoder_get_extension (RygelTranscoder* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_extension;
	result = _tmp0_;
	return result;
}


void rygel_transcoder_set_extension (RygelTranscoder* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_extension);
	self->priv->_extension = _tmp1_;
	g_object_notify ((GObject *) self, "extension");
}


static void rygel_transcoder_class_init (RygelTranscoderClass * klass) {
	rygel_transcoder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelTranscoderPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_transcoder_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_transcoder_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_transcoder_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_TRANSCODER_EXTENSION, g_param_spec_string ("extension", "extension", "extension", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_transcoder_instance_init (RygelTranscoder * self) {
	self->priv = RYGEL_TRANSCODER_GET_PRIVATE (self);
}


static void rygel_transcoder_finalize (GObject* obj) {
	RygelTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_TRANSCODER, RygelTranscoder);
	_g_free0 (self->priv->_extension);
	G_OBJECT_CLASS (rygel_transcoder_parent_class)->finalize (obj);
}


GType rygel_transcoder_get_type (void) {
	static volatile gsize rygel_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_transcoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTranscoder), 0, (GInstanceInitFunc) rygel_transcoder_instance_init, NULL };
		GType rygel_transcoder_type_id;
		rygel_transcoder_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelTranscoder", &g_define_type_info, 0);
		g_once_init_leave (&rygel_transcoder_type_id__volatile, rygel_transcoder_type_id);
	}
	return rygel_transcoder_type_id__volatile;
}


static void _vala_rygel_transcoder_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_TRANSCODER, RygelTranscoder);
	switch (property_id) {
		case RYGEL_TRANSCODER_EXTENSION:
		g_value_set_string (value, rygel_transcoder_get_extension (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_transcoder_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_TRANSCODER, RygelTranscoder);
	switch (property_id) {
		case RYGEL_TRANSCODER_EXTENSION:
		rygel_transcoder_set_extension (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



