/* rygel-relational-expression.c generated by valac 0.26.0.3-ba43c, the Vala compiler
 * generated from rygel-relational-expression.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gio/gio.h>
#include <gee.h>


#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelRelationalExpressionPrivate RygelRelationalExpressionPrivate;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_TRACKABLE_CONTAINER (rygel_trackable_container_get_type ())
#define RYGEL_TRACKABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER, RygelTrackableContainer))
#define RYGEL_IS_TRACKABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER))
#define RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_TRACKABLE_CONTAINER, RygelTrackableContainerIface))

typedef struct _RygelTrackableContainer RygelTrackableContainer;
typedef struct _RygelTrackableContainerIface RygelTrackableContainerIface;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_TRACKABLE_ITEM (rygel_trackable_item_get_type ())
#define RYGEL_TRACKABLE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRACKABLE_ITEM, RygelTrackableItem))
#define RYGEL_IS_TRACKABLE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRACKABLE_ITEM))
#define RYGEL_TRACKABLE_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_TRACKABLE_ITEM, RygelTrackableItemIface))

typedef struct _RygelTrackableItem RygelTrackableItem;
typedef struct _RygelTrackableItemIface RygelTrackableItemIface;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_WRITABLE_CONTAINER (rygel_writable_container_get_type ())
#define RYGEL_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainer))
#define RYGEL_WRITABLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerClass))
#define RYGEL_IS_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_IS_WRITABLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_WRITABLE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerClass))

typedef struct _RygelWritableContainer RygelWritableContainer;
typedef struct _RygelWritableContainerClass RygelWritableContainerClass;

#define RYGEL_TYPE_PHOTO_ITEM (rygel_photo_item_get_type ())
#define RYGEL_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItem))
#define RYGEL_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))
#define RYGEL_IS_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_IS_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_PHOTO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))

typedef struct _RygelPhotoItem RygelPhotoItem;
typedef struct _RygelPhotoItemClass RygelPhotoItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
typedef struct _RygelPhotoItemPrivate RygelPhotoItemPrivate;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelRelationalExpression {
	RygelSearchExpression parent_instance;
	RygelRelationalExpressionPrivate * priv;
};

struct _RygelRelationalExpressionClass {
	RygelSearchExpressionClass parent_class;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* ref_id;
	gchar* upnp_class;
	GUPnPOCMFlags ocm_flags;
	GeeArrayList* uris;
	guint object_update_id;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	void (*get_children) (RygelMediaObject* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaObject* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
};

struct _RygelTrackableContainerIface {
	GTypeInterface parent_iface;
};

struct _RygelTrackableItemIface {
	GTypeInterface parent_iface;
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	GeeArrayList* create_classes;
	gchar* sort_criteria;
	guint update_id;
	RygelMediaObject* found_object;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* dlna_profile;
	gchar* mime_type;
	glong size;
	gboolean place_holder;
	gchar* date;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
};

struct _RygelPhotoItem {
	RygelMediaItem parent_instance;
	RygelPhotoItemPrivate * priv;
	gchar* creator;
};

struct _RygelPhotoItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	gchar* artist;
	gchar* album;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};


static gpointer rygel_relational_expression_parent_class = NULL;

gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_RELATIONAL_EXPRESSION_DUMMY_PROPERTY
};
#define RYGEL_RELATIONAL_EXPRESSION_CAPS "@id,@parentID,@refID,upnp:class," "dc:title,upnp:artist,upnp:album," "dc:creator,upnp:createClass,@childCount"
static gboolean rygel_relational_expression_real_satisfied_by (RygelSearchExpression* base, RygelMediaObject* media_object);
gboolean rygel_relational_expression_compare_string (RygelRelationalExpression* self, const gchar* str);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
RygelMediaContainer* rygel_media_object_get_parent (RygelMediaObject* self);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
GType rygel_trackable_container_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_trackable_item_get_type (void) G_GNUC_CONST;
gboolean rygel_relational_expression_compare_uint (RygelRelationalExpression* self, guint integer);
GType rygel_writable_container_get_type (void) G_GNUC_CONST;
static gboolean rygel_relational_expression_compare_create_class (RygelRelationalExpression* self, RygelWritableContainer* container);
GType rygel_photo_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
gboolean rygel_relational_expression_compare_int (RygelRelationalExpression* self, gint integer);
gint rygel_media_container_get_child_count (RygelMediaContainer* self);
static gchar* rygel_relational_expression_real_to_string (RygelSearchExpression* base);
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
RygelSearchExpression* rygel_search_expression_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GType h_type, GBoxedCopyFunc h_dup_func, GDestroyNotify h_destroy_func, GType i_type, GBoxedCopyFunc i_dup_func, GDestroyNotify i_destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean rygel_relational_expression_real_satisfied_by (RygelSearchExpression* base, RygelMediaObject* media_object) {
	RygelRelationalExpression * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	static GQuark _tmp2_label8 = 0;
	static GQuark _tmp2_label9 = 0;
	static GQuark _tmp2_label10 = 0;
	static GQuark _tmp2_label11 = 0;
	self = (RygelRelationalExpression*) base;
	g_return_val_if_fail (media_object != NULL, FALSE);
	_tmp0_ = ((RygelSearchExpression*) self)->operand1;
	_tmp1_ = (const gchar*) _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("@id")))) {
		switch (0) {
			default:
			{
				RygelMediaObject* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				_tmp4_ = media_object;
				_tmp5_ = rygel_media_object_get_id (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = rygel_relational_expression_compare_string (self, _tmp6_);
				result = _tmp7_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("@refID")))) {
		switch (0) {
			default:
			{
				RygelMediaObject* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				gboolean _tmp10_ = FALSE;
				_tmp8_ = media_object;
				_tmp9_ = _tmp8_->ref_id;
				_tmp10_ = rygel_relational_expression_compare_string (self, _tmp9_);
				result = _tmp10_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("@parentID")))) {
		switch (0) {
			default:
			{
				RygelMediaObject* _tmp11_ = NULL;
				RygelMediaContainer* _tmp12_ = NULL;
				RygelMediaContainer* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
				_tmp11_ = media_object;
				_tmp12_ = rygel_media_object_get_parent (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = rygel_relational_expression_compare_string (self, _tmp15_);
				result = _tmp16_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("upnp:class")))) {
		switch (0) {
			default:
			{
				RygelMediaObject* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
				gboolean _tmp19_ = FALSE;
				_tmp17_ = media_object;
				_tmp18_ = _tmp17_->upnp_class;
				_tmp19_ = rygel_relational_expression_compare_string (self, _tmp18_);
				result = _tmp19_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("dc:title")))) {
		switch (0) {
			default:
			{
				RygelMediaObject* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				gboolean _tmp23_ = FALSE;
				_tmp20_ = media_object;
				_tmp21_ = rygel_media_object_get_title (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = rygel_relational_expression_compare_string (self, _tmp22_);
				result = _tmp23_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("upnp:objectUpdateID")))) {
		switch (0) {
			default:
			{
				gconstpointer _tmp24_ = NULL;
				_tmp24_ = ((RygelSearchExpression*) self)->op;
				if (((GUPnPSearchCriteriaOp) ((gintptr) _tmp24_)) == GUPNP_SEARCH_CRITERIA_OP_EXISTS) {
					gconstpointer _tmp25_ = NULL;
					_tmp25_ = ((RygelSearchExpression*) self)->operand2;
					if (g_strcmp0 ((const gchar*) _tmp25_, "true") == 0) {
						gboolean _tmp26_ = FALSE;
						RygelMediaObject* _tmp27_ = NULL;
						_tmp27_ = media_object;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, RYGEL_TYPE_TRACKABLE_CONTAINER)) {
							_tmp26_ = TRUE;
						} else {
							RygelMediaObject* _tmp28_ = NULL;
							_tmp28_ = media_object;
							_tmp26_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, RYGEL_TYPE_TRACKABLE_ITEM);
						}
						result = _tmp26_;
						return result;
					} else {
						gboolean _tmp29_ = FALSE;
						RygelMediaObject* _tmp30_ = NULL;
						_tmp30_ = media_object;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, RYGEL_TYPE_TRACKABLE_CONTAINER)) {
							_tmp29_ = TRUE;
						} else {
							RygelMediaObject* _tmp31_ = NULL;
							_tmp31_ = media_object;
							_tmp29_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, RYGEL_TYPE_TRACKABLE_ITEM);
						}
						result = !_tmp29_;
						return result;
					}
				} else {
					RygelMediaObject* _tmp32_ = NULL;
					guint _tmp33_ = 0U;
					gboolean _tmp34_ = FALSE;
					_tmp32_ = media_object;
					_tmp33_ = _tmp32_->object_update_id;
					_tmp34_ = rygel_relational_expression_compare_uint (self, _tmp33_);
					result = _tmp34_;
					return result;
				}
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("upnp:containerUpdateID")))) {
		switch (0) {
			default:
			{
				RygelMediaObject* _tmp35_ = NULL;
				gconstpointer _tmp36_ = NULL;
				_tmp35_ = media_object;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, RYGEL_TYPE_MEDIA_CONTAINER)) {
					result = FALSE;
					return result;
				}
				_tmp36_ = ((RygelSearchExpression*) self)->op;
				if (((GUPnPSearchCriteriaOp) ((gintptr) _tmp36_)) == GUPNP_SEARCH_CRITERIA_OP_EXISTS) {
					gconstpointer _tmp37_ = NULL;
					_tmp37_ = ((RygelSearchExpression*) self)->operand2;
					if (g_strcmp0 ((const gchar*) _tmp37_, "true") == 0) {
						RygelMediaObject* _tmp38_ = NULL;
						_tmp38_ = media_object;
						result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp38_, RYGEL_TYPE_TRACKABLE_CONTAINER);
						return result;
					} else {
						RygelMediaObject* _tmp39_ = NULL;
						_tmp39_ = media_object;
						result = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, RYGEL_TYPE_TRACKABLE_CONTAINER);
						return result;
					}
				} else {
					RygelMediaContainer* container = NULL;
					RygelMediaObject* _tmp40_ = NULL;
					RygelMediaContainer* _tmp41_ = NULL;
					RygelMediaContainer* _tmp42_ = NULL;
					guint _tmp43_ = 0U;
					gboolean _tmp44_ = FALSE;
					_tmp40_ = media_object;
					_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp40_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp40_) : NULL);
					container = _tmp41_;
					_tmp42_ = container;
					_tmp43_ = _tmp42_->update_id;
					_tmp44_ = rygel_relational_expression_compare_uint (self, _tmp43_);
					result = _tmp44_;
					_g_object_unref0 (container);
					return result;
				}
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("upnp:createClass")))) {
		switch (0) {
			default:
			{
				RygelMediaObject* _tmp45_ = NULL;
				RygelMediaObject* _tmp46_ = NULL;
				gboolean _tmp47_ = FALSE;
				_tmp45_ = media_object;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp45_, RYGEL_TYPE_WRITABLE_CONTAINER)) {
					result = FALSE;
					return result;
				}
				_tmp46_ = media_object;
				_tmp47_ = rygel_relational_expression_compare_create_class (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp46_, RYGEL_TYPE_WRITABLE_CONTAINER) ? ((RygelWritableContainer*) _tmp46_) : NULL);
				result = _tmp47_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("dc:creator")))) {
		switch (0) {
			default:
			{
				RygelMediaObject* _tmp48_ = NULL;
				RygelMediaObject* _tmp49_ = NULL;
				const gchar* _tmp50_ = NULL;
				gboolean _tmp51_ = FALSE;
				_tmp48_ = media_object;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, RYGEL_TYPE_PHOTO_ITEM)) {
					result = FALSE;
					return result;
				}
				_tmp49_ = media_object;
				_tmp50_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp49_, RYGEL_TYPE_PHOTO_ITEM) ? ((RygelPhotoItem*) _tmp49_) : NULL)->creator;
				_tmp51_ = rygel_relational_expression_compare_string (self, _tmp50_);
				result = _tmp51_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("upnp:artist")))) {
		switch (0) {
			default:
			{
				RygelMediaObject* _tmp52_ = NULL;
				RygelMediaObject* _tmp53_ = NULL;
				const gchar* _tmp54_ = NULL;
				gboolean _tmp55_ = FALSE;
				_tmp52_ = media_object;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp52_, RYGEL_TYPE_MUSIC_ITEM)) {
					result = FALSE;
					return result;
				}
				_tmp53_ = media_object;
				_tmp54_ = ((RygelAudioItem*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp53_, RYGEL_TYPE_MUSIC_ITEM) ? ((RygelMusicItem*) _tmp53_) : NULL))->artist;
				_tmp55_ = rygel_relational_expression_compare_string (self, _tmp54_);
				result = _tmp55_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label10) ? _tmp2_label10 : (_tmp2_label10 = g_quark_from_static_string ("upnp:album")))) {
		switch (0) {
			default:
			{
				RygelMediaObject* _tmp56_ = NULL;
				RygelMediaObject* _tmp57_ = NULL;
				const gchar* _tmp58_ = NULL;
				gboolean _tmp59_ = FALSE;
				_tmp56_ = media_object;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp56_, RYGEL_TYPE_MUSIC_ITEM)) {
					result = FALSE;
					return result;
				}
				_tmp57_ = media_object;
				_tmp58_ = ((RygelAudioItem*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp57_, RYGEL_TYPE_MUSIC_ITEM) ? ((RygelMusicItem*) _tmp57_) : NULL))->album;
				_tmp59_ = rygel_relational_expression_compare_string (self, _tmp58_);
				result = _tmp59_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label11) ? _tmp2_label11 : (_tmp2_label11 = g_quark_from_static_string ("@childCount")))) {
		switch (0) {
			default:
			{
				RygelMediaObject* _tmp60_ = NULL;
				RygelMediaContainer* container = NULL;
				RygelMediaObject* _tmp61_ = NULL;
				RygelMediaContainer* _tmp62_ = NULL;
				RygelMediaContainer* _tmp63_ = NULL;
				gint _tmp64_ = 0;
				gint _tmp65_ = 0;
				gboolean _tmp66_ = FALSE;
				_tmp60_ = media_object;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp60_, RYGEL_TYPE_MEDIA_CONTAINER)) {
					result = FALSE;
					return result;
				}
				_tmp61_ = media_object;
				_tmp62_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp61_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp61_) : NULL);
				container = _tmp62_;
				_tmp63_ = container;
				_tmp64_ = rygel_media_container_get_child_count (_tmp63_);
				_tmp65_ = _tmp64_;
				_tmp66_ = rygel_relational_expression_compare_int (self, _tmp65_);
				result = _tmp66_;
				_g_object_unref0 (container);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = FALSE;
				return result;
			}
		}
	}
}


static gchar* rygel_relational_expression_real_to_string (RygelSearchExpression* base) {
	RygelRelationalExpression * self;
	gchar* result = NULL;
	gconstpointer _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	self = (RygelRelationalExpression*) base;
	_tmp0_ = ((RygelSearchExpression*) self)->operand1;
	_tmp1_ = ((RygelSearchExpression*) self)->op;
	_tmp2_ = ((RygelSearchExpression*) self)->operand2;
	_tmp3_ = g_strdup_printf ("%s %d %s", (const gchar*) _tmp0_, (gint) ((GUPnPSearchCriteriaOp) ((gintptr) _tmp1_)), (const gchar*) _tmp2_);
	result = _tmp3_;
	return result;
}


static gboolean rygel_relational_expression_compare_create_class (RygelRelationalExpression* self, RygelWritableContainer* container) {
	gboolean result = FALSE;
	gboolean ret = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (container != NULL, FALSE);
	ret = FALSE;
	{
		GeeArrayList* _create_class_list = NULL;
		RygelWritableContainer* _tmp0_ = NULL;
		GeeArrayList* _tmp1_ = NULL;
		GeeArrayList* _tmp2_ = NULL;
		gint _create_class_size = 0;
		GeeArrayList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _create_class_index = 0;
		_tmp0_ = container;
		_tmp1_ = ((RygelMediaContainer*) _tmp0_)->create_classes;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_create_class_list = _tmp2_;
		_tmp3_ = _create_class_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_create_class_size = _tmp5_;
		_create_class_index = -1;
		while (TRUE) {
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gchar* create_class = NULL;
			GeeArrayList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
			_tmp6_ = _create_class_index;
			_create_class_index = _tmp6_ + 1;
			_tmp7_ = _create_class_index;
			_tmp8_ = _create_class_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _create_class_list;
			_tmp10_ = _create_class_index;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
			create_class = (gchar*) _tmp11_;
			_tmp12_ = create_class;
			_tmp13_ = rygel_relational_expression_compare_string (self, _tmp12_);
			if (_tmp13_) {
				ret = TRUE;
				_g_free0 (create_class);
				break;
			}
			_g_free0 (create_class);
		}
		_g_object_unref0 (_create_class_list);
	}
	result = ret;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


gboolean rygel_relational_expression_compare_string (RygelRelationalExpression* self, const gchar* str) {
	gboolean result = FALSE;
	gchar* up_operand2 = NULL;
	gconstpointer _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* up_str = NULL;
	const gchar* _tmp2_ = NULL;
	gconstpointer _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = ((RygelSearchExpression*) self)->operand2;
	_tmp1_ = g_utf8_strup ((const gchar*) _tmp0_, (gssize) (-1));
	up_operand2 = _tmp1_;
	_tmp2_ = str;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp3_ = str;
		_tmp4_ = g_utf8_strup (_tmp3_, (gssize) (-1));
		_g_free0 (up_str);
		up_str = _tmp4_;
	} else {
		_g_free0 (up_str);
		up_str = NULL;
	}
	_tmp5_ = ((RygelSearchExpression*) self)->op;
	switch ((GUPnPSearchCriteriaOp) ((gintptr) _tmp5_)) {
		case GUPNP_SEARCH_CRITERIA_OP_EXISTS:
		{
			gconstpointer _tmp6_ = NULL;
			_tmp6_ = ((RygelSearchExpression*) self)->operand2;
			if (g_strcmp0 ((const gchar*) _tmp6_, "true") == 0) {
				const gchar* _tmp7_ = NULL;
				_tmp7_ = up_str;
				result = _tmp7_ != NULL;
				_g_free0 (up_str);
				_g_free0 (up_operand2);
				return result;
			} else {
				const gchar* _tmp8_ = NULL;
				_tmp8_ = up_str;
				result = _tmp8_ == NULL;
				_g_free0 (up_str);
				_g_free0 (up_operand2);
				return result;
			}
		}
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
		{
			const gchar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			_tmp9_ = up_operand2;
			_tmp10_ = up_str;
			result = g_strcmp0 (_tmp9_, _tmp10_) == 0;
			_g_free0 (up_str);
			_g_free0 (up_operand2);
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_NEQ:
		{
			const gchar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			_tmp11_ = up_operand2;
			_tmp12_ = up_str;
			result = g_strcmp0 (_tmp11_, _tmp12_) != 0;
			_g_free0 (up_str);
			_g_free0 (up_operand2);
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
		{
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			gboolean _tmp15_ = FALSE;
			_tmp13_ = up_str;
			_tmp14_ = up_operand2;
			_tmp15_ = string_contains (_tmp13_, _tmp14_);
			result = _tmp15_;
			_g_free0 (up_str);
			_g_free0 (up_operand2);
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM:
		{
			const gchar* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			gboolean _tmp18_ = FALSE;
			_tmp16_ = up_str;
			_tmp17_ = up_operand2;
			_tmp18_ = g_str_has_prefix (_tmp16_, _tmp17_);
			result = _tmp18_;
			_g_free0 (up_str);
			_g_free0 (up_operand2);
			return result;
		}
		default:
		{
			result = FALSE;
			_g_free0 (up_str);
			_g_free0 (up_operand2);
			return result;
		}
	}
	_g_free0 (up_str);
	_g_free0 (up_operand2);
}


gboolean rygel_relational_expression_compare_int (RygelRelationalExpression* self, gint integer) {
	gboolean result = FALSE;
	gint operand2 = 0;
	gconstpointer _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gconstpointer _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = ((RygelSearchExpression*) self)->operand2;
	_tmp1_ = atoi ((const gchar*) _tmp0_);
	operand2 = _tmp1_;
	_tmp2_ = ((RygelSearchExpression*) self)->op;
	switch ((GUPnPSearchCriteriaOp) ((gintptr) _tmp2_)) {
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
		{
			gint _tmp3_ = 0;
			gint _tmp4_ = 0;
			_tmp3_ = integer;
			_tmp4_ = operand2;
			result = _tmp3_ == _tmp4_;
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_NEQ:
		{
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			_tmp5_ = integer;
			_tmp6_ = operand2;
			result = _tmp5_ != _tmp6_;
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_LESS:
		{
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			_tmp7_ = integer;
			_tmp8_ = operand2;
			result = _tmp7_ < _tmp8_;
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_LEQ:
		{
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			_tmp9_ = integer;
			_tmp10_ = operand2;
			result = _tmp9_ <= _tmp10_;
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_GREATER:
		{
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			_tmp11_ = integer;
			_tmp12_ = operand2;
			result = _tmp11_ > _tmp12_;
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_GEQ:
		{
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			_tmp13_ = integer;
			_tmp14_ = operand2;
			result = _tmp13_ >= _tmp14_;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static guint64 uint64_parse (const gchar* str) {
	guint64 result = 0ULL;
	const gchar* _tmp0_ = NULL;
	guint64 _tmp1_ = 0ULL;
	g_return_val_if_fail (str != NULL, 0ULL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoull (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


gboolean rygel_relational_expression_compare_uint (RygelRelationalExpression* self, guint integer) {
	gboolean result = FALSE;
	guint64 operand2 = 0ULL;
	gconstpointer _tmp0_ = NULL;
	guint64 _tmp1_ = 0ULL;
	gconstpointer _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = ((RygelSearchExpression*) self)->operand2;
	_tmp1_ = uint64_parse ((const gchar*) _tmp0_);
	operand2 = _tmp1_;
	_tmp2_ = ((RygelSearchExpression*) self)->op;
	switch ((GUPnPSearchCriteriaOp) ((gintptr) _tmp2_)) {
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
		{
			guint _tmp3_ = 0U;
			guint64 _tmp4_ = 0ULL;
			_tmp3_ = integer;
			_tmp4_ = operand2;
			result = ((guint64) _tmp3_) == _tmp4_;
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_NEQ:
		{
			guint _tmp5_ = 0U;
			guint64 _tmp6_ = 0ULL;
			_tmp5_ = integer;
			_tmp6_ = operand2;
			result = ((guint64) _tmp5_) != _tmp6_;
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_LESS:
		{
			guint _tmp7_ = 0U;
			guint64 _tmp8_ = 0ULL;
			_tmp7_ = integer;
			_tmp8_ = operand2;
			result = ((guint64) _tmp7_) < _tmp8_;
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_LEQ:
		{
			guint _tmp9_ = 0U;
			guint64 _tmp10_ = 0ULL;
			_tmp9_ = integer;
			_tmp10_ = operand2;
			result = ((guint64) _tmp9_) <= _tmp10_;
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_GREATER:
		{
			guint _tmp11_ = 0U;
			guint64 _tmp12_ = 0ULL;
			_tmp11_ = integer;
			_tmp12_ = operand2;
			result = ((guint64) _tmp11_) > _tmp12_;
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_GEQ:
		{
			guint _tmp13_ = 0U;
			guint64 _tmp14_ = 0ULL;
			_tmp13_ = integer;
			_tmp14_ = operand2;
			result = ((guint64) _tmp13_) >= _tmp14_;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


RygelRelationalExpression* rygel_relational_expression_construct (GType object_type) {
	RygelRelationalExpression* self = NULL;
	self = (RygelRelationalExpression*) rygel_search_expression_construct (object_type, gupnp_search_criteria_op_get_type (), NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free);
	return self;
}


RygelRelationalExpression* rygel_relational_expression_new (void) {
	return rygel_relational_expression_construct (RYGEL_TYPE_RELATIONAL_EXPRESSION);
}


static void rygel_relational_expression_class_init (RygelRelationalExpressionClass * klass) {
	rygel_relational_expression_parent_class = g_type_class_peek_parent (klass);
	((RygelSearchExpressionClass *) klass)->satisfied_by = rygel_relational_expression_real_satisfied_by;
	((RygelSearchExpressionClass *) klass)->to_string = rygel_relational_expression_real_to_string;
}


static void rygel_relational_expression_instance_init (RygelRelationalExpression * self) {
}


/**
 * This is a parsed UPnP search expression consisting of two strings joined by a
 * relational operator such as such <, <=, ==, !=, >, >=, derivedFrom or exists.
 */
GType rygel_relational_expression_get_type (void) {
	static volatile gsize rygel_relational_expression_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_relational_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelRelationalExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_relational_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelRelationalExpression), 0, (GInstanceInitFunc) rygel_relational_expression_instance_init, NULL };
		GType rygel_relational_expression_type_id;
		rygel_relational_expression_type_id = g_type_register_static (RYGEL_TYPE_SEARCH_EXPRESSION, "RygelRelationalExpression", &g_define_type_info, 0);
		g_once_init_leave (&rygel_relational_expression_type_id__volatile, rygel_relational_expression_type_id);
	}
	return rygel_relational_expression_type_id__volatile;
}



