/* rygel-media-art-store.c generated by valac 0.26.0.3-ba43c, the Vala compiler
 * generated from rygel-media-art-store.vala, do not modify */

/*
 * Copyright (C) 2010 Jens Georg <mail@jensge.org>.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libmediaart/mediaart.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <glib/gstdio.h>


#define RYGEL_TYPE_MEDIA_ART_STORE (rygel_media_art_store_get_type ())
#define RYGEL_MEDIA_ART_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStore))
#define RYGEL_MEDIA_ART_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStoreClass))
#define RYGEL_IS_MEDIA_ART_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ART_STORE))
#define RYGEL_IS_MEDIA_ART_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ART_STORE))
#define RYGEL_MEDIA_ART_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStoreClass))

typedef struct _RygelMediaArtStore RygelMediaArtStore;
typedef struct _RygelMediaArtStoreClass RygelMediaArtStoreClass;
typedef struct _RygelMediaArtStorePrivate RygelMediaArtStorePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))

typedef enum  {
	MEDIA_ART_STORE_ERROR_NO_DIR,
	MEDIA_ART_STORE_ERROR_NO_MEDIA_ART
} MediaArtStoreError;
#define MEDIA_ART_STORE_ERROR media_art_store_error_quark ()
struct _RygelMediaArtStore {
	GObject parent_instance;
	RygelMediaArtStorePrivate * priv;
};

struct _RygelMediaArtStoreClass {
	GObjectClass parent_class;
};

struct _RygelMediaArtStorePrivate {
	gchar* directory;
	MediaArtProcess* media_art_process;
};


static gpointer rygel_media_art_store_parent_class = NULL;
static RygelMediaArtStore* rygel_media_art_store_media_art_store;
static RygelMediaArtStore* rygel_media_art_store_media_art_store = NULL;
static gboolean rygel_media_art_store_first_time;
static gboolean rygel_media_art_store_first_time = TRUE;

GQuark media_art_store_error_quark (void);
GType rygel_media_art_store_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_ART_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStorePrivate))
enum  {
	RYGEL_MEDIA_ART_STORE_DUMMY_PROPERTY
};
RygelMediaArtStore* rygel_media_art_store_get_default (void);
static RygelMediaArtStore* rygel_media_art_store_new (GError** error);
static RygelMediaArtStore* rygel_media_art_store_construct (GType object_type, GError** error);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
RygelThumbnail* rygel_media_art_store_find_media_art (RygelMediaArtStore* self, RygelMusicItem* item, gboolean simple, GError** error);
GFile* rygel_media_art_store_get_media_art_file (RygelMediaArtStore* self, const gchar* type, RygelMusicItem* item, gboolean simple);
RygelThumbnail* rygel_thumbnail_new (const gchar* mime_type, const gchar* dlna_profile, const gchar* file_extension);
RygelThumbnail* rygel_thumbnail_construct (GType object_type, const gchar* mime_type, const gchar* dlna_profile, const gchar* file_extension);
RygelThumbnail* rygel_media_art_store_find_media_art_any (RygelMediaArtStore* self, RygelMusicItem* item, GError** error);
const gchar* rygel_audio_item_get_album (RygelAudioItem* self);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
const gchar* rygel_media_object_get_artist (RygelMediaObject* self);
void rygel_media_art_store_add (RygelMediaArtStore* self, RygelMusicItem* item, GFile* file, guint8* data, int data_length1);
const gchar* rygel_media_item_get_mime_type (RygelMediaItem* self);
static void rygel_media_art_store_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark media_art_store_error_quark (void) {
	return g_quark_from_static_string ("media_art_store_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelMediaArtStore* rygel_media_art_store_get_default (void) {
	RygelMediaArtStore* result = NULL;
	gboolean _tmp0_ = FALSE;
	RygelMediaArtStore* _tmp6_ = NULL;
	RygelMediaArtStore* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = rygel_media_art_store_first_time;
	if (_tmp0_) {
		{
			RygelMediaArtStore* _tmp1_ = NULL;
			RygelMediaArtStore* _tmp2_ = NULL;
			RygelMediaArtStore* _tmp3_ = NULL;
			media_art_plugin_init (128);
			_tmp2_ = rygel_media_art_store_new (&_inner_error_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == MEDIA_ART_STORE_ERROR) {
					goto __catch0_media_art_store_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (rygel_media_art_store_media_art_store);
			rygel_media_art_store_media_art_store = _tmp3_;
			_g_object_unref0 (_tmp1_);
		}
		goto __finally0;
		__catch0_media_art_store_error:
		{
			GError* _error_ = NULL;
			GError* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp4_ = _error_;
			_tmp5_ = _tmp4_->message;
			g_warning ("rygel-media-art-store.vala:47: No media art available: %s", _tmp5_);
			_g_error_free0 (_error_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	rygel_media_art_store_first_time = FALSE;
	_tmp6_ = rygel_media_art_store_media_art_store;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}


RygelThumbnail* rygel_media_art_store_find_media_art (RygelMediaArtStore* self, RygelMusicItem* item, gboolean simple, GError** error) {
	RygelThumbnail* result = NULL;
	gchar** types = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint types_length1 = 0;
	gint _types_size_ = 0;
	GFile* file = NULL;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	GFile* _tmp16_ = NULL;
	GFileInfo* info = NULL;
	GFile* _tmp17_ = NULL;
	GFileInfo* _tmp18_ = NULL;
	GFileInfo* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	RygelThumbnail* thumb = NULL;
	RygelThumbnail* _tmp21_ = NULL;
	RygelThumbnail* _tmp22_ = NULL;
	GFile* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	RygelThumbnail* _tmp25_ = NULL;
	GFileInfo* _tmp26_ = NULL;
	gint64 _tmp27_ = 0LL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = g_strdup ("track");
	_tmp1_ = g_strdup ("album");
	_tmp2_ = g_strdup ("artist");
	_tmp3_ = g_strdup ("podcast");
	_tmp4_ = g_strdup ("radio");
	_tmp5_ = g_new0 (gchar*, 5 + 1);
	_tmp5_[0] = _tmp0_;
	_tmp5_[1] = _tmp1_;
	_tmp5_[2] = _tmp2_;
	_tmp5_[3] = _tmp3_;
	_tmp5_[4] = _tmp4_;
	types = _tmp5_;
	types_length1 = 5;
	_types_size_ = types_length1;
	file = NULL;
	_tmp6_ = types;
	_tmp6__length1 = types_length1;
	{
		gchar** type_collection = NULL;
		gint type_collection_length1 = 0;
		gint _type_collection_size_ = 0;
		gint type_it = 0;
		type_collection = _tmp6_;
		type_collection_length1 = _tmp6__length1;
		for (type_it = 0; type_it < _tmp6__length1; type_it = type_it + 1) {
			gchar* _tmp7_ = NULL;
			gchar* type = NULL;
			_tmp7_ = g_strdup (type_collection[type_it]);
			type = _tmp7_;
			{
				const gchar* _tmp8_ = NULL;
				RygelMusicItem* _tmp9_ = NULL;
				gboolean _tmp10_ = FALSE;
				GFile* _tmp11_ = NULL;
				gboolean _tmp12_ = FALSE;
				GFile* _tmp13_ = NULL;
				_tmp8_ = type;
				_tmp9_ = item;
				_tmp10_ = simple;
				_tmp11_ = rygel_media_art_store_get_media_art_file (self, _tmp8_, _tmp9_, _tmp10_);
				_g_object_unref0 (file);
				file = _tmp11_;
				_tmp13_ = file;
				if (_tmp13_ != NULL) {
					GFile* _tmp14_ = NULL;
					gboolean _tmp15_ = FALSE;
					_tmp14_ = file;
					_tmp15_ = g_file_query_exists (_tmp14_, NULL);
					_tmp12_ = _tmp15_;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_g_free0 (type);
					break;
				} else {
					_g_object_unref0 (file);
					file = NULL;
				}
				_g_free0 (type);
			}
		}
	}
	_tmp16_ = file;
	if (_tmp16_ == NULL) {
		result = NULL;
		_g_object_unref0 (file);
		types = (_vala_array_free (types, types_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp17_ = file;
	_tmp18_ = g_file_query_info (_tmp17_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ "," G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	info = _tmp18_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		types = (_vala_array_free (types, types_length1, (GDestroyNotify) g_free), NULL);
		return NULL;
	}
	_tmp19_ = info;
	_tmp20_ = g_file_info_get_attribute_boolean (_tmp19_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ);
	if (!_tmp20_) {
		result = NULL;
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		types = (_vala_array_free (types, types_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp21_ = rygel_thumbnail_new ("image/jpeg", "JPEG_TN", "jpg");
	thumb = _tmp21_;
	_tmp22_ = thumb;
	_tmp23_ = file;
	_tmp24_ = g_file_get_uri (_tmp23_);
	_g_free0 (((RygelIconInfo*) _tmp22_)->uri);
	((RygelIconInfo*) _tmp22_)->uri = _tmp24_;
	_tmp25_ = thumb;
	_tmp26_ = info;
	_tmp27_ = g_file_info_get_size (_tmp26_);
	((RygelIconInfo*) _tmp25_)->size = (gint64) _tmp27_;
	result = thumb;
	_g_object_unref0 (info);
	_g_object_unref0 (file);
	types = (_vala_array_free (types, types_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


RygelThumbnail* rygel_media_art_store_find_media_art_any (RygelMediaArtStore* self, RygelMusicItem* item, GError** error) {
	RygelThumbnail* result = NULL;
	RygelThumbnail* thumb = NULL;
	RygelMusicItem* _tmp0_ = NULL;
	RygelThumbnail* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = item;
	_tmp1_ = rygel_media_art_store_find_media_art (self, _tmp0_, FALSE, &_inner_error_);
	thumb = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = thumb;
	return result;
}


GFile* rygel_media_art_store_get_media_art_file (RygelMediaArtStore* self, const gchar* type, RygelMusicItem* item, gboolean simple) {
	GFile* result = NULL;
	GFile* file = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	RygelMusicItem* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GFile* _tmp12_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_tmp1_ = type;
	if (g_strcmp0 (_tmp1_, "album") == 0) {
		RygelMusicItem* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp2_ = item;
		_tmp3_ = rygel_audio_item_get_album ((RygelAudioItem*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		RygelMusicItem* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		_tmp5_ = item;
		_tmp6_ = rygel_media_object_get_title ((RygelMediaObject*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp0_ = _tmp7_;
	}
	_tmp8_ = item;
	_tmp9_ = rygel_media_object_get_artist ((RygelMediaObject*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = type;
	media_art_get_file (_tmp10_, _tmp0_, _tmp11_, NULL, &_tmp12_, NULL);
	_g_object_unref0 (file);
	file = _tmp12_;
	result = file;
	return result;
}


void rygel_media_art_store_add (RygelMediaArtStore* self, RygelMusicItem* item, GFile* file, guint8* data, int data_length1) {
	MediaArtProcess* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = self->priv->media_art_process;
	if (_tmp0_ == NULL) {
		return;
	}
	{
		MediaArtProcess* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		guint8* _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		RygelMusicItem* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		RygelMusicItem* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		RygelMusicItem* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		_tmp1_ = self->priv->media_art_process;
		_tmp2_ = file;
		_tmp3_ = data;
		_tmp3__length1 = data_length1;
		_tmp4_ = item;
		_tmp5_ = rygel_media_item_get_mime_type ((RygelMediaItem*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = item;
		_tmp8_ = rygel_media_object_get_artist ((RygelMediaObject*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = item;
		_tmp11_ = rygel_audio_item_get_album ((RygelAudioItem*) _tmp10_);
		_tmp12_ = _tmp11_;
		media_art_process_buffer (_tmp1_, MEDIA_ART_ALBUM, MEDIA_ART_PROCESS_FLAGS_NONE, _tmp2_, _tmp3_, (gsize) _tmp3__length1, _tmp6_, _tmp9_, _tmp12_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = _error_;
		_tmp14_ = _tmp13_->message;
		g_warning ("rygel-media-art-store.vala:119: %s", _tmp14_);
		_g_error_free0 (_error_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static RygelMediaArtStore* rygel_media_art_store_construct (GType object_type, GError** error) {
	RygelMediaArtStore * self = NULL;
	gchar* dir = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GFile* file = NULL;
	const gchar* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelMediaArtStore*) g_object_new (object_type, NULL);
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "media-art", NULL);
	dir = _tmp1_;
	_tmp2_ = dir;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	file = _tmp3_;
	_tmp4_ = file;
	_tmp5_ = g_file_query_exists (_tmp4_, NULL);
	if (!_tmp5_) {
		const gchar* _tmp6_ = NULL;
		_tmp6_ = dir;
		g_mkdir_with_parents (_tmp6_, 0750);
	}
	_tmp7_ = dir;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (self->priv->directory);
	self->priv->directory = _tmp8_;
	{
		MediaArtProcess* _tmp9_ = NULL;
		MediaArtProcess* _tmp10_ = NULL;
		MediaArtProcess* _tmp11_ = NULL;
		_tmp10_ = media_art_process_new (&_inner_error_);
		_tmp9_ = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp11_ = _tmp9_;
		_tmp9_ = NULL;
		_g_object_unref0 (self->priv->media_art_process);
		self->priv->media_art_process = _tmp11_;
		_g_object_unref0 (_tmp9_);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_object_unref0 (self->priv->media_art_process);
		self->priv->media_art_process = NULL;
		_tmp12_ = _error_;
		_tmp13_ = _tmp12_->message;
		_tmp14_ = g_error_new (MEDIA_ART_STORE_ERROR, MEDIA_ART_STORE_ERROR_NO_MEDIA_ART, "%s", _tmp13_);
		_inner_error_ = _tmp14_;
		_g_error_free0 (_error_);
		goto __finally2;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == MEDIA_ART_STORE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (file);
			_g_free0 (dir);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (file);
			_g_free0 (dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_object_unref0 (file);
	_g_free0 (dir);
	return self;
}


static RygelMediaArtStore* rygel_media_art_store_new (GError** error) {
	return rygel_media_art_store_construct (RYGEL_TYPE_MEDIA_ART_STORE, error);
}


static void rygel_media_art_store_class_init (RygelMediaArtStoreClass * klass) {
	rygel_media_art_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaArtStorePrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_art_store_finalize;
}


static void rygel_media_art_store_instance_init (RygelMediaArtStore * self) {
	self->priv = RYGEL_MEDIA_ART_STORE_GET_PRIVATE (self);
}


static void rygel_media_art_store_finalize (GObject* obj) {
	RygelMediaArtStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStore);
	_g_free0 (self->priv->directory);
	_g_object_unref0 (self->priv->media_art_process);
	G_OBJECT_CLASS (rygel_media_art_store_parent_class)->finalize (obj);
}


/**
 * This maps RygelMusicItem objects to their cached cover art,
 * implementing the GNOME
 * [[https://live.gnome.org/MediaArtStorageSpec|MediaArt storage specification]].
 */
GType rygel_media_art_store_get_type (void) {
	static volatile gsize rygel_media_art_store_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_art_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaArtStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_art_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaArtStore), 0, (GInstanceInitFunc) rygel_media_art_store_instance_init, NULL };
		GType rygel_media_art_store_type_id;
		rygel_media_art_store_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaArtStore", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_art_store_type_id__volatile, rygel_media_art_store_type_id);
	}
	return rygel_media_art_store_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



