/* rygel-av-transport.c generated by valac 0.24.0.74-2894, the Vala compiler
 * generated from rygel-av-transport.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009,2010 Nokia Corporation.
 * Copyright (C) 2012 Openismus GmbH.
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Neha Shanbhag <N.Shanbhag@cablelabs.com>
 *         Sivakumar Mani <siva@orexel.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <rygel-core.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_AV_TRANSPORT (rygel_av_transport_get_type ())
#define RYGEL_AV_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport))
#define RYGEL_AV_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportClass))
#define RYGEL_IS_AV_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AV_TRANSPORT))
#define RYGEL_IS_AV_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AV_TRANSPORT))
#define RYGEL_AV_TRANSPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportClass))

typedef struct _RygelAVTransport RygelAVTransport;
typedef struct _RygelAVTransportClass RygelAVTransportClass;
typedef struct _RygelAVTransportPrivate RygelAVTransportPrivate;

#define RYGEL_TYPE_CHANGE_LOG (rygel_change_log_get_type ())
#define RYGEL_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLog))
#define RYGEL_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))
#define RYGEL_IS_CHANGE_LOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_IS_CHANGE_LOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CHANGE_LOG))
#define RYGEL_CHANGE_LOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CHANGE_LOG, RygelChangeLogClass))

typedef struct _RygelChangeLog RygelChangeLog;
typedef struct _RygelChangeLogClass RygelChangeLogClass;

#define RYGEL_TYPE_MEDIA_PLAYER (rygel_media_player_get_type ())
#define RYGEL_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayer))
#define RYGEL_IS_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_PLAYER))
#define RYGEL_MEDIA_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayerIface))

typedef struct _RygelMediaPlayer RygelMediaPlayer;
typedef struct _RygelMediaPlayerIface RygelMediaPlayerIface;

#define RYGEL_TYPE_PLAYER_CONTROLLER (rygel_player_controller_get_type ())
#define RYGEL_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerController))
#define RYGEL_PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerControllerClass))
#define RYGEL_IS_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAYER_CONTROLLER))
#define RYGEL_IS_PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAYER_CONTROLLER))
#define RYGEL_PLAYER_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerControllerClass))

typedef struct _RygelPlayerController RygelPlayerController;
typedef struct _RygelPlayerControllerClass RygelPlayerControllerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_MEDIA_RENDERER_PLUGIN (rygel_media_renderer_plugin_get_type ())
#define RYGEL_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPlugin))
#define RYGEL_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_MEDIA_RENDERER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))

typedef struct _RygelMediaRendererPlugin RygelMediaRendererPlugin;
typedef struct _RygelMediaRendererPluginClass RygelMediaRendererPluginClass;
#define __vala_SoupURI_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupURI_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_GUPnPServiceAction_free0(var) ((var == NULL) ? NULL : (var = (_vala_GUPnPServiceAction_free (var), NULL)))
typedef struct _Block2Data Block2Data;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _RygelAvTransportHandlePlaylistData RygelAvTransportHandlePlaylistData;
typedef struct _Block3Data Block3Data;

struct _RygelAVTransport {
	GUPnPService parent_instance;
	RygelAVTransportPrivate * priv;
};

struct _RygelAVTransportClass {
	GUPnPServiceClass parent_class;
};

struct _RygelMediaPlayerIface {
	GTypeInterface parent_iface;
	gboolean (*seek) (RygelMediaPlayer* self, gint64 time);
	gboolean (*seek_bytes) (RygelMediaPlayer* self, gint64 bytes);
	gchar** (*get_protocols) (RygelMediaPlayer* self, int* result_length1);
	gchar** (*get_mime_types) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_state) (RygelMediaPlayer* self);
	void (*set_playback_state) (RygelMediaPlayer* self, const gchar* value);
	gchar** (*get_allowed_playback_speeds) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_speed) (RygelMediaPlayer* self);
	void (*set_playback_speed) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_uri) (RygelMediaPlayer* self);
	void (*set_uri) (RygelMediaPlayer* self, const gchar* value);
	gdouble (*get_volume) (RygelMediaPlayer* self);
	void (*set_volume) (RygelMediaPlayer* self, gdouble value);
	gint64 (*get_duration) (RygelMediaPlayer* self);
	gint64 (*get_size) (RygelMediaPlayer* self);
	gchar* (*get_metadata) (RygelMediaPlayer* self);
	void (*set_metadata) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_mime_type) (RygelMediaPlayer* self);
	void (*set_mime_type) (RygelMediaPlayer* self, const gchar* value);
	gboolean (*get_can_seek) (RygelMediaPlayer* self);
	gboolean (*get_can_seek_bytes) (RygelMediaPlayer* self);
	gchar* (*get_content_features) (RygelMediaPlayer* self);
	void (*set_content_features) (RygelMediaPlayer* self, const gchar* value);
	gint64 (*get_position) (RygelMediaPlayer* self);
	gint64 (*get_byte_position) (RygelMediaPlayer* self);
};

struct _RygelAVTransportPrivate {
	SoupSession* session;
	gchar* protocol_info;
	gchar* _status;
	gchar* _mode;
	RygelChangeLog* changelog;
	RygelMediaPlayer* player;
	RygelPlayerController* controller;
};

struct _Block2Data {
	int _ref_count_;
	RygelAVTransport* self;
	gpointer _async_data_;
};

struct _RygelAvTransportHandlePlaylistData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelAVTransport* self;
	GUPnPServiceAction* action;
	gchar* uri;
	gchar* metadata;
	gchar* mime;
	gchar* features;
	Block2Data* _data2_;
	SoupMessage* message;
	const gchar* _tmp0_;
	SoupMessage* _tmp1_;
	SoupSession* _tmp2_;
	SoupMessage* _tmp3_;
	SoupMessage* _tmp4_;
	SoupMessage* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	GUPnPServiceAction* _tmp8_;
	const gchar* _tmp9_;
	const gchar* xml_string;
	SoupMessage* _tmp10_;
	SoupMessageBody* _tmp11_;
	guint8* _tmp12_;
	gint _tmp12__length1;
	GUPnPMediaCollection* collection;
	const gchar* _tmp13_;
	GUPnPMediaCollection* _tmp14_;
	GUPnPMediaCollection* _tmp15_;
	GList* _tmp16_;
	GList* _tmp17_;
	guint _tmp18_;
	gboolean _tmp19_;
	GUPnPServiceAction* _tmp20_;
	const gchar* _tmp21_;
	GUPnPServiceAction* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	GQuark _tmp26_;
	RygelPlayerController* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	GUPnPMediaCollection* _tmp30_;
	RygelPlayerController* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	GUPnPMediaCollection* _tmp34_;
	GUPnPServiceAction* _tmp35_;
};

struct _Block3Data {
	int _ref_count_;
	RygelAVTransport* self;
	GUPnPServiceAction* action;
	gchar* uri;
	gchar* metadata;
};


static gpointer rygel_av_transport_parent_class = NULL;

GType rygel_av_transport_get_type (void) G_GNUC_CONST;
GType rygel_change_log_get_type (void) G_GNUC_CONST;
GType rygel_media_player_get_type (void) G_GNUC_CONST;
GType rygel_player_controller_get_type (void) G_GNUC_CONST;
#define RYGEL_AV_TRANSPORT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportPrivate))
enum  {
	RYGEL_AV_TRANSPORT_DUMMY_PROPERTY,
	RYGEL_AV_TRANSPORT_STATUS,
	RYGEL_AV_TRANSPORT_PLAYBACK_MEDIUM,
	RYGEL_AV_TRANSPORT_SPEED,
	RYGEL_AV_TRANSPORT_MODE
};
#define RYGEL_AV_TRANSPORT_UPNP_ID "urn:upnp-org:serviceId:AVTransport"
#define RYGEL_AV_TRANSPORT_UPNP_TYPE "urn:schemas-upnp-org:service:AVTransport:2"
#define RYGEL_AV_TRANSPORT_UPNP_TYPE_V1 "urn:schemas-upnp-org:service:AVTransport:1"
#define RYGEL_AV_TRANSPORT_DESCRIPTION_PATH "xml/AVTransport2.xml"
#define RYGEL_AV_TRANSPORT_LAST_CHANGE_NS "urn:schemas-upnp-org:metadata-1-0/AVT/"
static void rygel_av_transport_real_constructed (GObject* base);
GType rygel_media_renderer_plugin_get_type (void) G_GNUC_CONST;
RygelChangeLog* rygel_change_log_new (GUPnPService* service, const gchar* service_ns);
RygelChangeLog* rygel_change_log_construct (GType object_type, GUPnPService* service, const gchar* service_ns);
static RygelMediaPlayer* rygel_av_transport_get_player (RygelAVTransport* self);
RygelPlayerController* rygel_media_renderer_plugin_get_controller (RygelMediaRendererPlugin* self);
static void rygel_av_transport_query_last_change_cb (RygelAVTransport* self, GUPnPService* service, const gchar* variable, GValue* value);
static void _rygel_av_transport_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_av_transport_set_av_transport_uri_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_set_next_av_transport_uri_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_set_next_av_transport_uri_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_media_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_media_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_media_info_ex_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_media_info_ex_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_transport_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_transport_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_position_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_position_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_device_capabilities_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_transport_settings_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_transport_settings_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_get_transport_actions_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_get_transport_actions_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_stop_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_stop_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_play_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_play_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_pause_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_pause_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_seek_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_seek_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_next_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_next_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_previous_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_previous_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_x_dlna_get_byte_position_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action);
static void _rygel_av_transport_x_dlna_get_byte_position_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_av_transport_notify_state_cb (RygelAVTransport* self, GObject* controller, GParamSpec* p);
static void _rygel_av_transport_notify_state_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_n_tracks_cb (RygelAVTransport* self, GObject* controller, GParamSpec* p);
static void _rygel_av_transport_notify_n_tracks_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_track_cb (RygelAVTransport* self, GObject* controller, GParamSpec* p);
static void _rygel_av_transport_notify_track_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_uri_cb (RygelAVTransport* self, GObject* controller, GParamSpec* p);
static void _rygel_av_transport_notify_uri_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_meta_data_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_meta_data_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_track_uri_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_track_uri_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_track_meta_data_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_track_meta_data_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_next_uri_cb (RygelAVTransport* self, GObject* controller, GParamSpec* p);
static void _rygel_av_transport_notify_next_uri_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_next_meta_data_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_next_meta_data_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_av_transport_notify_duration_cb (RygelAVTransport* self, GObject* player, GParamSpec* p);
static void _rygel_av_transport_notify_duration_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _vala_SoupURI_free (SoupURI* self);
gchar* rygel_media_renderer_plugin_get_protocol_info (RygelMediaRendererPlugin* self);
RygelMediaPlayer* rygel_media_renderer_plugin_get_player (RygelMediaRendererPlugin* self);
void rygel_change_log_log (RygelChangeLog* self, const gchar* variable, const gchar* value);
const gchar* rygel_player_controller_get_playback_state (RygelPlayerController* self);
gchar* rygel_player_controller_get_current_transport_actions (RygelPlayerController* self);
const gchar* rygel_av_transport_get_status (RygelAVTransport* self);
const gchar* rygel_av_transport_get_playback_medium (RygelAVTransport* self);
const gchar* rygel_av_transport_get_mode (RygelAVTransport* self);
gchar* rygel_media_player_get_playback_speed (RygelMediaPlayer* self);
guint rygel_player_controller_get_n_tracks (RygelPlayerController* self);
guint rygel_player_controller_get_track (RygelPlayerController* self);
gchar* rygel_media_player_get_duration_as_str (RygelMediaPlayer* self);
const gchar* rygel_player_controller_get_uri (RygelPlayerController* self);
const gchar* rygel_player_controller_get_metadata (RygelPlayerController* self);
gchar* rygel_player_controller_get_track_uri (RygelPlayerController* self);
gchar* rygel_player_controller_get_track_metadata (RygelPlayerController* self);
const gchar* rygel_player_controller_get_next_uri (RygelPlayerController* self);
const gchar* rygel_player_controller_get_next_metadata (RygelPlayerController* self);
gchar* rygel_change_log_finish (RygelChangeLog* self);
static gboolean rygel_av_transport_check_instance_id (RygelAVTransport* self, GUPnPServiceAction* action);
static void rygel_av_transport_handle_new_transport_uri (RygelAVTransport* self, GUPnPServiceAction* action, const gchar* uri, const gchar* metadata);
static gboolean rygel_av_transport_is_valid_mime_type (RygelAVTransport* self, const gchar* mime);
gchar** rygel_media_player_get_mime_types (RygelMediaPlayer* self, int* result_length1);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
gchar* rygel_media_player_get_position_as_str (RygelMediaPlayer* self);
void rygel_player_controller_set_playback_state (RygelPlayerController* self, const gchar* value);
gchar** rygel_media_player_get_allowed_playback_speeds (RygelMediaPlayer* self, int* result_length1);
void rygel_media_player_set_playback_speed (RygelMediaPlayer* self, const gchar* value);
gint64 rygel_time_utils_time_from_string (const gchar* str);
gboolean rygel_media_player_get_can_seek (RygelMediaPlayer* self);
gboolean rygel_media_player_seek (RygelMediaPlayer* self, gint64 time);
gint64 rygel_media_player_get_byte_position (RygelMediaPlayer* self);
gboolean rygel_media_player_get_can_seek_bytes (RygelMediaPlayer* self);
gboolean rygel_media_player_seek_bytes (RygelMediaPlayer* self, gint64 bytes);
void rygel_player_controller_set_track (RygelPlayerController* self, guint value);
gboolean rygel_player_controller_next (RygelPlayerController* self);
gboolean rygel_player_controller_previous (RygelPlayerController* self);
gint64 rygel_media_player_get_size (RygelMediaPlayer* self);
static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self);
static void rygel_av_transport_handle_playlist_data_free (gpointer _data);
static GUPnPServiceAction* _vala_GUPnPServiceAction_copy (GUPnPServiceAction* self);
static void rygel_av_transport_handle_playlist (RygelAVTransport* self, GUPnPServiceAction* action, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_av_transport_handle_playlist_finish (RygelAVTransport* self, GAsyncResult* _res_);
static gboolean rygel_av_transport_handle_playlist_co (RygelAvTransportHandlePlaylistData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda8_ (Block2Data* _data2_);
static void ___lambda8__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void rygel_player_controller_set_playlist_uri (RygelPlayerController* self, const gchar* uri, const gchar* metadata, GUPnPMediaCollection* collection);
void rygel_player_controller_set_next_playlist_uri (RygelPlayerController* self, const gchar* uri, const gchar* metadata, GUPnPMediaCollection* collection);
static gboolean rygel_av_transport_is_playlist (RygelAVTransport* self, const gchar* mime, const gchar* features);
static void rygel_av_transport_check_resource (RygelAVTransport* self, SoupMessage* msg, const gchar* _uri, const gchar* _metadata, GUPnPServiceAction* action);
static void ___lambda7_ (RygelAVTransport* self, SoupMessage* msg);
static void ____lambda7__soup_message_got_headers (SoupMessage* _sender, gpointer self);
static void rygel_av_transport_set_single_play_uri (RygelAVTransport* self, GUPnPServiceAction* action, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ___lambda6_ (Block3Data* _data3_, SoupMessage* msg);
static void ____lambda6__soup_message_finished (SoupMessage* _sender, gpointer self);
void rygel_player_controller_set_single_play_uri (RygelPlayerController* self, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features);
void rygel_player_controller_set_next_single_play_uri (RygelPlayerController* self, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features);
RygelAVTransport* rygel_av_transport_new (void);
RygelAVTransport* rygel_av_transport_construct (GType object_type);
void rygel_av_transport_set_status (RygelAVTransport* self, const gchar* value);
gchar* rygel_av_transport_get_speed (RygelAVTransport* self);
void rygel_av_transport_set_speed (RygelAVTransport* self, const gchar* value);
void rygel_av_transport_set_mode (RygelAVTransport* self, const gchar* value);
static void rygel_av_transport_finalize (GObject* obj);
static void _vala_rygel_av_transport_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_av_transport_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _rygel_av_transport_query_last_change_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
	rygel_av_transport_query_last_change_cb ((RygelAVTransport*) self, _sender, variable, value);
}


static void _rygel_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_set_av_transport_uri_cb ((RygelAVTransport*) self, _sender, action);
}


static void _rygel_av_transport_set_next_av_transport_uri_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_set_next_av_transport_uri_cb ((RygelAVTransport*) self, _sender, action);
}


static void _rygel_av_transport_get_media_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_get_media_info_cb ((RygelAVTransport*) self, _sender, action);
}


static void _rygel_av_transport_get_media_info_ex_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_get_media_info_ex_cb ((RygelAVTransport*) self, _sender, action);
}


static void _rygel_av_transport_get_transport_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_get_transport_info_cb ((RygelAVTransport*) self, _sender, action);
}


static void _rygel_av_transport_get_position_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_get_position_info_cb ((RygelAVTransport*) self, _sender, action);
}


static void _rygel_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_get_device_capabilities_cb ((RygelAVTransport*) self, _sender, action);
}


static void _rygel_av_transport_get_transport_settings_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_get_transport_settings_cb ((RygelAVTransport*) self, _sender, action);
}


static void _rygel_av_transport_get_transport_actions_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_get_transport_actions_cb ((RygelAVTransport*) self, _sender, action);
}


static void _rygel_av_transport_stop_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_stop_cb ((RygelAVTransport*) self, _sender, action);
}


static void _rygel_av_transport_play_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_play_cb ((RygelAVTransport*) self, _sender, action);
}


static void _rygel_av_transport_pause_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_pause_cb ((RygelAVTransport*) self, _sender, action);
}


static void _rygel_av_transport_seek_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_seek_cb ((RygelAVTransport*) self, _sender, action);
}


static void _rygel_av_transport_next_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_next_cb ((RygelAVTransport*) self, _sender, action);
}


static void _rygel_av_transport_previous_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_previous_cb ((RygelAVTransport*) self, _sender, action);
}


static void _rygel_av_transport_x_dlna_get_byte_position_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
	rygel_av_transport_x_dlna_get_byte_position_info_cb ((RygelAVTransport*) self, _sender, action);
}


static void _rygel_av_transport_notify_state_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_av_transport_notify_state_cb ((RygelAVTransport*) self, _sender, pspec);
}


static void _rygel_av_transport_notify_n_tracks_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_av_transport_notify_n_tracks_cb ((RygelAVTransport*) self, _sender, pspec);
}


static void _rygel_av_transport_notify_track_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_av_transport_notify_track_cb ((RygelAVTransport*) self, _sender, pspec);
}


static void _rygel_av_transport_notify_uri_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_av_transport_notify_uri_cb ((RygelAVTransport*) self, _sender, pspec);
}


static void _rygel_av_transport_notify_meta_data_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_av_transport_notify_meta_data_cb ((RygelAVTransport*) self, _sender, pspec);
}


static void _rygel_av_transport_notify_track_uri_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_av_transport_notify_track_uri_cb ((RygelAVTransport*) self, _sender, pspec);
}


static void _rygel_av_transport_notify_track_meta_data_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_av_transport_notify_track_meta_data_cb ((RygelAVTransport*) self, _sender, pspec);
}


static void _rygel_av_transport_notify_next_uri_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_av_transport_notify_next_uri_cb ((RygelAVTransport*) self, _sender, pspec);
}


static void _rygel_av_transport_notify_next_meta_data_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_av_transport_notify_next_meta_data_cb ((RygelAVTransport*) self, _sender, pspec);
}


static void _rygel_av_transport_notify_duration_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	rygel_av_transport_notify_duration_cb ((RygelAVTransport*) self, _sender, pspec);
}


static void _vala_SoupURI_free (SoupURI* self) {
	g_boxed_free (soup_uri_get_type (), self);
}


static void rygel_av_transport_real_constructed (GObject* base) {
	RygelAVTransport * self;
	RygelMediaRendererPlugin* plugin = NULL;
	GUPnPRootDevice* _tmp0_ = NULL;
	GUPnPRootDevice* _tmp1_ = NULL;
	GUPnPRootDevice* _tmp2_ = NULL;
	GUPnPResourceFactory* _tmp3_ = NULL;
	GUPnPResourceFactory* _tmp4_ = NULL;
	RygelMediaRendererPlugin* _tmp5_ = NULL;
	RygelMediaRendererPlugin* _tmp6_ = NULL;
	RygelChangeLog* _tmp7_ = NULL;
	RygelMediaPlayer* _tmp8_ = NULL;
	RygelMediaRendererPlugin* _tmp9_ = NULL;
	RygelPlayerController* _tmp10_ = NULL;
	RygelPlayerController* _tmp11_ = NULL;
	RygelPlayerController* _tmp12_ = NULL;
	RygelPlayerController* _tmp13_ = NULL;
	RygelPlayerController* _tmp14_ = NULL;
	RygelPlayerController* _tmp15_ = NULL;
	RygelPlayerController* _tmp16_ = NULL;
	RygelPlayerController* _tmp17_ = NULL;
	RygelPlayerController* _tmp18_ = NULL;
	RygelPlayerController* _tmp19_ = NULL;
	RygelMediaPlayer* _tmp20_ = NULL;
	gchar* proxy = NULL;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	RygelMediaRendererPlugin* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	self = (RygelAVTransport*) base;
	G_OBJECT_CLASS (rygel_av_transport_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gupnp_service_get_type (), GUPnPService));
	g_object_get ((GUPnPService*) self, "root-device", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_MEDIA_RENDERER_PLUGIN) ? ((RygelMediaRendererPlugin*) _tmp4_) : NULL);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp2_);
	plugin = _tmp6_;
	_tmp7_ = rygel_change_log_new ((GUPnPService*) self, RYGEL_AV_TRANSPORT_LAST_CHANGE_NS);
	_g_object_unref0 (self->priv->changelog);
	self->priv->changelog = _tmp7_;
	_tmp8_ = rygel_av_transport_get_player (self);
	_g_object_unref0 (self->priv->player);
	self->priv->player = _tmp8_;
	_tmp9_ = plugin;
	_tmp10_ = rygel_media_renderer_plugin_get_controller (_tmp9_);
	_g_object_unref0 (self->priv->controller);
	self->priv->controller = _tmp10_;
	g_signal_connect_object ((GUPnPService*) self, "query-variable::LastChange", (GCallback) _rygel_av_transport_query_last_change_cb_gupnp_service_query_variable, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SetAVTransportURI", (GCallback) _rygel_av_transport_set_av_transport_uri_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::SetNextAVTransportURI", (GCallback) _rygel_av_transport_set_next_av_transport_uri_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetMediaInfo", (GCallback) _rygel_av_transport_get_media_info_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetMediaInfo_Ext", (GCallback) _rygel_av_transport_get_media_info_ex_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTransportInfo", (GCallback) _rygel_av_transport_get_transport_info_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetPositionInfo", (GCallback) _rygel_av_transport_get_position_info_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetDeviceCapabilities", (GCallback) _rygel_av_transport_get_device_capabilities_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTransportSettings", (GCallback) _rygel_av_transport_get_transport_settings_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetCurrentTransportActions", (GCallback) _rygel_av_transport_get_transport_actions_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Stop", (GCallback) _rygel_av_transport_stop_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Play", (GCallback) _rygel_av_transport_play_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Pause", (GCallback) _rygel_av_transport_pause_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Seek", (GCallback) _rygel_av_transport_seek_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Next", (GCallback) _rygel_av_transport_next_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Previous", (GCallback) _rygel_av_transport_previous_cb_gupnp_service_action_invoked, self, 0);
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::X_DLNA_GetBytePositionInfo", (GCallback) _rygel_av_transport_x_dlna_get_byte_position_info_cb_gupnp_service_action_invoked, self, 0);
	_tmp11_ = self->priv->controller;
	g_signal_connect_object ((GObject*) _tmp11_, "notify::playback-state", (GCallback) _rygel_av_transport_notify_state_cb_g_object_notify, self, 0);
	_tmp12_ = self->priv->controller;
	g_signal_connect_object ((GObject*) _tmp12_, "notify::n-tracks", (GCallback) _rygel_av_transport_notify_n_tracks_cb_g_object_notify, self, 0);
	_tmp13_ = self->priv->controller;
	g_signal_connect_object ((GObject*) _tmp13_, "notify::track", (GCallback) _rygel_av_transport_notify_track_cb_g_object_notify, self, 0);
	_tmp14_ = self->priv->controller;
	g_signal_connect_object ((GObject*) _tmp14_, "notify::uri", (GCallback) _rygel_av_transport_notify_uri_cb_g_object_notify, self, 0);
	_tmp15_ = self->priv->controller;
	g_signal_connect_object ((GObject*) _tmp15_, "notify::metadata", (GCallback) _rygel_av_transport_notify_meta_data_cb_g_object_notify, self, 0);
	_tmp16_ = self->priv->controller;
	g_signal_connect_object ((GObject*) _tmp16_, "notify::track-uri", (GCallback) _rygel_av_transport_notify_track_uri_cb_g_object_notify, self, 0);
	_tmp17_ = self->priv->controller;
	g_signal_connect_object ((GObject*) _tmp17_, "notify::track-metadata", (GCallback) _rygel_av_transport_notify_track_meta_data_cb_g_object_notify, self, 0);
	_tmp18_ = self->priv->controller;
	g_signal_connect_object ((GObject*) _tmp18_, "notify::next-uri", (GCallback) _rygel_av_transport_notify_next_uri_cb_g_object_notify, self, 0);
	_tmp19_ = self->priv->controller;
	g_signal_connect_object ((GObject*) _tmp19_, "notify::next-metadata", (GCallback) _rygel_av_transport_notify_next_meta_data_cb_g_object_notify, self, 0);
	_tmp20_ = self->priv->player;
	g_signal_connect_object ((GObject*) _tmp20_, "notify::duration", (GCallback) _rygel_av_transport_notify_duration_cb_g_object_notify, self, 0);
	_tmp21_ = g_getenv ("http_proxy");
	_tmp22_ = g_strdup (_tmp21_);
	proxy = _tmp22_;
	_tmp23_ = proxy;
	if (_tmp23_ != NULL) {
		gboolean _tmp24_ = FALSE;
		const gchar* _tmp25_ = NULL;
		gboolean _tmp26_ = FALSE;
		const gchar* _tmp31_ = NULL;
		SoupURI* _tmp32_ = NULL;
		SoupURI* _tmp33_ = NULL;
		SoupSession* _tmp34_ = NULL;
		_tmp25_ = proxy;
		_tmp26_ = g_str_has_prefix (_tmp25_, "http://");
		if (!_tmp26_) {
			const gchar* _tmp27_ = NULL;
			gboolean _tmp28_ = FALSE;
			_tmp27_ = proxy;
			_tmp28_ = g_str_has_prefix (_tmp27_, "https://");
			_tmp24_ = !_tmp28_;
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			const gchar* _tmp29_ = NULL;
			gchar* _tmp30_ = NULL;
			_tmp29_ = proxy;
			_tmp30_ = g_strconcat ("http://", _tmp29_, NULL);
			_g_free0 (proxy);
			proxy = _tmp30_;
		}
		_tmp31_ = proxy;
		_tmp32_ = soup_uri_new (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = soup_session_new_with_options (SOUP_SESSION_PROXY_URI, _tmp33_, NULL);
		_g_object_unref0 (self->priv->session);
		self->priv->session = _tmp34_;
		__vala_SoupURI_free0 (_tmp33_);
	} else {
		SoupSession* _tmp35_ = NULL;
		_tmp35_ = soup_session_new ();
		_g_object_unref0 (self->priv->session);
		self->priv->session = _tmp35_;
	}
	_tmp36_ = plugin;
	_tmp37_ = rygel_media_renderer_plugin_get_protocol_info (_tmp36_);
	_g_free0 (self->priv->protocol_info);
	self->priv->protocol_info = _tmp37_;
	_g_free0 (proxy);
	_g_object_unref0 (plugin);
}


static RygelMediaPlayer* rygel_av_transport_get_player (RygelAVTransport* self) {
	RygelMediaPlayer* result = NULL;
	RygelMediaRendererPlugin* plugin = NULL;
	GUPnPRootDevice* _tmp0_ = NULL;
	GUPnPRootDevice* _tmp1_ = NULL;
	GUPnPRootDevice* _tmp2_ = NULL;
	GUPnPResourceFactory* _tmp3_ = NULL;
	GUPnPResourceFactory* _tmp4_ = NULL;
	RygelMediaRendererPlugin* _tmp5_ = NULL;
	RygelMediaRendererPlugin* _tmp6_ = NULL;
	RygelMediaPlayer* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_object_get ((GUPnPService*) self, "root-device", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_MEDIA_RENDERER_PLUGIN) ? ((RygelMediaRendererPlugin*) _tmp4_) : NULL);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp2_);
	plugin = _tmp6_;
	_tmp7_ = rygel_media_renderer_plugin_get_player (plugin);
	result = _tmp7_;
	_g_object_unref0 (plugin);
	return result;
}


static void rygel_av_transport_query_last_change_cb (RygelAVTransport* self, GUPnPService* service, const gchar* variable, GValue* value) {
	RygelChangeLog* log = NULL;
	RygelChangeLog* _tmp0_ = NULL;
	RygelPlayerController* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	RygelPlayerController* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	RygelMediaPlayer* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	RygelPlayerController* _tmp18_ = NULL;
	guint _tmp19_ = 0U;
	guint _tmp20_ = 0U;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	RygelPlayerController* _tmp23_ = NULL;
	guint _tmp24_ = 0U;
	guint _tmp25_ = 0U;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	RygelMediaPlayer* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	RygelMediaPlayer* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	RygelPlayerController* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	RygelPlayerController* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	RygelPlayerController* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
	RygelPlayerController* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
	gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	RygelPlayerController* _tmp54_ = NULL;
	const gchar* _tmp55_ = NULL;
	const gchar* _tmp56_ = NULL;
	RygelPlayerController* _tmp57_ = NULL;
	const gchar* _tmp58_ = NULL;
	const gchar* _tmp59_ = NULL;
	gchar* _tmp60_ = NULL;
	gchar* _tmp61_ = NULL;
	gchar* _tmp62_ = NULL;
	gchar* _tmp63_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (variable != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = rygel_change_log_new (NULL, RYGEL_AV_TRANSPORT_LAST_CHANGE_NS);
	log = _tmp0_;
	_tmp1_ = self->priv->controller;
	_tmp2_ = rygel_player_controller_get_playback_state (_tmp1_);
	_tmp3_ = _tmp2_;
	rygel_change_log_log (log, "TransportState", _tmp3_);
	_tmp4_ = self->priv->controller;
	_tmp5_ = rygel_player_controller_get_current_transport_actions (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	rygel_change_log_log (log, "CurrentTransportActions", _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = rygel_av_transport_get_status (self);
	_tmp9_ = _tmp8_;
	rygel_change_log_log (log, "TransportStatus", _tmp9_);
	_tmp10_ = rygel_av_transport_get_playback_medium (self);
	_tmp11_ = _tmp10_;
	rygel_change_log_log (log, "PlaybackStorageMedium", _tmp11_);
	rygel_change_log_log (log, "RecordStorageMedium", "NOT_IMPLEMENTED");
	rygel_change_log_log (log, "PossiblePlaybackStorageMedia", "None,Network");
	rygel_change_log_log (log, "PossibleRecordStorageMedia", "NOT_IMPLEMENTED");
	_tmp12_ = rygel_av_transport_get_mode (self);
	_tmp13_ = _tmp12_;
	rygel_change_log_log (log, "CurrentPlayMode", _tmp13_);
	_tmp14_ = self->priv->player;
	_tmp15_ = rygel_media_player_get_playback_speed (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = _tmp16_;
	rygel_change_log_log (log, "TransportPlaySpeed", _tmp17_);
	_g_free0 (_tmp17_);
	rygel_change_log_log (log, "RecordMediumWriteStatus", "NOT_IMPLEMENTED");
	rygel_change_log_log (log, "CurrentRecordQualityMode", "NOT_IMPLEMENTED");
	rygel_change_log_log (log, "PossibleRecordQualityModes", "NOT_IMPLEMENTED");
	_tmp18_ = self->priv->controller;
	_tmp19_ = rygel_player_controller_get_n_tracks (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strdup_printf ("%u", _tmp20_);
	_tmp22_ = _tmp21_;
	rygel_change_log_log (log, "NumberOfTracks", _tmp22_);
	_g_free0 (_tmp22_);
	_tmp23_ = self->priv->controller;
	_tmp24_ = rygel_player_controller_get_track (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_strdup_printf ("%u", _tmp25_);
	_tmp27_ = _tmp26_;
	rygel_change_log_log (log, "CurrentTrack", _tmp27_);
	_g_free0 (_tmp27_);
	_tmp28_ = self->priv->player;
	_tmp29_ = rygel_media_player_get_duration_as_str (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = _tmp30_;
	rygel_change_log_log (log, "CurrentTrackDuration", _tmp31_);
	_g_free0 (_tmp31_);
	_tmp32_ = self->priv->player;
	_tmp33_ = rygel_media_player_get_duration_as_str (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = _tmp34_;
	rygel_change_log_log (log, "CurrentMediaDuration", _tmp35_);
	_g_free0 (_tmp35_);
	_tmp36_ = self->priv->controller;
	_tmp37_ = rygel_player_controller_get_uri (_tmp36_);
	_tmp38_ = _tmp37_;
	rygel_change_log_log (log, "AVTransportURI", _tmp38_);
	_tmp39_ = self->priv->controller;
	_tmp40_ = rygel_player_controller_get_metadata (_tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = g_markup_escape_text (_tmp41_, (gssize) (-1));
	_tmp43_ = _tmp42_;
	rygel_change_log_log (log, "AVTransportURIMetaData", _tmp43_);
	_g_free0 (_tmp43_);
	_tmp44_ = self->priv->controller;
	_tmp45_ = rygel_player_controller_get_track_uri (_tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = _tmp46_;
	rygel_change_log_log (log, "CurrentTrackURI", _tmp47_);
	_g_free0 (_tmp47_);
	_tmp48_ = self->priv->controller;
	_tmp49_ = rygel_player_controller_get_track_metadata (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = _tmp50_;
	_tmp52_ = g_markup_escape_text (_tmp51_, (gssize) (-1));
	_tmp53_ = _tmp52_;
	rygel_change_log_log (log, "CurrentTrackMetaData", _tmp53_);
	_g_free0 (_tmp53_);
	_g_free0 (_tmp51_);
	_tmp54_ = self->priv->controller;
	_tmp55_ = rygel_player_controller_get_next_uri (_tmp54_);
	_tmp56_ = _tmp55_;
	rygel_change_log_log (log, "NextAVTransportURI", _tmp56_);
	_tmp57_ = self->priv->controller;
	_tmp58_ = rygel_player_controller_get_next_metadata (_tmp57_);
	_tmp59_ = _tmp58_;
	_tmp60_ = g_markup_escape_text (_tmp59_, (gssize) (-1));
	_tmp61_ = _tmp60_;
	rygel_change_log_log (log, "NextAVTransportURIMetaData", _tmp61_);
	_g_free0 (_tmp61_);
	g_value_init (value, G_TYPE_STRING);
	_tmp62_ = rygel_change_log_finish (log);
	_tmp63_ = _tmp62_;
	g_value_set_string (value, _tmp63_);
	_g_free0 (_tmp63_);
	_g_object_unref0 (log);
}


static gboolean int64_try_parse (const gchar* str, gint64* _result_) {
	gint64 _vala_result = 0LL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	_tmp2_ = g_ascii_strtoll (_tmp0_, &_tmp1_, (guint) 0);
	endptr = _tmp1_;
	_vala_result = _tmp2_;
	_tmp3_ = endptr;
	_tmp4_ = str;
	_tmp5_ = str;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp3_ == (((gchar*) _tmp4_) + _tmp7_)) {
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	} else {
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
}


static gboolean rygel_av_transport_check_instance_id (RygelAVTransport* self, GUPnPServiceAction* action) {
	gboolean result = FALSE;
	gchar* instance_id_string = NULL;
	gint64 instance_id = 0LL;
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gint64 _tmp8_ = 0LL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (action != NULL, FALSE);
	instance_id = (gint64) (-1);
	_tmp0_ = action;
	gupnp_service_action_get (_tmp0_, "InstanceID", G_TYPE_STRING, &instance_id_string, NULL);
	_tmp2_ = instance_id_string;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_ = NULL;
		gint64 _tmp4_ = 0LL;
		gboolean _tmp5_ = FALSE;
		_tmp3_ = instance_id_string;
		_tmp5_ = int64_try_parse (_tmp3_, &_tmp4_);
		instance_id = _tmp4_;
		_tmp1_ = !_tmp5_;
	}
	if (_tmp1_) {
		GUPnPServiceAction* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		_tmp6_ = action;
		_tmp7_ = _ ("Invalid argument");
		gupnp_service_action_return_error (_tmp6_, (guint) 402, _tmp7_);
		result = FALSE;
		_g_free0 (instance_id_string);
		return result;
	}
	_tmp8_ = instance_id;
	if (_tmp8_ != ((gint64) 0)) {
		GUPnPServiceAction* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		_tmp9_ = action;
		_tmp10_ = _ ("Invalid InstanceID");
		gupnp_service_action_return_error (_tmp9_, (guint) 718, _tmp10_);
		result = FALSE;
		_g_free0 (instance_id_string);
		return result;
	}
	result = TRUE;
	_g_free0 (instance_id_string);
	return result;
}


static void rygel_av_transport_set_av_transport_uri_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* _uri = NULL;
	gchar* _metadata = NULL;
	GUPnPServiceAction* _tmp2_ = NULL;
	GUPnPServiceAction* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = action;
	gupnp_service_action_get (_tmp2_, "CurrentURI", G_TYPE_STRING, &_uri, "CurrentURIMetaData", G_TYPE_STRING, &_metadata, NULL);
	_tmp3_ = action;
	_tmp4_ = _uri;
	_tmp5_ = _metadata;
	rygel_av_transport_handle_new_transport_uri (self, _tmp3_, _tmp4_, _tmp5_);
	_g_free0 (_metadata);
	_g_free0 (_uri);
}


static void rygel_av_transport_set_next_av_transport_uri_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* _uri = NULL;
	gchar* _metadata = NULL;
	GUPnPServiceAction* _tmp2_ = NULL;
	GUPnPServiceAction* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = action;
	gupnp_service_action_get (_tmp2_, "NextURI", G_TYPE_STRING, &_uri, "NextURIMetaData", G_TYPE_STRING, &_metadata, NULL);
	_tmp3_ = action;
	_tmp4_ = _uri;
	_tmp5_ = _metadata;
	rygel_av_transport_handle_new_transport_uri (self, _tmp3_, _tmp4_, _tmp5_);
	_g_free0 (_metadata);
	_g_free0 (_uri);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static gboolean rygel_av_transport_is_valid_mime_type (RygelAVTransport* self, const gchar* mime) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* normalized = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	RygelMediaPlayer* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gchar** _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gboolean _tmp11_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = mime;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = mime;
	_tmp2_ = g_utf8_strdown (_tmp1_, (gssize) (-1));
	_tmp3_ = _tmp2_;
	_tmp4_ = string_replace (_tmp3_, " ", "");
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	normalized = _tmp5_;
	_tmp6_ = normalized;
	_tmp7_ = self->priv->player;
	_tmp9_ = rygel_media_player_get_mime_types (_tmp7_, &_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp10__length1 = _tmp8_;
	_tmp11_ = _vala_string_array_contains (_tmp10_, _tmp8_, _tmp6_);
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
	result = _tmp11_;
	_g_free0 (normalized);
	return result;
}


static void rygel_av_transport_get_media_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* media_duration = NULL;
	RygelPlayerController* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	GUPnPServiceAction* _tmp9_ = NULL;
	RygelPlayerController* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	guint _tmp12_ = 0U;
	const gchar* _tmp13_ = NULL;
	RygelPlayerController* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	RygelPlayerController* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	GUPnPServiceAction* _tmp22_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->controller;
	_tmp3_ = rygel_player_controller_get_n_tracks (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > ((guint) 1)) {
		gchar* _tmp5_ = NULL;
		_tmp5_ = g_strdup ("0:00:00");
		_g_free0 (media_duration);
		media_duration = _tmp5_;
	} else {
		RygelMediaPlayer* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp6_ = self->priv->player;
		_tmp7_ = rygel_media_player_get_duration_as_str (_tmp6_);
		_tmp8_ = _tmp7_;
		_g_free0 (media_duration);
		media_duration = _tmp8_;
	}
	_tmp9_ = action;
	_tmp10_ = self->priv->controller;
	_tmp11_ = rygel_player_controller_get_n_tracks (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = media_duration;
	_tmp14_ = self->priv->controller;
	_tmp15_ = rygel_player_controller_get_uri (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = self->priv->controller;
	_tmp18_ = rygel_player_controller_get_metadata (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = rygel_av_transport_get_playback_medium (self);
	_tmp21_ = _tmp20_;
	gupnp_service_action_set (_tmp9_, "NrTracks", G_TYPE_UINT, _tmp12_, "MediaDuration", G_TYPE_STRING, _tmp13_, "CurrentURI", G_TYPE_STRING, _tmp16_, "CurrentURIMetaData", G_TYPE_STRING, _tmp19_, "NextURI", G_TYPE_STRING, "NOT_IMPLEMENTED", "NextURIMetaData", G_TYPE_STRING, "NOT_IMPLEMENTED", "PlayMedium", G_TYPE_STRING, _tmp21_, "RecordMedium", G_TYPE_STRING, "NOT_IMPLEMENTED", "WriteStatus", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
	_tmp22_ = action;
	gupnp_service_action_return (_tmp22_);
	_g_free0 (media_duration);
}


static void rygel_av_transport_get_media_info_ex_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* media_duration = NULL;
	RygelPlayerController* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	GUPnPServiceAction* _tmp9_ = NULL;
	RygelPlayerController* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	guint _tmp12_ = 0U;
	const gchar* _tmp13_ = NULL;
	RygelPlayerController* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	RygelPlayerController* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	GUPnPServiceAction* _tmp22_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->controller;
	_tmp3_ = rygel_player_controller_get_n_tracks (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > ((guint) 1)) {
		gchar* _tmp5_ = NULL;
		_tmp5_ = g_strdup ("0:00:00");
		_g_free0 (media_duration);
		media_duration = _tmp5_;
	} else {
		RygelMediaPlayer* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp6_ = self->priv->player;
		_tmp7_ = rygel_media_player_get_duration_as_str (_tmp6_);
		_tmp8_ = _tmp7_;
		_g_free0 (media_duration);
		media_duration = _tmp8_;
	}
	_tmp9_ = action;
	_tmp10_ = self->priv->controller;
	_tmp11_ = rygel_player_controller_get_n_tracks (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = media_duration;
	_tmp14_ = self->priv->controller;
	_tmp15_ = rygel_player_controller_get_uri (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = self->priv->controller;
	_tmp18_ = rygel_player_controller_get_metadata (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = rygel_av_transport_get_playback_medium (self);
	_tmp21_ = _tmp20_;
	gupnp_service_action_set (_tmp9_, "CurrentType", G_TYPE_STRING, "NO_MEDIA", "NrTracks", G_TYPE_UINT, _tmp12_, "MediaDuration", G_TYPE_STRING, _tmp13_, "CurrentURI", G_TYPE_STRING, _tmp16_, "CurrentURIMetaData", G_TYPE_STRING, _tmp19_, "NextURI", G_TYPE_STRING, "NOT_IMPLEMENTED", "NextURIMetaData", G_TYPE_STRING, "NOT_IMPLEMENTED", "PlayMedium", G_TYPE_STRING, _tmp21_, "RecordMedium", G_TYPE_STRING, "NOT_IMPLEMENTED", "WriteStatus", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
	_tmp22_ = action;
	gupnp_service_action_return (_tmp22_);
	_g_free0 (media_duration);
}


static void rygel_av_transport_get_transport_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_ = NULL;
	RygelPlayerController* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	RygelMediaPlayer* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GUPnPServiceAction* _tmp12_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = action;
	_tmp3_ = self->priv->controller;
	_tmp4_ = rygel_player_controller_get_playback_state (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = rygel_av_transport_get_status (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->player;
	_tmp9_ = rygel_media_player_get_playback_speed (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp10_;
	gupnp_service_action_set (_tmp2_, "CurrentTransportState", G_TYPE_STRING, _tmp5_, "CurrentTransportStatus", G_TYPE_STRING, _tmp7_, "CurrentSpeed", G_TYPE_STRING, _tmp11_, NULL);
	_g_free0 (_tmp11_);
	_tmp12_ = action;
	gupnp_service_action_return (_tmp12_);
}


static void rygel_av_transport_get_transport_actions_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_ = NULL;
	RygelPlayerController* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GUPnPServiceAction* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = action;
	_tmp3_ = self->priv->controller;
	_tmp4_ = rygel_player_controller_get_current_transport_actions (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	gupnp_service_action_set (_tmp2_, "Actions", G_TYPE_STRING, _tmp6_, NULL);
	_g_free0 (_tmp6_);
	_tmp7_ = action;
	gupnp_service_action_return (_tmp7_);
}


static void rygel_av_transport_get_position_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_ = NULL;
	RygelPlayerController* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	RygelMediaPlayer* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	RygelPlayerController* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	RygelPlayerController* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	RygelMediaPlayer* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	RygelMediaPlayer* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	GUPnPServiceAction* _tmp28_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = action;
	_tmp3_ = self->priv->controller;
	_tmp4_ = rygel_player_controller_get_track (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->player;
	_tmp7_ = rygel_media_player_get_duration_as_str (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->controller;
	_tmp11_ = rygel_player_controller_get_track_metadata (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp14_ = self->priv->controller;
	_tmp15_ = rygel_player_controller_get_track_uri (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = _tmp16_;
	_tmp18_ = self->priv->player;
	_tmp19_ = rygel_media_player_get_position_as_str (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = _tmp20_;
	_tmp22_ = self->priv->player;
	_tmp23_ = rygel_media_player_get_position_as_str (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = _tmp24_;
	_tmp26_ = G_MAXINT;
	_tmp27_ = G_MAXINT;
	gupnp_service_action_set (_tmp2_, "Track", G_TYPE_UINT, _tmp5_, "TrackDuration", G_TYPE_STRING, _tmp9_, "TrackMetaData", G_TYPE_STRING, _tmp13_, "TrackURI", G_TYPE_STRING, _tmp17_, "RelTime", G_TYPE_STRING, _tmp21_, "AbsTime", G_TYPE_STRING, _tmp25_, "RelCount", G_TYPE_INT, _tmp26_, "AbsCount", G_TYPE_INT, _tmp27_, NULL);
	_g_free0 (_tmp25_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp9_);
	_tmp28_ = action;
	gupnp_service_action_return (_tmp28_);
}


static void rygel_av_transport_get_device_capabilities_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_ = NULL;
	GUPnPServiceAction* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = action;
	gupnp_service_action_set (_tmp2_, "PlayMedia", G_TYPE_STRING, "None,Network", "RecMedia", G_TYPE_STRING, "NOT_IMPLEMENTED", "RecQualityModes", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
	_tmp3_ = action;
	gupnp_service_action_return (_tmp3_);
}


static void rygel_av_transport_get_transport_settings_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GUPnPServiceAction* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GUPnPServiceAction* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = action;
	_tmp3_ = rygel_av_transport_get_mode (self);
	_tmp4_ = _tmp3_;
	gupnp_service_action_set (_tmp2_, "PlayMode", G_TYPE_STRING, _tmp4_, "RecQualityMode", G_TYPE_STRING, "NOT_IMPLEMENTED", NULL);
	_tmp5_ = action;
	gupnp_service_action_return (_tmp5_);
}


static void rygel_av_transport_stop_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	RygelPlayerController* _tmp2_ = NULL;
	GUPnPServiceAction* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->controller;
	rygel_player_controller_set_playback_state (_tmp2_, "STOPPED");
	_tmp3_ = action;
	gupnp_service_action_return (_tmp3_);
}


static void rygel_av_transport_play_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* speed = NULL;
	GUPnPServiceAction* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	RygelMediaPlayer* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gboolean _tmp8_ = FALSE;
	RygelMediaPlayer* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	RygelPlayerController* _tmp13_ = NULL;
	GUPnPServiceAction* _tmp14_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = action;
	gupnp_service_action_get (_tmp2_, "Speed", G_TYPE_STRING, &speed, NULL);
	_tmp3_ = speed;
	_tmp4_ = self->priv->player;
	_tmp5_ = rygel_media_player_get_allowed_playback_speeds (_tmp4_, &_tmp5__length1);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	_tmp8_ = !_vala_string_array_contains (_tmp7_, _tmp6__length1, _tmp3_);
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
	if (_tmp8_) {
		GUPnPServiceAction* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		_tmp9_ = action;
		_tmp10_ = _ ("Play speed not supported");
		gupnp_service_action_return_error (_tmp9_, (guint) 717, _tmp10_);
		_g_free0 (speed);
		return;
	}
	_tmp11_ = self->priv->player;
	_tmp12_ = speed;
	rygel_media_player_set_playback_speed (_tmp11_, _tmp12_);
	_tmp13_ = self->priv->controller;
	rygel_player_controller_set_playback_state (_tmp13_, "PLAYING");
	_tmp14_ = action;
	gupnp_service_action_return (_tmp14_);
	_g_free0 (speed);
}


static void rygel_av_transport_pause_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	RygelPlayerController* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	RygelPlayerController* _tmp7_ = NULL;
	GUPnPServiceAction* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->controller;
	_tmp3_ = rygel_player_controller_get_playback_state (_tmp2_);
	_tmp4_ = _tmp3_;
	if (g_strcmp0 (_tmp4_, "PLAYING") != 0) {
		GUPnPServiceAction* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp5_ = action;
		_tmp6_ = _ ("Transition not available");
		gupnp_service_action_return_error (_tmp5_, (guint) 701, _tmp6_);
		return;
	}
	_tmp7_ = self->priv->controller;
	rygel_player_controller_set_playback_state (_tmp7_, "PAUSED_PLAYBACK");
	_tmp8_ = action;
	gupnp_service_action_return (_tmp8_);
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static void rygel_av_transport_seek_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* unit = NULL;
	gchar* target = NULL;
	GUPnPServiceAction* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	static GQuark _tmp5_label1 = 0;
	static GQuark _tmp5_label2 = 0;
	static GQuark _tmp5_label3 = 0;
	static GQuark _tmp5_label4 = 0;
	static GQuark _tmp5_label5 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = action;
	gupnp_service_action_get (_tmp2_, "Unit", G_TYPE_STRING, &unit, "Target", G_TYPE_STRING, &target, NULL);
	_tmp3_ = unit;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if ((_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("ABS_TIME")))) || (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("REL_TIME"))))) {
		switch (0) {
			default:
			{
				gint64 seek_target = 0LL;
				const gchar* _tmp7_ = NULL;
				gint64 _tmp8_ = 0LL;
				gint64 _tmp9_ = 0LL;
				RygelMediaPlayer* _tmp10_ = NULL;
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				RygelMediaPlayer* _tmp15_ = NULL;
				gint64 _tmp16_ = 0LL;
				gboolean _tmp17_ = FALSE;
				GUPnPServiceAction* _tmp20_ = NULL;
				_tmp7_ = target;
				_tmp8_ = rygel_time_utils_time_from_string (_tmp7_);
				seek_target = _tmp8_;
				_tmp9_ = seek_target;
				g_debug ("rygel-av-transport.vala:528: Seeking to %lld sec", _tmp9_ / G_TIME_SPAN_SECOND);
				_tmp10_ = self->priv->player;
				_tmp11_ = rygel_media_player_get_can_seek (_tmp10_);
				_tmp12_ = _tmp11_;
				if (!_tmp12_) {
					GUPnPServiceAction* _tmp13_ = NULL;
					const gchar* _tmp14_ = NULL;
					_tmp13_ = action;
					_tmp14_ = _ ("Seek mode not supported");
					gupnp_service_action_return_error (_tmp13_, (guint) 710, _tmp14_);
					_g_free0 (target);
					_g_free0 (unit);
					return;
				}
				_tmp15_ = self->priv->player;
				_tmp16_ = seek_target;
				_tmp17_ = rygel_media_player_seek (_tmp15_, _tmp16_);
				if (!_tmp17_) {
					GUPnPServiceAction* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
					_tmp18_ = action;
					_tmp19_ = _ ("Illegal seek target");
					gupnp_service_action_return_error (_tmp18_, (guint) 711, _tmp19_);
					_g_free0 (target);
					_g_free0 (unit);
					return;
				}
				_tmp20_ = action;
				gupnp_service_action_return (_tmp20_);
				_g_free0 (target);
				_g_free0 (unit);
				return;
			}
		}
	} else if (((_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("REL_COUNT")))) || (_tmp6_ == ((0 != _tmp5_label3) ? _tmp5_label3 : (_tmp5_label3 = g_quark_from_static_string ("X_DLNA_REL_BYTE"))))) || (_tmp6_ == ((0 != _tmp5_label4) ? _tmp5_label4 : (_tmp5_label4 = g_quark_from_static_string ("ABS_COUNT"))))) {
		switch (0) {
			default:
			{
				gint64 seek_target = 0LL;
				const gchar* _tmp21_ = NULL;
				gint64 _tmp22_ = 0LL;
				const gchar* _tmp23_ = NULL;
				gint64 _tmp28_ = 0LL;
				RygelMediaPlayer* _tmp29_ = NULL;
				gboolean _tmp30_ = FALSE;
				gboolean _tmp31_ = FALSE;
				RygelMediaPlayer* _tmp34_ = NULL;
				gint64 _tmp35_ = 0LL;
				gboolean _tmp36_ = FALSE;
				GUPnPServiceAction* _tmp39_ = NULL;
				_tmp21_ = target;
				_tmp22_ = int64_parse (_tmp21_);
				seek_target = _tmp22_;
				_tmp23_ = unit;
				if (g_strcmp0 (_tmp23_, "ABS_COUNT") != 0) {
					gint64 _tmp24_ = 0LL;
					RygelMediaPlayer* _tmp25_ = NULL;
					gint64 _tmp26_ = 0LL;
					gint64 _tmp27_ = 0LL;
					_tmp24_ = seek_target;
					_tmp25_ = self->priv->player;
					_tmp26_ = rygel_media_player_get_byte_position (_tmp25_);
					_tmp27_ = _tmp26_;
					seek_target = _tmp24_ + _tmp27_;
				}
				_tmp28_ = seek_target;
				g_debug ("rygel-av-transport.vala:553: Seeking to %lld bytes.", _tmp28_);
				_tmp29_ = self->priv->player;
				_tmp30_ = rygel_media_player_get_can_seek_bytes (_tmp29_);
				_tmp31_ = _tmp30_;
				if (!_tmp31_) {
					GUPnPServiceAction* _tmp32_ = NULL;
					const gchar* _tmp33_ = NULL;
					_tmp32_ = action;
					_tmp33_ = _ ("Seek mode not supported");
					gupnp_service_action_return_error (_tmp32_, (guint) 710, _tmp33_);
					_g_free0 (target);
					_g_free0 (unit);
					return;
				}
				_tmp34_ = self->priv->player;
				_tmp35_ = seek_target;
				_tmp36_ = rygel_media_player_seek_bytes (_tmp34_, _tmp35_);
				if (!_tmp36_) {
					GUPnPServiceAction* _tmp37_ = NULL;
					const gchar* _tmp38_ = NULL;
					_tmp37_ = action;
					_tmp38_ = _ ("Illegal seek target");
					gupnp_service_action_return_error (_tmp37_, (guint) 711, _tmp38_);
					_g_free0 (target);
					_g_free0 (unit);
					return;
				}
				_tmp39_ = action;
				gupnp_service_action_return (_tmp39_);
				_g_free0 (target);
				_g_free0 (unit);
				return;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label5) ? _tmp5_label5 : (_tmp5_label5 = g_quark_from_static_string ("TRACK_NR")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp40_ = NULL;
				gint track = 0;
				const gchar* _tmp41_ = NULL;
				gint _tmp42_ = 0;
				gboolean _tmp43_ = FALSE;
				gint _tmp44_ = 0;
				RygelPlayerController* _tmp51_ = NULL;
				gint _tmp52_ = 0;
				GUPnPServiceAction* _tmp53_ = NULL;
				_tmp40_ = target;
				g_debug ("rygel-av-transport.vala:571: Setting track to %s.", _tmp40_);
				_tmp41_ = target;
				_tmp42_ = atoi (_tmp41_);
				track = _tmp42_;
				_tmp44_ = track;
				if (_tmp44_ < 1) {
					_tmp43_ = TRUE;
				} else {
					gint _tmp45_ = 0;
					RygelPlayerController* _tmp46_ = NULL;
					guint _tmp47_ = 0U;
					guint _tmp48_ = 0U;
					_tmp45_ = track;
					_tmp46_ = self->priv->controller;
					_tmp47_ = rygel_player_controller_get_n_tracks (_tmp46_);
					_tmp48_ = _tmp47_;
					_tmp43_ = ((guint) _tmp45_) > _tmp48_;
				}
				if (_tmp43_) {
					GUPnPServiceAction* _tmp49_ = NULL;
					const gchar* _tmp50_ = NULL;
					_tmp49_ = action;
					_tmp50_ = _ ("Illegal seek target");
					gupnp_service_action_return_error (_tmp49_, (guint) 711, _tmp50_);
					_g_free0 (target);
					_g_free0 (unit);
					return;
				}
				_tmp51_ = self->priv->controller;
				_tmp52_ = track;
				rygel_player_controller_set_track (_tmp51_, (guint) _tmp52_);
				_tmp53_ = action;
				gupnp_service_action_return (_tmp53_);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GUPnPServiceAction* _tmp54_ = NULL;
				const gchar* _tmp55_ = NULL;
				_tmp54_ = action;
				_tmp55_ = _ ("Seek mode not supported");
				gupnp_service_action_return_error (_tmp54_, (guint) 710, _tmp55_);
				_g_free0 (target);
				_g_free0 (unit);
				return;
			}
		}
	}
	_g_free0 (target);
	_g_free0 (unit);
}


static void rygel_av_transport_next_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	RygelPlayerController* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->controller;
	_tmp1_ = rygel_player_controller_next (_tmp0_);
	if (_tmp1_) {
		GUPnPServiceAction* _tmp2_ = NULL;
		_tmp2_ = action;
		gupnp_service_action_return (_tmp2_);
	} else {
		GUPnPServiceAction* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = action;
		_tmp4_ = _ ("Illegal seek target");
		gupnp_service_action_return_error (_tmp3_, (guint) 711, _tmp4_);
	}
}


static void rygel_av_transport_previous_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	RygelPlayerController* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->controller;
	_tmp1_ = rygel_player_controller_previous (_tmp0_);
	if (_tmp1_) {
		GUPnPServiceAction* _tmp2_ = NULL;
		_tmp2_ = action;
		gupnp_service_action_return (_tmp2_);
	} else {
		GUPnPServiceAction* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = action;
		_tmp4_ = _ ("Illegal seek target");
		gupnp_service_action_return_error (_tmp3_, (guint) 711, _tmp4_);
	}
}


static void rygel_av_transport_x_dlna_get_byte_position_info_cb (RygelAVTransport* self, GUPnPService* service, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	RygelPlayerController* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GUPnPServiceAction* _tmp18_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = rygel_av_transport_check_instance_id (self, _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->controller;
	_tmp3_ = rygel_player_controller_get_uri (_tmp2_);
	_tmp4_ = _tmp3_;
	if (g_strcmp0 (_tmp4_, "") == 0) {
		GUPnPServiceAction* _tmp5_ = NULL;
		_tmp5_ = action;
		gupnp_service_action_set (_tmp5_, "TrackSize", G_TYPE_STRING, "", "RelByte", G_TYPE_STRING, "", "AbsByte", G_TYPE_STRING, "", NULL);
	} else {
		gchar* position = NULL;
		RygelMediaPlayer* _tmp6_ = NULL;
		gint64 _tmp7_ = 0LL;
		gint64 _tmp8_ = 0LL;
		gchar* _tmp9_ = NULL;
		GUPnPServiceAction* _tmp10_ = NULL;
		RygelMediaPlayer* _tmp11_ = NULL;
		gint64 _tmp12_ = 0LL;
		gint64 _tmp13_ = 0LL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		_tmp6_ = self->priv->player;
		_tmp7_ = rygel_media_player_get_byte_position (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp8_);
		position = _tmp9_;
		_tmp10_ = action;
		_tmp11_ = self->priv->player;
		_tmp12_ = rygel_media_player_get_size (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = position;
		_tmp17_ = position;
		gupnp_service_action_set (_tmp10_, "TrackSize", G_TYPE_STRING, _tmp15_, "RelByte", G_TYPE_STRING, _tmp16_, "AbsByte", G_TYPE_STRING, _tmp17_, NULL);
		_g_free0 (_tmp15_);
		_g_free0 (position);
	}
	_tmp18_ = action;
	gupnp_service_action_return (_tmp18_);
}


static void rygel_av_transport_notify_state_cb (RygelAVTransport* self, GObject* controller, GParamSpec* p) {
	gchar* state = NULL;
	RygelPlayerController* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	RygelChangeLog* _tmp4_ = NULL;
	RygelChangeLog* _tmp5_ = NULL;
	RygelPlayerController* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (controller != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->controller;
	_tmp1_ = rygel_player_controller_get_playback_state (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	state = _tmp3_;
	_tmp4_ = self->priv->changelog;
	rygel_change_log_log (_tmp4_, "TransportState", state);
	_tmp5_ = self->priv->changelog;
	_tmp6_ = self->priv->controller;
	_tmp7_ = rygel_player_controller_get_current_transport_actions (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	rygel_change_log_log (_tmp5_, "CurrentTransportActions", _tmp9_);
	_g_free0 (_tmp9_);
	_g_free0 (state);
}


static void rygel_av_transport_notify_n_tracks_cb (RygelAVTransport* self, GObject* controller, GParamSpec* p) {
	RygelChangeLog* _tmp0_ = NULL;
	RygelPlayerController* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (controller != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->changelog;
	_tmp1_ = self->priv->controller;
	_tmp2_ = rygel_player_controller_get_n_tracks (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%u", _tmp3_);
	_tmp5_ = _tmp4_;
	rygel_change_log_log (_tmp0_, "NumberOfTracks", _tmp5_);
	_g_free0 (_tmp5_);
}


static void rygel_av_transport_notify_track_cb (RygelAVTransport* self, GObject* controller, GParamSpec* p) {
	RygelChangeLog* _tmp0_ = NULL;
	RygelPlayerController* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (controller != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->changelog;
	_tmp1_ = self->priv->controller;
	_tmp2_ = rygel_player_controller_get_track (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%u", _tmp3_);
	_tmp5_ = _tmp4_;
	rygel_change_log_log (_tmp0_, "CurrentTrack", _tmp5_);
	_g_free0 (_tmp5_);
}


static void rygel_av_transport_notify_duration_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelChangeLog* _tmp0_ = NULL;
	RygelMediaPlayer* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	RygelChangeLog* _tmp5_ = NULL;
	RygelMediaPlayer* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->changelog;
	_tmp1_ = self->priv->player;
	_tmp2_ = rygel_media_player_get_duration_as_str (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	rygel_change_log_log (_tmp0_, "CurrentTrackDuration", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->priv->changelog;
	_tmp6_ = self->priv->player;
	_tmp7_ = rygel_media_player_get_duration_as_str (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	rygel_change_log_log (_tmp5_, "CurrentMediaDuration", _tmp9_);
	_g_free0 (_tmp9_);
}


static void rygel_av_transport_notify_uri_cb (RygelAVTransport* self, GObject* controller, GParamSpec* p) {
	RygelChangeLog* _tmp0_ = NULL;
	RygelPlayerController* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (controller != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->changelog;
	_tmp1_ = self->priv->controller;
	_tmp2_ = rygel_player_controller_get_uri (_tmp1_);
	_tmp3_ = _tmp2_;
	rygel_change_log_log (_tmp0_, "AVTransportURI", _tmp3_);
}


static void rygel_av_transport_notify_meta_data_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelChangeLog* _tmp0_ = NULL;
	RygelPlayerController* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->changelog;
	_tmp1_ = self->priv->controller;
	_tmp2_ = rygel_player_controller_get_metadata (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_markup_escape_text (_tmp3_, (gssize) (-1));
	_tmp5_ = _tmp4_;
	rygel_change_log_log (_tmp0_, "AVTransportURIMetaData", _tmp5_);
	_g_free0 (_tmp5_);
}


static void rygel_av_transport_notify_track_uri_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelChangeLog* _tmp0_ = NULL;
	RygelPlayerController* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->changelog;
	_tmp1_ = self->priv->controller;
	_tmp2_ = rygel_player_controller_get_track_uri (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	rygel_change_log_log (_tmp0_, "CurrentTrackURI", _tmp4_);
	_g_free0 (_tmp4_);
}


static void rygel_av_transport_notify_track_meta_data_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelChangeLog* _tmp0_ = NULL;
	RygelPlayerController* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->changelog;
	_tmp1_ = self->priv->controller;
	_tmp2_ = rygel_player_controller_get_track_metadata (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = g_markup_escape_text (_tmp4_, (gssize) (-1));
	_tmp6_ = _tmp5_;
	rygel_change_log_log (_tmp0_, "CurrentTrackMetaData", _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
}


static void rygel_av_transport_notify_next_uri_cb (RygelAVTransport* self, GObject* controller, GParamSpec* p) {
	RygelChangeLog* _tmp0_ = NULL;
	RygelPlayerController* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (controller != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->changelog;
	_tmp1_ = self->priv->controller;
	_tmp2_ = rygel_player_controller_get_next_uri (_tmp1_);
	_tmp3_ = _tmp2_;
	rygel_change_log_log (_tmp0_, "NextAVTransportURI", _tmp3_);
}


static void rygel_av_transport_notify_next_meta_data_cb (RygelAVTransport* self, GObject* player, GParamSpec* p) {
	RygelChangeLog* _tmp0_ = NULL;
	RygelPlayerController* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->changelog;
	_tmp1_ = self->priv->controller;
	_tmp2_ = rygel_player_controller_get_next_metadata (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_markup_escape_text (_tmp3_, (gssize) (-1));
	_tmp5_ = _tmp4_;
	rygel_change_log_log (_tmp0_, "NextAVTransportURIMetaData", _tmp5_);
	_g_free0 (_tmp5_);
}


static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self) {
	g_boxed_free (gupnp_service_action_get_type (), self);
}


static void rygel_av_transport_handle_playlist_data_free (gpointer _data) {
	RygelAvTransportHandlePlaylistData* _data_;
	_data_ = _data;
	__vala_GUPnPServiceAction_free0 (_data_->action);
	_g_free0 (_data_->uri);
	_g_free0 (_data_->metadata);
	_g_free0 (_data_->mime);
	_g_free0 (_data_->features);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelAvTransportHandlePlaylistData, _data_);
}


static GUPnPServiceAction* _vala_GUPnPServiceAction_copy (GUPnPServiceAction* self) {
	return g_boxed_copy (gupnp_service_action_get_type (), self);
}


static gpointer __vala_GUPnPServiceAction_copy0 (gpointer self) {
	return self ? _vala_GUPnPServiceAction_copy (self) : NULL;
}


static void rygel_av_transport_handle_playlist (RygelAVTransport* self, GUPnPServiceAction* action, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelAvTransportHandlePlaylistData* _data_;
	RygelAVTransport* _tmp0_ = NULL;
	GUPnPServiceAction* _tmp1_ = NULL;
	GUPnPServiceAction* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	_data_ = g_slice_new0 (RygelAvTransportHandlePlaylistData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_av_transport_handle_playlist);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_av_transport_handle_playlist_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = action;
	_tmp2_ = __vala_GUPnPServiceAction_copy0 (_tmp1_);
	__vala_GUPnPServiceAction_free0 (_data_->action);
	_data_->action = _tmp2_;
	_tmp3_ = uri;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp4_;
	_tmp5_ = metadata;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_data_->metadata);
	_data_->metadata = _tmp6_;
	_tmp7_ = mime;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (_data_->mime);
	_data_->mime = _tmp8_;
	_tmp9_ = features;
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 (_data_->features);
	_data_->features = _tmp10_;
	rygel_av_transport_handle_playlist_co (_data_);
}


static void rygel_av_transport_handle_playlist_finish (RygelAVTransport* self, GAsyncResult* _res_) {
	RygelAvTransportHandlePlaylistData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		RygelAVTransport* self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void __lambda8_ (Block2Data* _data2_) {
	RygelAVTransport* self;
	self = _data2_->self;
	rygel_av_transport_handle_playlist_co (_data2_->_async_data_);
}


static void ___lambda8__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
	__lambda8_ (self);
	block2_data_unref (self);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean rygel_av_transport_handle_playlist_co (RygelAvTransportHandlePlaylistData* _data_) {
	static GQuark _tmp25_label0 = 0;
	static GQuark _tmp25_label1 = 0;
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data2_ = g_slice_new0 (Block2Data);
	_data_->_data2_->_ref_count_ = 1;
	_data_->_data2_->self = g_object_ref (_data_->self);
	_data_->_data2_->_async_data_ = _data_;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->uri;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = soup_message_new ("GET", _data_->_tmp0_);
	_data_->message = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->self->priv->session;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->message;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _g_object_ref0 (_data_->_tmp3_);
	soup_session_queue_message (_data_->_tmp2_, _data_->_tmp4_, ___lambda8__soup_session_callback, block2_data_ref (_data_->_data2_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->message;
	_data_->_tmp6_ = 0U;
	g_object_get (_data_->_tmp5_, "status-code", &_data_->_tmp6_, NULL);
	_data_->_tmp7_ = 0U;
	_data_->_tmp7_ = _data_->_tmp6_;
	if (_data_->_tmp7_ != ((guint) 200)) {
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->action;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _ ("Resource not found");
		gupnp_service_action_return_error (_data_->_tmp8_, (guint) 716, _data_->_tmp9_);
		_g_object_unref0 (_data_->message);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->message;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->_tmp10_->response_body;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12__length1 = 0;
	_data_->_tmp12_ = _data_->_tmp11_->data;
	_data_->_tmp12__length1 = (gint) _data_->_tmp11_->length;
	_data_->xml_string = (const gchar*) _data_->_tmp12_;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->xml_string;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = gupnp_media_collection_new_from_string (_data_->_tmp13_);
	_data_->collection = _data_->_tmp14_;
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->collection;
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = gupnp_media_collection_get_items (_data_->_tmp15_);
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = _data_->_tmp16_;
	_data_->_tmp18_ = 0U;
	_data_->_tmp18_ = g_list_length (_data_->_tmp17_);
	_data_->_tmp19_ = FALSE;
	_data_->_tmp19_ = _data_->_tmp18_ == ((guint) 0);
	__g_list_free__g_object_unref0_0 (_data_->_tmp17_);
	if (_data_->_tmp19_) {
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _data_->action;
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = _ ("Resource not found");
		gupnp_service_action_return_error (_data_->_tmp20_, (guint) 716, _data_->_tmp21_);
		_g_object_unref0 (_data_->collection);
		_g_object_unref0 (_data_->message);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = _data_->action;
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = gupnp_service_action_get_name (_data_->_tmp22_);
	_data_->_tmp24_ = NULL;
	_data_->_tmp26_ = 0U;
	_data_->_tmp24_ = _data_->_tmp23_;
	_data_->_tmp26_ = (NULL == _data_->_tmp24_) ? 0 : g_quark_from_string (_data_->_tmp24_);
	if (_data_->_tmp26_ == ((0 != _tmp25_label0) ? _tmp25_label0 : (_tmp25_label0 = g_quark_from_static_string ("SetAVTransportURI")))) {
		switch (0) {
			default:
			{
				_data_->_tmp27_ = NULL;
				_data_->_tmp27_ = _data_->self->priv->controller;
				_data_->_tmp28_ = NULL;
				_data_->_tmp28_ = _data_->uri;
				_data_->_tmp29_ = NULL;
				_data_->_tmp29_ = _data_->metadata;
				_data_->_tmp30_ = NULL;
				_data_->_tmp30_ = _data_->collection;
				rygel_player_controller_set_playlist_uri (_data_->_tmp27_, _data_->_tmp28_, _data_->_tmp29_, _data_->_tmp30_);
				break;
			}
		}
	} else if (_data_->_tmp26_ == ((0 != _tmp25_label1) ? _tmp25_label1 : (_tmp25_label1 = g_quark_from_static_string ("SetNextAVTransportURI")))) {
		switch (0) {
			default:
			{
				_data_->_tmp31_ = NULL;
				_data_->_tmp31_ = _data_->self->priv->controller;
				_data_->_tmp32_ = NULL;
				_data_->_tmp32_ = _data_->uri;
				_data_->_tmp33_ = NULL;
				_data_->_tmp33_ = _data_->metadata;
				_data_->_tmp34_ = NULL;
				_data_->_tmp34_ = _data_->collection;
				rygel_player_controller_set_next_playlist_uri (_data_->_tmp31_, _data_->_tmp32_, _data_->_tmp33_, _data_->_tmp34_);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
	_data_->_tmp35_ = NULL;
	_data_->_tmp35_ = _data_->action;
	gupnp_service_action_return (_data_->_tmp35_);
	_g_object_unref0 (_data_->collection);
	_g_object_unref0 (_data_->message);
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean rygel_av_transport_is_playlist (RygelAVTransport* self, const gchar* mime, const gchar* features) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp2_ = mime;
	if (g_strcmp0 (_tmp2_, "text/xml") == 0) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = features;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		_tmp4_ = features;
		_tmp5_ = g_str_has_prefix (_tmp4_, "DLNA.ORG_PN=DIDL_S");
		_tmp0_ = _tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static void ___lambda7_ (RygelAVTransport* self, SoupMessage* msg) {
	SoupSession* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupMessage* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	g_return_if_fail (msg != NULL);
	_tmp0_ = self->priv->session;
	_tmp1_ = msg;
	_tmp2_ = msg;
	g_object_get (_tmp2_, "status-code", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	soup_session_cancel_message (_tmp0_, _tmp1_, _tmp4_);
}


static void ____lambda7__soup_message_got_headers (SoupMessage* _sender, gpointer self) {
	___lambda7_ ((RygelAVTransport*) self, _sender);
}


static void rygel_av_transport_check_resource (RygelAVTransport* self, SoupMessage* msg, const gchar* _uri, const gchar* _metadata, GUPnPServiceAction* action) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	SoupMessage* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	SoupMessage* _tmp25_ = NULL;
	guint _tmp26_ = 0U;
	guint _tmp27_ = 0U;
	gchar* mime = NULL;
	SoupMessage* _tmp36_ = NULL;
	SoupMessageHeaders* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	gchar* features = NULL;
	SoupMessage* _tmp40_ = NULL;
	SoupMessageHeaders* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	gboolean _tmp44_ = FALSE;
	const gchar* _tmp45_ = NULL;
	gboolean _tmp46_ = FALSE;
	const gchar* _tmp52_ = NULL;
	const gchar* _tmp53_ = NULL;
	gboolean _tmp54_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	g_return_if_fail (_uri != NULL);
	g_return_if_fail (_metadata != NULL);
	g_return_if_fail (action != NULL);
	_tmp4_ = msg;
	g_object_get (_tmp4_, "status-code", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == ((guint) SOUP_STATUS_MALFORMED)) {
		_tmp3_ = TRUE;
	} else {
		SoupMessage* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
		guint _tmp9_ = 0U;
		_tmp7_ = msg;
		g_object_get (_tmp7_, "status-code", &_tmp8_, NULL);
		_tmp9_ = _tmp8_;
		_tmp3_ = _tmp9_ == ((guint) SOUP_STATUS_BAD_REQUEST);
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		SoupMessage* _tmp10_ = NULL;
		guint _tmp11_ = 0U;
		guint _tmp12_ = 0U;
		_tmp10_ = msg;
		g_object_get (_tmp10_, "status-code", &_tmp11_, NULL);
		_tmp12_ = _tmp11_;
		_tmp2_ = _tmp12_ == ((guint) SOUP_STATUS_METHOD_NOT_ALLOWED);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		SoupMessage* _tmp13_ = NULL;
		guint _tmp14_ = 0U;
		guint _tmp15_ = 0U;
		_tmp13_ = msg;
		g_object_get (_tmp13_, "status-code", &_tmp14_, NULL);
		_tmp15_ = _tmp14_;
		_tmp1_ = _tmp15_ == ((guint) SOUP_STATUS_NOT_IMPLEMENTED);
	}
	if (_tmp1_) {
		SoupMessage* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		_tmp16_ = msg;
		g_object_get (_tmp16_, "method", &_tmp17_, NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_;
		_tmp0_ = g_strcmp0 (_tmp19_, "HEAD") == 0;
		_g_free0 (_tmp19_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		SoupMessage* _tmp20_ = NULL;
		SoupMessage* _tmp21_ = NULL;
		SoupSession* _tmp22_ = NULL;
		SoupMessage* _tmp23_ = NULL;
		SoupMessage* _tmp24_ = NULL;
		g_debug ("rygel-av-transport.vala:749: Peer does not support HEAD, trying GET");
		_tmp20_ = msg;
		g_object_set (_tmp20_, "method", "GET", NULL);
		_tmp21_ = msg;
		g_signal_connect_object (_tmp21_, "got-headers", (GCallback) ____lambda7__soup_message_got_headers, self, 0);
		_tmp22_ = self->priv->session;
		_tmp23_ = msg;
		_tmp24_ = _g_object_ref0 (_tmp23_);
		soup_session_queue_message (_tmp22_, _tmp24_, NULL, NULL);
		return;
	}
	_tmp25_ = msg;
	g_object_get (_tmp25_, "status-code", &_tmp26_, NULL);
	_tmp27_ = _tmp26_;
	if (_tmp27_ != ((guint) SOUP_STATUS_OK)) {
		const gchar* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		SoupMessage* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		GUPnPServiceAction* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		_tmp28_ = _ ("Failed to access resource at %s: %s");
		_tmp29_ = _uri;
		_tmp30_ = msg;
		g_object_get (_tmp30_, "reason-phrase", &_tmp31_, NULL);
		_tmp32_ = _tmp31_;
		_tmp33_ = _tmp32_;
		g_warning (_tmp28_, _tmp29_, _tmp33_);
		_g_free0 (_tmp33_);
		_tmp34_ = action;
		_tmp35_ = _ ("Resource not found");
		gupnp_service_action_return_error (_tmp34_, (guint) 716, _tmp35_);
		return;
	}
	_tmp36_ = msg;
	_tmp37_ = _tmp36_->response_headers;
	_tmp38_ = soup_message_headers_get_one (_tmp37_, "Content-Type");
	_tmp39_ = g_strdup (_tmp38_);
	mime = _tmp39_;
	_tmp40_ = msg;
	_tmp41_ = _tmp40_->response_headers;
	_tmp42_ = soup_message_headers_get_one (_tmp41_, "contentFeatures.dlna.org");
	_tmp43_ = g_strdup (_tmp42_);
	features = _tmp43_;
	_tmp45_ = mime;
	_tmp46_ = rygel_av_transport_is_valid_mime_type (self, _tmp45_);
	if (!_tmp46_) {
		const gchar* _tmp47_ = NULL;
		const gchar* _tmp48_ = NULL;
		gboolean _tmp49_ = FALSE;
		_tmp47_ = mime;
		_tmp48_ = features;
		_tmp49_ = rygel_av_transport_is_playlist (self, _tmp47_, _tmp48_);
		_tmp44_ = !_tmp49_;
	} else {
		_tmp44_ = FALSE;
	}
	if (_tmp44_) {
		GUPnPServiceAction* _tmp50_ = NULL;
		const gchar* _tmp51_ = NULL;
		_tmp50_ = action;
		_tmp51_ = _ ("Illegal MIME-type");
		gupnp_service_action_return_error (_tmp50_, (guint) 714, _tmp51_);
		_g_free0 (features);
		_g_free0 (mime);
		return;
	}
	_tmp52_ = mime;
	_tmp53_ = features;
	_tmp54_ = rygel_av_transport_is_playlist (self, _tmp52_, _tmp53_);
	if (_tmp54_) {
		GUPnPServiceAction* _tmp55_ = NULL;
		const gchar* _tmp56_ = NULL;
		const gchar* _tmp57_ = NULL;
		const gchar* _tmp58_ = NULL;
		const gchar* _tmp59_ = NULL;
		_tmp55_ = action;
		_tmp56_ = _uri;
		_tmp57_ = _metadata;
		_tmp58_ = mime;
		_tmp59_ = features;
		rygel_av_transport_handle_playlist (self, _tmp55_, _tmp56_, _tmp57_, _tmp58_, _tmp59_, NULL, NULL);
	} else {
		GUPnPServiceAction* _tmp60_ = NULL;
		const gchar* _tmp61_ = NULL;
		const gchar* _tmp62_ = NULL;
		const gchar* _tmp63_ = NULL;
		const gchar* _tmp64_ = NULL;
		_tmp60_ = action;
		_tmp61_ = _uri;
		_tmp62_ = _metadata;
		_tmp63_ = mime;
		_tmp64_ = features;
		rygel_av_transport_set_single_play_uri (self, _tmp60_, _tmp61_, _tmp62_, _tmp63_, _tmp64_);
	}
	_g_free0 (features);
	_g_free0 (mime);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		RygelAVTransport* self;
		self = _data3_->self;
		__vala_GUPnPServiceAction_free0 (_data3_->action);
		_g_free0 (_data3_->uri);
		_g_free0 (_data3_->metadata);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void ___lambda6_ (Block3Data* _data3_, SoupMessage* msg) {
	RygelAVTransport* self;
	SoupMessage* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GUPnPServiceAction* _tmp3_ = NULL;
	self = _data3_->self;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = _data3_->uri;
	_tmp2_ = _data3_->metadata;
	_tmp3_ = _data3_->action;
	rygel_av_transport_check_resource (self, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
}


static void ____lambda6__soup_message_finished (SoupMessage* _sender, gpointer self) {
	___lambda6_ (self, _sender);
}


static void rygel_av_transport_handle_new_transport_uri (RygelAVTransport* self, GUPnPServiceAction* action, const gchar* uri, const gchar* metadata) {
	Block3Data* _data3_;
	GUPnPServiceAction* _tmp0_ = NULL;
	GUPnPServiceAction* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (metadata != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = action;
	_tmp1_ = __vala_GUPnPServiceAction_copy0 (_tmp0_);
	__vala_GUPnPServiceAction_free0 (_data3_->action);
	_data3_->action = _tmp1_;
	_tmp2_ = uri;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (_data3_->uri);
	_data3_->uri = _tmp3_;
	_tmp4_ = metadata;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (_data3_->metadata);
	_data3_->metadata = _tmp5_;
	_tmp7_ = _data3_->uri;
	_tmp8_ = g_str_has_prefix (_tmp7_, "http://");
	if (_tmp8_) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		_tmp9_ = _data3_->uri;
		_tmp10_ = g_str_has_prefix (_tmp9_, "https://");
		_tmp6_ = _tmp10_;
	}
	if (_tmp6_) {
		SoupMessage* message = NULL;
		const gchar* _tmp11_ = NULL;
		SoupMessage* _tmp12_ = NULL;
		SoupMessage* _tmp13_ = NULL;
		SoupMessageHeaders* _tmp14_ = NULL;
		SoupMessage* _tmp15_ = NULL;
		SoupSession* _tmp16_ = NULL;
		SoupMessage* _tmp17_ = NULL;
		SoupMessage* _tmp18_ = NULL;
		_tmp11_ = _data3_->uri;
		_tmp12_ = soup_message_new ("HEAD", _tmp11_);
		message = _tmp12_;
		_tmp13_ = message;
		_tmp14_ = _tmp13_->request_headers;
		soup_message_headers_append (_tmp14_, "getContentFeatures.dlna.org", "1");
		_tmp15_ = message;
		g_signal_connect_data (_tmp15_, "finished", (GCallback) ____lambda6__soup_message_finished, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
		_tmp16_ = self->priv->session;
		_tmp17_ = message;
		_tmp18_ = _g_object_ref0 (_tmp17_);
		soup_session_queue_message (_tmp16_, _tmp18_, NULL, NULL);
		_g_object_unref0 (message);
	} else {
		GUPnPServiceAction* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		_tmp19_ = _data3_->action;
		_tmp20_ = _data3_->uri;
		_tmp21_ = _data3_->metadata;
		rygel_av_transport_set_single_play_uri (self, _tmp19_, _tmp20_, _tmp21_, NULL, NULL);
	}
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


static void rygel_av_transport_set_single_play_uri (RygelAVTransport* self, GUPnPServiceAction* action, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features) {
	GUPnPServiceAction* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	GUPnPServiceAction* _tmp15_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (metadata != NULL);
	_tmp0_ = action;
	_tmp1_ = gupnp_service_action_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("SetAVTransportURI")))) {
		switch (0) {
			default:
			{
				RygelPlayerController* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				_tmp5_ = self->priv->controller;
				_tmp6_ = uri;
				_tmp7_ = metadata;
				_tmp8_ = mime;
				_tmp9_ = features;
				rygel_player_controller_set_single_play_uri (_tmp5_, _tmp6_, _tmp7_, _tmp8_, _tmp9_);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("SetNextAVTransportURI")))) {
		switch (0) {
			default:
			{
				RygelPlayerController* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				_tmp10_ = self->priv->controller;
				_tmp11_ = uri;
				_tmp12_ = metadata;
				_tmp13_ = mime;
				_tmp14_ = features;
				rygel_player_controller_set_next_single_play_uri (_tmp10_, _tmp11_, _tmp12_, _tmp13_, _tmp14_);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
	_tmp15_ = action;
	gupnp_service_action_return (_tmp15_);
}


RygelAVTransport* rygel_av_transport_construct (GType object_type) {
	RygelAVTransport * self = NULL;
	self = (RygelAVTransport*) g_object_new (object_type, NULL);
	return self;
}


RygelAVTransport* rygel_av_transport_new (void) {
	return rygel_av_transport_construct (RYGEL_TYPE_AV_TRANSPORT);
}


const gchar* rygel_av_transport_get_status (RygelAVTransport* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_status;
	result = _tmp0_;
	return result;
}


void rygel_av_transport_set_status (RygelAVTransport* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	RygelChangeLog* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_status);
	self->priv->_status = _tmp1_;
	_tmp2_ = self->priv->changelog;
	_tmp3_ = self->priv->_status;
	rygel_change_log_log (_tmp2_, "TransportStatus", _tmp3_);
	g_object_notify ((GObject *) self, "status");
}


const gchar* rygel_av_transport_get_playback_medium (RygelAVTransport* self) {
	const gchar* result;
	RygelPlayerController* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->controller;
	_tmp1_ = rygel_player_controller_get_uri (_tmp0_);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "") == 0) {
		result = "NONE";
		return result;
	} else {
		result = "NETWORK";
		return result;
	}
}


gchar* rygel_av_transport_get_speed (RygelAVTransport* self) {
	gchar* result;
	RygelMediaPlayer* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->player;
	_tmp1_ = rygel_media_player_get_playback_speed (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


void rygel_av_transport_set_speed (RygelAVTransport* self, const gchar* value) {
	RygelMediaPlayer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	RygelChangeLog* _tmp2_ = NULL;
	RygelMediaPlayer* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->player;
	_tmp1_ = value;
	rygel_media_player_set_playback_speed (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->changelog;
	_tmp3_ = self->priv->player;
	_tmp4_ = rygel_media_player_get_playback_speed (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	rygel_change_log_log (_tmp2_, "TransportPlaySpeed", _tmp6_);
	_g_free0 (_tmp6_);
	g_object_notify ((GObject *) self, "speed");
}


const gchar* rygel_av_transport_get_mode (RygelAVTransport* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mode;
	result = _tmp0_;
	return result;
}


void rygel_av_transport_set_mode (RygelAVTransport* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	RygelChangeLog* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_mode);
	self->priv->_mode = _tmp1_;
	_tmp2_ = self->priv->changelog;
	_tmp3_ = self->priv->_mode;
	rygel_change_log_log (_tmp2_, "CurrentPlayMode", _tmp3_);
	g_object_notify ((GObject *) self, "mode");
}


static void rygel_av_transport_class_init (RygelAVTransportClass * klass) {
	rygel_av_transport_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelAVTransportPrivate));
	G_OBJECT_CLASS (klass)->constructed = rygel_av_transport_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_av_transport_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_av_transport_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_av_transport_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_STATUS, g_param_spec_string ("status", "status", "status", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_PLAYBACK_MEDIUM, g_param_spec_string ("playback-medium", "playback-medium", "playback-medium", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_SPEED, g_param_spec_string ("speed", "speed", "speed", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AV_TRANSPORT_MODE, g_param_spec_string ("mode", "mode", "mode", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_av_transport_instance_init (RygelAVTransport * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self->priv = RYGEL_AV_TRANSPORT_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("OK");
	self->priv->_status = _tmp0_;
	_tmp1_ = g_strdup ("NORMAL");
	self->priv->_mode = _tmp1_;
}


static void rygel_av_transport_finalize (GObject* obj) {
	RygelAVTransport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport);
	_g_object_unref0 (self->priv->session);
	_g_free0 (self->priv->protocol_info);
	_g_free0 (self->priv->_status);
	_g_free0 (self->priv->_mode);
	_g_object_unref0 (self->priv->changelog);
	_g_object_unref0 (self->priv->player);
	_g_object_unref0 (self->priv->controller);
	G_OBJECT_CLASS (rygel_av_transport_parent_class)->finalize (obj);
}


GType rygel_av_transport_get_type (void) {
	static volatile gsize rygel_av_transport_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_av_transport_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelAVTransportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_av_transport_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelAVTransport), 0, (GInstanceInitFunc) rygel_av_transport_instance_init, NULL };
		GType rygel_av_transport_type_id;
		rygel_av_transport_type_id = g_type_register_static (gupnp_service_get_type (), "RygelAVTransport", &g_define_type_info, 0);
		g_once_init_leave (&rygel_av_transport_type_id__volatile, rygel_av_transport_type_id);
	}
	return rygel_av_transport_type_id__volatile;
}


static void _vala_rygel_av_transport_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelAVTransport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport);
	switch (property_id) {
		case RYGEL_AV_TRANSPORT_STATUS:
		g_value_set_string (value, rygel_av_transport_get_status (self));
		break;
		case RYGEL_AV_TRANSPORT_PLAYBACK_MEDIUM:
		g_value_set_string (value, rygel_av_transport_get_playback_medium (self));
		break;
		case RYGEL_AV_TRANSPORT_SPEED:
		g_value_take_string (value, rygel_av_transport_get_speed (self));
		break;
		case RYGEL_AV_TRANSPORT_MODE:
		g_value_set_string (value, rygel_av_transport_get_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_av_transport_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelAVTransport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport);
	switch (property_id) {
		case RYGEL_AV_TRANSPORT_STATUS:
		rygel_av_transport_set_status (self, g_value_get_string (value));
		break;
		case RYGEL_AV_TRANSPORT_SPEED:
		rygel_av_transport_set_speed (self, g_value_get_string (value));
		break;
		case RYGEL_AV_TRANSPORT_MODE:
		rygel_av_transport_set_mode (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



