#include "config.h"

#include <iostream>
#include <fstream>
#include <iomanip>
#include <string>
#include <cassert>

#include "asserts.h"
#include "error.h"
#include "fs.h"
#include "vaulter.h"

bool make_dir(const std::string& path)
{
	bool thrown;

	thrown = false;
	try {
		mk_dir(path);
	}
	catch(...) {
		thrown = true;
	}

	return(thrown == false);
}

void setup(void)
{
	std::ofstream out;

	assert(make_dir("./test-vaulter.dir"));
	assert(make_dir("./test-vaulter.dir/group-1"));
	assert(make_dir("./test-vaulter.dir/group-1/vault-1"));
	assert(make_dir("./test-vaulter.dir/group-1/vault-2"));
	assert(make_dir("./test-vaulter.dir/group-1/vault-3"));
	assert(make_dir("./test-vaulter.dir/group-1/vault-1/2003-09-15"));
	assert(make_dir("./test-vaulter.dir/group-1/vault-2/2003-09-16"));
	assert(make_dir("./test-vaulter.dir/group-1/vault-3/2003-09-17"));
	assert(make_dir("./test-vaulter.dir/group-1/vault-1/2003-09-18.incomplete"));
	assert(make_dir("./test-vaulter.dir/group-1/vault-1/2003-09-18.corrupt"));
	assert(make_dir("./test-vaulter.dir/group-1/vault-2/2003-09-19"));
	assert(make_dir("./test-vaulter.dir/group-1/vault-3/2003-09-20"));
	assert(make_dir("./test-vaulter.dir/group-1/vault-1/2003-09-21"));
	assert(make_dir("./test-vaulter.dir/group-1/vault-2/2003-09-22"));
	assert(make_dir("./test-vaulter.dir/group-2"));
	assert(make_dir("./test-vaulter.dir/group-2/vault-1"));
	assert(make_dir("./test-vaulter.dir/group-2/vault-2"));
	assert(make_dir("./test-vaulter.dir/group-2/vault-3"));
	assert(make_dir("./test-vaulter.dir/group-2/vault-1/2003-09-15"));
	assert(make_dir("./test-vaulter.dir/group-2/vault-2/2003-09-16"));
	assert(make_dir("./test-vaulter.dir/group-2/vault-3/2003-09-17"));
	assert(make_dir("./test-vaulter.dir/group-2/vault-1/2003-09-18"));
	assert(make_dir("./test-vaulter.dir/group-2/vault-2/2003-09-19"));
	assert(make_dir("./test-vaulter.dir/group-2/vault-3/2003-09-20"));
	assert(make_dir("./test-vaulter.dir/group-2/vault-1/2003-09-21"));
	assert(make_dir("./test-vaulter.dir/log.dir"));
	assert(make_dir("./test-vaulter.dir/log.dir/log-1.dir"));
	assert(make_dir("./test-vaulter.dir/log.dir/log-2.dir"));

	out.open("./test-vaulter.dir/file-1.conf");
	assert(out.is_open());
	out << "log-dir ./test-vaulter.dir/log.dir/log-1.dir" << std::endl;
	out << "vault ./test-vaulter.dir/group-1/*" << std::endl;
	out << "vault-selection-behavior round-robin" << std::endl;
	out.close();

	assert(make_dir("./test-vaulter.dir/log.dir/log-3.dir"));
	assert(make_dir("./test-vaulter.dir/group-3"));
	assert(make_dir("./test-vaulter.dir/group-3/vault-1"));
	assert(make_dir("./test-vaulter.dir/group-3/vault-1/2006-06-20"));
	assert(make_dir("./test-vaulter.dir/group-3/vault-1/2006-06-21"));
	assert(make_dir("./test-vaulter.dir/group-3/vault-1/2006-06-22"));
	assert(make_dir("./test-vaulter.dir/group-3/vault-1/2006-06-23"));
	assert(make_dir("./test-vaulter.dir/group-3/vault-1/2006-06-24"));

	out.open("./test-vaulter.dir/log.dir/log-3.dir/2006-06-20.log");
	assert(out.is_open());
	out << "Hello World" << std::endl;
	out.close();

	out.open("./test-vaulter.dir/log.dir/log-3.dir/2006-06-20.report");
	assert(out.is_open());
	out << "Hello World" << std::endl;
	out.close();

	out.open("./test-vaulter.dir/log.dir/log-3.dir/2006-06-21.relink");
	assert(out.is_open());
	out << "Hello World" << std::endl;
	out.close();

	out.open("./test-vaulter.dir/log.dir/log-3.dir/2006-06-22.log");
	assert(out.is_open());
	out << "Hello World" << std::endl;
	out.close();

	out.open("./test-vaulter.dir/log.dir/log-3.dir/2006-06-22.report");
	assert(out.is_open());
	out << "Hello World" << std::endl;
	out.close();

	out.open("./test-vaulter.dir/log.dir/log-3.dir/2006-06-23.log");
	assert(out.is_open());
	out << "Hello World" << std::endl;
	out.close();

	out.open("./test-vaulter.dir/log.dir/log-3.dir/2006-06-23.report");
	assert(out.is_open());
	out << "Hello World" << std::endl;
	out.close();

	out.open("./test-vaulter.dir/file-2.conf");
	assert(out.is_open());
	out << "log-dir ./test-vaulter.dir/log.dir/log-3.dir" << std::endl;
	out << "delete-old-log-files yes" << std::endl;
	out << "vault ./test-vaulter.dir/group-3/*" << std::endl;
	out << "vault-selection-behavior round-robin" << std::endl;
	out.close();

	out.open("./test-vaulter.dir/file-3.conf");
	assert(out.is_open());
	out << "log-dir ./test-vaulter.dir/log.dir/log-3.dir" << std::endl;
	out << "delete-old-report-files yes" << std::endl;
	out << "vault ./test-vaulter.dir/group-3/*" << std::endl;
	out << "vault-selection-behavior round-robin" << std::endl;
	out.close();

	out.open("./test-vaulter.dir/file-4.conf");
	assert(out.is_open());
	out << "log-dir ./test-vaulter.dir/log.dir/log-3.dir" << std::endl;
	out << "delete-old-log-files yes" << std::endl;
	out << "delete-old-report-files yes" << std::endl;
	out << "vault ./test-vaulter.dir/group-3/*" << std::endl;
	out << "vault-selection-behavior round-robin" << std::endl;
	out.close();

	out.open("./test-vaulter.dir/file-5.conf");
	assert(out.is_open());
	out << "log-dir ./test-vaulter.dir/log.dir/log-3.dir" << std::endl;
	out << "vault ./test-vaulter.dir/group-3/*" << std::endl;
	out << "vault-selection-behavior round-robin" << std::endl;
	out.close();
}

void cleanup(void)
{
	system("rm -fr ./test-vaulter.dir");
}

