#include "config.h"

#include <iostream>
#include <string>
#include <cassert>

#include "types.h"
#include "error.h"
#include "estring.h"
#include "strfmt.h"
#include "rmath.h"
#include "timer.h"

// #define ERR_OUT(e) std::cerr << e
#define ERR_OUT(e)

#define TEST(code) \
	try { \
		code; \
	} \
	catch(error e) { \
		ERR_OUT(e); \
		thrown = true; \
	} \
	catch(...) { \
		assert(0); \
	}


void test(void)
{
	const uint64 max = max_limit<uint64>();
	uint64 x;
	std::string s;
	std::string last_s;
	std::string::size_type s_len;
	std::string::size_type idx;
	timer t;
	int ip;
	double dp;

	t.start();
	for (x = 0; x != max; ++x) {
		s = percent_string(x,max);
		idx = s.find(".");
		s_len = s.size();
		if (last_s != s) {
			t.stop();
			dp = static_cast<double>(x) / static_cast<double>(max);
			ip = static_cast<unsigned int>(dp);
			std::cerr 
				<< "Test is " 
				<< s 
				<< " complete.  ETA: " 
				<< t.eta(ip)
				<< std::endl;
			last_s = s;
		}
		if (s_len - idx > 3)
			std::cerr 
				<< "percent_string(" 
				<< x 
				<< "," 
				<< max 
				<< ") = " 
				<< s
				<< std::endl;
	}
}

int main(int argc, char const * argv[])
{
	try {
		test();
	}
	catch(error e) {
		std::cerr << e;
		assert(0);
	}
	catch(...) {
		std::cerr << err_unknown;
		assert(0);
	}
	return(0);
}

