#ifndef __timer_h__
#define __timer_h__

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifdef TIME_WITH_SYS_TIME
	#include <sys/time.h>
	#include <time.h>
#else
	#ifdef HAVE_SYS_TIME_H
		#include <sys/time.h>
	#else
		#include <time.h>
	#endif
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <string>

#include "asserts.h"
#include "types.h"

/** Used as a stopwatch */
class timer
{
public:
	typedef time_t value_type;
	typedef double duration_type;

	timer();
	timer(const timer& a_timer);
	timer(const value_type a_start);
	timer(const value_type a_start, const value_type a_stop);

	void clear(void);
	void start(void);
	void stop(void);

	const value_type start_value(void) const;
	const value_type stop_value(void) const;

	void assign(const timer& a_timer);
	void assign(const value_type a_start);
	void assign(const value_type a_start, const value_type a_stop);

	timer& operator=(const timer& a_timer);

	void use_localtime(const bool a_switch);
	const bool use_localtime(void) const;

	const std::string started_at(void) const;
	const std::string stopped_at(void) const;
	const std::string duration(void) const;
	const std::string eta(unsigned int a_percent_complete) const;
	const std::string eta(unsigned int a_complete, unsigned int a_total) const;
	const std::string bps(uint64 a_bytes) const;

	const bool is_started(void) const;
	const bool is_stopped(void) const;

	const duration_type duration_secs(void) const;
	const duration_type duration_mins(void) const;
	const duration_type duration_hours(void) const;
	const duration_type duration_days(void) const;
	const duration_type duration_years(void) const;

private:
	value_type m_start;
	value_type m_stop;
	bool m_started;
	bool m_stopped;
	duration_type m_duration;
	bool m_use_localtime;

	void mf_start_value(const value_type a_t);
	void mf_stop_value(const value_type a_t);
	const duration_type mf_calculate_duration(
		const value_type a_start, const value_type a_stop) const;
	const std::string mf_make_timer_string(const value_type a_t) const;
	const std::string mf_make_string(const value_type a_t) const;
	const std::string mf_make_string(const duration_type a_d) const;
};

const std::string current_time(void);

/** A null timer */
const timer null_timer(0,0);

std::string stamp(const pid_t = 0, const int a_indention = 0);

#endif
