#include "config.h"

#include <cassert>
#include <string>

#include "asserts.h"
#include "types.h"

void test_u8(void)
{
	uint8 u8 = 0;
	uint8 u8_old = 0;
	unsigned int c = 0;

	u8 = 1;
	for (c = 0; u8 != u8_old; c++) {
		u8_old = u8;
		u8 <<= 1;
		u8 |= 1;
	}

	assert(c == 8);
}

void test_u16(void)
{
	uint16 u16 = 0;
	uint16 u16_old = 0;
	unsigned int c = 0;

	u16 = 1;
	for (c = 0; u16 != u16_old; c++) {
		u16_old = u16;
		u16 <<= 1;
		u16 |= 1;
	}

	assert(c == 16);
}

void test_u32(void)
{
	uint32 u32 = 0;
	uint32 u32_old = 0;
	unsigned int c = 0;

	u32 = 1;
	for (c = 0; u32 != u32_old; c++) {
		u32_old = u32;
		u32 <<= 1;
		u32 |= 1;
	}

	assert(c == 32);
}

void test_u64(void)
{
	uint64 u64 = 0;
	uint64 u64_old = 0;
	unsigned int c = 0;
	
	u64 = 1;
	for (c = 0; u64 != u64_old; c++) {
		u64_old = u64;
		u64 <<= 1;
		u64 |= 1;
	}

	assert(c == 64);
}

void test_type(void)
{
	char sc;
	unsigned char uc;
	short ss;
	unsigned short us;
	int si;
	unsigned int ui;
	long sl;
	unsigned long ul;
	long long sll;
	unsigned long long ull;
	float f;
	double d;
	bool b;

	assert( is_signed_char(sc));
	assert(!is_signed_char(uc));
	assert(!is_signed_char(ss));
	assert(!is_signed_char(us));
	assert(!is_signed_char(si));
	assert(!is_signed_char(ui));
	assert(!is_signed_char(sl));
	assert(!is_signed_char(ul));
	assert(!is_signed_char(sll));
	assert(!is_signed_char(ull));
	assert(!is_signed_char(f));
	assert(!is_signed_char(d));
	assert(!is_signed_char(b));

	assert(!is_unsigned_char(sc));
	assert( is_unsigned_char(uc));
	assert(!is_unsigned_char(ss));
	assert(!is_unsigned_char(us));
	assert(!is_unsigned_char(si));
	assert(!is_unsigned_char(ui));
	assert(!is_unsigned_char(sl));
	assert(!is_unsigned_char(ul));
	assert(!is_unsigned_char(sll));
	assert(!is_unsigned_char(ull));
	assert(!is_unsigned_char(f));
	assert(!is_unsigned_char(d));
	assert(!is_unsigned_char(b));

	assert(!is_signed_short(sc));
	assert(!is_signed_short(uc));
	assert( is_signed_short(ss));
	assert(!is_signed_short(us));
	assert(!is_signed_short(si));
	assert(!is_signed_short(ui));
	assert(!is_signed_short(sl));
	assert(!is_signed_short(ul));
	assert(!is_signed_short(sll));
	assert(!is_signed_short(ull));
	assert(!is_signed_short(f));
	assert(!is_signed_short(d));
	assert(!is_signed_short(b));

	assert(!is_unsigned_short(sc));
	assert(!is_unsigned_short(uc));
	assert(!is_unsigned_short(ss));
	assert( is_unsigned_short(us));
	assert(!is_unsigned_short(si));
	assert(!is_unsigned_short(ui));
	assert(!is_unsigned_short(sl));
	assert(!is_unsigned_short(ul));
	assert(!is_unsigned_short(sll));
	assert(!is_unsigned_short(ull));
	assert(!is_unsigned_short(f));
	assert(!is_unsigned_short(d));
	assert(!is_unsigned_short(b));

	assert(!is_signed_int(sc));
	assert(!is_signed_int(uc));
	assert(!is_signed_int(ss));
	assert(!is_signed_int(us));
	assert( is_signed_int(si));
	assert(!is_signed_int(ui));
	assert(!is_signed_int(sl));
	assert(!is_signed_int(ul));
	assert(!is_signed_int(sll));
	assert(!is_signed_int(ull));
	assert(!is_signed_int(f));
	assert(!is_signed_int(d));
	assert(!is_signed_int(b));

	assert(!is_unsigned_int(sc));
	assert(!is_unsigned_int(uc));
	assert(!is_unsigned_int(ss));
	assert(!is_unsigned_int(us));
	assert(!is_unsigned_int(si));
	assert( is_unsigned_int(ui));
	assert(!is_unsigned_int(sl));
	assert(!is_unsigned_int(ul));
	assert(!is_unsigned_int(sll));
	assert(!is_unsigned_int(ull));
	assert(!is_unsigned_int(f));
	assert(!is_unsigned_int(d));
	assert(!is_unsigned_int(b));

	assert(!is_signed_long(sc));
	assert(!is_signed_long(uc));
	assert(!is_signed_long(ss));
	assert(!is_signed_long(us));
	assert(!is_signed_long(si));
	assert(!is_signed_long(ui));
	assert( is_signed_long(sl));
	assert(!is_signed_long(ul));
	assert(!is_signed_long(sll));
	assert(!is_signed_long(ull));
	assert(!is_signed_long(f));
	assert(!is_signed_long(d));
	assert(!is_signed_long(b));

	assert(!is_unsigned_long(sc));
	assert(!is_unsigned_long(uc));
	assert(!is_unsigned_long(ss));
	assert(!is_unsigned_long(us));
	assert(!is_unsigned_long(si));
	assert(!is_unsigned_long(ui));
	assert(!is_unsigned_long(sl));
	assert( is_unsigned_long(ul));
	assert(!is_unsigned_long(sll));
	assert(!is_unsigned_long(ull));
	assert(!is_unsigned_long(f));
	assert(!is_unsigned_long(d));
	assert(!is_unsigned_long(b));

	assert(!is_signed_long_long(sc));
	assert(!is_signed_long_long(uc));
	assert(!is_signed_long_long(ss));
	assert(!is_signed_long_long(us));
	assert(!is_signed_long_long(si));
	assert(!is_signed_long_long(ui));
	assert(!is_signed_long_long(sl));
	assert(!is_signed_long_long(ul));
	assert( is_signed_long_long(sll));
	assert(!is_signed_long_long(ull));
	assert(!is_signed_long_long(f));
	assert(!is_signed_long_long(d));
	assert(!is_signed_long_long(b));

	assert(!is_unsigned_long_long(sc));
	assert(!is_unsigned_long_long(uc));
	assert(!is_unsigned_long_long(ss));
	assert(!is_unsigned_long_long(us));
	assert(!is_unsigned_long_long(si));
	assert(!is_unsigned_long_long(ui));
	assert(!is_unsigned_long_long(sl));
	assert(!is_unsigned_long_long(ul));
	assert(!is_unsigned_long_long(sll));
	assert( is_unsigned_long_long(ull));
	assert(!is_unsigned_long_long(f));
	assert(!is_unsigned_long_long(d));
	assert(!is_unsigned_long_long(b));

	assert(!is_float(sc));
	assert(!is_float(uc));
	assert(!is_float(ss));
	assert(!is_float(us));
	assert(!is_float(si));
	assert(!is_float(ui));
	assert(!is_float(sl));
	assert(!is_float(ul));
	assert(!is_float(sll));
	assert(!is_float(ull));
	assert( is_float(f));
	assert(!is_float(d));
	assert(!is_float(b));

	assert(!is_double(sc));
	assert(!is_double(uc));
	assert(!is_double(ss));
	assert(!is_double(us));
	assert(!is_double(si));
	assert(!is_double(ui));
	assert(!is_double(sl));
	assert(!is_double(ul));
	assert(!is_double(sll));
	assert(!is_double(ull));
	assert(!is_double(f));
	assert( is_double(d));
	assert(!is_double(b));

	assert(!is_bool(sc));
	assert(!is_bool(uc));
	assert(!is_bool(ss));
	assert(!is_bool(us));
	assert(!is_bool(si));
	assert(!is_bool(ui));
	assert(!is_bool(sl));
	assert(!is_bool(ul));
	assert(!is_bool(sll));
	assert(!is_bool(ull));
	assert(!is_bool(f));
	assert(!is_bool(d));
	assert( is_bool(b));

	assert(static_cast<std::string>(type_name(sc)) == "char");
	assert(static_cast<std::string>(type_name(uc)) == "unsigned char");
	assert(static_cast<std::string>(type_name(ss)) == "short");
	assert(static_cast<std::string>(type_name(us)) == "unsigned short");
	assert(static_cast<std::string>(type_name(si)) == "int");
	assert(static_cast<std::string>(type_name(ui)) == "unsigned int");
	assert(static_cast<std::string>(type_name(sl)) == "long");
	assert(static_cast<std::string>(type_name(ul)) == "unsigned long");
	assert(static_cast<std::string>(type_name(sll)) == "long long");
	assert(static_cast<std::string>(type_name(ull)) == "unsigned long long");
	assert(static_cast<std::string>(type_name(f)) == "float");
	assert(static_cast<std::string>(type_name(d)) == "double");
	assert(static_cast<std::string>(type_name(b)) == "bool");
}

int main(int argc, char const * argv[])
{
	test_u8();
	test_u16();
	test_u32();
	test_u64();
	test_type();
	return(0);
}
