#include "config.h"

#include <iostream>
#include <string>
#include <cassert>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <errno.h>

#include "asserts.h"
#include "types.h"
#include "error.h"
#include "estring.h"
#include "fs.h"
#include "tstamp.h"
#include "rconfig.h"
#include "test-rconfig-setup.h"

#define ERR_OUT(e) std::cerr << e;
// #define ERR_OUT(e)

void test(void)
{
	char const * argv[256] = { 0 };
	int argc = 0;
	bool thrown = false;
	std::vector<std::string> opt_vec;

	argv[argc++] = "<program>";
	argv[argc++] = "--archive";

	config.default_file("./test-rconfig.dir/job.dir/file-7.conf");
	config.default_logdir("./test-rconfig.dir/log.dir");
	try {
		config.init(argc, argv);
	}
	catch(error e) {
		ERR_OUT(e);
		thrown = true;
	}
	catch(...) {
		assert(0);
	}
	assert(!thrown);
	assert(config.default_job().groupname == "group-A");
	assert(config.default_job().hostname == "host-A");
	assert(config.default_job().rsync_behavior.default_value()
		== rsync_behavior::fail);
	assert(config.default_job().rsync_behavior.map_value().size() == 1);
	assert(config.default_job().rsync_behavior[5] == rsync_behavior::ok);
	assert(config.default_job().rsync_connection == job::connection_server);
	assert(config.default_job().rsync_hardlink == false);
	assert(config.default_job().rsync_options == "--some  -options for-rsync");
	assert(config.default_job().rsync_remote_user == "alice");
	assert(config.default_job().rsync_remote_port == 4338);
	assert(config.jobs().size() == 5);
	assert(config.jobs()[0].jobname == "job-A");
	assert(config.jobs()[0].groupname == "group-A");
	assert(config.jobs()[0].hostname == "host-A");
	assert(config.jobs()[0].rsync_behavior.default_value()
		== rsync_behavior::retry);
	assert(config.jobs()[0].rsync_behavior.map_value().size() == 9);
	assert(config.jobs()[0].rsync_behavior[0] == rsync_behavior::ok);
	assert(config.jobs()[0].rsync_behavior[1] == rsync_behavior::fail);
	assert(config.jobs()[0].rsync_behavior[2] == rsync_behavior::fail);
	assert(config.jobs()[0].rsync_behavior[4] == rsync_behavior::fail);
	assert(config.jobs()[0].rsync_behavior[23]
		== rsync_behavior::retry_without_hardlinks);
	assert(config.jobs()[0].rsync_behavior[124] == rsync_behavior::fail);
	assert(config.jobs()[0].rsync_behavior[125] == rsync_behavior::fail);
	assert(config.jobs()[0].rsync_behavior[126] == rsync_behavior::fail);
	assert(config.jobs()[0].rsync_behavior[127] == rsync_behavior::fail);
	assert(config.jobs()[0].rsync_connection == job::connection_local);
	assert(config.jobs()[0].rsync_hardlink == true);
	assert(config.jobs()[0].rsync_multi_hardlink == false);
	assert(config.jobs()[0].rsync_multi_hardlink_max == 20);
	assert(config.jobs()[0].rsync_options == "--some  -options for-rsync some more \"options for\" the\\trsync\\ program");
	opt_vec.clear();
	opt_vec = config.jobs()[0].generate_rsync_options_vector();
	assert(opt_vec[0] == "--some");
	assert(opt_vec[1] == "-options");
	assert(opt_vec[2] == "for-rsync");
	assert(opt_vec[3] == "some");
	assert(opt_vec[4] == "more");
	assert(opt_vec[5] == "options for");
	assert(opt_vec[6] == "the\trsync program");
	assert(opt_vec.size() == 7);
	assert(config.jobs()[0].rsync_remote_user == "");
	assert(config.jobs()[0].rsync_remote_port == 0);
	assert(config.jobs()[1].jobname.size() == 0);
	assert(config.jobs()[1].groupname == "group-A");
	assert(config.jobs()[1].hostname == "host-B");
	assert(config.jobs()[1].rsync_behavior.default_value()
		== rsync_behavior::fail);
	assert(config.jobs()[1].rsync_behavior.map_value().size() == 1);
	assert(config.jobs()[1].rsync_behavior.map_value().find(5)->second
		== rsync_behavior::ok);
	assert(config.jobs()[1].rsync_connection == job::connection_server);
	assert(config.jobs()[1].rsync_hardlink == false);
	assert(config.jobs()[1].rsync_remote_user == "alice");
	assert(config.jobs()[1].rsync_remote_port == 4338);
	assert(config.jobs()[2].hostname == "host-C");
	assert(config.jobs()[2].rsync_hardlink == true);
	assert(config.jobs()[2].rsync_multi_hardlink == true);
	assert(config.jobs()[2].rsync_multi_hardlink_max == 7);
	assert(config.jobs()[3].jobname == "job-D");
	assert(config.jobs()[3].rsync_options == "--some  -options for-rsync -e \"-i foo\"");
	opt_vec.clear();
	opt_vec = config.jobs()[3].generate_rsync_options_vector();
	assert(opt_vec[0] == "--some");
	assert(opt_vec[1] == "-options");
	assert(opt_vec[2] == "for-rsync");
	assert(opt_vec[3] == "-e");
	assert(opt_vec[4] == "-i foo");
	assert(config.jobs()[4].jobname == "job-E");
	assert(config.jobs()[4].rsync_options == "--some  -options for-rsync --rsh=\"/usr/bin/rsh -i foo\"");
	opt_vec.clear();
	opt_vec = config.jobs()[4].generate_rsync_options_vector();
	assert(opt_vec[0] == "--some");
	assert(opt_vec[1] == "-options");
	assert(opt_vec[2] == "for-rsync");
	assert(opt_vec[3] == "--rsh=/usr/bin/rsh -i foo");
}

int main(int argc, char const * argv[])
{
	cleanup();
	setup();
	try {
		test();
	}
	catch(error e) {
		std::cerr << e;
		assert(0);
	}
	catch(...) {
		std::cerr << err_unknown;
		assert(0);
	}
	cleanup();
	return(0);
}

