#include "config.h"

#include <iostream>
#include <string>
#include <cassert>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <errno.h>

#include "asserts.h"
#include "types.h"
#include "error.h"
#include "estring.h"
#include "fs.h"
#include "tstamp.h"
#include "rconfig.h"
#include "test-rconfig-setup.h"

#define ERR_OUT(e) std::cerr << e;
// #define ERR_OUT(e)

void test(void)
{
	char const * argv[256] = { 0 };
	int argc = 0;
	bool thrown = false;

	argv[argc++] = "<program>";
	argv[argc++] = "--archive";

	config.default_file("./test-rconfig.dir/job.dir/file-6.conf");
	config.default_logdir("./test-rconfig.dir/log.dir");
	try {
		config.init(argc, argv);
	}
	catch(error e) {
		ERR_OUT(e);
		thrown = true;
	}
	catch(...) {
		assert(0);
	}
	assert(!thrown);
	assert(config.default_job().excludes.size() == 1);
	assert(config.default_job().excludes[0] == 
		"./test-rconfig.dir/job.dir/../excludes.dir/excludes.group-B.file-1");
	assert(config.jobs().size() == 2);
	assert(config.jobs()[0].excludes.size() == 4);
	assert(config.jobs()[0].excludes[0] == 
		"./test-rconfig.dir/job.dir/../excludes.dir/excludes.group-A.file-1");
	assert(config.jobs()[0].excludes[1] == 
		"./test-rconfig.dir/job.dir/../excludes.dir/excludes.group-A.file-2");
	assert(config.jobs()[0].excludes[2] == 
		"./test-rconfig.dir/job.dir/../excludes.dir/excludes.group-A.file-3");
	assert(config.jobs()[0].excludes[3] == 
		"./test-rconfig.dir/job.dir/../excludes.dir/excludes.group-B.file-2");
	assert(config.jobs()[1].excludes.size() == 2);
	assert(config.jobs()[1].excludes[0] ==
		"./test-rconfig.dir/job.dir/../excludes.dir/excludes.group-B.file-1");
	assert(config.jobs()[1].excludes[1] ==
		"./test-rconfig.dir/job.dir/../excludes.dir/excludes.group-A.file-3");
}

int main(int argc, char const * argv[])
{
	cleanup();
	setup();
	try {
		test();
	}
	catch(error e) {
		std::cerr << e;
		assert(0);
	}
	catch(...) {
		std::cerr << err_unknown;
		assert(0);
	}
	cleanup();
	return(0);
}

