#ifndef __fdstream_h__
#define __fdstream_h__

#include <iostream>
#ifdef HAVE_STREAMBUF
#include <streambuf>
#endif
#include <cstdio>

#include <string.h>

class fdoutbuf : public std::streambuf
{
public:
	fdoutbuf();
	fdoutbuf(int a_fd);
	void attach(int a_fd);
	virtual int overflow(int a_c);
	virtual std::streamsize xsputn(const char* a_s, std::streamsize a_num);

protected:
	int m_fd;
};

class ofdstream : public std::ostream
{
public:
	ofdstream();
	ofdstream(int a_fd);
	void attach(int a_fd);
	int fd(void);

protected:
	fdoutbuf m_buf;
	int m_fd;
};

class fdinbuf : public std::streambuf
{
public:
	fdinbuf();
	fdinbuf(int a_fd);
	void attach(int a_fd);
	virtual int underflow(void);

protected:
	int m_fd;
	static const int m_buffer_size = 10;
	char m_buffer[m_buffer_size];
};

class ifdstream : public std::istream
{
public:
	ifdstream();
	ifdstream(int a_fd);
	void attach(int a_fd);
	int fd(void);

protected:
	fdinbuf m_buf;
	int m_fd;
};

#endif
