# Caretaker Maintainership

_(If this file is included in a project, you can find the list of current caretakers at the bottom.)_

In a small classical open-source project, maintainers do a lot, and if maintainers don't have time to do a lot, usually the project stalls.
Finding new maintainers is hard because few people actively want to take over all the responsibilities of a project.
There must be a different way.

With Caretaker Maintainership, "Maintainers" become "Caretakers".
Caretakers' only mandatory responsibility is to grant Releasers commit and publish access to the project.
Caretakers can of course still do other things as they wish.

Releasers are one of three kinds of contributors to a Caretaker project:
- Reporters are people who report bugs
- Builders write code, docs, make art, proofread, etc, **and open pull requests**
- Releasers do final polish, add to changelogs, etc as needed, and publish new versions.

You can of course have multiple roles.
A single-person project will have that person do all or almost all roles.
You're also not restricted to just these roles, or to follow them precisely.
Do whatever fits best!

Someone who wishes to be a Releaser **must** open an issue or contact the Caretakers in some other way and ask, detailing what they want to do.
That can be as limited as "merge this feature" or as open-ended as "work on the project during my free time".
- If accepted, a Caretaker then gives enough rights or permissions to the new Releaser that they may cut new releases of the project on their own.
- If the Releasership is for a limited purpose, the Releaser loses their rights (either relinquishes them on their own or is taken out of permissions by Caretakers) after they've done their bit.

**Caretaker maintainership is not suitable for commercial, high-stakes, or security projects!**

Also you may want to use one of the badges below on your readme and/or add the #caretaker tag to your github description so:
- People who want to contribute to Caretaker projects can find them, and
- People who want to *avoid using* Caretaker projects for whatever reason can do that.

[![Uses Caretaker Maintainership](https://badgen.net/badge/Caretaker/Maintainership%20👥%20/purple)](https://gist.github.com/passcod/7332390db1813f9bccb07e5cf3a9649b)
[![Uses Caretaker Maintainership](https://flat.badgen.net/badge/Caretaker/Maintainership%20👥%20/purple)](https://gist.github.com/passcod/7332390db1813f9bccb07e5cf3a9649b)

## Current Caretakers

- Félix Saparelli, @passcod on github and twitter
