A `rustc_deprecated` attribute wasn't paired with a `stable`/`unstable`
attribute.

Erroneous code example:

```compile_fail,E0549
#![feature(staged_api)]
#![stable(since = "1.0.0", feature = "test")]

#[rustc_deprecated(
    since = "1.0.1",
    reason = "explanation for deprecation"
)] // invalid
fn _deprecated_fn() {}
```

To fix this issue, you need to add also an attribute `stable` or `unstable`.
Example:

```
#![feature(staged_api)]
#![stable(since = "1.0.0", feature = "test")]

#[stable(since = "1.0.0", feature = "test")]
#[rustc_deprecated(
    since = "1.0.1",
    reason = "explanation for deprecation"
)] // ok!
fn _deprecated_fn() {}
```

See the [How Rust is Made and “Nightly Rust”][how-rust-made-nightly] appendix
of the Book and the [Stability attributes][stability-attributes] section of the
Rustc Dev Guide for more details.

[how-rust-made-nightly]: https://doc.rust-lang.org/book/appendix-07-nightly-rust.html
[stability-attributes]: https://rustc-dev-guide.rust-lang.org/stability.html
