# Summary

[Introduction](index.md)

* [Getting Started](getting-started/index.md)
    * [Installation](getting-started/installation.md)
    * [First Steps with Cargo](getting-started/first-steps.md)

* [Cargo Guide](guide/index.md)
    * [Why Cargo Exists](guide/why-cargo-exists.md)
    * [Creating a New Package](guide/creating-a-new-project.md)
    * [Working on an Existing Package](guide/working-on-an-existing-project.md)
    * [Dependencies](guide/dependencies.md)
    * [Package Layout](guide/project-layout.md)
    * [Cargo.toml vs Cargo.lock](guide/cargo-toml-vs-cargo-lock.md)
    * [Tests](guide/tests.md)
    * [Continuous Integration](guide/continuous-integration.md)
    * [Build Cache](guide/build-cache.md)

* [Cargo Reference](reference/index.md)
    * [Specifying Dependencies](reference/specifying-dependencies.md)
    * [The Manifest Format](reference/manifest.md)
    * [Configuration](reference/config.md)
    * [Environment Variables](reference/environment-variables.md)
    * [Build Scripts](reference/build-scripts.md)
    * [Publishing on crates.io](reference/publishing.md)
    * [Package ID Specifications](reference/pkgid-spec.md)
    * [Source Replacement](reference/source-replacement.md)
    * [External Tools](reference/external-tools.md)
    * [Unstable Features](reference/unstable.md)

* [Cargo Commands](commands/index.md)
    * [Build Commands](commands/build-commands.md)
        * [bench](commands/cargo-bench.md)
        * [build](commands/cargo-build.md)
        * [check](commands/cargo-check.md)
        * [clean](commands/cargo-clean.md)
        * [doc](commands/cargo-doc.md)
        * [fetch](commands/cargo-fetch.md)
        * [fix](commands/cargo-fix.md)
        * [run](commands/cargo-run.md)
        * [rustc](commands/cargo-rustc.md)
        * [rustdoc](commands/cargo-rustdoc.md)
        * [test](commands/cargo-test.md)
    * [Manifest Commands](commands/manifest-commands.md)
        * [generate-lockfile](commands/cargo-generate-lockfile.md)
        * [locate-project](commands/cargo-locate-project.md)
        * [metadata](commands/cargo-metadata.md)
        * [pkgid](commands/cargo-pkgid.md)
        * [update](commands/cargo-update.md)
        * [verify-project](commands/cargo-verify-project.md)
    * [Package Commands](commands/package-commands.md)
        * [init](commands/cargo-init.md)
        * [install](commands/cargo-install.md)
        * [new](commands/cargo-new.md)
        * [search](commands/cargo-search.md)
        * [uninstall](commands/cargo-uninstall.md)
    * [Publishing Commands](commands/publishing-commands.md)
        * [login](commands/cargo-login.md)
        * [owner](commands/cargo-owner.md)
        * [package](commands/cargo-package.md)
        * [publish](commands/cargo-publish.md)
        * [yank](commands/cargo-yank.md)
    * [General Commands](commands/general-commands.md)
        * [help](commands/cargo-help.md)
        * [version](commands/cargo-version.md)

* [FAQ](faq.md)
* [Appendix: Glossary](appendix/glossary.md)
