# The Rust Reference

[Introduction](introduction.md)

- [Notation](notation.md)

- [Lexical structure](lexical-structure.md)
    - [Input format](input-format.md)
    - [Keywords](keywords.md)
    - [Identifiers](identifiers.md)
    - [Comments](comments.md)
    - [Whitespace](whitespace.md)
    - [Tokens](tokens.md)
    - [Paths](paths.md)

- [Macros](macros.md)
    - [Macros By Example](macros-by-example.md)
    - [Procedural Macros](procedural-macros.md)

- [Crates and source files](crates-and-source-files.md)

- [Conditional compilation](conditional-compilation.md)

- [Items and attributes](items-and-attributes.md)
    - [Items](items.md)
        - [Modules](items/modules.md)
        - [Extern crates](items/extern-crates.md)
        - [Use declarations](items/use-declarations.md)
        - [Functions](items/functions.md)
        - [Type aliases](items/type-aliases.md)
        - [Structs](items/structs.md)
        - [Enumerations](items/enumerations.md)
        - [Unions](items/unions.md)
        - [Constant items](items/constant-items.md)
        - [Static items](items/static-items.md)
        - [Traits](items/traits.md)
        - [Implementations](items/implementations.md)
        - [External blocks](items/external-blocks.md)
    - [Type and lifetime parameters](items/generics.md)
    - [Associated Items](items/associated-items.md)
    - [Visibility and Privacy](visibility-and-privacy.md)
    - [Attributes](attributes.md)

- [Statements and expressions](statements-and-expressions.md)
    - [Statements](statements.md)
    - [Expressions](expressions.md)
        - [Literal expressions](expressions/literal-expr.md)
        - [Path expressions](expressions/path-expr.md)
        - [Block expressions](expressions/block-expr.md)
        - [Operator expressions](expressions/operator-expr.md)
        - [Grouped expressions](expressions/grouped-expr.md)
        - [Array and index expressions](expressions/array-expr.md)
        - [Tuple and index expressions](expressions/tuple-expr.md)
        - [Struct expressions](expressions/struct-expr.md)
        - [Enum variant expressions](expressions/enum-variant-expr.md)
        - [Call expressions](expressions/call-expr.md)
        - [Method call expressions](expressions/method-call-expr.md)
        - [Field access expressions](expressions/field-expr.md)
        - [Closure expressions](expressions/closure-expr.md)
        - [Loop expressions](expressions/loop-expr.md)
        - [Range expressions](expressions/range-expr.md)
        - [If and if let expressions](expressions/if-expr.md)
        - [Match expressions](expressions/match-expr.md)
        - [Return expressions](expressions/return-expr.md)

- [Patterns](patterns.md)

- [Type system](type-system.md)
    - [Types](types.md)
        - [Boolean type](types/boolean.md)
        - [Numeric types](types/numeric.md)
        - [Textual types](types/textual.md)
        - [Never type](types/never.md)
        - [Tuple types](types/tuple.md)
        - [Array types](types/array.md)
        - [Slice types](types/slice.md)
        - [Struct types](types/struct.md)
        - [Enumerated types](types/enum.md)
        - [Union types](types/union.md)
        - [Function item types](types/function-item.md)
        - [Closure types](types/closure.md)
        - [Pointer types](types/pointer.md)
        - [Function pointer types](types/function-pointer.md)
        - [Trait object types](types/trait-object.md)
        - [Impl trait type](types/impl-trait.md)
        - [Type parameters](types/parameters.md)
        - [Inferred type](types/inferred.md)
    - [Dynamically Sized Types](dynamically-sized-types.md)
    - [Type layout](type-layout.md)
    - [Interior mutability](interior-mutability.md)
    - [Subtyping and Variance](subtyping.md)
    - [Trait and lifetime bounds](trait-bounds.md)
    - [Type coercions](type-coercions.md)
    - [Destructors](destructors.md)
    - [Lifetime elision](lifetime-elision.md)

- [Special types and traits](special-types-and-traits.md)

- [Memory model](memory-model.md)
    - [Memory allocation and lifetime](memory-allocation-and-lifetime.md)
    - [Memory ownership](memory-ownership.md)
    - [Variables](variables.md)

- [Linkage](linkage.md)

- [Unsafety](unsafety.md)
    - [Unsafe functions](unsafe-functions.md)
    - [Unsafe blocks](unsafe-blocks.md)
    - [Behavior considered undefined](behavior-considered-undefined.md)
    - [Behavior not considered unsafe](behavior-not-considered-unsafe.md)

- [Constant Evaluation](const_eval.md)

[Appendix: Influences](influences.md)

[Appendix: As-yet-undocumented Features](undocumented.md)

[Appendix: Glossary](glossary.md)
