# Support of rust bootstrap on a legacy system

This repository supported a series of patches that are needed to make full
bootstrap of rust by [mrustc] on officially unsupported systems.

Each supported rust version keeps as a dedicated orphan branch with a series of
needed patches. Anyway, the default branch contains an exported version of all
needed patches as one file.

Some systems may require to use of an additional library which provides some
missed system calls. Like `linkat` for legacy macOS. If you're using that system
you must define the environment variable: `RUST_LEGACY_LIBRARY_NAME` which
contains the library name and optionally `RUST_LEGACY_LIBRARY_PATH` to specify
which folder should be used to look for the library. Rust's `libstd` is linked
against this library. By default it uses static linking. When library's name
starts with `-l'`, it forces to use dynamic linking.

## macOS 10.6

First of all, you need `libc++`. The system doesn't ship any `libc++` :) I
suggest you use [libcxx]. Anyway, when you build your `libc++` keep in mind that
it should expose symbol `__cxa_thread_atexit`.

The easier way to have such `libc++` is using [MacPorts] and install `libcxx`
with enabled variants `+emulated_tls`.

Ok, the next things: a lot of modern things aren't supported by crypto-API from
macOS 10.6, and I've switched to OpenSSL. I suggest to use 1.1 branch as the
most universal and easy to use. Yeah, `OPENSSL_DIR` is your friend here.

[mrustc]: https://github.com/thepowersgang/mrustc
[libcxx]: https://libcxx.llvm.org
[MacPorts]: https://www.macports.org
