use crate::quote;

/// This file has been generated from `assets\tokens.yaml`
/// DO NOT modify by hand!

pub(crate) fn kind_from_ident(ident: &str) -> Option<quote::Kind> {
    match ident {
        "abstract" => Some(quote::Kind("Abstract")),
        "alignof" => Some(quote::Kind("AlignOf")),
        "as" => Some(quote::Kind("As")),
        "async" => Some(quote::Kind("Async")),
        "await" => Some(quote::Kind("Await")),
        "become" => Some(quote::Kind("Become")),
        "break" => Some(quote::Kind("Break")),
        "const" => Some(quote::Kind("Const")),
        "continue" => Some(quote::Kind("Continue")),
        "crate" => Some(quote::Kind("Crate")),
        "default" => Some(quote::Kind("Default")),
        "do" => Some(quote::Kind("Do")),
        "else" => Some(quote::Kind("Else")),
        "enum" => Some(quote::Kind("Enum")),
        "extern" => Some(quote::Kind("Extern")),
        "false" => Some(quote::Kind("False")),
        "final" => Some(quote::Kind("Final")),
        "fn" => Some(quote::Kind("Fn")),
        "for" => Some(quote::Kind("For")),
        "if" => Some(quote::Kind("If")),
        "impl" => Some(quote::Kind("Impl")),
        "in" => Some(quote::Kind("In")),
        "is" => Some(quote::Kind("Is")),
        "let" => Some(quote::Kind("Let")),
        "loop" => Some(quote::Kind("Loop")),
        "macro" => Some(quote::Kind("Macro")),
        "match" => Some(quote::Kind("Match")),
        "mod" => Some(quote::Kind("Mod")),
        "move" => Some(quote::Kind("Move")),
        "mut" => Some(quote::Kind("Mut")),
        "not" => Some(quote::Kind("Not")),
        "offsetof" => Some(quote::Kind("OffsetOf")),
        "override" => Some(quote::Kind("Override")),
        "priv" => Some(quote::Kind("Priv")),
        "proc" => Some(quote::Kind("Proc")),
        "pub" => Some(quote::Kind("Pub")),
        "pure" => Some(quote::Kind("Pure")),
        "ref" => Some(quote::Kind("Ref")),
        "return" => Some(quote::Kind("Return")),
        "select" => Some(quote::Kind("Select")),
        "Self" => Some(quote::Kind("SelfType")),
        "self" => Some(quote::Kind("SelfValue")),
        "sizeof" => Some(quote::Kind("SizeOf")),
        "static" => Some(quote::Kind("Static")),
        "struct" => Some(quote::Kind("Struct")),
        "super" => Some(quote::Kind("Super")),
        "true" => Some(quote::Kind("True")),
        "typeof" => Some(quote::Kind("TypeOf")),
        "unsafe" => Some(quote::Kind("Unsafe")),
        "use" => Some(quote::Kind("Use")),
        "virtual" => Some(quote::Kind("Virtual")),
        "while" => Some(quote::Kind("While")),
        "yield" => Some(quote::Kind("Yield")),
        _ => None,
    }
}

pub(crate) fn kind_from_punct(buf: &[char]) -> Option<quote::Kind> {
    match buf {
        ['&', '\0', '\0'] => Some(quote::Kind("Amp")),
        ['&', '&', '\0'] => Some(quote::Kind("AmpAmp")),
        ['&', '=', '\0'] => Some(quote::Kind("AmpEq")),
        ['-', '>', '\0'] => Some(quote::Kind("Arrow")),
        ['@', '\0', '\0'] => Some(quote::Kind("At")),
        ['!', '\0', '\0'] => Some(quote::Kind("Bang")),
        ['!', '=', '\0'] => Some(quote::Kind("BangEq")),
        ['^', '\0', '\0'] => Some(quote::Kind("Caret")),
        ['^', '=', '\0'] => Some(quote::Kind("CaretEq")),
        [':', '\0', '\0'] => Some(quote::Kind("Colon")),
        [':', ':', '\0'] => Some(quote::Kind("ColonColon")),
        [',', '\0', '\0'] => Some(quote::Kind("Comma")),
        ['-', '\0', '\0'] => Some(quote::Kind("Dash")),
        ['-', '=', '\0'] => Some(quote::Kind("DashEq")),
        ['/', '\0', '\0'] => Some(quote::Kind("Div")),
        ['$', '\0', '\0'] => Some(quote::Kind("Dollar")),
        ['.', '\0', '\0'] => Some(quote::Kind("Dot")),
        ['.', '.', '\0'] => Some(quote::Kind("DotDot")),
        ['.', '.', '='] => Some(quote::Kind("DotDotEq")),
        ['=', '\0', '\0'] => Some(quote::Kind("Eq")),
        ['=', '=', '\0'] => Some(quote::Kind("EqEq")),
        ['>', '\0', '\0'] => Some(quote::Kind("Gt")),
        ['>', '=', '\0'] => Some(quote::Kind("GtEq")),
        ['>', '>', '\0'] => Some(quote::Kind("GtGt")),
        ['>', '>', '='] => Some(quote::Kind("GtGtEq")),
        ['<', '\0', '\0'] => Some(quote::Kind("Lt")),
        ['<', '=', '\0'] => Some(quote::Kind("LtEq")),
        ['<', '<', '\0'] => Some(quote::Kind("LtLt")),
        ['<', '<', '='] => Some(quote::Kind("LtLtEq")),
        ['%', '\0', '\0'] => Some(quote::Kind("Perc")),
        ['%', '=', '\0'] => Some(quote::Kind("PercEq")),
        ['|', '\0', '\0'] => Some(quote::Kind("Pipe")),
        ['|', '=', '\0'] => Some(quote::Kind("PipeEq")),
        ['|', '|', '\0'] => Some(quote::Kind("PipePipe")),
        ['+', '\0', '\0'] => Some(quote::Kind("Plus")),
        ['+', '=', '\0'] => Some(quote::Kind("PlusEq")),
        ['#', '\0', '\0'] => Some(quote::Kind("Pound")),
        ['?', '\0', '\0'] => Some(quote::Kind("QuestionMark")),
        ['=', '>', '\0'] => Some(quote::Kind("Rocket")),
        [';', '\0', '\0'] => Some(quote::Kind("SemiColon")),
        ['/', '=', '\0'] => Some(quote::Kind("SlashEq")),
        ['*', '\0', '\0'] => Some(quote::Kind("Star")),
        ['*', '=', '\0'] => Some(quote::Kind("StarEq")),
        ['~', '\0', '\0'] => Some(quote::Kind("Tilde")),
        ['_', '\0', '\0'] => Some(quote::Kind("Underscore")),
        _ => None,
    }
}
