require 'ftools'
require 'find'

def instdir
  begin
    require 'rbconfig'
    libdir = Config::CONFIG['sitedir'] + "/" + 
             Config::CONFIG['MAJOR'] + "." +
             Config::CONFIG['MINOR']
  rescue ScriptError
    $LOAD_PATH.each do |l|
      if l =~ /site_ruby/ && l =~ /\d$/ && l !~ /#{PLATFORM}/
	libdir = l
	break
      end
    end
    STDERR.puts "Hmm... rbconfig.rb cannot load."
    STDERR.puts "The library (webfetcher.rb) is installed to #{libdir}"
  end
  return libdir
end

INSTLIBDIR = instdir

def inst_lib(file, mode)
  to = File.join(INSTLIBDIR,file)
  File.install(file, to, mode, true)
end

inst_lib('webfetcher.rb', 0644)
