require 'webfetcher'
include WebFetcher

RECURSE = proc {|page, i, total| puts "recurse #{page} (#{i} of #{total})"}
SAVE = proc {|file, page, i, total| puts  "saving #{file} (#{i} of #{total})"}

# Download a month of dilbert comics
def dilbert
    archive = Page.url('http://www.dilbert.com/comics/dilbert/archive/') 
    date_pages = archive.links.delete_if {|x| !x.url[/dilbert-\d+\.html/]}
    images = date_pages.images.delete_if {|x| !x.url[/dilbert\d+\.gif$/]}
    images.save('dilbert', &SAVE)
end

# Download "Programming Ruby"
def pickaxe
    book = Page.url('http://www.rubycentral.com/book/') 
    book.recurse(&RECURSE).save('pickaxe', &SAVE)
end

# Download images of rubies from google
def rubies
    google = Page.url('http://images.google.com/images?q=ruby')
    images = google.images.delete_if {|x| !x.url['q=']}
    images.save('rubies', :rename_all, &SAVE)
end

# Download ScottMcClouds impro comics
def scott
    page = Page.url('http://www.scottmccloud.com/comics/mi/mi.html')
    pc = page.recurse(&RECURSE).rich_page.save('scott', &SAVE)
end

ok = %w(dilbert pickaxe rubies scott)
ARGV.each {|x|
    if !ok.include?(x)
        $stderr.puts "#{x} is not in #{ok.join ' '}"
    else
        method(x.intern).call
    end
}
if ARGV.size == 0
    $stderr.puts "specify one of #{ok.join ' '}"
end

# vim: set sw=4:
