require "win32ole"
require "socket"
require "parsedate"

module Sys
   class UptimeError < StandardError; end
   class Uptime
      VERSION = "0.4.0"
      def self.boot_time(host=Socket.gethostname)
         cs = "winmgmts://#{host}/root/cimv2"
         begin
            wmi = WIN32OLE.connect(cs)
         rescue WIN32OLERuntimeError => e
            raise UptimeError, e
         else
            query = "select LastBootupTime from Win32_OperatingSystem"
            results = wmi.ExecQuery(query)
            results.each{ |ole|
               time_array = ParseDate.parsedate(ole.LastBootupTime)
               return Time.mktime(*time_array)
            }
         end
      end
      
      def self.uptime(host=Socket.gethostname)
         arr = self.get_dhms(host)
         return arr.join(":")
      end
      
      def self.dhms(host=Socket.gethostname)
         return self.get_dhms(host)
      end
      
      def self.days(host=Socket.gethostname)
         return self.get_dhms(host).first
      end
      
      def self.hours(host=Socket.gethostname)
         return self.get_dhms(host)[1]
      end
      
      def self.minutes(host=Socket.gethostname)
         return self.get_dhms(host)[2]
      end
      
      def self.seconds(host=Socket.gethostname)
         return self.get_dhms(host).last
      end
      
      private
      
      def self.get_dhms(host)
         cs = "winmgmts://#{host}/root/cimv2"
         begin
            wmi = WIN32OLE.connect(cs)
         rescue WIN32OLERuntimeError => e
            raise UptimeError, e
         else
            query = "select LastBootupTime from Win32_OperatingSystem"
            results = wmi.ExecQuery(query)
            now = Time.now
            
            results.each{ |ole|
               time_array = ParseDate.parsedate(ole.LastBootupTime)
               boot_time = Time.mktime(*time_array)
               break
            }
            
            seconds = (now - boot_time).to_i
            days = (seconds / 86400).to_i
            seconds -= days * 86400
            hours = seconds / 3600
            seconds -= hours * 3600
            minutes = seconds / 60
            seconds -= minutes * 60
            return [days,hours,minutes,seconds]
         end
      end
   end
end