# $kNotwork: product.rb,v 1.2 2004/04/23 09:38:24 gotoken Exp $

class Product
  include Enumerable

  def initialize(ary)
    ary.is_a?(Array) or raise ArgumentError, "value must be an array"
    car, *cdr = ary
    car.is_a?(Enumerable) or raise ArgumentError, "value must be enumerable"
    @car = car
    @cdr = cdr.empty? ? nil : Product.new(cdr)
  end
  
  attr_reader :car, :cdr
  protected :car, :cdr

  def *(enum)
    enum.is_a?(Enumerable) or
      raise(ArgumentError, "non-enumerable argument type `#{enum.class}'")

    if enum.is_a?(Product)
      self.class.new(components.push(*enum.components))
    else
      self.class.new(components << enum)
    end
  end

  alias product *

  def **(n)
    n.is_a?(Integer) or
      raise(ArgumentError, 
            "no implicit conversion to Integer `#{n.inspect}'")
    
    if n < 1
      raise(ArgumentError, "non-positive argument `#{n.inspect}'")
    elsif n == 1
      self
    else
      a = self
      (n-1).times{|i| a *= self}
      a
    end
  end

  alias power **

  def do_each(prefix, list, &block)
    list.nil? and return yield(prefix.dup)
    list.car.each{ |o|
      prefix << o
      do_each(prefix, list.cdr, &block)
      prefix.delete_at(-1)
    }
  end

  private :do_each

  def each(&block)
    @car.each{ |o|
      do_each([o], @cdr, &block)
    }
  end

  def to_a
    ary = []
    each{|i| ary << i}
    ary
  end
  
  def components
    @cdr.nil? ? [@car] : [@car, *@cdr.components]
  end

  InspectKey = :__inspect_key__

  def inspect
    save = (Thread.current[InspectKey] ||= [])

    if Thread.current[InspectKey].include?(__id__)
      return format('#<%s:0x%x ...>', self.class.name, __id__*2)
    end

    begin
      Thread.current[InspectKey] = [__id__]
      format("#<%s:0x%x %s>", 
             self.class, __id__*2, components.map{|i|
               i.is_a?(Range) ? "(#{i.inspect})" : i.inspect
             }.join("*"))
    ensure
      Thread.current[InspectKey] = save
    end
  end

  To_sKey = :__to_s_key__

  def to_s
    save = (Thread.current[To_sKey] ||= [])

    if Thread.current[To_sKey].include?(__id__)
      return format('(...)', self.class.name, __id__*2)
    end

    begin
      Thread.current[To_sKey] = [__id__]
      components.map{|i|
        i.is_a?(Range) ? "(#{i.inspect})" : i.inspect
      }.join("*")
    ensure
      Thread.current[To_sKey] = save
    end
  end

  module MixinForEnumerable
    def *(enum)
      enum.is_a?(Enumerable) or
        raise(ArgumentError, "non-enumerable argument type `#{enum.class}'")
      Product.new([self])*enum
    end

    alias product *

    def **(n)
      n.is_a?(Integer) or
        raise(ArgumentError, 
              "no implicit conversion to Integer `#{n.inspect}'")

      if n < 1
        raise(ArgumentError, "non-positive argument `#{n.inspect}'")
      elsif n == 1
        self
      else
        a = Product.new([self])
        (n-1).times{|i| a *= self}
        a
      end
    end

    alias power **
  end    

  module OverrideForEnumerable
    include ::Product::MixinForEnumerable
    def self.append_features(mod)
      super

      im = mod.instance_methods(false)

      if im.include?('*')
        mod.class_eval <<-EOS
          alias_method(:__times__, :*)
          def *(x)
            x.is_a?(Enumerable) ? product(x) : __times__(x)
          end
        EOS
      end

      if im.include?('**')
        mod.class_eval <<-EOS
          alias_method(:__power__, :**)
          def **(x)
            x.is_a?(Enumerable) ? power(x) : __power__(x)
          end
        EOS
      end
    end
  end
end
