require "rjab/rexml/text"

module REXML
	class CData < Text
		START = '<![CDATA['
		START_RE = /\A<!\[CDATA\[/u
		STOP = ']]>'
		PATTERN = /#{Regexp.escape(START)}(.*?)#{Regexp.escape(STOP)}/um

		##
		#	Constructor.  CData is data between <![CDATA[ ... ]]>
		#	@param first If a Source, then CData is parsed directly from the
		#	source.  Otherwise, all arguments are passed to the superclass
		#	constructor, Text.
		def initialize( first, whitespace=nil, parent=nil )
			super( first, whitespace, parent, PATTERN, true )
		end

		def clone
			CData.new self
		end

		def to_s
			@string
		end

		def write( output, indent )
			indent( output, indent )
			output << START
			output << @string
			output << STOP
		end

		def CData.parse_stream(source, listener)
			listener.cdata(source.match( PATTERN, true )[1])
		end
	end
end
