require "net/pingsimple"

tu = true
begin
   require "test/unit"
rescue LoadError
   tu = false
end

# Run the test suite if testnit is installed or our basic test otherwise
if tu
   require "test/tc_pingtcp"
   require "test/tc_pingudp"
   require "test/tc_pingexternal"
else
   host = ARGV[0] || "www.ruby-lang.org"

   Net::PingTCP.ecr = true
   tcp = Net::PingTCP.new(host)

   pu = Net::PingUDP.new(host)
   pe = Net::PingExternal.new(host)

   if tcp.ping?
      puts "TCP ping successful"
      unless tcp.warning.nil?
         puts "TCP warning: " + tcp.warning
      end
   else
      puts "TCP ping unsuccessful: " +  tcp.exception
   end

   if pu.ping?
      puts "UDP ping successful"
   else
      puts "UDP ping unsuccessful: " +  pu.exception
   end

   if pe.ping?
      puts "External ping successful"
      unless pe.warning.nil?
         puts "Warning: " + pe.warning
      end
   else
      puts "External ping unsuccessful: " +  pe.exception
   end
end
