################################################################
# tc_pingudp.rb
#
# Test case for the Net::PingUDP class
#
# If someone could provide me a host where a udp ping actually
# works, I would appreciate it. :)
################################################################
require "ftools"

if caller.first =~ /test\.rb/
   base_dir = Dir.pwd
else
   base_dir = File.dirname(Dir.pwd)
end

net_dir = base_dir + "/net"
ping_file = net_dir + "/pingsimple.rb"

$:.unshift base_dir
$:.unshift Dir.pwd

require "test/unit"
require "net/pingsimple"
include Net

class TC_PingUDP < Test::Unit::TestCase
   def setup
      @host = "www.ruby-lang.org"
   end

   def test_01_version
      assert_equal("0.3.0",PingUDP::VERSION,"Bad version constant")
   end

   def test_02_ping_standard
      @udp = PingUDP.new(@host)
      assert_equal(false,@udp.ping?,"Bad ping")
      assert_equal(false,@udp.exception.nil?,"Bad exception data")
   end

   def teardown
      @host = nil
      @udp  = nil
   end
end
