class CocoaRef::DataTypeDef < CocoaRef::MethodDef
  attr_accessor :fields
  def initialize
    super
    @fields = ''
  end
  
  def to_rdoc
    str  = ''
    str += "  # This is a ruby wrapped class generated by BridgeSupport.\n"
    str += "  #\n"
    str += "  # Description::  #{@description.rdocify}\n"  unless @description.empty?
    unless @discussion.empty?
      index = 0
      @discussion.each do |paragraph|
        if index.zero?
          str += "  # Discussion::   #{paragraph.rdocify}\n"
        else
          str += "  #                #{paragraph.rdocify}\n"
        end
        str += "  #\n"
        index = index.next
      end
    end
    str += "  # Definition::   #{@definition.rdocify}\n" unless @definition.empty?
    str += "  # Availability:: #{@availability.rdocify}\n" unless @availability.empty?
    unless @see_also.empty?
      str += "  # See also::     "
      @see_also.each do |s|
        str += "<tt>#{s.to_rb_def}</tt> " unless s.empty?
      end
      str += "\n"
    end
    
    begin
      fields = OSX.const_get(@name).fields
      str += "  class #{@name}\n"
      str += "    attr_accessor :#{fields.join(', :')}\n" unless fields.empty?
      unless OSX.const_get(@name).opaque?
        str += "    def initialize(#{fields.join(', ')})\n"
        str += "    end\n\n"
        str += "    # :call-seq:\n"
        str += "    #   to_a => [#{fields.join(', ')}]\n"
        str += "    #\n"
        str += "    # Returns the values of the fields as an Array.\n"
        str += "    def to_a\n"
        str += "    end\n\n"
      end
      str += "    # :call-seq:\n"
      str += "    #   == => true or false\n"
      str += "    #\n"
      str += "    # Compares the #{@name} instance to another #{@name} instance.\n"
      str += "    def ==(other)\n"
      str += "    end\n"
      str += "  end\n\n"
    rescue OSX::OCMessageSendException
      str += "\n\n"
    end
  
    return str
  end
end