macro(ClangVersion path version_major version_minor)
  if(EXISTS "${path}/clang/Basic/Version.inc")
    file(READ "${path}/clang/Basic/Version.inc" CLANG_VERSION_DATA)
    string(REGEX REPLACE ";" "\\\\;" CLANG_VERSION_DATA ${CLANG_VERSION_DATA})
    string(REGEX REPLACE "\n" ";" CLANG_VERSION_DATA ${CLANG_VERSION_DATA})
    foreach(line ${CLANG_VERSION_DATA})
      string(REGEX REPLACE "^#define CLANG_VERSION ([0-9]+\\.[0-9]+)$" "\\1" CLANG_VERSION_STRING ${line})
      if(DEFINED CLANG_VERSION_STRING)
	string(REGEX REPLACE "^([0-9]+)\\.[0-9]+$" "\\1" CLANG_VERSION_MAJOR ${CLANG_VERSION_STRING})
	string(REGEX REPLACE "^[0-9]+\\.([0-9]+)$" "\\1" CLANG_VERSION_MINOR ${CLANG_VERSION_STRING})
	if(NOT ${CLANG_VERSION_MAJOR} STREQUAL "" AND NOT ${CLANG_VERSION_MINOR} STREQUAL "")
          break()
        endif()
      endif()
    endforeach()
  endif()
  if(NOT ${CLANG_VERSION_MAJOR} STREQUAL "" AND NOT ${CLANG_VERSION_MINOR} STREQUAL "")
    set(${version_major} ${CLANG_VERSION_MAJOR})
    set(${version_minor} ${CLANG_VERSION_MINOR})
  else()
    message(FATAL_ERROR "Unable to parse ClangVersion from ${path}/clang/Basic/Version.inc")
  endif()
endmacro()
