
IF ( NOT EXISTS ${LIBRARY} )
    MESSAGE ( FATAL_ERROR "The provided file ${LIBRARY} does not exist" )
    RETURN ()
ENDIF ( NOT EXISTS ${LIBRARY} )

SET ( TARGET_PATH "${TARGET}" )

IF ( EXISTS ${TARGET} AND NOT IS_DIRECTORY ${TARGET} )
	FILE ( TO_NATIVE_PATH "${TARGET}" TARGET_PATH )
	IF ( EXISTS ${TARGET_PATH} )
		GET_FILENAME_COMPONENT ( TARGET_PATH ${TARGET} PATH )
	ENDIF ( EXISTS ${TARGET_PATH} )
ENDIF ( EXISTS ${TARGET} AND NOT IS_DIRECTORY ${TARGET} )

IF ( NOT EXISTS ${TARGET_PATH} AND NOT IS_DIRECTORY ${TARGET_PATH} )
    MESSAGE ( FATAL_ERROR "The provided target ${TARGET_PATH} does not exist, and is not a directory" )
    RETURN ()
ENDIF ( NOT EXISTS ${TARGET_PATH} AND NOT IS_DIRECTORY ${TARGET_PATH} )
SET ( OUTPUT_TARGET ${TARGET_PATH} )

FILE ( TO_NATIVE_PATH "${LIBRARY}" NATIVE_LIBRARY_PATH )
FILE ( TO_NATIVE_PATH "${OUTPUT_TARGET}/" NATIVE_TARGET_PATH )

#MESSAGE ( STATUS "Copying ${NATIVE_LIBRARY_PATH} => ${NATIVE_TARGET_PATH}" )

FILE ( COPY ${NATIVE_LIBRARY_PATH} DESTINATION ${NATIVE_TARGET_PATH} )

