/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#include "../Globals.h"
#include "ScriptSquadron.h"

namespace Scripting {

ScriptSquadron::ScriptSquadron(Squadron* i_squad): squad(i_squad) {
}

void ScriptSquadron::select() {
	sides[squad->my_side].selected_squads.push_back(CoordsInt(squad->my_side, squad->my_squad));
}

void ScriptSquadron::highlight() {
	sides[squad->my_side].highlighted_squads.push_back(squad->my_squad);
}

}

