/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_World
#define GUARD_World

#include "Projectile.h"
#include "scripting/ScriptManager.h"
#include "Sound.h"
#include "Terrain.h"

#include <vector>
#include <list>
#include <map>

enum ScriptAnim {ANIM_NONE, ANIM_BOMBARDMENT, ANIM_INVASION};

class World {
public:
	World(): update_interval(standard_interval), scroll_interval(standard_interval), paused(false) {}
	
	void load_mission(const std::string& mission_file);
	void init();
	void shutdown();
	bool update_squad_selection();
	void run();
	void draw();

	void mouse_d(Uint8 button, Uint16 x, Uint16 y);
	void mouse_u(Uint8 button, Uint16 x, Uint16 y);
	void mouse_m(Uint8 state, Uint16 x, Uint16 y);
	void keyboard(SDL_keysym& keysym);

	void play_sound(float x, float y, SoundEffect which);
	void play_sound(SDL_Rect rect, SoundEffect which);
	void do_ion_pulse();

	void pause(bool by_script);
	void unpause(bool by_script);
	void set_update_interval(int new_value);

	std::string mission_folder_name;
	std::string mission_folder;
	std::wstring mission_name;
	std::wstring mission_briefing;
	int mission_number;
	int width;
	int height;

	int frame_counter;
	//set to now in rtsinit
	int last_ai_time;
	//set to now in rtsinit
	int last_scroll_time;
	int update_interval;
	int scroll_interval;

	bool paused;
	bool paused_by_script;
	bool cut_scene_on;
	ScriptAnim script_anim;
	bool mission_completed;
	bool radar_sharing;
	bool rem_side_dead[max_players];

	int viewx;
	int viewy;
	int view_side;
	int view_squad;

	//for sound alerts
	bool cap_found;
	bool frigate_found;
	bool bomber_found;
	bool rem_cap_found;
	bool rem_frigate_found;
	bool rem_bomber_found;

	std::vector< std::vector<TerrainTile> > terrain_tiles;
	std::list<Projectile> projectiles;
	std::map<std::wstring, AIScript> ai_scripts;

	ScriptManager script_manager;

private:
	void distribute_ai_frames();
	void setup_terrain();
	void set_starting_positions();

	void scroll(int x, int y);
	void update_cursor_type(int x, int y);

	void run_scanning();
	void run_group_ai();
	void run_move_commands();
	void run_fire_commands();
	void upkeep();

	void draw_terrain();
	void draw_ion_pulse();
	void draw_fog_of_war();
	void check_view_pos();

	std::vector<ForegroundPic> foreground_pics;
	ScaledPic background_pic;
	std::map<std::wstring, ScaledPic> terrain_pictures;

	std::list<CoordsInt> old_selected_squads;
	CoordsInt drag_box_start;
	SDL_Rect drag_box;
	int last_alert_sound;
	float ion_alpha;
	int anim_timer;

	static const int min_alert_gap = 30;
};

#endif
