/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.

   See the COPYING file for more details.
*/

#ifndef GUARD_Stuff
#define GUARD_Stuff

#include "GlobalConstants.h"

#include "GLSDL.h"

#include <string>
#include <stdexcept>

class Rect32 {
public:
	Rect32() {}
	Rect32(int i_x, int i_y, int i_w, int i_h) {x = i_x; y = i_y; w = i_w; h = i_h;}
	Rect32(SDL_Rect init) {x = init.x; y = init.y; w = init.w; h = init.h;}
	int x;
	int y;
	int w;
	int h;
};

class MinorError: public std::runtime_error {
public:
	MinorError(const char* description): std::runtime_error(description) {}
};

class CoordsInt {
public:
	CoordsInt() {}
	CoordsInt(int ix, int iy): x(ix), y(iy) {}
    
	CoordsInt& operator=(const CoordsInt& coords_two) {x = coords_two.x; y = coords_two.y; return *this;}
	
    bool operator==(const CoordsInt& coords_two) const {return (x == coords_two.x && y == coords_two.y) ? 1 : 0;}
    bool operator!=(const CoordsInt& coords_two) const {return (x == coords_two.x && y == coords_two.y) ? 0 : 1;}

	int x;
    int y;
};

class CoordsFloat {
public:
	CoordsFloat() {}
	CoordsFloat(float ix, float iy): x(ix), y(iy) {}
    
	CoordsFloat& operator=(const CoordsFloat& coords_two) {x = coords_two.x; y = coords_two.y; return *this;}
	
    bool operator==(const CoordsFloat& coords_two) const {return (x == coords_two.x && y == coords_two.y) ? 1 : 0;}
    bool operator!=(const CoordsFloat& coords_two) const {return (x == coords_two.x && y == coords_two.y) ? 0 : 1;}

	float x;
    float y;
};

int test_overlap(const Rect32& rect_one, const Rect32& rect_two);

int get_move_props(float& propx, float& propy, float dx, float dy);

void draw_rect_border(SDL_Rect& the_rect, const OpenGLColor& color, float width);

void error_back_to_mm(const std::wstring& error);

const std::string make_pic_dir_string(int n_side, const std::string& end_of_dir, bool in_mission_folder);

void follow_view_center();

const ustring str_to_ustr(const std::string& str);
const std::string ustr_to_str(const ustring& ustr);

void clear_sides();

int sdl_key_to_number(int key);
void create_info_string(const std::wstring& i_the_string, bool force = false);

bool distance_within_range(CoordsFloat& point_one, CoordsFloat& point_two, float range);

#endif

