/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.

   See the COPYING file for more details.
*/

#ifndef GUARD_Squadron
#define GUARD_Squadron

#include "scripting/ScriptSquadron.h"
#include "Enums.h"
#include "RTSStructs.h"
#include "Stuff.h"

#include <string>

class Group_Base;

class Squadron {
	friend class Scripting::ScriptSquadron;

public:
	Squadron(int i_my_side, int i_my_squad, int i_group_one, int i_group_two);

	void keyboard(SDL_keysym& keysym);
	void drag_select(SDL_Rect& drag_box);

	void init_pointer(Group_Base* pointer, int which_group);
	void select();
	void unselect();
	void add_waypoint(CoordsFloat waypoint);
	void add_current_pos_as_waypoint();
	void launch(const std::wstring& i_ai_filename, int mission_slot);

	//assume only called on squads with one unit
	void order_move(float x, float y);
	void order_halt();

	void change_ai_script(const std::wstring& i_ai_filename);
	void upkeep();

	UnitType get_type() const;
	const std::wstring get_unit_name() const;
	bool is_small() const;
	bool is_big_ship() const;
	int get_parent_cap() const;
	bool both_in_hangar() const;
	bool either_in_hangar() const;
	bool get_alive() const;
	bool is_first(int group) const;
	int get_other_wing (int you) const;
	bool get_selected() const {return selected;}
	CoordsInt get_starting_coords() const;
	bool get_pic_flip() const;
	int get_fuel() const;
	int get_fuel_percent() const;
	int get_big_ammo() const;
	int get_ammo_percent() const;
	int get_shield() const;
	int get_armour() const;
	int get_shield_max() const;
	int get_armour_max() const;
	const std::wstring get_current_mission() const;
	CoordsFloat get_center() const;
	const std::wstring get_engine_name() const;
	const std::wstring get_shield_name() const;
	const std::wstring get_armour_name() const;
	WeaponType get_big_type() const;
	WeaponType get_small_type() const;
	const std::wstring get_blurb() const;
	int get_hot_key() const {return hot_key;}
	int get_health() const;
	int get_units_left() const;

	//just return that of group 1
	const AICommands* get_the_commands() const;
	int get_script_var(int which) const;

	//these assume only called for squads with one unit
	void get_rect(Rect32& give_rect) const;
	int get_small_number() const;

	//for squirrel
	bool is_moving() const;
	bool ready_for_launch() const;
	int find_distance_to(int n_side, int n_squad) const;
	int find_distance_to_point(int x, int y) const;
	CoordsFloat get_pos() const;

	int my_squad;
	int my_side;
	int my_group_one;
	int my_group_two;

private:
	Group_Base* group_one;
	Group_Base* group_two;

	bool exposed_to_sq;
	bool selected;
	int hot_key;
};

#endif
