/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.

   See the COPYING file for more details.
*/

#ifndef GUARD_Side
#define GUARD_Side

#include "GlobalConstants.h"
#include "ScaledPic.h"
#include "Stuff.h"

#include <list>
#include <map>
#include <vector>
#include <string>

class Group;
class Squadron;

class Mission {
public:
	Mission();

	void reset();

	//don't want people decrementing them to negative values
	unsigned int script_vars[n_ai_vars];
	CoordsInt save_groups[n_ai_vars];
};

class Side {
public:
	Side(const std::wstring& i_name, int i_flag);

	//must be seperate to constructor as we access the side
	//in group constructors called by loading data
	void load_data();
	void free_pictures();

	void init();
	void blank_scanned_groups();
	void check_if_scanned();
	void run_ai();
	void save_to_file();
	int get_mission_slot();
	void launch_mission(const std::wstring& ai_script);
	void order_return();
	void order_recall();
	void select_squad(int side, int squad);
	void deselect_squad(int side, int squad);
	void toggle_highlight_squadron(int squad);
	void select_highlighted_squadrons();

	//for when someone dies
	void unhighlight_squadron(int squad);
	void display_missions_fuel();
	void hide_missions_fuel();

	int get_total_units();
	int get_total_health();
	int get_total_big_ships();
	int get_start_big_ships() {return start_big_ships;}
	
	void add_ai_error(const std::wstring& msg);
	bool already_ai_error;
	CoordsFloat work_out_selected_center();

	std::wstring name;
	OpenGLColor color;
	OpenGLColor laser_color;
	OpenGLColor radar_color;
	int my_flag;
	int my_side;

	std::vector<Group> groups;
	std::vector<Squadron> squadrons;
	std::vector< std::vector<bool> > scanned_groups;
	std::map<std::wstring, ScaledPic> unit_pictures;
	std::vector<Mission> missions;
	std::list<CoordsInt> selected_squads;
	std::list<int> highlighted_squads;

private:
	void set_colors(const std::string& color_string);
	const std::wstring color_to_string();
	int start_big_ships;
};

#endif
