/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#include "FileUtils.h"
#include "Inlines.h"
#include "SettingsStruct.h"

#include <fstream>
#include <iostream>
#include <stdexcept>
#include <string>

#ifndef WIN32
//for chdir
#include <unistd.h>
//for opendir
#include <sys/types.h>
#include <dirent.h>
//for mkdir
#include <sys/types.h>
#include <sys/stat.h>
#endif

using std::endl;
using std::ofstream;
using std::runtime_error;
using std::string;
using std::wstring;
using std::cout;

void SettingsStruct::load_settings() {
	FileReader the_file;
	string settings_path;

#ifndef WIN32
	try {
		settings_path = user_home_path + "settings.dat";
		the_file.load(settings_path);
	} catch (runtime_error e) {	
		settings_path = "settings.dat";
	}
#else
	settings_path = "settings.dat";
#endif

	try {
		the_file.load(settings_path);
	} catch (runtime_error e) {	
#ifndef WIN32
		string error = "Couldn't find settings.dat in $HOME/.rrgbis or in present working directory";
#else
		string error = "Couldn't find settings.dat";
#endif
		throw runtime_error(error);
	}

	#ifndef WIN32
		cout << "Using " << settings_path << ":" << endl << endl;
	#endif

	//data path
	bdp = the_file.get_string_after_colon();
	if (bdp != "pwd") {
		#ifndef WIN32
		char tmp_path[256];
		getcwd(tmp_path, sizeof(tmp_path));
		rem_dir = tmp_path;
		chdir(bdp.c_str());
		#endif
	}

	//fullscreen
	full_screen = static_cast<bool>(the_file.get_int_after_colon());
	
	//screen resolution
	screen_width = the_file.get_int_after_colon();
	screen_height = the_file.get_int_after_colon();

	//bits per pixel
	bpp = the_file.get_int_after_colon();

	//texture size
	texture_size = the_file.get_int_after_colon();
	
	//volume
	sound_volume = the_file.get_int_after_colon();
	music_volume = the_file.get_int_after_colon();
	
	//disable sound
	disable_sound = static_cast<bool>(the_file.get_int_after_colon());
	old_disable_sound = disable_sound;

	//mission progress
	max_mission = the_file.get_int_after_colon();

	//debug mode, changes effect of escape key and activates debugging hot keys
	debug = static_cast<bool>(the_file.get_int_after_colon());
}

void SettingsStruct::save_settings() {
	#ifndef WIN32
	if (opendir(user_home_path.c_str()) == NULL)
		mkdir(user_home_path.c_str(), S_IRWXU | S_IRGRP | S_IROTH);
	#endif
	string settings_str = user_home_path + "settings.dat";
	ofstream output(settings_str.c_str(), std::ios::trunc | std::ios::out);

	output << "- there must be exactly one space between each colon and the setting that follows" << endl;
	output << endl;
	
	if (bdp.size())
		output << "Base data path: " << bdp << endl << endl;
	else
		output << "Base data path: pwd" << endl << endl;
	
	output << "Fullscreen: " << full_screen << endl;
	output << "Screen width: " << screen_width << endl;
	output << "Screen height: " << screen_height << endl;
	output << "BPP: " << bpp << endl;
	output << "Texture size: " << texture_size << endl << endl;
	
	output << "Sound volume: " << sound_volume << endl;
	output << "Music volume: " << music_volume << endl;
	
	if (dont_write_sound)
		output << "Disable sound: " << old_disable_sound << endl << endl;
	else
		output << "Disable sound: " << disable_sound << endl << endl;

	output << "Max mission: " << max_mission << endl;
	output << "Debug: " << debug << endl << endl;
}
