/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#include "SelectMission.h"

#include "FileUtils.h"
#include "Font.h"
#include "Globals.h"
#include "Group.h"
#include "Display.h"
#include "SettingsStruct.h"
#include "Side.h"
#include "World.h"

using std::wstring;

namespace SelectMission {

SelectMission_State::SelectMission_State() {
	my_windows.push_back(GenWindow(50, 150, SM_SELECT_MISSION_MENU, 0, 0, WFLAG_STATIC | WFLAG_CANTCLOSE));
}

SelectMission_State::~SelectMission_State() {
	kill_all_windows();
	sound.end_sound();
}

void SelectMission_State::main() {
	draw_world();
}

void SelectMission_State:: mouse_d(Uint8 button, Uint16 x, Uint16 y) {
}

void SelectMission_State::keyboard(SDL_keysym& keysym) {
	if (keysym.sym == SDLK_ESCAPE)
		gs_to = GST_MAIN_MENU;
}

void SelectMission_State::draw_world() {
	display.blt(gen_pictures[GENPIC_INTRO_NEBULA], viewable_screen_rect, GL_EFFECT_SCALED);
	draw_all_windows();
}

///

SelectMissionMenu::SelectMissionMenu(int ix, int iy, int flags):
Menu_Base(ix, iy, window_id_none, flags), old_hover(-1) {
	add_item(L"Mission 1", SM_LOAD_MISSION, 1, normal_font.get_height() * 2, MFLAG_BOLD);
	add_item(L"Mission 2", SM_LOAD_MISSION, 2, normal_font.get_height() * 2, MFLAG_BOLD);
	add_item(L"Mission 3", SM_LOAD_MISSION, 3, normal_font.get_height() * 2, MFLAG_BOLD);
	add_item(L"Mission 4", SM_LOAD_MISSION, 4, normal_font.get_height() * 2, MFLAG_BOLD);
	add_item(L"Mission 5", SM_LOAD_MISSION, 5, normal_font.get_height() * 2, MFLAG_BOLD);
	add_item(L"Mission 6", SM_LOAD_MISSION, 6, normal_font.get_height() * 2, MFLAG_BOLD);
	add_item(L"Credits", SM_CREDITS, 7, normal_font.get_height() * 2, MFLAG_BOLD);
	init_rects();

	my_windows.push_back(GenWindow(250, 150, WC_WRAPPED_STRING, briefing_width, briefing_height, L"Select a mission from the menu on the left", true, WFLAG_STATIC | WFLAG_CANTCLOSE));
	info_win_id = window_ids;
}

bool SelectMissionMenu::mouse_m(Uint8 state, Uint16 x, Uint16 y) {
	bool ret = Menu_Base::mouse_m(state, x, y);

	if (current_selection.choice_type == MCT_HIGHLIGHT && hover != old_hover) {
		sound.stop_script_sound();

		wstring text;

		if (global_settings.max_mission >= current_selection.parem) {
			world.mission_folder = "missions/" + wstring_to_string(current_selection.desc) + "/";
			if (current_selection.desc != L"Credits")
				sound.play_script_sound(L"briefing.ogg");

			FileReader the_file(world.mission_folder + "mission.dat");
			world.mission_name = string_to_wstring(the_file.get_string_after_colon());
			world.mission_number = the_file.get_int_after_colon();
			world.mission_briefing = string_to_wstring(the_file.get_string_after_colon());
			text = world.mission_name + L"\n\n" + world.mission_briefing;
		} else {
			text = L"Mission not yet available\n\nYou must complete the previous mission before you can advance any further";
		}		

		kill_window(info_win_id);
		my_windows.push_back(GenWindow(250, 150, WC_WRAPPED_STRING, briefing_width, briefing_height, text, true, WFLAG_STATIC | WFLAG_CANTCLOSE));
		info_win_id = window_ids;
		old_hover = hover;
	}

	return ret;
}

void SelectMissionMenu::switch_on_choice(Uint16 x, Uint16 y) {
	if (current_selection.choice_type == MCT_LEFTCURSOR && global_settings.max_mission >= current_selection.parem) {
		if (current_selection.choice == SM_CREDITS)
			gs_to = GST_CREDITS;
		else {
			//set this first for music load to know to look in mission folder
			gs_to = GST_BATTLE;
			world.load_mission(wstring_to_string(current_selection.desc));
		}
	}
}

} // end namespace




