/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_RTSUnit
#define GUARD_RTSUnit

#include "RTSUnit_Base.h"
#include "GenericHandle.h"

/*
RTSUnit:

This class is the smallest level of division in the game. These are the actual individual ships.
As such each has a position, an armour and shield value, etc.
*/

class RTSUnit {
public:
	RTSUnit(int i_my_side, int i_my_group, const std::wstring& i_name, bool face_left);
	RTSUnit(int i_my_side, int i_my_group, const std::wstring& i_name);

	void set_pos(float ix, float iy) {h_unit->set_pos(ix, iy);}

	void select_small_targets(AICommands& the_commands, bool fire) {if (h_unit->alive) h_unit->select_small_targets(the_commands, fire);}
	void select_big_targets(AICommands& the_commands, bool fire) {if (h_unit->alive) h_unit->select_big_targets(the_commands, fire);}

	void select_small_targets(const AICommands& the_commands) {if (h_unit->alive) h_unit->select_small_targets(the_commands);}
	void select_big_targets(const AICommands& the_commands) {if (h_unit->alive) h_unit->select_big_targets(the_commands);}

	void move(float distx, float disty) {if (h_unit->alive) h_unit->move(distx, disty);}
	void add_extra_move_frames() {if (h_unit->alive) h_unit->add_extra_move_frames();}
	void fire(AICommands& the_commands) {if (h_unit->alive) h_unit->fire(the_commands);}
	void fire() {if (h_unit->alive) h_unit->fire();}

	void been_hit(int power) {if (h_unit->alive) h_unit->been_hit(power);}

	void upkeep() {if (h_unit->alive) h_unit->upkeep();}
	void dead_upkeep() {if (!h_unit->alive) h_unit->dead_upkeep();}
	void just_docked() {if (h_unit->alive) h_unit->just_docked();}

	void draw_self() {h_unit->draw_self();}
	void draw_bound(bool b_draw_weapon_range) {h_unit->draw_bound(b_draw_weapon_range);}
	void draw_big_laser() {h_unit->draw_big_laser();}

	UnitType get_type() const {return h_unit->my_type;}
	const std::wstring get_blurb() const {return h_unit->blurb;}

	bool get_pic_flip() const {return h_unit->b_flip;}
	int get_small_number() const {return h_unit->small_number;}

	int get_health() const {return h_unit->shield_current + h_unit->armour_current;}
	int get_shield() const {return h_unit->shield_current;}
	int get_armour() const {return h_unit->armour_current;}
	int get_health_max() const {return h_unit->shield_max + h_unit->armour_max;}
	int get_shield_max() const {return h_unit->shield_max;}
	int get_armour_max() const {return h_unit->armour_max;}
	
	WeaponType get_small_type() const {return h_unit->small_type;}
	WeaponType get_big_type() const {return h_unit->big_type;}
	int get_big_ammo() const {return h_unit->big_ammo;}
	int get_big_ammo_max() const {return h_unit->big_ammo_max;}

	void get_dimensions(int& giveWidth, int& giveHeight) const {giveWidth = h_unit->width; giveHeight = h_unit->height;}
	CoordsFloat get_center() const {return h_unit->get_center();}
	CoordsInt get_weak_spot() const {return h_unit->get_weak_spot();}

	const std::wstring get_engine_name() const {return h_unit->engine_name;}
	const std::wstring get_shield_name() const {return h_unit->shield_name;}
	const std::wstring get_armour_name() const {return h_unit->armour_name;}

	int get_capacity() const {return h_unit->get_capacity();}

	int get_alive() const {return h_unit->alive;}

protected:
	GenericHandle<RTSUnit_Base> h_unit;
};

#endif


