/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_RTSStructs
#define GUARD_RTSStructs

#include "Enums.h"
#include "Stuff.h"

#include <string>
#include <vector>
#include <map>

class AIScript {
public:
	std::vector<ustring> script;
	std::map<ustring, int> function_lookup;
	int first_line;
};

class AICommands {
public:
	MoveCommand move_command;
	bool b_inverse;
	//either by AI script or right click
	bool ordered_to_fire;
	bool ordered_to_dock;

	CoordsInt fire_target;
	int fire_target_dist;

	//all these values get used for PATROL, too
	//moveTargetSide.y is also used to store compass directions
	CoordsInt move_target;
	CoordsFloat point_target;
	CompassDirection compass_target;
	float aim_prop_x;
	float aim_prop_y;
	//only valid if a group target
	int move_target_dist;
	int patrol_dist;
	float speed;
};

//for an individual unit, AI commands is for a group
class TargetDesc {
public:
	int which_unit;

	float currentx;
	float currenty;
	CoordsInt weak_spot;

	float speedx;
	float speedy;
};

class WeaponDesc {
public:
	std::wstring name;
	int power;
	float range;
	int accuracy;
	int reload;
	float speed;
	//for big lasers, missiles and torpedos this means length in time
	float length;
	int start_ammo;
};

class EquipDesc {
public:
	int max;
	int recharge;
};

#endif
