/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_Projectile
#define GUARD_Projectile

#include "RTSStructs.h"
#include "GenericHandle.h"

//forward declarations:
class Projectile;
class Projectile_Base;
class LaserBolt;

class Projectile_Base {
public:
	Projectile_Base(float ix, float iy, CoordsInt target, WeaponType i_type, const OpenGLColor& i_color);
	//for explosions
	Projectile_Base(float ix, float iy);
	virtual ~Projectile_Base() {}

	static void draw_big_laser(float x0, float y0, float x1, float y1, const OpenGLColor& color);

	static bool check_to_hit(int accuracy);

	virtual bool move();
	void explode();

	virtual void draw_self() {}

	virtual WeaponType get_type() const = 0;
	CoordsInt get_target() const {CoordsInt ret(targetSide, targetGroup);	return ret;}

protected:
	void draw_our_line();

	void predict_target();
	void props_to_speed_and_length(float dx, float dy);
	void set_duration(float distance);

	//must be floats or projectiles often look like they miss totally
	float x;
	float y;
	float speedx;
	float speedy;
	float lengthx;
	float lengthy;

	int timer;
	int duration;
	bool we_hit;

	TargetDesc target_info;
	int targetSide;
	int targetGroup;
	int target_unit;
	float my_speed;
	float my_length;
	WeaponType my_type;

	OpenGLColor color;
	int explode_timer;
	bool finished_explode;
};

class LaserBolt_Base: public Projectile_Base {
public:
	LaserBolt_Base(float ix, float iy, CoordsInt target, WeaponType i_type, const OpenGLColor& i_color);
};

class SmallLaserBolt: public LaserBolt_Base {
public:
	SmallLaserBolt(float ix, float iy, CoordsInt target, WeaponType i_type, const OpenGLColor& i_color);

	void draw_self();

	WeaponType get_type() const {return WT_SMALL;}
};

class TwinLaserBolt: public LaserBolt_Base {
public:
	TwinLaserBolt(float ix, float iy, CoordsInt target, WeaponType i_type, const OpenGLColor& i_color);

	void draw_self();

	WeaponType get_type() const {return WT_TWIN;}
};

class Missile: public Projectile_Base {
public:
	Missile(float ix, float iy, CoordsInt target, WeaponType i_type);

	bool move();
	void draw_self();

	WeaponType get_type() const {return WT_MISSILE;}

private:
	CoordsFloat target_coords;
	bool exploding;
	bool target_dead;
};

class Torpedo: public Projectile_Base {
public:
	Torpedo(float ix, float iy, CoordsInt target, WeaponType i_type);

	bool move();
	void draw_self();
	
	WeaponType get_type() const {return WT_TORPEDO;}

protected:
	bool exploding;
};

class LaserExplosion: public Projectile_Base {
public:
	LaserExplosion(float ix, float iy);
	bool move();
	void draw_self();

	WeaponType get_type() const {return WT_EXPLOSION;}
};

class DropShip: public Projectile_Base {
public:
	DropShip(float ix, float iy, CoordsInt target, WeaponType i_type);
	void draw_self();

	WeaponType get_type() const {return WT_DROP_SHIP;}
};

class Projectile {
public:
	Projectile(float ix, float iy, CoordsInt target, WeaponType i_type, const OpenGLColor& i_color);
	//for explosions
	Projectile(float ix, float iy);

	//returns 0 if finished and wishes to be destroyed
	bool move() {return h_proj->move();}

	void draw_self() {h_proj->draw_self();}

	WeaponType get_type() {return h_proj->get_type();}
	CoordsInt get_target() {return h_proj->get_target();}

protected:
	GenericHandle<Projectile_Base> h_proj;
};

#endif

