/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#include "MissionEditor.h"
#include "Globals.h"
#include "Group.h"
#include "SettingsStruct.h"
#include "World.h"

namespace MissionEditor {

MissionEditor_State::MissionEditor_State() {
	world.pause(false);
	debug_display_all_groups = true;
	sound.set_music_volume(0);
}


MissionEditor_State::~MissionEditor_State() {
	sound.set_music_volume(global_settings.music_volume);
	debug_display_all_groups = false;
	world.unpause(false);
}

void MissionEditor_State::keyboard(SDL_keysym& keysym) {
	RTS_State::keyboard(keysym);

	if (keysym.sym == SDLK_F10)
		save_to_file();
}

void MissionEditor_State::save_to_file() {
	for (int i = 0; i != sides.size(); ++i)
		sides[i].save_to_file();
}

}

