/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.

   See the COPYING file for more details.
*/

#ifndef GUARD_LoadGameData
#define GUARD_LoadGameData

#include "RTSStructs.h"
#include "Stuff.h"

#include <iterator>
#include <sstream>

class OptionSkipIter;

void load_standard_graphics();
void clear_standard_graphics();
void reset_graphics();
void load_title_images();
void free_title_images();
void load_title_music();

void setup_lookup_tables();

void FillWeaponValues(WeaponType i, std::istringstream& input, OptionSkipIter& iter, const OptionSkipIter& file_end);
void fill_equip_values(int i, std::istringstream& input, OptionSkipIter& iter, const OptionSkipIter& file_end);

void load_ai_scripts();
void create_ai_script_vec(const std::wstring& script_name);
void make_function_lookup_table(const std::wstring& script_name);
void check_over_ai(const std::wstring& script_name);

#endif


