/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#include "Display.h"
#include "Font.h"
#include "GenWindow.h"
#include "Globals.h"
#include "Intro.h"
#include "SettingsStruct.h"
#include "Sound.h"

using std::wstring;

namespace Intro {

Intro_State::Intro_State() {
	wstring tmp_str =
	L"The great galactic war of 4320 - 4359 AD resulted in the fall of the immense Artilian Empire, which had previously ruled "
	L"over more than 70% of the inhabited worlds in our galaxy.\n\n"

	L"This game allows you to play a selection of really rather good battles from this epic conflict, always in the "
	L"role of Admiral Vadas of the Morellian Empire.\n\n"

	L"                       <press enter to continue>";

	my_windows.push_back(GenWindow(0, 0, INT_INTRO_TEXT, 400, 350, tmp_str, false, WFLAG_CENTER | WFLAG_TRANSPARENT | WFLAG_CANTCLOSE | WFLAG_STATIC));

	if (global_settings.music_volume >= 90)
		sound.set_music_volume(128);
	sound.start_music();
}

Intro_State::~Intro_State() {
	kill_all_windows();
	current_cursor_type = GENPIC_CURSOR;
}

void Intro_State::main() {
	current_cursor_type = GENPIC_CLOSEBOX;
	display.blt(gen_pictures[GENPIC_INTRO_NEBULA], viewable_screen_rect, GL_EFFECT_SCALED);
	draw_all_windows();
}

void Intro_State::keyboard(SDL_keysym& keysym) {
	if (keysym.sym == SDLK_ESCAPE || keysym.sym == SDLK_RETURN)
		gs_to = GST_MAIN_MENU;
}

IntroText::IntroText(int ix, int iy, int iw, int ih, const std::wstring& the_string, bool bold_title, int flags):
WrappedString(ix, iy, iw, ih, the_string, bold_title, flags) {}

void IntroText::draw_self() {
	SDL_Rect tmp = {rect.x, rect.y, rect.w, rect.h - 100};
	display.blt_fill(tmp, standard_colors.black, 0.3f);
	WrappedString::draw_self();
}

}

