/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_Globals
#define GUARD_Globals

#include "GlobalConstants.h"
#include "Enums.h"
#include "Logging.h"
#include "Side.h"
#include "FileUtils.h"
#include "Squadron.h"
#include "StandardColors.h"

//forward declarations
class Display;
class EquipDesc;
class Font;
class GenWindow;
class SettingsStruct;
class Sound;
class World;
class WeaponDesc;

#include <vector>
#include <list>
#include <map>

//the rts world
extern World world;
extern std::vector<Side> sides;

//display stuff
extern Display display;
extern SDL_Rect viewable_screen_rect;
extern bool skip_display_frame;
extern GenPicture current_cursor_type;

//sound
extern Sound sound;

//structs of data
extern StandardColors standard_colors;
extern SettingsStruct global_settings;

//program state control
extern GameStateType gs_current;
extern GameStateType gs_to;
extern int now;

//windowing system
extern std::list<GenWindow> my_windows;
extern int window_ids;
extern Font normal_font;
extern Font bold_font;

//stored image data
extern SDL_Surface* gen_pictures[max_gen_pictures];

//lookup tables
extern std::map<std::wstring, WeaponType> weapon_load_lookup;
extern WeaponDesc weapon_lookup[n_weapon_types];
extern std::map<std::wstring, EquipDesc> equip_lookup;
extern std::map<std::string, unsigned char> token_lookup;
extern std::vector<int> fog_line_lookup;

extern std::map<UnitType, std::wstring> unit_type_to_string;
extern std::map<std::wstring, UnitType> string_to_unit_type;

//stupid FIXME globals
extern bool an_info_string;
extern std::wstring global_error_string;
extern bool mouse_over_ui;
extern bool debug_display_all_groups;

#endif

