/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#include "Font.h"
#include "GenWindow.h"
#include "Globals.h"
#include "Group.h"
#include "Display.h"
#include "SettingsStruct.h"
#include "Side.h"
#include "Sound.h"
#include "World.h"

using std::string;
using std::wstring;
using std::map;
using std::vector;
using std::list;

//the rts world
World world;
vector<Side> sides;

//display stuff
Display display;
SDL_Rect viewable_screen_rect;
bool skip_display_frame;
GenPicture current_cursor_type = GENPIC_CURSOR;

//sound
Sound sound;

//structs of data
StandardColors standard_colors;
SettingsStruct global_settings;

//program state control
GameStateType gs_current = GST_THE_OS;
GameStateType gs_to = GST_INTRO;
int now;

//windowing system
list<GenWindow> my_windows;
int window_ids = 0;
Font normal_font;
Font bold_font;

//stored image data
SDL_Surface* gen_pictures[max_gen_pictures];

//lookup tables
map<wstring, WeaponType> weapon_load_lookup;
WeaponDesc weapon_lookup[n_weapon_types];
map<wstring, EquipDesc> equip_lookup;
vector<int> fog_line_lookup;
map<string, unsigned char> token_lookup;
map<UnitType, wstring> unit_type_to_string;
map<wstring, UnitType> string_to_unit_type;

//stupid FIXME globals
bool an_info_string = false;
wstring global_error_string = L"No error right now";
bool mouse_over_ui = false;
bool debug_display_all_groups = false;

