/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.

   See the COPYING file for more details.
*/

#ifndef GUARD_GlobalConstants
#define GUARD_GlobalConstants

//I don't care if Microsoft thinks sprintf is deprecated
#pragma warning(disable:4996)
//it warns about converting bools to ints even if you explicitly cast
#pragma warning(disable:4800)

#include "GLSDL.h"
#include <string>

//basic defines
const std::wstring version_string = L"1.12";
const int num_missions = 6;

typedef std::basic_string<unsigned char> ustring;

const int window_id_all = 2147483647;
const int window_id_none = 2147483646;

//spacing and UI
const int WFLAG_STATIC = 1;
const int WFLAG_TILED = 2;
const int WFLAG_CANTCLOSE = 4;
const int WFLAG_INVISIBLE = 8;
const int WFLAG_CENTER = 16;
const int WFLAG_TRANSPARENT = 32;

const int MFLAG_BOLD = 1;
const int MFLAG_FADED = 2;
const int MFLAG_HIGHLIGHT = 4;

const int small_border_size = 2;
const int big_border_size = 7;
const int health_bar_height = 4;

const int radar_indent = 10;
const int info_window_width = 310;
const int info_window_height = 210;

const int slider_win_width = 250;
const int slider_win_height = 80;
const int menu_item_width = 160;

const int max_text_input_length = 120;

//vector size
const int n_font_chars = 91;
const int n_weapon_types = 16;
const int max_gen_pictures = 50;

//simulation constants

const int max_players = 6;
const int ss_group_size = 3;

const int max_world_update_interval = 400;
const int max_scroll_interval = 300;
const int standard_interval = 33;
const int time_acceleration_interval = 16;

const int med_explosion_width = 328;
const int med_explosion_height = 72;
const int large_explosion_width = 768;
const int large_explosion_height = 168;

const int cap_small_lasers = 8;
const int frig_small_lasers = 4;
const int defence_node_small_lasers = 4;
const int hangar_capacity = 6;

const int frames_per_anim_frame = 3;

const int ss_draw_at_back_time = 120;

const int screen_move_speed = 40;

const int max_simultaneous_missions = 10;
const int max_ai_instructions = 100;
const int max_script_digits = 6;
const int max_ai_int = 999999;
const int n_ai_vars = 10;

const int terrain_tile_dim = 100;
const int patrol_leeway = 30;
const int move_point_leeway = 5;
const int docking_leeway = 10;
const int fuel_leeway = 500;
const int max_aiming = 15;
const int stagger_frames = 10;

#endif
