/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_GenWindow
#define GUARD_GenWindow

#include "GenWindow_Base.h"
#include "GenericHandle.h"

#include <string>

class GenWindow;

void update_windows();
bool win_mouse_d(Uint8 button, Uint16 x, Uint16 y);
void win_mouse_m(Uint8 state, Uint16 x, Uint16 y);
bool win_key_d(SDL_keysym& keysym);
bool win_key_u(SDL_keysym& keysym);

void message_windows(WindowChoice the_msg, int parem_one, int parem_two, int target_id, int source_id);
void draw_all_windows();
void kill_all_windows();
void kill_window(int id);

class GenWindow {
public:
	GenWindow(int ix, int iy, WindowChoice i_type, int parem_one, int parem_two, int flags);
	GenWindow(WindowChoice i_type, const std::wstring& i_the_string);
	GenWindow(int ix, int iy, WindowChoice i_type, int iw, int ih, const std::wstring& the_string, bool bold_title, int flags);
	GenWindow(int ix, int iy, WindowChoice i_type, const std::wstring& iString, UnitType iUnitType, int parem_one, int parem_two, int paremThree);
	GenWindow(int ix, int iy, WindowChoice i_type, int iSliderVar, int i_var_min, int i_var_max, const std::wstring& iVarName, const std::wstring& iVarUnits, int i_parent_id, int flags);
	GenWindow(int ix, int iy, WindowChoice i_type, int* iVarPointer, int i_var_min, int i_var_max, const std::wstring& iVarName, const std::wstring& iVarUnits, int i_parent_id, int flags);
	GenWindow(WindowChoice i_type, UnitType iUnitType, int parem_one);
	GenWindow(WindowChoice i_type, int i_my_side, int i_my_group, WindowChoice iChoiceType);
	GenWindow(const std::wstring& i_the_string);

	//control icons
	GenWindow(WindowChoice i_type, SDL_Rect& i_rect, SDL_Surface* i_pic, const std::wstring& i_desc, bool minus_width, bool i_active);
	GenWindow(WindowChoice i_type, SDL_Rect& i_rect, SDL_Surface* i_pic, const std::wstring& i_desc, int i_text_offset_x, bool i_active);

	bool mouse_d(Uint8 button, Uint16 x, Uint16 y) {return h_window->mouse_d(button, x, y);}
	bool mouse_m(Uint8 state, Uint16 x, Uint16 y) {return h_window->mouse_m(state, x, y);}
	bool keyboard(SDL_keysym& keysym) {return h_window->keyboard(keysym);}
	bool key_u(SDL_keysym& keysym) {return h_window->key_u(keysym);}
	
	void update() {h_window->update();}
	
	bool TakeActivate();
	int GetClosed() const {return h_window->closed;}
	void draw_self() {h_window->draw_self();}

	GenWindow_Base* get_pointer() {return h_window.get_pointer();}

	void win_message(WindowChoice the_msg, int parem_one, int parem_two, int target_id, int source_id);

protected:
	GenericHandle<GenWindow_Base> h_window;
};

#endif

