/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.

   See the COPYING file for more details.
*/

#include "Font.h"
#include "Globals.h"
#include "Inlines.h"

#include <stdexcept>
#include <string>

using std::runtime_error;
using std::string;
using std::wstring;

//static members
OpenGLColor Font::my_white;

void Font::init(const string& filename, int i_size) {
	if (!does_file_exist(filename)) {
		string error = "Cannot load font: " + filename;
		throw runtime_error(error);
	}

	font = new FTGLTextureFont(filename.c_str());
	font->FaceSize(i_size);
	my_size = i_size;
	my_line_height = static_cast<int>(font->LineHeight());
	my_white = standard_colors.white;
}

void Font::render(int x, int y, const wstring& output, const OpenGLColor& color) {
	glColor4f(color.r, color.g, color.b, 1);
	y += (my_line_height - 8);
	glLoadIdentity ();
	glTranslatef(x, y, 0);
	glRotatef(180, 1, 0, 0);

	int first_index = 0;
	int last_index = 0;

	for (; last_index != output.size(); ++last_index) {
		if (output[last_index] == '\n') {
			font->Render(output.substr(first_index, last_index - first_index).c_str());
			first_index = last_index + 1;
			y += normal_font.get_height();
			glLoadIdentity ();
			glTranslatef(x, y, 0);
			glRotatef(180, 1, 0, 0);
			continue;
		}
	}
	
	if (last_index > first_index)
		font->Render(output.substr(first_index, last_index - first_index).c_str());
}

void Font::shutdown() {
	delete font;
	font = 0;
}

int Font::get_width(const wstring& str) {
	return static_cast<int>(font->Advance(str.c_str()));
}

