/*
   Copyright (C) 2006 by James Gregory
   Part of the Really Rather Good Battles In Space project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_Enums
#define GUARD_Enums

enum GameStateType {GST_INTRO, GST_CREDITS, GST_MAIN_MENU, GST_SELECT_MISSION, GST_MISSION_EDITOR, GST_BATTLE, GST_RELOAD, GST_THE_OS};

enum UnitType {UT_FIGHTER, UT_BOMBER, UT_FRIGATE, UT_CAPITAL, UT_FREIGHTER, UT_DEFENCE_NODE, UT_PLANET};

enum MenuChoiceType {MCT_NONE, MCT_LEFTCURSOR, MCT_RIGHTCURSOR, MCT_HIGHLIGHT};

enum CompassDirection {CD_N, CD_NE, CD_E, CD_SE, CD_S, CD_SW, CD_W, CD_NW};

enum WeaponStage {W_RELOADING, W_READY, W_AIMING, W_FIRING};

enum MoveCommand {MC_NO_MOVE, MC_MOVE_COMPASS, MC_MOVE_GROUP, MC_PATROL, MC_MOVE_POINT};

enum WeaponType{
    WT_NONE,
    WT_TWIN,
	WT_HEAVY_TWIN,
	WT_PLATFORM,
    WT_SMALL,
    WT_LARGE,
    WT_MISSILE,
    WT_TORPEDO,
	WT_DROP_SHIP,
	WT_EXPLOSION,
};

enum WindowChoice {
    WC_NOTHING,
    WC_QUIT,
    WC_YES,
    WC_NO,
	WC_WRAPPED_STRING,
    WC_INFO_STRING,
    WC_IM_ACTIVE,
    WC_IM_CLOSING,
    WC_IM_MOVING,
    WC_YOU_CLOSE,

	WC_OPTIONS_WIN_OPEN,
	WC_MISSION_WIN_OPEN,
	WC_SQUAD_LIST_WIN_SS,
	WC_SQUAD_LIST_WIN_NO_SS,
	WC_BS_WIN_OPEN,
	WC_SS_WIN_OPEN,
	WC_TARGET_WIN_OPEN,

	WC_OPTIONS_WIN_CLOSED,
	WC_CLOSE_GROUP_WIN,
	WC_CLOSE_MISSION_WIN,
	WC_TARGET_WIN_CLOSED,

	WC_NO_SQUAD_HIGHLIGHT,
	WC_SQUAD_HOME_HIGHLIGHT,
	WC_SQUAD_AWAY_HIGHLIGHT,

	WC_CLOSE_PORTRAIT_TEXT,

	INT_INTRO_TEXT,
	CREDITS_CREDITS_TEXT,

    MM_MAIN_SM,
    MM_SELECT_MISSION,
    MM_OPTIONS,

	OPT_FULLSCREEN_TOGGLE,
	OPT_HIGH_RES_TOGGLE,
	OPT_SET_RESOLUTION,
	OPT_800,
	OPT_1024,
	OPT_1280,
    OPT_SOUND_VOLUME,
    OPT_MUSIC_VOLUME,
	OPT_DEFAULTS,

    SM_SELECT_MISSION_MENU,
	SM_LOAD_MISSION,
	SM_CREDITS,

	RTS_MISSIONS,
	RTS_COMM,
	RTS_REPEAT_COMM,
	RTS_BRIEFING,
	RTS_MISSION_FAILED,
	RTS_RANGE,
	RTS_OPTIONS,
    RTS_SQUAD_LIST,
    RTS_SQUAD_STATS,
    RTS_SQUAD_STATUS,
	RTS_SQUAD_VARS,
	RTS_DEBUG_WIN,
	RTS_RETURN,
	RTS_RECALL,
	RTS_PATROL,
	RTS_ATTACK,
	RTS_RECON,
	RTS_SELECT,
	RTS_CANCEL,

	RTS_GROUP,
	RTS_TARGET_RECON,
	RTS_TARGET_PATROL,
	RTS_TARGET_ATTACK,

    RTS_RESTART,
    RTS_GAME_SPEED,
    RTS_SCROLL_SPEED,
	RTS_RETURN_TO_GAME,

	RTS_PORTRAIT_TEXT
};

enum GenPicture{
    GENPIC_CURSOR,
	GENPIC_CURSORMOVE,
	GENPIC_CURSORATTACK,
    GENPIC_CLOSEBOX,

	GENPIC_MISSIONS_ICON,
	GENPIC_COMM_ICON,
	GENPIC_BRIEFING_ICON,
	GENPIC_RANGE_ICON,
	GENPIC_OPTIONS_ICON,
	
	GENPIC_STATS_ICON,
	GENPIC_STATUS_ICON,
	GENPIC_RETURN_ICON,
	GENPIC_RECALL_ICON,
	
	GENPIC_PATROL_ICON,
	GENPIC_ATTACK_ICON,
	GENPIC_RECON_ICON,
	GENPIC_SELECT_ICON,
	GENPIC_CANCEL_ICON,

	GENPIC_INTRO_NEBULA,
    GENPIC_TITLE,

    GENPIC_SMALL_EXPLODE1,
    GENPIC_SMALL_EXPLODE2,
    GENPIC_SMALL_EXPLODE3,
    GENPIC_SMALL_EXPLODE4,
    GENPIC_SMALL_EXPLODE5,
    GENPIC_SMALL_EXPLODE6,

    GENPIC_LARGE_EXPLODE1,
    GENPIC_LARGE_EXPLODE2,
    GENPIC_LARGE_EXPLODE3,
    GENPIC_LARGE_EXPLODE4,
    GENPIC_LARGE_EXPLODE5,
    GENPIC_LARGE_EXPLODE6,
    GENPIC_LARGE_EXPLODE7,
    GENPIC_LARGE_EXPLODE8,
    GENPIC_LARGE_EXPLODE9,

	GENPIC_DROP_SHIP
};

//these share the decimal number of the ascii codes, so we don't have to manipulate things quite so much when turning into bytecode
const unsigned char TT_TAB = 9;
//space is 20
const unsigned char TT_COMMENT = 35; //i.e. #
//
const unsigned char TT_MODULO = 37; //%
//
//40 no TT_OpenB
//41 no TT_CloseB
const unsigned char TT_MULTIPLY = 42;
const unsigned char TT_ADD = 43;
//comma 44
const unsigned char TT_MINUS = 45;
//46 dot
const unsigned char TT_DIVIDE = 47;
//
//48 -> 5something are numbers

const unsigned char TT_COLON = 58;
const unsigned char TT_JUMP = 64;

////

//starting from A:
const unsigned char TT_IF = 65;
const unsigned char TT_ELSE = 66;
const unsigned char TT_ELIF = 67;
const unsigned char TT_RETURN = 68;
const unsigned char TT_START_TIMER = 69;

const unsigned char TT_MOVE = 70;
const unsigned char TT_MOVE_SLOW = 71;
const unsigned char TT_MOVE_AWAY = 72;
const unsigned char TT_FIRE = 73;
const unsigned char TT_PATROL = 74;
const unsigned char TT_DOCK = 75;

const unsigned char TT_Our = 80;
const unsigned char TT_AnyEnemy = 81;
const unsigned char TT_AnyFriend = 82;
const unsigned char TT_AnyAlly = 83;
const unsigned char TT_NearestEnemy = 84;
const unsigned char TT_NearestFriend = 85;
const unsigned char TT_NearestAlly = 86;
const unsigned char TT_NEAREST_WORLD_EDGE = 87;
const unsigned char TT_WAYPOINT = 88;

const unsigned char TT_NumEnemy = 90;
const unsigned char TT_NumFriend = 91;
const unsigned char TT_NumAlly = 92;

const unsigned char TT_Number = 100;
const unsigned char TT_Health = 101;
const unsigned char TT_Shield = 102;
const unsigned char TT_Armour = 103;
const unsigned char TT_HealthMax = 104;
const unsigned char TT_ShieldMax = 105;
const unsigned char TT_ArmourMax = 106;
const unsigned char TT_UnitShieldMax = 107;
const unsigned char TT_UnitArmourMax = 108;
const unsigned char TT_SPEED = 109;
const unsigned char TT_FUEL = 110;
const unsigned char TT_DISTANCE = 111;
const unsigned char TT_DISTANCE_FROM = 112;
const unsigned char TT_IS_ALPHA = 113;

const unsigned char TT_SmallRange = 120;
const unsigned char TT_SmallPower = 121;
const unsigned char TT_BigRange = 122;
const unsigned char TT_BigPower = 123;
const unsigned char TT_BIG_AMMO = 125;
const unsigned char TT_IN_SMALL_RANGE = 126;
const unsigned char TT_InBigRange = 127;
const unsigned char TT_OurInSmallRange = 128;
const unsigned char TT_OurInBigRange = 129;

const unsigned char TT_Left = 130;
const unsigned char TT_MissTarget = 131;
const unsigned char TT_TorpTarget = 132;
const unsigned char TT_GroupType = 133;

const unsigned char TT_NONE = 134;

const unsigned char TT_FIGHTER = 140;
const unsigned char TT_BOMBER = 141;
const unsigned char TT_FRIGATE = 142;
const unsigned char TT_FREIGHTER = 143;
const unsigned char TT_DEFENCE_NODE = 144;
const unsigned char TT_CAPITAL = 145;
const unsigned char TT_PLANET = 146;

const unsigned char TT_Equal = 150;
const unsigned char TT_NotEqual = 151;
const unsigned char TT_GreaterThan = 152;
const unsigned char TT_LessThan = 153;
const unsigned char TT_GreaterThanEqual = 154;
const unsigned char TT_LessThanEqual = 155;
const unsigned char TT_Not = 136;

const unsigned char TT_AND = 157;
const unsigned char TT_OR = 158;

const unsigned char TT_Integer = 160;
const unsigned char TT_SCRIPT_VAR = 161;
const unsigned char TT_SaveGroup = 162;
const unsigned char TT_ScriptTimer = 163;

const unsigned char TT_GLOBAL_SCRIPT_VAR = 164;
const unsigned char TT_GSaveGroup = 165;

const unsigned char TT_Assign = 166;
const unsigned char TT_Increment = 167;
const unsigned char TT_Decrement = 168;

const unsigned char TT_N = 170;
const unsigned char TT_NE = 171;
const unsigned char TT_E = 172;
const unsigned char TT_SE = 173;
const unsigned char TT_S = 174;
const unsigned char TT_SW = 175;
const unsigned char TT_W = 176;
const unsigned char TT_NW = 177;

const unsigned char TT_NorthEdge = 180;
const unsigned char TT_EastEdge = 181;
const unsigned char TT_SouthEdge = 182;
const unsigned char TT_WestEdge = 183;

const unsigned char TT_RANDOM = 190;
const unsigned char TT_NUM_WAYPOINT = 191;

#endif
